// DO NOT EDIT. Generated by tensorflow-op-codegen/src/main.rs.

/// Abort
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Abort>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Abort {
    error_msg: ::std::option::Option<::std::string::String>,
    exit_without_error: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Abort {
    fn default() -> Self {
        Self {
            error_msg: None,
            exit_without_error: Some(false),
            target_device_name: None,
        }
    }
}
impl Abort {
    /// Creates a new `Abort`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `error_msg` attribute.
    pub fn error_msg<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.error_msg = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `exit_without_error` attribute.
    pub fn exit_without_error<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.exit_without_error = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute abort.
    pub fn call<'a>(&self, ctx: &'a crate::eager::Context) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "Abort")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.error_msg {
            op.set_attr_string("error_msg", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.exit_without_error {
            op.set_attr_bool("exit_without_error", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `Abort::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Abort>
pub fn abort<'a>(ctx: &'a crate::eager::Context) -> crate::Result<()> {
    let op = Abort::new();
    op.call(ctx)
}

/// Abs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Abs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Abs {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Abs {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Abs {
    /// Creates a new `Abs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute abs.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Abs")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Abs::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Abs>
pub fn abs<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Abs::new();
    op.call(ctx, x)
}

/// AccumulateNV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulateNV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AccumulateNV2 {
    shape: ::std::option::Option<crate::Shape>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AccumulateNV2 {
    fn default() -> Self {
        Self {
            shape: None,
            target_device_name: None,
        }
    }
}
impl AccumulateNV2 {
    /// Creates a new `AccumulateNV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute accumulate_nv2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &[&T0],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AccumulateNV2")?;

        // Required input arguments
        let mut inputs_list = Vec::new();

        for t in inputs {
            inputs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&inputs_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.shape {
            op.set_attr_shape("shape", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AccumulateNV2::new().call(&ctx, &inputs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulateNV2>
pub fn accumulate_nv2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    inputs: &[&T0],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AccumulateNV2::new();
    op.call(ctx, inputs)
}

/// AccumulatorApplyGradient
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorApplyGradient>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AccumulatorApplyGradient {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AccumulatorApplyGradient {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AccumulatorApplyGradient {
    /// Creates a new `AccumulatorApplyGradient`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute accumulator_apply_gradient.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        local_step: &T1,
        gradient: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AccumulatorApplyGradient")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&local_step.to_handle(ctx)?)?;
        op.add_input(&gradient.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AccumulatorApplyGradient::new().call(&ctx, &handle, &local_step, &gradient)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorApplyGradient>
pub fn accumulator_apply_gradient<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    local_step: &T1,
    gradient: &T2,
) -> crate::Result<()> {
    let op = AccumulatorApplyGradient::new();
    op.call(ctx, handle, local_step, gradient)
}

/// AccumulatorNumAccumulated
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorNumAccumulated>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AccumulatorNumAccumulated {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AccumulatorNumAccumulated {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AccumulatorNumAccumulated {
    /// Creates a new `AccumulatorNumAccumulated`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute accumulator_num_accumulated.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AccumulatorNumAccumulated")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AccumulatorNumAccumulated::new().call(&ctx, &handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorNumAccumulated>
pub fn accumulator_num_accumulated<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AccumulatorNumAccumulated::new();
    op.call(ctx, handle)
}

/// AccumulatorSetGlobalStep
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorSetGlobalStep>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AccumulatorSetGlobalStep {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AccumulatorSetGlobalStep {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AccumulatorSetGlobalStep {
    /// Creates a new `AccumulatorSetGlobalStep`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute accumulator_set_global_step.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        new_global_step: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AccumulatorSetGlobalStep")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&new_global_step.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AccumulatorSetGlobalStep::new().call(&ctx, &handle, &new_global_step)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorSetGlobalStep>
pub fn accumulator_set_global_step<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    new_global_step: &T1,
) -> crate::Result<()> {
    let op = AccumulatorSetGlobalStep::new();
    op.call(ctx, handle, new_global_step)
}

/// AccumulatorTakeGradient
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorTakeGradient>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AccumulatorTakeGradient {
    dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AccumulatorTakeGradient {
    fn default() -> Self {
        Self {
            dtype: None,
            target_device_name: None,
        }
    }
}
impl AccumulatorTakeGradient {
    /// Creates a new `AccumulatorTakeGradient`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute accumulator_take_gradient.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        num_required: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AccumulatorTakeGradient")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&num_required.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.dtype {
            op.set_attr_type("dtype", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AccumulatorTakeGradient::new().call(&ctx, &handle, &num_required)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AccumulatorTakeGradient>
pub fn accumulator_take_gradient<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    num_required: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AccumulatorTakeGradient::new();
    op.call(ctx, handle, num_required)
}

/// Acos
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Acos>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Acos {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Acos {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Acos {
    /// Creates a new `Acos`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute acos.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Acos")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Acos::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Acos>
pub fn acos<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Acos::new();
    op.call(ctx, x)
}

/// Acosh
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Acosh>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Acosh {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Acosh {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Acosh {
    /// Creates a new `Acosh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute acosh.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Acosh")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Acosh::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Acosh>
pub fn acosh<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Acosh::new();
    op.call(ctx, x)
}

/// Add
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Add>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Add {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Add {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Add {
    /// Creates a new `Add`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute add.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Add")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Add::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Add>
pub fn add<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Add::new();
    op.call(ctx, x, y)
}

/// AddManySparseToTensorsMap
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddManySparseToTensorsMap>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AddManySparseToTensorsMap {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AddManySparseToTensorsMap {
    fn default() -> Self {
        Self {
            container: None,
            shared_name: None,
            target_device_name: None,
        }
    }
}
impl AddManySparseToTensorsMap {
    /// Creates a new `AddManySparseToTensorsMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute add_many_sparse_to_tensors_map.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        sparse_indices: &T0,
        sparse_values: &T1,
        sparse_shape: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AddManySparseToTensorsMap")?;

        // Required input arguments
        op.add_input(&sparse_indices.to_handle(ctx)?)?;
        op.add_input(&sparse_values.to_handle(ctx)?)?;
        op.add_input(&sparse_shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AddManySparseToTensorsMap::new().call(&ctx, &sparse_indices, &sparse_values, &sparse_shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddManySparseToTensorsMap>
pub fn add_many_sparse_to_tensors_map<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    sparse_indices: &T0,
    sparse_values: &T1,
    sparse_shape: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AddManySparseToTensorsMap::new();
    op.call(ctx, sparse_indices, sparse_values, sparse_shape)
}

/// AddN
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddN>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AddN {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AddN {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AddN {
    /// Creates a new `AddN`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute add_n.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &[&T0],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AddN")?;

        // Required input arguments
        let mut inputs_list = Vec::new();

        for t in inputs {
            inputs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&inputs_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AddN::new().call(&ctx, &inputs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddN>
pub fn add_n<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    inputs: &[&T0],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AddN::new();
    op.call(ctx, inputs)
}

/// AddSparseToTensorsMap
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddSparseToTensorsMap>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AddSparseToTensorsMap {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AddSparseToTensorsMap {
    fn default() -> Self {
        Self {
            container: None,
            shared_name: None,
            target_device_name: None,
        }
    }
}
impl AddSparseToTensorsMap {
    /// Creates a new `AddSparseToTensorsMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute add_sparse_to_tensors_map.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        sparse_indices: &T0,
        sparse_values: &T1,
        sparse_shape: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AddSparseToTensorsMap")?;

        // Required input arguments
        op.add_input(&sparse_indices.to_handle(ctx)?)?;
        op.add_input(&sparse_values.to_handle(ctx)?)?;
        op.add_input(&sparse_shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AddSparseToTensorsMap::new().call(&ctx, &sparse_indices, &sparse_values, &sparse_shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddSparseToTensorsMap>
pub fn add_sparse_to_tensors_map<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    sparse_indices: &T0,
    sparse_values: &T1,
    sparse_shape: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AddSparseToTensorsMap::new();
    op.call(ctx, sparse_indices, sparse_values, sparse_shape)
}

/// AddV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AddV2 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AddV2 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AddV2 {
    /// Creates a new `AddV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute add_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AddV2")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AddV2::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AddV2>
pub fn add_v2<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AddV2::new();
    op.call(ctx, x, y)
}

/// AdjustContrast
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustContrast>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AdjustContrast {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AdjustContrast {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AdjustContrast {
    /// Creates a new `AdjustContrast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute adjust_contrast.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        images: &T0,
        contrast_factor: &T1,
        min_value: &T2,
        max_value: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AdjustContrast")?;

        // Required input arguments
        op.add_input(&images.to_handle(ctx)?)?;
        op.add_input(&contrast_factor.to_handle(ctx)?)?;
        op.add_input(&min_value.to_handle(ctx)?)?;
        op.add_input(&max_value.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AdjustContrast::new().call(&ctx, &images, &contrast_factor, &min_value, &max_value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustContrast>
pub fn adjust_contrast<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    images: &T0,
    contrast_factor: &T1,
    min_value: &T2,
    max_value: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AdjustContrast::new();
    op.call(ctx, images, contrast_factor, min_value, max_value)
}

/// AdjustContrastv2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustContrastv2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AdjustContrastv2 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AdjustContrastv2 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AdjustContrastv2 {
    /// Creates a new `AdjustContrastv2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute adjust_contrastv2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        images: &T0,
        contrast_factor: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AdjustContrastv2")?;

        // Required input arguments
        op.add_input(&images.to_handle(ctx)?)?;
        op.add_input(&contrast_factor.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AdjustContrastv2::new().call(&ctx, &images, &contrast_factor)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustContrastv2>
pub fn adjust_contrastv2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    images: &T0,
    contrast_factor: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AdjustContrastv2::new();
    op.call(ctx, images, contrast_factor)
}

/// AdjustHue
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustHue>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AdjustHue {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AdjustHue {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AdjustHue {
    /// Creates a new `AdjustHue`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute adjust_hue.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        images: &T0,
        delta: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AdjustHue")?;

        // Required input arguments
        op.add_input(&images.to_handle(ctx)?)?;
        op.add_input(&delta.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AdjustHue::new().call(&ctx, &images, &delta)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustHue>
pub fn adjust_hue<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    images: &T0,
    delta: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AdjustHue::new();
    op.call(ctx, images, delta)
}

/// AdjustSaturation
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustSaturation>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AdjustSaturation {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AdjustSaturation {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AdjustSaturation {
    /// Creates a new `AdjustSaturation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute adjust_saturation.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        images: &T0,
        scale: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AdjustSaturation")?;

        // Required input arguments
        op.add_input(&images.to_handle(ctx)?)?;
        op.add_input(&scale.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AdjustSaturation::new().call(&ctx, &images, &scale)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AdjustSaturation>
pub fn adjust_saturation<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    images: &T0,
    scale: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AdjustSaturation::new();
    op.call(ctx, images, scale)
}

/// All
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/All>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct All {
    keep_dims: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for All {
    fn default() -> Self {
        Self {
            keep_dims: Some(false),
            target_device_name: None,
        }
    }
}
impl All {
    /// Creates a new `All`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `keep_dims` attribute.
    pub fn keep_dims<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.keep_dims = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute all.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        reduction_indices: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "All")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&reduction_indices.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.keep_dims {
            op.set_attr_bool("keep_dims", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `All::new().call(&ctx, &input, &reduction_indices)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/All>
pub fn all<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    reduction_indices: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = All::new();
    op.call(ctx, input, reduction_indices)
}

/// AllCandidateSampler
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AllCandidateSampler>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AllCandidateSampler {
    num_true: ::std::option::Option<i64>,
    num_sampled: ::std::option::Option<i64>,
    unique: ::std::option::Option<bool>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AllCandidateSampler {
    fn default() -> Self {
        Self {
            num_true: None,
            num_sampled: None,
            unique: None,
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl AllCandidateSampler {
    /// Creates a new `AllCandidateSampler`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_true` attribute.
    pub fn num_true<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_true = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_sampled` attribute.
    pub fn num_sampled<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_sampled = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `unique` attribute.
    pub fn unique<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.unique = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute all_candidate_sampler.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        true_classes: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AllCandidateSampler")?;

        // Required input arguments
        op.add_input(&true_classes.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_true {
            op.set_attr_int("num_true", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_sampled {
            op.set_attr_int("num_sampled", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.unique {
            op.set_attr_bool("unique", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AllCandidateSampler::new().call(&ctx, &true_classes)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AllCandidateSampler>
pub fn all_candidate_sampler<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    true_classes: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = AllCandidateSampler::new();
    op.call(ctx, true_classes)
}

/// AllToAll
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AllToAll>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AllToAll {
    concat_dimension: ::std::option::Option<i64>,
    split_dimension: ::std::option::Option<i64>,
    split_count: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AllToAll {
    fn default() -> Self {
        Self {
            concat_dimension: None,
            split_dimension: None,
            split_count: None,
            target_device_name: None,
        }
    }
}
impl AllToAll {
    /// Creates a new `AllToAll`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `concat_dimension` attribute.
    pub fn concat_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.concat_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_dimension` attribute.
    pub fn split_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.split_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_count` attribute.
    pub fn split_count<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.split_count = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute all_to_all.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        group_assignment: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AllToAll")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&group_assignment.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.concat_dimension {
            op.set_attr_int("concat_dimension", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.split_dimension {
            op.set_attr_int("split_dimension", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.split_count {
            op.set_attr_int("split_count", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AllToAll::new().call(&ctx, &input, &group_assignment)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AllToAll>
pub fn all_to_all<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    group_assignment: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AllToAll::new();
    op.call(ctx, input, group_assignment)
}

/// Angle
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Angle>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Angle {
    Tout: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Angle {
    fn default() -> Self {
        Self {
            Tout: Some(crate::DataType::Float),
            target_device_name: None,
        }
    }
}
impl Angle {
    /// Creates a new `Angle`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute angle.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Angle")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type("Tout", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Angle::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Angle>
pub fn angle<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Angle::new();
    op.call(ctx, input)
}

/// AnonymousHashTable
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousHashTable>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousHashTable {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousHashTable {
    fn default() -> Self {
        Self {
            key_dtype: None,
            value_dtype: None,
            target_device_name: None,
        }
    }
}
impl AnonymousHashTable {
    /// Creates a new `AnonymousHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_hash_table.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousHashTable")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.key_dtype {
            op.set_attr_type("key_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.value_dtype {
            op.set_attr_type("value_dtype", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousHashTable::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousHashTable>
pub fn anonymous_hash_table<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousHashTable::new();
    op.call(ctx)
}

/// AnonymousIterator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIterator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousIterator {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousIterator {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AnonymousIterator {
    /// Creates a new `AnonymousIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_iterator.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousIterator")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousIterator::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIterator>
pub fn anonymous_iterator<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousIterator::new();
    op.call(ctx)
}

/// AnonymousIteratorV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIteratorV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousIteratorV2 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousIteratorV2 {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AnonymousIteratorV2 {
    /// Creates a new `AnonymousIteratorV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_iterator_v2.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousIteratorV2")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AnonymousIteratorV2::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIteratorV2>
pub fn anonymous_iterator_v2<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = AnonymousIteratorV2::new();
    op.call(ctx)
}

/// AnonymousIteratorV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIteratorV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousIteratorV3 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousIteratorV3 {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AnonymousIteratorV3 {
    /// Creates a new `AnonymousIteratorV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_iterator_v3.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousIteratorV3")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousIteratorV3::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousIteratorV3>
pub fn anonymous_iterator_v3<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousIteratorV3::new();
    op.call(ctx)
}

/// AnonymousMemoryCache
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMemoryCache>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousMemoryCache {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousMemoryCache {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AnonymousMemoryCache {
    /// Creates a new `AnonymousMemoryCache`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_memory_cache.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousMemoryCache")?;

        // Required input arguments

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AnonymousMemoryCache::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMemoryCache>
pub fn anonymous_memory_cache<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = AnonymousMemoryCache::new();
    op.call(ctx)
}

/// AnonymousMultiDeviceIterator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMultiDeviceIterator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousMultiDeviceIterator {
    devices: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousMultiDeviceIterator {
    fn default() -> Self {
        Self {
            devices: None,
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AnonymousMultiDeviceIterator {
    /// Creates a new `AnonymousMultiDeviceIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `devices` attribute.
    pub fn devices<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.devices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_multi_device_iterator.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousMultiDeviceIterator")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.devices {
            op.set_attr_string_list("devices", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AnonymousMultiDeviceIterator::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMultiDeviceIterator>
pub fn anonymous_multi_device_iterator<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = AnonymousMultiDeviceIterator::new();
    op.call(ctx)
}

/// AnonymousMutableDenseHashTable
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableDenseHashTable>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousMutableDenseHashTable {
    value_dtype: ::std::option::Option<crate::DataType>,
    value_shape: ::std::option::Option<crate::Shape>,
    initial_num_buckets: ::std::option::Option<i64>,
    max_load_factor: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousMutableDenseHashTable {
    fn default() -> Self {
        Self {
            value_dtype: None,
            value_shape: None,
            initial_num_buckets: Some(131072i64),
            max_load_factor: Some(0.8f32),
            target_device_name: None,
        }
    }
}
impl AnonymousMutableDenseHashTable {
    /// Creates a new `AnonymousMutableDenseHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_shape` attribute.
    pub fn value_shape<ArgType: ::std::convert::Into<crate::Shape>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `initial_num_buckets` attribute.
    pub fn initial_num_buckets<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.initial_num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_load_factor` attribute.
    pub fn max_load_factor<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.max_load_factor = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_mutable_dense_hash_table.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        empty_key: &T0,
        deleted_key: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousMutableDenseHashTable")?;

        // Required input arguments
        op.add_input(&empty_key.to_handle(ctx)?)?;
        op.add_input(&deleted_key.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.value_dtype {
            op.set_attr_type("value_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.value_shape {
            op.set_attr_shape("value_shape", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.initial_num_buckets {
            op.set_attr_int("initial_num_buckets", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_load_factor {
            op.set_attr_float("max_load_factor", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousMutableDenseHashTable::new().call(&ctx, &empty_key, &deleted_key)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableDenseHashTable>
pub fn anonymous_mutable_dense_hash_table<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    empty_key: &T0,
    deleted_key: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousMutableDenseHashTable::new();
    op.call(ctx, empty_key, deleted_key)
}

/// AnonymousMutableHashTable
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableHashTable>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousMutableHashTable {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousMutableHashTable {
    fn default() -> Self {
        Self {
            key_dtype: None,
            value_dtype: None,
            target_device_name: None,
        }
    }
}
impl AnonymousMutableHashTable {
    /// Creates a new `AnonymousMutableHashTable`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_mutable_hash_table.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousMutableHashTable")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.key_dtype {
            op.set_attr_type("key_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.value_dtype {
            op.set_attr_type("value_dtype", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousMutableHashTable::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableHashTable>
pub fn anonymous_mutable_hash_table<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousMutableHashTable::new();
    op.call(ctx)
}

/// AnonymousMutableHashTableOfTensors
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableHashTableOfTensors>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousMutableHashTableOfTensors {
    key_dtype: ::std::option::Option<crate::DataType>,
    value_dtype: ::std::option::Option<crate::DataType>,
    value_shape: ::std::option::Option<crate::Shape>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousMutableHashTableOfTensors {
    fn default() -> Self {
        Self {
            key_dtype: None,
            value_dtype: None,
            value_shape: None,
            target_device_name: None,
        }
    }
}
impl AnonymousMutableHashTableOfTensors {
    /// Creates a new `AnonymousMutableHashTableOfTensors`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `key_dtype` attribute.
    pub fn key_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.key_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_dtype` attribute.
    pub fn value_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `value_shape` attribute.
    pub fn value_shape<ArgType: ::std::convert::Into<crate::Shape>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_mutable_hash_table_of_tensors.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousMutableHashTableOfTensors")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.key_dtype {
            op.set_attr_type("key_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.value_dtype {
            op.set_attr_type("value_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.value_shape {
            op.set_attr_shape("value_shape", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AnonymousMutableHashTableOfTensors::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousMutableHashTableOfTensors>
pub fn anonymous_mutable_hash_table_of_tensors<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AnonymousMutableHashTableOfTensors::new();
    op.call(ctx)
}

/// AnonymousRandomSeedGenerator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousRandomSeedGenerator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousRandomSeedGenerator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousRandomSeedGenerator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AnonymousRandomSeedGenerator {
    /// Creates a new `AnonymousRandomSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_random_seed_generator.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        seed: &T0,
        seed2: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousRandomSeedGenerator")?;

        // Required input arguments
        op.add_input(&seed.to_handle(ctx)?)?;
        op.add_input(&seed2.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AnonymousRandomSeedGenerator::new().call(&ctx, &seed, &seed2)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousRandomSeedGenerator>
pub fn anonymous_random_seed_generator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seed: &T0,
    seed2: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = AnonymousRandomSeedGenerator::new();
    op.call(ctx, seed, seed2)
}

/// AnonymousSeedGenerator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousSeedGenerator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AnonymousSeedGenerator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AnonymousSeedGenerator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AnonymousSeedGenerator {
    /// Creates a new `AnonymousSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute anonymous_seed_generator.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        seed: &T0,
        seed2: &T1,
        reshuffle: &T2,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "AnonymousSeedGenerator")?;

        // Required input arguments
        op.add_input(&seed.to_handle(ctx)?)?;
        op.add_input(&seed2.to_handle(ctx)?)?;
        op.add_input(&reshuffle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `AnonymousSeedGenerator::new().call(&ctx, &seed, &seed2, &reshuffle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AnonymousSeedGenerator>
pub fn anonymous_seed_generator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seed: &T0,
    seed2: &T1,
    reshuffle: &T2,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = AnonymousSeedGenerator::new();
    op.call(ctx, seed, seed2, reshuffle)
}

/// Any
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Any>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Any {
    keep_dims: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Any {
    fn default() -> Self {
        Self {
            keep_dims: Some(false),
            target_device_name: None,
        }
    }
}
impl Any {
    /// Creates a new `Any`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `keep_dims` attribute.
    pub fn keep_dims<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.keep_dims = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute any.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        reduction_indices: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Any")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&reduction_indices.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.keep_dims {
            op.set_attr_bool("keep_dims", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Any::new().call(&ctx, &input, &reduction_indices)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Any>
pub fn any<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    reduction_indices: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Any::new();
    op.call(ctx, input, reduction_indices)
}

/// ApplyAdaMax
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdaMax>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdaMax {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdaMax {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyAdaMax {
    /// Creates a new `ApplyAdaMax`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_ada_max.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        m: &T1,
        v: &T2,
        beta1_power: &T3,
        lr: &T4,
        beta1: &T5,
        beta2: &T6,
        epsilon: &T7,
        grad: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdaMax")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&v.to_handle(ctx)?)?;
        op.add_input(&beta1_power.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&beta1.to_handle(ctx)?)?;
        op.add_input(&beta2.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdaMax::new().call(&ctx, &var, &m, &v, &beta1_power, &lr, &beta1, &beta2, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdaMax>
pub fn apply_ada_max<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    m: &T1,
    v: &T2,
    beta1_power: &T3,
    lr: &T4,
    beta1: &T5,
    beta2: &T6,
    epsilon: &T7,
    grad: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdaMax::new();
    op.call(ctx, var, m, v, beta1_power, lr, beta1, beta2, epsilon, grad)
}

/// ApplyAdadelta
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdadelta>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdadelta {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdadelta {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyAdadelta {
    /// Creates a new `ApplyAdadelta`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_adadelta.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        accum_update: &T2,
        lr: &T3,
        rho: &T4,
        epsilon: &T5,
        grad: &T6,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdadelta")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&accum_update.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&rho.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdadelta::new().call(&ctx, &var, &accum, &accum_update, &lr, &rho, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdadelta>
pub fn apply_adadelta<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    accum_update: &T2,
    lr: &T3,
    rho: &T4,
    epsilon: &T5,
    grad: &T6,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdadelta::new();
    op.call(ctx, var, accum, accum_update, lr, rho, epsilon, grad)
}

/// ApplyAdagrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdagrad {
    use_locking: ::std::option::Option<bool>,
    update_slots: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdagrad {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            update_slots: Some(true),
            target_device_name: None,
        }
    }
}
impl ApplyAdagrad {
    /// Creates a new `ApplyAdagrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `update_slots` attribute.
    pub fn update_slots<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.update_slots = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_adagrad.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        lr: &T2,
        grad: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdagrad")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.update_slots {
            op.set_attr_bool("update_slots", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdagrad::new().call(&ctx, &var, &accum, &lr, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagrad>
pub fn apply_adagrad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    lr: &T2,
    grad: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdagrad::new();
    op.call(ctx, var, accum, lr, grad)
}

/// ApplyAdagradDA
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagradDA>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdagradDA {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdagradDA {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyAdagradDA {
    /// Creates a new `ApplyAdagradDA`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_adagrad_da.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        gradient_accumulator: &T1,
        gradient_squared_accumulator: &T2,
        grad: &T3,
        lr: &T4,
        l1: &T5,
        l2: &T6,
        global_step: &T7,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdagradDA")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&gradient_accumulator.to_handle(ctx)?)?;
        op.add_input(&gradient_squared_accumulator.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&global_step.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdagradDA::new().call(&ctx, &var, &gradient_accumulator, &gradient_squared_accumulator, &grad, &lr, &l1, &l2, &global_step)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagradDA>
pub fn apply_adagrad_da<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    gradient_accumulator: &T1,
    gradient_squared_accumulator: &T2,
    grad: &T3,
    lr: &T4,
    l1: &T5,
    l2: &T6,
    global_step: &T7,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdagradDA::new();
    op.call(
        ctx,
        var,
        gradient_accumulator,
        gradient_squared_accumulator,
        grad,
        lr,
        l1,
        l2,
        global_step,
    )
}

/// ApplyAdagradV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagradV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdagradV2 {
    use_locking: ::std::option::Option<bool>,
    update_slots: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdagradV2 {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            update_slots: Some(true),
            target_device_name: None,
        }
    }
}
impl ApplyAdagradV2 {
    /// Creates a new `ApplyAdagradV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `update_slots` attribute.
    pub fn update_slots<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.update_slots = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_adagrad_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        lr: &T2,
        epsilon: &T3,
        grad: &T4,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdagradV2")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.update_slots {
            op.set_attr_bool("update_slots", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdagradV2::new().call(&ctx, &var, &accum, &lr, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdagradV2>
pub fn apply_adagrad_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    lr: &T2,
    epsilon: &T3,
    grad: &T4,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdagradV2::new();
    op.call(ctx, var, accum, lr, epsilon, grad)
}

/// ApplyAdam
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdam>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAdam {
    use_locking: ::std::option::Option<bool>,
    use_nesterov: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAdam {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            use_nesterov: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyAdam {
    /// Creates a new `ApplyAdam`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_nesterov` attribute.
    pub fn use_nesterov<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_nesterov = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_adam.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        m: &T1,
        v: &T2,
        beta1_power: &T3,
        beta2_power: &T4,
        lr: &T5,
        beta1: &T6,
        beta2: &T7,
        epsilon: &T8,
        grad: &T9,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAdam")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&v.to_handle(ctx)?)?;
        op.add_input(&beta1_power.to_handle(ctx)?)?;
        op.add_input(&beta2_power.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&beta1.to_handle(ctx)?)?;
        op.add_input(&beta2.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_nesterov {
            op.set_attr_bool("use_nesterov", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAdam::new().call(&ctx, &var, &m, &v, &beta1_power, &beta2_power, &lr, &beta1, &beta2, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAdam>
pub fn apply_adam<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    m: &T1,
    v: &T2,
    beta1_power: &T3,
    beta2_power: &T4,
    lr: &T5,
    beta1: &T6,
    beta2: &T7,
    epsilon: &T8,
    grad: &T9,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAdam::new();
    op.call(
        ctx,
        var,
        m,
        v,
        beta1_power,
        beta2_power,
        lr,
        beta1,
        beta2,
        epsilon,
        grad,
    )
}

/// ApplyAddSign
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAddSign>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyAddSign {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyAddSign {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyAddSign {
    /// Creates a new `ApplyAddSign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_add_sign.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        m: &T1,
        lr: &T2,
        alpha: &T3,
        sign_decay: &T4,
        beta: &T5,
        grad: &T6,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyAddSign")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&alpha.to_handle(ctx)?)?;
        op.add_input(&sign_decay.to_handle(ctx)?)?;
        op.add_input(&beta.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyAddSign::new().call(&ctx, &var, &m, &lr, &alpha, &sign_decay, &beta, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyAddSign>
pub fn apply_add_sign<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    m: &T1,
    lr: &T2,
    alpha: &T3,
    sign_decay: &T4,
    beta: &T5,
    grad: &T6,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyAddSign::new();
    op.call(ctx, var, m, lr, alpha, sign_decay, beta, grad)
}

/// ApplyCenteredRMSProp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyCenteredRMSProp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyCenteredRMSProp {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyCenteredRMSProp {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyCenteredRMSProp {
    /// Creates a new `ApplyCenteredRMSProp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_centered_rmsprop.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        mg: &T1,
        ms: &T2,
        mom: &T3,
        lr: &T4,
        rho: &T5,
        momentum: &T6,
        epsilon: &T7,
        grad: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyCenteredRMSProp")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&mg.to_handle(ctx)?)?;
        op.add_input(&ms.to_handle(ctx)?)?;
        op.add_input(&mom.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&rho.to_handle(ctx)?)?;
        op.add_input(&momentum.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyCenteredRMSProp::new().call(&ctx, &var, &mg, &ms, &mom, &lr, &rho, &momentum, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyCenteredRMSProp>
pub fn apply_centered_rmsprop<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    mg: &T1,
    ms: &T2,
    mom: &T3,
    lr: &T4,
    rho: &T5,
    momentum: &T6,
    epsilon: &T7,
    grad: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyCenteredRMSProp::new();
    op.call(ctx, var, mg, ms, mom, lr, rho, momentum, epsilon, grad)
}

/// ApplyFtrl
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyFtrl>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyFtrl {
    use_locking: ::std::option::Option<bool>,
    multiply_linear_by_lr: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyFtrl {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            multiply_linear_by_lr: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyFtrl {
    /// Creates a new `ApplyFtrl`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `multiply_linear_by_lr` attribute.
    pub fn multiply_linear_by_lr<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.multiply_linear_by_lr = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_ftrl.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        linear: &T2,
        grad: &T3,
        lr: &T4,
        l1: &T5,
        l2: &T6,
        lr_power: &T7,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyFtrl")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&linear.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&lr_power.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.multiply_linear_by_lr {
            op.set_attr_bool("multiply_linear_by_lr", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyFtrl::new().call(&ctx, &var, &accum, &linear, &grad, &lr, &l1, &l2, &lr_power)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyFtrl>
pub fn apply_ftrl<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    linear: &T2,
    grad: &T3,
    lr: &T4,
    l1: &T5,
    l2: &T6,
    lr_power: &T7,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyFtrl::new();
    op.call(ctx, var, accum, linear, grad, lr, l1, l2, lr_power)
}

/// ApplyFtrlV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyFtrlV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyFtrlV2 {
    use_locking: ::std::option::Option<bool>,
    multiply_linear_by_lr: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyFtrlV2 {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            multiply_linear_by_lr: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyFtrlV2 {
    /// Creates a new `ApplyFtrlV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `multiply_linear_by_lr` attribute.
    pub fn multiply_linear_by_lr<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.multiply_linear_by_lr = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_ftrl_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        linear: &T2,
        grad: &T3,
        lr: &T4,
        l1: &T5,
        l2: &T6,
        l2_shrinkage: &T7,
        lr_power: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyFtrlV2")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&linear.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&l2_shrinkage.to_handle(ctx)?)?;
        op.add_input(&lr_power.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.multiply_linear_by_lr {
            op.set_attr_bool("multiply_linear_by_lr", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyFtrlV2::new().call(&ctx, &var, &accum, &linear, &grad, &lr, &l1, &l2, &l2_shrinkage, &lr_power)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyFtrlV2>
pub fn apply_ftrl_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    linear: &T2,
    grad: &T3,
    lr: &T4,
    l1: &T5,
    l2: &T6,
    l2_shrinkage: &T7,
    lr_power: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyFtrlV2::new();
    op.call(
        ctx,
        var,
        accum,
        linear,
        grad,
        lr,
        l1,
        l2,
        l2_shrinkage,
        lr_power,
    )
}

/// ApplyGradientDescent
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyGradientDescent>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyGradientDescent {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyGradientDescent {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyGradientDescent {
    /// Creates a new `ApplyGradientDescent`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_gradient_descent.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        alpha: &T1,
        delta: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyGradientDescent")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&alpha.to_handle(ctx)?)?;
        op.add_input(&delta.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyGradientDescent::new().call(&ctx, &var, &alpha, &delta)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyGradientDescent>
pub fn apply_gradient_descent<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    alpha: &T1,
    delta: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyGradientDescent::new();
    op.call(ctx, var, alpha, delta)
}

/// ApplyMomentum
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyMomentum>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyMomentum {
    use_locking: ::std::option::Option<bool>,
    use_nesterov: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyMomentum {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            use_nesterov: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyMomentum {
    /// Creates a new `ApplyMomentum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_nesterov` attribute.
    pub fn use_nesterov<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_nesterov = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_momentum.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        lr: &T2,
        grad: &T3,
        momentum: &T4,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyMomentum")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;
        op.add_input(&momentum.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_nesterov {
            op.set_attr_bool("use_nesterov", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyMomentum::new().call(&ctx, &var, &accum, &lr, &grad, &momentum)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyMomentum>
pub fn apply_momentum<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    lr: &T2,
    grad: &T3,
    momentum: &T4,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyMomentum::new();
    op.call(ctx, var, accum, lr, grad, momentum)
}

/// ApplyPowerSign
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyPowerSign>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyPowerSign {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyPowerSign {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyPowerSign {
    /// Creates a new `ApplyPowerSign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_power_sign.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        m: &T1,
        lr: &T2,
        logbase: &T3,
        sign_decay: &T4,
        beta: &T5,
        grad: &T6,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyPowerSign")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&logbase.to_handle(ctx)?)?;
        op.add_input(&sign_decay.to_handle(ctx)?)?;
        op.add_input(&beta.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyPowerSign::new().call(&ctx, &var, &m, &lr, &logbase, &sign_decay, &beta, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyPowerSign>
pub fn apply_power_sign<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    m: &T1,
    lr: &T2,
    logbase: &T3,
    sign_decay: &T4,
    beta: &T5,
    grad: &T6,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyPowerSign::new();
    op.call(ctx, var, m, lr, logbase, sign_decay, beta, grad)
}

/// ApplyProximalAdagrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyProximalAdagrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyProximalAdagrad {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyProximalAdagrad {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyProximalAdagrad {
    /// Creates a new `ApplyProximalAdagrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_proximal_adagrad.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        accum: &T1,
        lr: &T2,
        l1: &T3,
        l2: &T4,
        grad: &T5,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyProximalAdagrad")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&accum.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyProximalAdagrad::new().call(&ctx, &var, &accum, &lr, &l1, &l2, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyProximalAdagrad>
pub fn apply_proximal_adagrad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    accum: &T1,
    lr: &T2,
    l1: &T3,
    l2: &T4,
    grad: &T5,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyProximalAdagrad::new();
    op.call(ctx, var, accum, lr, l1, l2, grad)
}

/// ApplyProximalGradientDescent
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyProximalGradientDescent>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyProximalGradientDescent {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyProximalGradientDescent {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyProximalGradientDescent {
    /// Creates a new `ApplyProximalGradientDescent`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_proximal_gradient_descent.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        alpha: &T1,
        l1: &T2,
        l2: &T3,
        delta: &T4,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyProximalGradientDescent")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&alpha.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&delta.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyProximalGradientDescent::new().call(&ctx, &var, &alpha, &l1, &l2, &delta)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyProximalGradientDescent>
pub fn apply_proximal_gradient_descent<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    alpha: &T1,
    l1: &T2,
    l2: &T3,
    delta: &T4,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyProximalGradientDescent::new();
    op.call(ctx, var, alpha, l1, l2, delta)
}

/// ApplyRMSProp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyRMSProp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApplyRMSProp {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApplyRMSProp {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl ApplyRMSProp {
    /// Creates a new `ApplyRMSProp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute apply_rmsprop.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        var: &T0,
        ms: &T1,
        mom: &T2,
        lr: &T3,
        rho: &T4,
        momentum: &T5,
        epsilon: &T6,
        grad: &T7,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApplyRMSProp")?;

        // Required input arguments
        op.add_input(&var.to_handle(ctx)?)?;
        op.add_input(&ms.to_handle(ctx)?)?;
        op.add_input(&mom.to_handle(ctx)?)?;
        op.add_input(&lr.to_handle(ctx)?)?;
        op.add_input(&rho.to_handle(ctx)?)?;
        op.add_input(&momentum.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApplyRMSProp::new().call(&ctx, &var, &ms, &mom, &lr, &rho, &momentum, &epsilon, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApplyRMSProp>
pub fn apply_rmsprop<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    var: &T0,
    ms: &T1,
    mom: &T2,
    lr: &T3,
    rho: &T4,
    momentum: &T5,
    epsilon: &T6,
    grad: &T7,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApplyRMSProp::new();
    op.call(ctx, var, ms, mom, lr, rho, momentum, epsilon, grad)
}

/// ApproximateEqual
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApproximateEqual>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ApproximateEqual {
    tolerance: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ApproximateEqual {
    fn default() -> Self {
        Self {
            tolerance: Some(0.00001f32),
            target_device_name: None,
        }
    }
}
impl ApproximateEqual {
    /// Creates a new `ApproximateEqual`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `tolerance` attribute.
    pub fn tolerance<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.tolerance = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute approximate_equal.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ApproximateEqual")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.tolerance {
            op.set_attr_float("tolerance", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ApproximateEqual::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ApproximateEqual>
pub fn approximate_equal<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ApproximateEqual::new();
    op.call(ctx, x, y)
}

/// ArgMax
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ArgMax>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ArgMax {
    output_type: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ArgMax {
    fn default() -> Self {
        Self {
            output_type: Some(crate::DataType::Int64),
            target_device_name: None,
        }
    }
}
impl ArgMax {
    /// Creates a new `ArgMax`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_type` attribute.
    pub fn output_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute arg_max.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        dimension: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ArgMax")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&dimension.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_type {
            op.set_attr_type("output_type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ArgMax::new().call(&ctx, &input, &dimension)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ArgMax>
pub fn arg_max<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    dimension: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ArgMax::new();
    op.call(ctx, input, dimension)
}

/// ArgMin
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ArgMin>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ArgMin {
    output_type: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ArgMin {
    fn default() -> Self {
        Self {
            output_type: Some(crate::DataType::Int64),
            target_device_name: None,
        }
    }
}
impl ArgMin {
    /// Creates a new `ArgMin`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_type` attribute.
    pub fn output_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute arg_min.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        dimension: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ArgMin")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&dimension.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_type {
            op.set_attr_type("output_type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ArgMin::new().call(&ctx, &input, &dimension)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ArgMin>
pub fn arg_min<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    dimension: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ArgMin::new();
    op.call(ctx, input, dimension)
}

/// AsString
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AsString>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AsString {
    precision: ::std::option::Option<i64>,
    scientific: ::std::option::Option<bool>,
    shortest: ::std::option::Option<bool>,
    width: ::std::option::Option<i64>,
    fill: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AsString {
    fn default() -> Self {
        Self {
            precision: Some(-1i64),
            scientific: Some(false),
            shortest: Some(false),
            width: Some(-1i64),
            fill: None,
            target_device_name: None,
        }
    }
}
impl AsString {
    /// Creates a new `AsString`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `precision` attribute.
    pub fn precision<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.precision = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scientific` attribute.
    pub fn scientific<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.scientific = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shortest` attribute.
    pub fn shortest<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.shortest = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `width` attribute.
    pub fn width<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.width = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fill` attribute.
    pub fn fill<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.fill = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute as_string.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AsString")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.precision {
            op.set_attr_int("precision", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.scientific {
            op.set_attr_bool("scientific", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shortest {
            op.set_attr_bool("shortest", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.width {
            op.set_attr_int("width", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.fill {
            op.set_attr_string("fill", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AsString::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AsString>
pub fn as_string<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AsString::new();
    op.call(ctx, input)
}

/// Asin
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Asin>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Asin {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Asin {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Asin {
    /// Creates a new `Asin`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute asin.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Asin")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Asin::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Asin>
pub fn asin<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Asin::new();
    op.call(ctx, x)
}

/// Asinh
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Asinh>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Asinh {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Asinh {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Asinh {
    /// Creates a new `Asinh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute asinh.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Asinh")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Asinh::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Asinh>
pub fn asinh<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Asinh::new();
    op.call(ctx, x)
}

/// Assert
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Assert>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Assert {
    summarize: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Assert {
    fn default() -> Self {
        Self {
            summarize: Some(3i64),
            target_device_name: None,
        }
    }
}
impl Assert {
    /// Creates a new `Assert`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `summarize` attribute.
    pub fn summarize<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.summarize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assert.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        condition: &T0,
        data: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "Assert")?;

        // Required input arguments
        op.add_input(&condition.to_handle(ctx)?)?;
        op.add_input(&data.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.summarize {
            op.set_attr_int("summarize", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `Assert::new().call(&ctx, &condition, &data)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Assert>
pub fn assert<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    condition: &T0,
    data: &T1,
) -> crate::Result<()> {
    let op = Assert::new();
    op.call(ctx, condition, data)
}

/// AssertCardinalityDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssertCardinalityDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssertCardinalityDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssertCardinalityDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AssertCardinalityDataset {
    /// Creates a new `AssertCardinalityDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assert_cardinality_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        cardinality: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssertCardinalityDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&cardinality.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AssertCardinalityDataset::new().call(&ctx, &input_dataset, &cardinality)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssertCardinalityDataset>
pub fn assert_cardinality_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    cardinality: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AssertCardinalityDataset::new();
    op.call(ctx, input_dataset, cardinality)
}

/// AssertNextDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssertNextDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssertNextDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssertNextDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl AssertNextDataset {
    /// Creates a new `AssertNextDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assert_next_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        transformations: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssertNextDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&transformations.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AssertNextDataset::new().call(&ctx, &input_dataset, &transformations)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssertNextDataset>
pub fn assert_next_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    transformations: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AssertNextDataset::new();
    op.call(ctx, input_dataset, transformations)
}

/// Assign
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Assign>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Assign {
    validate_shape: ::std::option::Option<bool>,
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Assign {
    fn default() -> Self {
        Self {
            validate_shape: Some(true),
            use_locking: Some(true),
            target_device_name: None,
        }
    }
}
impl Assign {
    /// Creates a new `Assign`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `validate_shape` attribute.
    pub fn validate_shape<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        ref_: &T0,
        value: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Assign")?;

        // Required input arguments
        op.add_input(&ref_.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.validate_shape {
            op.set_attr_bool("validate_shape", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Assign::new().call(&ctx, &ref_, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Assign>
pub fn assign<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    ref_: &T0,
    value: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Assign::new();
    op.call(ctx, ref_, value)
}

/// AssignAdd
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignAdd>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignAdd {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignAdd {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl AssignAdd {
    /// Creates a new `AssignAdd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_add.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        ref_: &T0,
        value: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignAdd")?;

        // Required input arguments
        op.add_input(&ref_.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AssignAdd::new().call(&ctx, &ref_, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignAdd>
pub fn assign_add<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    ref_: &T0,
    value: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AssignAdd::new();
    op.call(ctx, ref_, value)
}

/// AssignAddVariableOp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignAddVariableOp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignAddVariableOp {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignAddVariableOp {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AssignAddVariableOp {
    /// Creates a new `AssignAddVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_add_variable_op.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        resource: &T0,
        value: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignAddVariableOp")?;

        // Required input arguments
        op.add_input(&resource.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AssignAddVariableOp::new().call(&ctx, &resource, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignAddVariableOp>
pub fn assign_add_variable_op<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    resource: &T0,
    value: &T1,
) -> crate::Result<()> {
    let op = AssignAddVariableOp::new();
    op.call(ctx, resource, value)
}

/// AssignSub
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignSub>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignSub {
    use_locking: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignSub {
    fn default() -> Self {
        Self {
            use_locking: Some(false),
            target_device_name: None,
        }
    }
}
impl AssignSub {
    /// Creates a new `AssignSub`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_locking` attribute.
    pub fn use_locking<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_locking = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_sub.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        ref_: &T0,
        value: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignSub")?;

        // Required input arguments
        op.add_input(&ref_.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_locking {
            op.set_attr_bool("use_locking", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AssignSub::new().call(&ctx, &ref_, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignSub>
pub fn assign_sub<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    ref_: &T0,
    value: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AssignSub::new();
    op.call(ctx, ref_, value)
}

/// AssignSubVariableOp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignSubVariableOp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignSubVariableOp {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignSubVariableOp {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl AssignSubVariableOp {
    /// Creates a new `AssignSubVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_sub_variable_op.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        resource: &T0,
        value: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignSubVariableOp")?;

        // Required input arguments
        op.add_input(&resource.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AssignSubVariableOp::new().call(&ctx, &resource, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignSubVariableOp>
pub fn assign_sub_variable_op<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    resource: &T0,
    value: &T1,
) -> crate::Result<()> {
    let op = AssignSubVariableOp::new();
    op.call(ctx, resource, value)
}

/// AssignVariableOp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignVariableOp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignVariableOp {
    validate_shape: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignVariableOp {
    fn default() -> Self {
        Self {
            validate_shape: Some(false),
            target_device_name: None,
        }
    }
}
impl AssignVariableOp {
    /// Creates a new `AssignVariableOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `validate_shape` attribute.
    pub fn validate_shape<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_variable_op.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        resource: &T0,
        value: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignVariableOp")?;

        // Required input arguments
        op.add_input(&resource.to_handle(ctx)?)?;
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.validate_shape {
            op.set_attr_bool("validate_shape", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AssignVariableOp::new().call(&ctx, &resource, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignVariableOp>
pub fn assign_variable_op<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    resource: &T0,
    value: &T1,
) -> crate::Result<()> {
    let op = AssignVariableOp::new();
    op.call(ctx, resource, value)
}

/// AssignVariableXlaConcatND
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignVariableXlaConcatND>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AssignVariableXlaConcatND {
    num_concats: ::std::option::Option<::std::vec::Vec<i64>>,
    paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AssignVariableXlaConcatND {
    fn default() -> Self {
        Self {
            num_concats: None,
            paddings: Some(vec![]),
            target_device_name: None,
        }
    }
}
impl AssignVariableXlaConcatND {
    /// Creates a new `AssignVariableXlaConcatND`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_concats` attribute.
    pub fn num_concats<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_concats = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `paddings` attribute.
    pub fn paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute assign_variable_xla_concat_nd.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        resource: &T0,
        inputs: &[&T1],
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "AssignVariableXlaConcatND")?;

        // Required input arguments
        op.add_input(&resource.to_handle(ctx)?)?;
        let mut inputs_list = Vec::new();

        for t in inputs {
            inputs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&inputs_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_concats {
            op.set_attr_int_list("num_concats", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.paddings {
            op.set_attr_int_list("paddings", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `AssignVariableXlaConcatND::new().call(&ctx, &resource, &inputs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AssignVariableXlaConcatND>
pub fn assign_variable_xla_concat_nd<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    resource: &T0,
    inputs: &[&T1],
) -> crate::Result<()> {
    let op = AssignVariableXlaConcatND::new();
    op.call(ctx, resource, inputs)
}

/// Atan
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atan>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Atan {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Atan {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Atan {
    /// Creates a new `Atan`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute atan.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Atan")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Atan::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atan>
pub fn atan<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Atan::new();
    op.call(ctx, x)
}

/// Atan2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atan2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Atan2 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Atan2 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Atan2 {
    /// Creates a new `Atan2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute atan2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        y: &T0,
        x: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Atan2")?;

        // Required input arguments
        op.add_input(&y.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Atan2::new().call(&ctx, &y, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atan2>
pub fn atan2<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    y: &T0,
    x: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Atan2::new();
    op.call(ctx, y, x)
}

/// Atanh
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atanh>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Atanh {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Atanh {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Atanh {
    /// Creates a new `Atanh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute atanh.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Atanh")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Atanh::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Atanh>
pub fn atanh<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Atanh::new();
    op.call(ctx, x)
}

/// AudioSpectrogram
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSpectrogram>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AudioSpectrogram {
    window_size: ::std::option::Option<i64>,
    stride: ::std::option::Option<i64>,
    magnitude_squared: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AudioSpectrogram {
    fn default() -> Self {
        Self {
            window_size: None,
            stride: None,
            magnitude_squared: Some(false),
            target_device_name: None,
        }
    }
}
impl AudioSpectrogram {
    /// Creates a new `AudioSpectrogram`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `window_size` attribute.
    pub fn window_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.window_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `stride` attribute.
    pub fn stride<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.stride = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `magnitude_squared` attribute.
    pub fn magnitude_squared<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.magnitude_squared = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute audio_spectrogram.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AudioSpectrogram")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.window_size {
            op.set_attr_int("window_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.stride {
            op.set_attr_int("stride", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.magnitude_squared {
            op.set_attr_bool("magnitude_squared", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AudioSpectrogram::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSpectrogram>
pub fn audio_spectrogram<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AudioSpectrogram::new();
    op.call(ctx, input)
}

/// AudioSummary
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSummary>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AudioSummary {
    sample_rate: ::std::option::Option<f32>,
    max_outputs: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AudioSummary {
    fn default() -> Self {
        Self {
            sample_rate: None,
            max_outputs: Some(3i64),
            target_device_name: None,
        }
    }
}
impl AudioSummary {
    /// Creates a new `AudioSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `sample_rate` attribute.
    pub fn sample_rate<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.sample_rate = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_outputs` attribute.
    pub fn max_outputs<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_outputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute audio_summary.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tag: &T0,
        tensor: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AudioSummary")?;

        // Required input arguments
        op.add_input(&tag.to_handle(ctx)?)?;
        op.add_input(&tensor.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.sample_rate {
            op.set_attr_float("sample_rate", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_outputs {
            op.set_attr_int("max_outputs", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AudioSummary::new().call(&ctx, &tag, &tensor)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSummary>
pub fn audio_summary<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tag: &T0,
    tensor: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AudioSummary::new();
    op.call(ctx, tag, tensor)
}

/// AudioSummaryV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSummaryV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AudioSummaryV2 {
    max_outputs: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AudioSummaryV2 {
    fn default() -> Self {
        Self {
            max_outputs: Some(3i64),
            target_device_name: None,
        }
    }
}
impl AudioSummaryV2 {
    /// Creates a new `AudioSummaryV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_outputs` attribute.
    pub fn max_outputs<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_outputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute audio_summary_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tag: &T0,
        tensor: &T1,
        sample_rate: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AudioSummaryV2")?;

        // Required input arguments
        op.add_input(&tag.to_handle(ctx)?)?;
        op.add_input(&tensor.to_handle(ctx)?)?;
        op.add_input(&sample_rate.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_outputs {
            op.set_attr_int("max_outputs", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AudioSummaryV2::new().call(&ctx, &tag, &tensor, &sample_rate)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AudioSummaryV2>
pub fn audio_summary_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tag: &T0,
    tensor: &T1,
    sample_rate: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AudioSummaryV2::new();
    op.call(ctx, tag, tensor, sample_rate)
}

/// AutoShardDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AutoShardDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AutoShardDataset {
    auto_shard_policy: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    num_replicas: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AutoShardDataset {
    fn default() -> Self {
        Self {
            auto_shard_policy: Some(0i64),
            output_types: None,
            output_shapes: None,
            num_replicas: Some(0i64),
            target_device_name: None,
        }
    }
}
impl AutoShardDataset {
    /// Creates a new `AutoShardDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `auto_shard_policy` attribute.
    pub fn auto_shard_policy<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.auto_shard_policy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_replicas` attribute.
    pub fn num_replicas<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_replicas = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute auto_shard_dataset.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        num_workers: &T1,
        index: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AutoShardDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&num_workers.to_handle(ctx)?)?;
        op.add_input(&index.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.auto_shard_policy {
            op.set_attr_int("auto_shard_policy", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_replicas {
            op.set_attr_int("num_replicas", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AutoShardDataset::new().call(&ctx, &input_dataset, &num_workers, &index)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AutoShardDataset>
pub fn auto_shard_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    num_workers: &T1,
    index: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AutoShardDataset::new();
    op.call(ctx, input_dataset, num_workers, index)
}

/// AvgPool
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AvgPool {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AvgPool {
    fn default() -> Self {
        Self {
            ksize: None,
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NHWC")),
            target_device_name: None,
        }
    }
}
impl AvgPool {
    /// Creates a new `AvgPool`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute avg_pool.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        value: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AvgPool")?;

        // Required input arguments
        op.add_input(&value.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.ksize {
            op.set_attr_int_list("ksize", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AvgPool::new().call(&ctx, &value)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool>
pub fn avg_pool<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    value: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AvgPool::new();
    op.call(ctx, value)
}

/// AvgPool3D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool3D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AvgPool3D {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AvgPool3D {
    fn default() -> Self {
        Self {
            ksize: None,
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NDHWC")),
            target_device_name: None,
        }
    }
}
impl AvgPool3D {
    /// Creates a new `AvgPool3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute avg_pool3_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AvgPool3D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.ksize {
            op.set_attr_int_list("ksize", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AvgPool3D::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool3D>
pub fn avg_pool3_d<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AvgPool3D::new();
    op.call(ctx, input)
}

/// AvgPool3DGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool3DGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AvgPool3DGrad {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AvgPool3DGrad {
    fn default() -> Self {
        Self {
            ksize: None,
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NDHWC")),
            target_device_name: None,
        }
    }
}
impl AvgPool3DGrad {
    /// Creates a new `AvgPool3DGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute avg_pool3_dgrad.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        orig_input_shape: &T0,
        grad: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AvgPool3DGrad")?;

        // Required input arguments
        op.add_input(&orig_input_shape.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.ksize {
            op.set_attr_int_list("ksize", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AvgPool3DGrad::new().call(&ctx, &orig_input_shape, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPool3DGrad>
pub fn avg_pool3_dgrad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    orig_input_shape: &T0,
    grad: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AvgPool3DGrad::new();
    op.call(ctx, orig_input_shape, grad)
}

/// AvgPoolGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPoolGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct AvgPoolGrad {
    ksize: ::std::option::Option<::std::vec::Vec<i64>>,
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for AvgPoolGrad {
    fn default() -> Self {
        Self {
            ksize: None,
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NHWC")),
            target_device_name: None,
        }
    }
}
impl AvgPoolGrad {
    /// Creates a new `AvgPoolGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `ksize` attribute.
    pub fn ksize<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ksize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute avg_pool_grad.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        orig_input_shape: &T0,
        grad: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "AvgPoolGrad")?;

        // Required input arguments
        op.add_input(&orig_input_shape.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.ksize {
            op.set_attr_int_list("ksize", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `AvgPoolGrad::new().call(&ctx, &orig_input_shape, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/AvgPoolGrad>
pub fn avg_pool_grad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    orig_input_shape: &T0,
    grad: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = AvgPoolGrad::new();
    op.call(ctx, orig_input_shape, grad)
}

/// BandedTriangularSolve
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BandedTriangularSolve>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BandedTriangularSolve {
    lower: ::std::option::Option<bool>,
    adjoint: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BandedTriangularSolve {
    fn default() -> Self {
        Self {
            lower: Some(true),
            adjoint: Some(false),
            target_device_name: None,
        }
    }
}
impl BandedTriangularSolve {
    /// Creates a new `BandedTriangularSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `lower` attribute.
    pub fn lower<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.lower = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute banded_triangular_solve.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        matrix: &T0,
        rhs: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BandedTriangularSolve")?;

        // Required input arguments
        op.add_input(&matrix.to_handle(ctx)?)?;
        op.add_input(&rhs.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.lower {
            op.set_attr_bool("lower", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adjoint {
            op.set_attr_bool("adjoint", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BandedTriangularSolve::new().call(&ctx, &matrix, &rhs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BandedTriangularSolve>
pub fn banded_triangular_solve<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    matrix: &T0,
    rhs: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BandedTriangularSolve::new();
    op.call(ctx, matrix, rhs)
}

/// Barrier
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Barrier>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Barrier {
    component_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    capacity: ::std::option::Option<i64>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Barrier {
    fn default() -> Self {
        Self {
            component_types: None,
            shapes: Some(vec![]),
            capacity: Some(-1i64),
            container: None,
            shared_name: None,
            target_device_name: None,
        }
    }
}
impl Barrier {
    /// Creates a new `Barrier`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `component_types` attribute.
    pub fn component_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.component_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shapes` attribute.
    pub fn shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `capacity` attribute.
    pub fn capacity<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.capacity = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Barrier")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.component_types {
            op.set_attr_type_list("component_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shapes {
            op.set_attr_shape_list("shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.capacity {
            op.set_attr_int("capacity", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Barrier::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Barrier>
pub fn barrier<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Barrier::new();
    op.call(ctx)
}

/// BarrierClose
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierClose>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BarrierClose {
    cancel_pending_enqueues: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BarrierClose {
    fn default() -> Self {
        Self {
            cancel_pending_enqueues: Some(false),
            target_device_name: None,
        }
    }
}
impl BarrierClose {
    /// Creates a new `BarrierClose`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `cancel_pending_enqueues` attribute.
    pub fn cancel_pending_enqueues<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.cancel_pending_enqueues = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier_close.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BarrierClose")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.cancel_pending_enqueues {
            op.set_attr_bool("cancel_pending_enqueues", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BarrierClose::new().call(&ctx, &handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierClose>
pub fn barrier_close<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
) -> crate::Result<()> {
    let op = BarrierClose::new();
    op.call(ctx, handle)
}

/// BarrierIncompleteSize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierIncompleteSize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BarrierIncompleteSize {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BarrierIncompleteSize {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BarrierIncompleteSize {
    /// Creates a new `BarrierIncompleteSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier_incomplete_size.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BarrierIncompleteSize")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BarrierIncompleteSize::new().call(&ctx, &handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierIncompleteSize>
pub fn barrier_incomplete_size<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BarrierIncompleteSize::new();
    op.call(ctx, handle)
}

/// BarrierInsertMany
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierInsertMany>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BarrierInsertMany {
    component_index: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BarrierInsertMany {
    fn default() -> Self {
        Self {
            component_index: None,
            target_device_name: None,
        }
    }
}
impl BarrierInsertMany {
    /// Creates a new `BarrierInsertMany`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `component_index` attribute.
    pub fn component_index<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.component_index = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier_insert_many.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        keys: &T1,
        values: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BarrierInsertMany")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&keys.to_handle(ctx)?)?;
        op.add_input(&values.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.component_index {
            op.set_attr_int("component_index", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BarrierInsertMany::new().call(&ctx, &handle, &keys, &values)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierInsertMany>
pub fn barrier_insert_many<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    keys: &T1,
    values: &T2,
) -> crate::Result<()> {
    let op = BarrierInsertMany::new();
    op.call(ctx, handle, keys, values)
}

/// BarrierReadySize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierReadySize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BarrierReadySize {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BarrierReadySize {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BarrierReadySize {
    /// Creates a new `BarrierReadySize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier_ready_size.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BarrierReadySize")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BarrierReadySize::new().call(&ctx, &handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierReadySize>
pub fn barrier_ready_size<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BarrierReadySize::new();
    op.call(ctx, handle)
}

/// BarrierTakeMany
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierTakeMany>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BarrierTakeMany {
    component_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    allow_small_batch: ::std::option::Option<bool>,
    wait_for_incomplete: ::std::option::Option<bool>,
    timeout_ms: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BarrierTakeMany {
    fn default() -> Self {
        Self {
            component_types: None,
            allow_small_batch: Some(false),
            wait_for_incomplete: Some(false),
            timeout_ms: Some(-1i64),
            target_device_name: None,
        }
    }
}
impl BarrierTakeMany {
    /// Creates a new `BarrierTakeMany`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `component_types` attribute.
    pub fn component_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.component_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allow_small_batch` attribute.
    pub fn allow_small_batch<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allow_small_batch = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `wait_for_incomplete` attribute.
    pub fn wait_for_incomplete<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.wait_for_incomplete = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_ms` attribute.
    pub fn timeout_ms<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.timeout_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute barrier_take_many.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        num_elements: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BarrierTakeMany")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&num_elements.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.component_types {
            op.set_attr_type_list("component_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.allow_small_batch {
            op.set_attr_bool("allow_small_batch", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.wait_for_incomplete {
            op.set_attr_bool("wait_for_incomplete", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_ms {
            op.set_attr_int("timeout_ms", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BarrierTakeMany::new().call(&ctx, &handle, &num_elements)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BarrierTakeMany>
pub fn barrier_take_many<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    num_elements: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = BarrierTakeMany::new();
    op.call(ctx, handle, num_elements)
}

/// Batch
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Batch>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Batch {
    num_batch_threads: ::std::option::Option<i64>,
    max_batch_size: ::std::option::Option<i64>,
    max_enqueued_batches: ::std::option::Option<i64>,
    batch_timeout_micros: ::std::option::Option<i64>,
    allowed_batch_sizes: ::std::option::Option<::std::vec::Vec<i64>>,
    grad_timeout_micros: ::std::option::Option<i64>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    batching_queue: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Batch {
    fn default() -> Self {
        Self {
            num_batch_threads: None,
            max_batch_size: None,
            max_enqueued_batches: Some(10i64),
            batch_timeout_micros: None,
            allowed_batch_sizes: Some(vec![]),
            grad_timeout_micros: None,
            container: None,
            shared_name: None,
            batching_queue: None,
            target_device_name: None,
        }
    }
}
impl Batch {
    /// Creates a new `Batch`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_batch_threads` attribute.
    pub fn num_batch_threads<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_batch_threads = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_batch_size` attribute.
    pub fn max_batch_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_batch_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_enqueued_batches` attribute.
    pub fn max_enqueued_batches<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_enqueued_batches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batch_timeout_micros` attribute.
    pub fn batch_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batch_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allowed_batch_sizes` attribute.
    pub fn allowed_batch_sizes<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allowed_batch_sizes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `grad_timeout_micros` attribute.
    pub fn grad_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.grad_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batching_queue` attribute.
    pub fn batching_queue<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batching_queue = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        in_tensors: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "Batch")?;

        // Required input arguments
        op.add_input(&in_tensors.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_batch_threads {
            op.set_attr_int("num_batch_threads", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_batch_size {
            op.set_attr_int("max_batch_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_enqueued_batches {
            op.set_attr_int("max_enqueued_batches", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.batch_timeout_micros {
            op.set_attr_int("batch_timeout_micros", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.allowed_batch_sizes {
            op.set_attr_int_list("allowed_batch_sizes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.grad_timeout_micros {
            op.set_attr_int("grad_timeout_micros", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.batching_queue {
            op.set_attr_string("batching_queue", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `Batch::new().call(&ctx, &in_tensors)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Batch>
pub fn batch<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    in_tensors: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = Batch::new();
    op.call(ctx, in_tensors)
}

/// BatchCholesky
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchCholesky>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchCholesky {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchCholesky {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchCholesky {
    /// Creates a new `BatchCholesky`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_cholesky.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchCholesky")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchCholesky::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchCholesky>
pub fn batch_cholesky<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchCholesky::new();
    op.call(ctx, input)
}

/// BatchCholeskyGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchCholeskyGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchCholeskyGrad {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchCholeskyGrad {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchCholeskyGrad {
    /// Creates a new `BatchCholeskyGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_cholesky_grad.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        l: &T0,
        grad: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchCholeskyGrad")?;

        // Required input arguments
        op.add_input(&l.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchCholeskyGrad::new().call(&ctx, &l, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchCholeskyGrad>
pub fn batch_cholesky_grad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    l: &T0,
    grad: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchCholeskyGrad::new();
    op.call(ctx, l, grad)
}

/// BatchDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl BatchDataset {
    /// Creates a new `BatchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        batch_size: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&batch_size.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchDataset::new().call(&ctx, &input_dataset, &batch_size)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchDataset>
pub fn batch_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    batch_size: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchDataset::new();
    op.call(ctx, input_dataset, batch_size)
}

/// BatchDatasetV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchDatasetV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchDatasetV2 {
    parallel_copy: ::std::option::Option<bool>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchDatasetV2 {
    fn default() -> Self {
        Self {
            parallel_copy: Some(false),
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl BatchDatasetV2 {
    /// Creates a new `BatchDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `parallel_copy` attribute.
    pub fn parallel_copy<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.parallel_copy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_dataset_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        batch_size: &T1,
        drop_remainder: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchDatasetV2")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&batch_size.to_handle(ctx)?)?;
        op.add_input(&drop_remainder.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.parallel_copy {
            op.set_attr_bool("parallel_copy", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchDatasetV2::new().call(&ctx, &input_dataset, &batch_size, &drop_remainder)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchDatasetV2>
pub fn batch_dataset_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    batch_size: &T1,
    drop_remainder: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchDatasetV2::new();
    op.call(ctx, input_dataset, batch_size, drop_remainder)
}

/// BatchFFT
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchFFT {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchFFT {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchFFT {
    /// Creates a new `BatchFFT`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_fft.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchFFT")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchFFT::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT>
pub fn batch_fft<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchFFT::new();
    op.call(ctx, input)
}

/// BatchFFT2D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT2D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchFFT2D {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchFFT2D {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchFFT2D {
    /// Creates a new `BatchFFT2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_fft2_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchFFT2D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchFFT2D::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT2D>
pub fn batch_fft2_d<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchFFT2D::new();
    op.call(ctx, input)
}

/// BatchFFT3D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT3D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchFFT3D {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchFFT3D {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchFFT3D {
    /// Creates a new `BatchFFT3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_fft3_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchFFT3D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchFFT3D::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFFT3D>
pub fn batch_fft3_d<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchFFT3D::new();
    op.call(ctx, input)
}

/// BatchFunction
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFunction>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchFunction {
    f: ::std::option::Option<::std::string::String>,
    num_batch_threads: ::std::option::Option<i64>,
    max_batch_size: ::std::option::Option<i64>,
    batch_timeout_micros: ::std::option::Option<i64>,
    max_enqueued_batches: ::std::option::Option<i64>,
    allowed_batch_sizes: ::std::option::Option<::std::vec::Vec<i64>>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    batching_queue: ::std::option::Option<::std::string::String>,
    Tout: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    enable_large_batch_splitting: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchFunction {
    fn default() -> Self {
        Self {
            f: None,
            num_batch_threads: None,
            max_batch_size: None,
            batch_timeout_micros: None,
            max_enqueued_batches: Some(10i64),
            allowed_batch_sizes: Some(vec![]),
            container: None,
            shared_name: None,
            batching_queue: None,
            Tout: None,
            enable_large_batch_splitting: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchFunction {
    /// Creates a new `BatchFunction`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `f` attribute.
    pub fn f<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.f = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_batch_threads` attribute.
    pub fn num_batch_threads<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_batch_threads = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_batch_size` attribute.
    pub fn max_batch_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_batch_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batch_timeout_micros` attribute.
    pub fn batch_timeout_micros<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batch_timeout_micros = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_enqueued_batches` attribute.
    pub fn max_enqueued_batches<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_enqueued_batches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allowed_batch_sizes` attribute.
    pub fn allowed_batch_sizes<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.allowed_batch_sizes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `batching_queue` attribute.
    pub fn batching_queue<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.batching_queue = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `enable_large_batch_splitting` attribute.
    pub fn enable_large_batch_splitting<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.enable_large_batch_splitting = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_function.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        in_tensors: &T0,
        captured_tensors: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchFunction")?;

        // Required input arguments
        op.add_input(&in_tensors.to_handle(ctx)?)?;
        op.add_input(&captured_tensors.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.f {
            op.set_attr_string("f", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_batch_threads {
            op.set_attr_int("num_batch_threads", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_batch_size {
            op.set_attr_int("max_batch_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.batch_timeout_micros {
            op.set_attr_int("batch_timeout_micros", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_enqueued_batches {
            op.set_attr_int("max_enqueued_batches", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.allowed_batch_sizes {
            op.set_attr_int_list("allowed_batch_sizes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.batching_queue {
            op.set_attr_string("batching_queue", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type_list("Tout", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.enable_large_batch_splitting {
            op.set_attr_bool("enable_large_batch_splitting", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchFunction::new().call(&ctx, &in_tensors, &captured_tensors)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchFunction>
pub fn batch_function<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    in_tensors: &T0,
    captured_tensors: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchFunction::new();
    op.call(ctx, in_tensors, captured_tensors)
}

/// BatchIFFT
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchIFFT {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchIFFT {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchIFFT {
    /// Creates a new `BatchIFFT`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_ifft.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchIFFT")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchIFFT::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT>
pub fn batch_ifft<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchIFFT::new();
    op.call(ctx, input)
}

/// BatchIFFT2D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT2D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchIFFT2D {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchIFFT2D {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchIFFT2D {
    /// Creates a new `BatchIFFT2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_ifft2_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchIFFT2D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchIFFT2D::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT2D>
pub fn batch_ifft2_d<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchIFFT2D::new();
    op.call(ctx, input)
}

/// BatchIFFT3D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT3D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchIFFT3D {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchIFFT3D {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchIFFT3D {
    /// Creates a new `BatchIFFT3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_ifft3_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchIFFT3D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchIFFT3D::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchIFFT3D>
pub fn batch_ifft3_d<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchIFFT3D::new();
    op.call(ctx, input)
}

/// BatchMatMul
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMul>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatMul {
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatMul {
    fn default() -> Self {
        Self {
            adj_x: Some(false),
            adj_y: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatMul {
    /// Creates a new `BatchMatMul`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_mat_mul.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatMul")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.adj_x {
            op.set_attr_bool("adj_x", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adj_y {
            op.set_attr_bool("adj_y", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatMul::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMul>
pub fn batch_mat_mul<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatMul::new();
    op.call(ctx, x, y)
}

/// BatchMatMulV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMulV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatMulV2 {
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatMulV2 {
    fn default() -> Self {
        Self {
            adj_x: Some(false),
            adj_y: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatMulV2 {
    /// Creates a new `BatchMatMulV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_mat_mul_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatMulV2")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.adj_x {
            op.set_attr_bool("adj_x", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adj_y {
            op.set_attr_bool("adj_y", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatMulV2::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMulV2>
pub fn batch_mat_mul_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatMulV2::new();
    op.call(ctx, x, y)
}

/// BatchMatMulV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMulV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatMulV3 {
    Tout: ::std::option::Option<crate::DataType>,
    adj_x: ::std::option::Option<bool>,
    adj_y: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatMulV3 {
    fn default() -> Self {
        Self {
            Tout: None,
            adj_x: Some(false),
            adj_y: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatMulV3 {
    /// Creates a new `BatchMatMulV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_x` attribute.
    pub fn adj_x<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_x = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adj_y` attribute.
    pub fn adj_y<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adj_y = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_mat_mul_v3.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatMulV3")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type("Tout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adj_x {
            op.set_attr_bool("adj_x", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adj_y {
            op.set_attr_bool("adj_y", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatMulV3::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatMulV3>
pub fn batch_mat_mul_v3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatMulV3::new();
    op.call(ctx, x, y)
}

/// BatchMatrixBandPart
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixBandPart>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixBandPart {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixBandPart {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchMatrixBandPart {
    /// Creates a new `BatchMatrixBandPart`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_band_part.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        num_lower: &T1,
        num_upper: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixBandPart")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&num_lower.to_handle(ctx)?)?;
        op.add_input(&num_upper.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixBandPart::new().call(&ctx, &input, &num_lower, &num_upper)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixBandPart>
pub fn batch_matrix_band_part<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    num_lower: &T1,
    num_upper: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixBandPart::new();
    op.call(ctx, input, num_lower, num_upper)
}

/// BatchMatrixDeterminant
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDeterminant>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixDeterminant {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixDeterminant {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchMatrixDeterminant {
    /// Creates a new `BatchMatrixDeterminant`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_determinant.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixDeterminant")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixDeterminant::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDeterminant>
pub fn batch_matrix_determinant<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixDeterminant::new();
    op.call(ctx, input)
}

/// BatchMatrixDiag
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDiag>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixDiag {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixDiag {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchMatrixDiag {
    /// Creates a new `BatchMatrixDiag`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_diag.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        diagonal: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixDiag")?;

        // Required input arguments
        op.add_input(&diagonal.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixDiag::new().call(&ctx, &diagonal)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDiag>
pub fn batch_matrix_diag<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    diagonal: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixDiag::new();
    op.call(ctx, diagonal)
}

/// BatchMatrixDiagPart
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDiagPart>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixDiagPart {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixDiagPart {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchMatrixDiagPart {
    /// Creates a new `BatchMatrixDiagPart`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_diag_part.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixDiagPart")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixDiagPart::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixDiagPart>
pub fn batch_matrix_diag_part<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixDiagPart::new();
    op.call(ctx, input)
}

/// BatchMatrixInverse
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixInverse>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixInverse {
    adjoint: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixInverse {
    fn default() -> Self {
        Self {
            adjoint: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatrixInverse {
    /// Creates a new `BatchMatrixInverse`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_inverse.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixInverse")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.adjoint {
            op.set_attr_bool("adjoint", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixInverse::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixInverse>
pub fn batch_matrix_inverse<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixInverse::new();
    op.call(ctx, input)
}

/// BatchMatrixSetDiag
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSetDiag>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixSetDiag {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixSetDiag {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchMatrixSetDiag {
    /// Creates a new `BatchMatrixSetDiag`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_set_diag.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        diagonal: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixSetDiag")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&diagonal.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixSetDiag::new().call(&ctx, &input, &diagonal)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSetDiag>
pub fn batch_matrix_set_diag<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    diagonal: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixSetDiag::new();
    op.call(ctx, input, diagonal)
}

/// BatchMatrixSolve
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSolve>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixSolve {
    adjoint: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixSolve {
    fn default() -> Self {
        Self {
            adjoint: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatrixSolve {
    /// Creates a new `BatchMatrixSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_solve.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        matrix: &T0,
        rhs: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixSolve")?;

        // Required input arguments
        op.add_input(&matrix.to_handle(ctx)?)?;
        op.add_input(&rhs.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.adjoint {
            op.set_attr_bool("adjoint", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixSolve::new().call(&ctx, &matrix, &rhs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSolve>
pub fn batch_matrix_solve<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    matrix: &T0,
    rhs: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixSolve::new();
    op.call(ctx, matrix, rhs)
}

/// BatchMatrixSolveLs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSolveLs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixSolveLs {
    fast: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixSolveLs {
    fn default() -> Self {
        Self {
            fast: Some(true),
            target_device_name: None,
        }
    }
}
impl BatchMatrixSolveLs {
    /// Creates a new `BatchMatrixSolveLs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `fast` attribute.
    pub fn fast<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fast = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_solve_ls.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        matrix: &T0,
        rhs: &T1,
        l2_regularizer: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixSolveLs")?;

        // Required input arguments
        op.add_input(&matrix.to_handle(ctx)?)?;
        op.add_input(&rhs.to_handle(ctx)?)?;
        op.add_input(&l2_regularizer.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.fast {
            op.set_attr_bool("fast", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixSolveLs::new().call(&ctx, &matrix, &rhs, &l2_regularizer)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixSolveLs>
pub fn batch_matrix_solve_ls<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    matrix: &T0,
    rhs: &T1,
    l2_regularizer: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixSolveLs::new();
    op.call(ctx, matrix, rhs, l2_regularizer)
}

/// BatchMatrixTriangularSolve
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixTriangularSolve>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchMatrixTriangularSolve {
    lower: ::std::option::Option<bool>,
    adjoint: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchMatrixTriangularSolve {
    fn default() -> Self {
        Self {
            lower: Some(true),
            adjoint: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchMatrixTriangularSolve {
    /// Creates a new `BatchMatrixTriangularSolve`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `lower` attribute.
    pub fn lower<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.lower = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `adjoint` attribute.
    pub fn adjoint<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.adjoint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_matrix_triangular_solve.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        matrix: &T0,
        rhs: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchMatrixTriangularSolve")?;

        // Required input arguments
        op.add_input(&matrix.to_handle(ctx)?)?;
        op.add_input(&rhs.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.lower {
            op.set_attr_bool("lower", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.adjoint {
            op.set_attr_bool("adjoint", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchMatrixTriangularSolve::new().call(&ctx, &matrix, &rhs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchMatrixTriangularSolve>
pub fn batch_matrix_triangular_solve<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    matrix: &T0,
    rhs: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchMatrixTriangularSolve::new();
    op.call(ctx, matrix, rhs)
}

/// BatchNormWithGlobalNormalization
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchNormWithGlobalNormalization>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchNormWithGlobalNormalization {
    variance_epsilon: ::std::option::Option<f32>,
    scale_after_normalization: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchNormWithGlobalNormalization {
    fn default() -> Self {
        Self {
            variance_epsilon: None,
            scale_after_normalization: None,
            target_device_name: None,
        }
    }
}
impl BatchNormWithGlobalNormalization {
    /// Creates a new `BatchNormWithGlobalNormalization`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `variance_epsilon` attribute.
    pub fn variance_epsilon<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.variance_epsilon = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scale_after_normalization` attribute.
    pub fn scale_after_normalization<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.scale_after_normalization = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_norm_with_global_normalization.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        t: &T0,
        m: &T1,
        v: &T2,
        beta: &T3,
        gamma: &T4,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchNormWithGlobalNormalization")?;

        // Required input arguments
        op.add_input(&t.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&v.to_handle(ctx)?)?;
        op.add_input(&beta.to_handle(ctx)?)?;
        op.add_input(&gamma.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.variance_epsilon {
            op.set_attr_float("variance_epsilon", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.scale_after_normalization {
            op.set_attr_bool("scale_after_normalization", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchNormWithGlobalNormalization::new().call(&ctx, &t, &m, &v, &beta, &gamma)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchNormWithGlobalNormalization>
pub fn batch_norm_with_global_normalization<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    t: &T0,
    m: &T1,
    v: &T2,
    beta: &T3,
    gamma: &T4,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchNormWithGlobalNormalization::new();
    op.call(ctx, t, m, v, beta, gamma)
}

/// BatchNormWithGlobalNormalizationGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchNormWithGlobalNormalizationGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchNormWithGlobalNormalizationGrad {
    variance_epsilon: ::std::option::Option<f32>,
    scale_after_normalization: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchNormWithGlobalNormalizationGrad {
    fn default() -> Self {
        Self {
            variance_epsilon: None,
            scale_after_normalization: None,
            target_device_name: None,
        }
    }
}
impl BatchNormWithGlobalNormalizationGrad {
    /// Creates a new `BatchNormWithGlobalNormalizationGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `variance_epsilon` attribute.
    pub fn variance_epsilon<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.variance_epsilon = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `scale_after_normalization` attribute.
    pub fn scale_after_normalization<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.scale_after_normalization = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_norm_with_global_normalization_grad.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        t: &T0,
        m: &T1,
        v: &T2,
        gamma: &T3,
        backprop: &T4,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchNormWithGlobalNormalizationGrad")?;

        // Required input arguments
        op.add_input(&t.to_handle(ctx)?)?;
        op.add_input(&m.to_handle(ctx)?)?;
        op.add_input(&v.to_handle(ctx)?)?;
        op.add_input(&gamma.to_handle(ctx)?)?;
        op.add_input(&backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.variance_epsilon {
            op.set_attr_float("variance_epsilon", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.scale_after_normalization {
            op.set_attr_bool("scale_after_normalization", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<5>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BatchNormWithGlobalNormalizationGrad::new().call(&ctx, &t, &m, &v, &gamma, &backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchNormWithGlobalNormalizationGrad>
pub fn batch_norm_with_global_normalization_grad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    t: &T0,
    m: &T1,
    v: &T2,
    gamma: &T3,
    backprop: &T4,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
    let op = BatchNormWithGlobalNormalizationGrad::new();
    op.call(ctx, t, m, v, gamma, backprop)
}

/// BatchSelfAdjointEig
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSelfAdjointEig>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchSelfAdjointEig {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchSelfAdjointEig {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchSelfAdjointEig {
    /// Creates a new `BatchSelfAdjointEig`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_self_adjoint_eig.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchSelfAdjointEig")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchSelfAdjointEig::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSelfAdjointEig>
pub fn batch_self_adjoint_eig<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchSelfAdjointEig::new();
    op.call(ctx, input)
}

/// BatchSelfAdjointEigV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSelfAdjointEigV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchSelfAdjointEigV2 {
    compute_v: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchSelfAdjointEigV2 {
    fn default() -> Self {
        Self {
            compute_v: Some(true),
            target_device_name: None,
        }
    }
}
impl BatchSelfAdjointEigV2 {
    /// Creates a new `BatchSelfAdjointEigV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compute_v` attribute.
    pub fn compute_v<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.compute_v = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_self_adjoint_eig_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchSelfAdjointEigV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.compute_v {
            op.set_attr_bool("compute_v", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BatchSelfAdjointEigV2::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSelfAdjointEigV2>
pub fn batch_self_adjoint_eig_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = BatchSelfAdjointEigV2::new();
    op.call(ctx, input)
}

/// BatchSvd
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSvd>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchSvd {
    compute_uv: ::std::option::Option<bool>,
    full_matrices: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchSvd {
    fn default() -> Self {
        Self {
            compute_uv: Some(true),
            full_matrices: Some(false),
            target_device_name: None,
        }
    }
}
impl BatchSvd {
    /// Creates a new `BatchSvd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compute_uv` attribute.
    pub fn compute_uv<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.compute_uv = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `full_matrices` attribute.
    pub fn full_matrices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.full_matrices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_svd.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchSvd")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.compute_uv {
            op.set_attr_bool("compute_uv", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.full_matrices {
            op.set_attr_bool("full_matrices", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BatchSvd::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchSvd>
pub fn batch_svd<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = BatchSvd::new();
    op.call(ctx, input)
}

/// BatchToSpace
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchToSpace>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchToSpace {
    block_size: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchToSpace {
    fn default() -> Self {
        Self {
            block_size: None,
            target_device_name: None,
        }
    }
}
impl BatchToSpace {
    /// Creates a new `BatchToSpace`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `block_size` attribute.
    pub fn block_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.block_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_to_space.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        crops: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchToSpace")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&crops.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.block_size {
            op.set_attr_int("block_size", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchToSpace::new().call(&ctx, &input, &crops)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchToSpace>
pub fn batch_to_space<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    crops: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchToSpace::new();
    op.call(ctx, input, crops)
}

/// BatchToSpaceND
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchToSpaceND>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BatchToSpaceND {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BatchToSpaceND {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BatchToSpaceND {
    /// Creates a new `BatchToSpaceND`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute batch_to_space_nd.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        block_shape: &T1,
        crops: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BatchToSpaceND")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&block_shape.to_handle(ctx)?)?;
        op.add_input(&crops.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BatchToSpaceND::new().call(&ctx, &input, &block_shape, &crops)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BatchToSpaceND>
pub fn batch_to_space_nd<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    block_shape: &T1,
    crops: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BatchToSpaceND::new();
    op.call(ctx, input, block_shape, crops)
}

/// BesselI0
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI0>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselI0 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselI0 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselI0 {
    /// Creates a new `BesselI0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_i0.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselI0")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselI0::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI0>
pub fn bessel_i0<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselI0::new();
    op.call(ctx, x)
}

/// BesselI0e
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI0e>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselI0e {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselI0e {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselI0e {
    /// Creates a new `BesselI0e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_i0e.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselI0e")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselI0e::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI0e>
pub fn bessel_i0e<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselI0e::new();
    op.call(ctx, x)
}

/// BesselI1
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI1>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselI1 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselI1 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselI1 {
    /// Creates a new `BesselI1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_i1.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselI1")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselI1::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI1>
pub fn bessel_i1<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselI1::new();
    op.call(ctx, x)
}

/// BesselI1e
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI1e>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselI1e {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselI1e {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselI1e {
    /// Creates a new `BesselI1e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_i1e.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselI1e")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselI1e::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselI1e>
pub fn bessel_i1e<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselI1e::new();
    op.call(ctx, x)
}

/// BesselJ0
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselJ0>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselJ0 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselJ0 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselJ0 {
    /// Creates a new `BesselJ0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_j0.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselJ0")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselJ0::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselJ0>
pub fn bessel_j0<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselJ0::new();
    op.call(ctx, x)
}

/// BesselJ1
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselJ1>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselJ1 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselJ1 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselJ1 {
    /// Creates a new `BesselJ1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_j1.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselJ1")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselJ1::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselJ1>
pub fn bessel_j1<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselJ1::new();
    op.call(ctx, x)
}

/// BesselK0
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK0>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselK0 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselK0 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselK0 {
    /// Creates a new `BesselK0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_k0.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselK0")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselK0::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK0>
pub fn bessel_k0<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselK0::new();
    op.call(ctx, x)
}

/// BesselK0e
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK0e>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselK0e {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselK0e {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselK0e {
    /// Creates a new `BesselK0e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_k0e.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselK0e")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselK0e::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK0e>
pub fn bessel_k0e<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselK0e::new();
    op.call(ctx, x)
}

/// BesselK1
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK1>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselK1 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselK1 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselK1 {
    /// Creates a new `BesselK1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_k1.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselK1")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselK1::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK1>
pub fn bessel_k1<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselK1::new();
    op.call(ctx, x)
}

/// BesselK1e
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK1e>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselK1e {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselK1e {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselK1e {
    /// Creates a new `BesselK1e`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_k1e.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselK1e")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselK1e::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselK1e>
pub fn bessel_k1e<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselK1e::new();
    op.call(ctx, x)
}

/// BesselY0
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselY0>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselY0 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselY0 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselY0 {
    /// Creates a new `BesselY0`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_y0.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselY0")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselY0::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselY0>
pub fn bessel_y0<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselY0::new();
    op.call(ctx, x)
}

/// BesselY1
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselY1>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BesselY1 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BesselY1 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BesselY1 {
    /// Creates a new `BesselY1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bessel_y1.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BesselY1")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BesselY1::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BesselY1>
pub fn bessel_y1<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BesselY1::new();
    op.call(ctx, x)
}

/// Betainc
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Betainc>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Betainc {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Betainc {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Betainc {
    /// Creates a new `Betainc`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute betainc.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        a: &T0,
        b: &T1,
        x: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Betainc")?;

        // Required input arguments
        op.add_input(&a.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Betainc::new().call(&ctx, &a, &b, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Betainc>
pub fn betainc<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    a: &T0,
    b: &T1,
    x: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Betainc::new();
    op.call(ctx, a, b, x)
}

/// BiasAdd
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAdd>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BiasAdd {
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BiasAdd {
    fn default() -> Self {
        Self {
            data_format: Some(::std::string::String::from("NHWC")),
            target_device_name: None,
        }
    }
}
impl BiasAdd {
    /// Creates a new `BiasAdd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bias_add.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        value: &T0,
        bias: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BiasAdd")?;

        // Required input arguments
        op.add_input(&value.to_handle(ctx)?)?;
        op.add_input(&bias.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BiasAdd::new().call(&ctx, &value, &bias)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAdd>
pub fn bias_add<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    value: &T0,
    bias: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BiasAdd::new();
    op.call(ctx, value, bias)
}

/// BiasAddGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAddGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BiasAddGrad {
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BiasAddGrad {
    fn default() -> Self {
        Self {
            data_format: Some(::std::string::String::from("NHWC")),
            target_device_name: None,
        }
    }
}
impl BiasAddGrad {
    /// Creates a new `BiasAddGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bias_add_grad.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        out_backprop: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BiasAddGrad")?;

        // Required input arguments
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BiasAddGrad::new().call(&ctx, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAddGrad>
pub fn bias_add_grad<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    out_backprop: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BiasAddGrad::new();
    op.call(ctx, out_backprop)
}

/// BiasAddV1
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAddV1>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BiasAddV1 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BiasAddV1 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BiasAddV1 {
    /// Creates a new `BiasAddV1`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bias_add_v1.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        value: &T0,
        bias: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BiasAddV1")?;

        // Required input arguments
        op.add_input(&value.to_handle(ctx)?)?;
        op.add_input(&bias.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BiasAddV1::new().call(&ctx, &value, &bias)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BiasAddV1>
pub fn bias_add_v1<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    value: &T0,
    bias: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BiasAddV1::new();
    op.call(ctx, value, bias)
}

/// Bincount
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bincount>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Bincount {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Bincount {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Bincount {
    /// Creates a new `Bincount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bincount.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        arr: &T0,
        size: &T1,
        weights: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Bincount")?;

        // Required input arguments
        op.add_input(&arr.to_handle(ctx)?)?;
        op.add_input(&size.to_handle(ctx)?)?;
        op.add_input(&weights.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Bincount::new().call(&ctx, &arr, &size, &weights)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bincount>
pub fn bincount<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    arr: &T0,
    size: &T1,
    weights: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Bincount::new();
    op.call(ctx, arr, size, weights)
}

/// Bitcast
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bitcast>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Bitcast {
    type_: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Bitcast {
    fn default() -> Self {
        Self {
            type_: None,
            target_device_name: None,
        }
    }
}
impl Bitcast {
    /// Creates a new `Bitcast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bitcast.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Bitcast")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.type_ {
            op.set_attr_type("type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Bitcast::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bitcast>
pub fn bitcast<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Bitcast::new();
    op.call(ctx, input)
}

/// BitwiseAnd
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseAnd>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BitwiseAnd {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BitwiseAnd {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BitwiseAnd {
    /// Creates a new `BitwiseAnd`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bitwise_and.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BitwiseAnd")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BitwiseAnd::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseAnd>
pub fn bitwise_and<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BitwiseAnd::new();
    op.call(ctx, x, y)
}

/// BitwiseOr
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseOr>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BitwiseOr {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BitwiseOr {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BitwiseOr {
    /// Creates a new `BitwiseOr`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bitwise_or.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BitwiseOr")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BitwiseOr::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseOr>
pub fn bitwise_or<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BitwiseOr::new();
    op.call(ctx, x, y)
}

/// BitwiseXor
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseXor>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BitwiseXor {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BitwiseXor {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BitwiseXor {
    /// Creates a new `BitwiseXor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bitwise_xor.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        y: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BitwiseXor")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&y.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BitwiseXor::new().call(&ctx, &x, &y)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BitwiseXor>
pub fn bitwise_xor<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    y: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BitwiseXor::new();
    op.call(ctx, x, y)
}

/// BlockLSTM
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTM>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BlockLSTM {
    forget_bias: ::std::option::Option<f32>,
    cell_clip: ::std::option::Option<f32>,
    use_peephole: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BlockLSTM {
    fn default() -> Self {
        Self {
            forget_bias: Some(1f32),
            cell_clip: Some(3f32),
            use_peephole: Some(false),
            target_device_name: None,
        }
    }
}
impl BlockLSTM {
    /// Creates a new `BlockLSTM`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `forget_bias` attribute.
    pub fn forget_bias<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.forget_bias = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `cell_clip` attribute.
    pub fn cell_clip<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.cell_clip = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute block_lstm.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        seq_len_max: &T0,
        x: &T1,
        cs_prev: &T2,
        h_prev: &T3,
        w: &T4,
        wci: &T5,
        wcf: &T6,
        wco: &T7,
        b: &T8,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BlockLSTM")?;

        // Required input arguments
        op.add_input(&seq_len_max.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&cs_prev.to_handle(ctx)?)?;
        op.add_input(&h_prev.to_handle(ctx)?)?;
        op.add_input(&w.to_handle(ctx)?)?;
        op.add_input(&wci.to_handle(ctx)?)?;
        op.add_input(&wcf.to_handle(ctx)?)?;
        op.add_input(&wco.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.forget_bias {
            op.set_attr_float("forget_bias", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.cell_clip {
            op.set_attr_float("cell_clip", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_peephole {
            op.set_attr_bool("use_peephole", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<7>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BlockLSTM::new().call(&ctx, &seq_len_max, &x, &cs_prev, &h_prev, &w, &wci, &wcf, &wco, &b)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTM>
pub fn block_lstm<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seq_len_max: &T0,
    x: &T1,
    cs_prev: &T2,
    h_prev: &T3,
    w: &T4,
    wci: &T5,
    wcf: &T6,
    wco: &T7,
    b: &T8,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
    let op = BlockLSTM::new();
    op.call(ctx, seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b)
}

/// BlockLSTMGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BlockLSTMGrad {
    use_peephole: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BlockLSTMGrad {
    fn default() -> Self {
        Self {
            use_peephole: None,
            target_device_name: None,
        }
    }
}
impl BlockLSTMGrad {
    /// Creates a new `BlockLSTMGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute block_lstmgrad.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
        T11: crate::eager::ToTensorHandle<'a>,
        T12: crate::eager::ToTensorHandle<'a>,
        T13: crate::eager::ToTensorHandle<'a>,
        T14: crate::eager::ToTensorHandle<'a>,
        T15: crate::eager::ToTensorHandle<'a>,
        T16: crate::eager::ToTensorHandle<'a>,
        T17: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        seq_len_max: &T0,
        x: &T1,
        cs_prev: &T2,
        h_prev: &T3,
        w: &T4,
        wci: &T5,
        wcf: &T6,
        wco: &T7,
        b: &T8,
        i: &T9,
        cs: &T10,
        f: &T11,
        o: &T12,
        ci: &T13,
        co: &T14,
        h: &T15,
        cs_grad: &T16,
        h_grad: &T17,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BlockLSTMGrad")?;

        // Required input arguments
        op.add_input(&seq_len_max.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&cs_prev.to_handle(ctx)?)?;
        op.add_input(&h_prev.to_handle(ctx)?)?;
        op.add_input(&w.to_handle(ctx)?)?;
        op.add_input(&wci.to_handle(ctx)?)?;
        op.add_input(&wcf.to_handle(ctx)?)?;
        op.add_input(&wco.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;
        op.add_input(&i.to_handle(ctx)?)?;
        op.add_input(&cs.to_handle(ctx)?)?;
        op.add_input(&f.to_handle(ctx)?)?;
        op.add_input(&o.to_handle(ctx)?)?;
        op.add_input(&ci.to_handle(ctx)?)?;
        op.add_input(&co.to_handle(ctx)?)?;
        op.add_input(&h.to_handle(ctx)?)?;
        op.add_input(&cs_grad.to_handle(ctx)?)?;
        op.add_input(&h_grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_peephole {
            op.set_attr_bool("use_peephole", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<8>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BlockLSTMGrad::new().call(&ctx, &seq_len_max, &x, &cs_prev, &h_prev, &w, &wci, &wcf, &wco, &b, &i, &cs, &f, &o, &ci, &co, &h, &cs_grad, &h_grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMGrad>
pub fn block_lstmgrad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
    T11: crate::eager::ToTensorHandle<'a>,
    T12: crate::eager::ToTensorHandle<'a>,
    T13: crate::eager::ToTensorHandle<'a>,
    T14: crate::eager::ToTensorHandle<'a>,
    T15: crate::eager::ToTensorHandle<'a>,
    T16: crate::eager::ToTensorHandle<'a>,
    T17: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seq_len_max: &T0,
    x: &T1,
    cs_prev: &T2,
    h_prev: &T3,
    w: &T4,
    wci: &T5,
    wcf: &T6,
    wco: &T7,
    b: &T8,
    i: &T9,
    cs: &T10,
    f: &T11,
    o: &T12,
    ci: &T13,
    co: &T14,
    h: &T15,
    cs_grad: &T16,
    h_grad: &T17,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
    let op = BlockLSTMGrad::new();
    op.call(
        ctx,
        seq_len_max,
        x,
        cs_prev,
        h_prev,
        w,
        wci,
        wcf,
        wco,
        b,
        i,
        cs,
        f,
        o,
        ci,
        co,
        h,
        cs_grad,
        h_grad,
    )
}

/// BlockLSTMGradV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMGradV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BlockLSTMGradV2 {
    use_peephole: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BlockLSTMGradV2 {
    fn default() -> Self {
        Self {
            use_peephole: None,
            target_device_name: None,
        }
    }
}
impl BlockLSTMGradV2 {
    /// Creates a new `BlockLSTMGradV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute block_lstmgrad_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
        T11: crate::eager::ToTensorHandle<'a>,
        T12: crate::eager::ToTensorHandle<'a>,
        T13: crate::eager::ToTensorHandle<'a>,
        T14: crate::eager::ToTensorHandle<'a>,
        T15: crate::eager::ToTensorHandle<'a>,
        T16: crate::eager::ToTensorHandle<'a>,
        T17: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        seq_len_max: &T0,
        x: &T1,
        cs_prev: &T2,
        h_prev: &T3,
        w: &T4,
        wci: &T5,
        wcf: &T6,
        wco: &T7,
        b: &T8,
        i: &T9,
        cs: &T10,
        f: &T11,
        o: &T12,
        ci: &T13,
        co: &T14,
        h: &T15,
        cs_grad: &T16,
        h_grad: &T17,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BlockLSTMGradV2")?;

        // Required input arguments
        op.add_input(&seq_len_max.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&cs_prev.to_handle(ctx)?)?;
        op.add_input(&h_prev.to_handle(ctx)?)?;
        op.add_input(&w.to_handle(ctx)?)?;
        op.add_input(&wci.to_handle(ctx)?)?;
        op.add_input(&wcf.to_handle(ctx)?)?;
        op.add_input(&wco.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;
        op.add_input(&i.to_handle(ctx)?)?;
        op.add_input(&cs.to_handle(ctx)?)?;
        op.add_input(&f.to_handle(ctx)?)?;
        op.add_input(&o.to_handle(ctx)?)?;
        op.add_input(&ci.to_handle(ctx)?)?;
        op.add_input(&co.to_handle(ctx)?)?;
        op.add_input(&h.to_handle(ctx)?)?;
        op.add_input(&cs_grad.to_handle(ctx)?)?;
        op.add_input(&h_grad.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.use_peephole {
            op.set_attr_bool("use_peephole", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<8>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BlockLSTMGradV2::new().call(&ctx, &seq_len_max, &x, &cs_prev, &h_prev, &w, &wci, &wcf, &wco, &b, &i, &cs, &f, &o, &ci, &co, &h, &cs_grad, &h_grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMGradV2>
pub fn block_lstmgrad_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
    T11: crate::eager::ToTensorHandle<'a>,
    T12: crate::eager::ToTensorHandle<'a>,
    T13: crate::eager::ToTensorHandle<'a>,
    T14: crate::eager::ToTensorHandle<'a>,
    T15: crate::eager::ToTensorHandle<'a>,
    T16: crate::eager::ToTensorHandle<'a>,
    T17: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seq_len_max: &T0,
    x: &T1,
    cs_prev: &T2,
    h_prev: &T3,
    w: &T4,
    wci: &T5,
    wcf: &T6,
    wco: &T7,
    b: &T8,
    i: &T9,
    cs: &T10,
    f: &T11,
    o: &T12,
    ci: &T13,
    co: &T14,
    h: &T15,
    cs_grad: &T16,
    h_grad: &T17,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
    let op = BlockLSTMGradV2::new();
    op.call(
        ctx,
        seq_len_max,
        x,
        cs_prev,
        h_prev,
        w,
        wci,
        wcf,
        wco,
        b,
        i,
        cs,
        f,
        o,
        ci,
        co,
        h,
        cs_grad,
        h_grad,
    )
}

/// BlockLSTMV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BlockLSTMV2 {
    cell_clip: ::std::option::Option<f32>,
    use_peephole: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BlockLSTMV2 {
    fn default() -> Self {
        Self {
            cell_clip: Some(0f32),
            use_peephole: Some(false),
            target_device_name: None,
        }
    }
}
impl BlockLSTMV2 {
    /// Creates a new `BlockLSTMV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `cell_clip` attribute.
    pub fn cell_clip<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.cell_clip = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_peephole` attribute.
    pub fn use_peephole<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_peephole = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute block_lstmv2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        seq_len_max: &T0,
        x: &T1,
        cs_prev: &T2,
        h_prev: &T3,
        w: &T4,
        wci: &T5,
        wcf: &T6,
        wco: &T7,
        b: &T8,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BlockLSTMV2")?;

        // Required input arguments
        op.add_input(&seq_len_max.to_handle(ctx)?)?;
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&cs_prev.to_handle(ctx)?)?;
        op.add_input(&h_prev.to_handle(ctx)?)?;
        op.add_input(&w.to_handle(ctx)?)?;
        op.add_input(&wci.to_handle(ctx)?)?;
        op.add_input(&wcf.to_handle(ctx)?)?;
        op.add_input(&wco.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.cell_clip {
            op.set_attr_float("cell_clip", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_peephole {
            op.set_attr_bool("use_peephole", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<7>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BlockLSTMV2::new().call(&ctx, &seq_len_max, &x, &cs_prev, &h_prev, &w, &wci, &wcf, &wco, &b)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BlockLSTMV2>
pub fn block_lstmv2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    seq_len_max: &T0,
    x: &T1,
    cs_prev: &T2,
    h_prev: &T3,
    w: &T4,
    wci: &T5,
    wcf: &T6,
    wco: &T7,
    b: &T8,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
    let op = BlockLSTMV2::new();
    op.call(ctx, seq_len_max, x, cs_prev, h_prev, w, wci, wcf, wco, b)
}

/// BoostedTreesAggregateStats
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesAggregateStats>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesAggregateStats {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesAggregateStats {
    fn default() -> Self {
        Self {
            max_splits: None,
            num_buckets: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesAggregateStats {
    /// Creates a new `BoostedTreesAggregateStats`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_aggregate_stats.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_ids: &T0,
        gradients: &T1,
        hessians: &T2,
        feature: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesAggregateStats")?;

        // Required input arguments
        op.add_input(&node_ids.to_handle(ctx)?)?;
        op.add_input(&gradients.to_handle(ctx)?)?;
        op.add_input(&hessians.to_handle(ctx)?)?;
        op.add_input(&feature.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_splits {
            op.set_attr_int("max_splits", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_buckets {
            op.set_attr_int("num_buckets", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesAggregateStats::new().call(&ctx, &node_ids, &gradients, &hessians, &feature)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesAggregateStats>
pub fn boosted_trees_aggregate_stats<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_ids: &T0,
    gradients: &T1,
    hessians: &T2,
    feature: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesAggregateStats::new();
    op.call(ctx, node_ids, gradients, hessians, feature)
}

/// BoostedTreesBucketize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesBucketize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesBucketize {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesBucketize {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesBucketize {
    /// Creates a new `BoostedTreesBucketize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_bucketize.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        float_values: &[&T0],
        bucket_boundaries: &[&T1],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesBucketize")?;

        // Required input arguments
        let mut float_values_list = Vec::new();

        for t in float_values {
            float_values_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&float_values_list)?;
        let mut bucket_boundaries_list = Vec::new();

        for t in bucket_boundaries {
            bucket_boundaries_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucket_boundaries_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesBucketize::new().call(&ctx, &float_values, &bucket_boundaries)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesBucketize>
pub fn boosted_trees_bucketize<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    float_values: &[&T0],
    bucket_boundaries: &[&T1],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesBucketize::new();
    op.call(ctx, float_values, bucket_boundaries)
}

/// BoostedTreesCalculateBestFeatureSplit
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestFeatureSplit>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCalculateBestFeatureSplit {
    logits_dimension: ::std::option::Option<i64>,
    split_type: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCalculateBestFeatureSplit {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            split_type: Some(::std::string::String::from("inequality")),
            target_device_name: None,
        }
    }
}
impl BoostedTreesCalculateBestFeatureSplit {
    /// Creates a new `BoostedTreesCalculateBestFeatureSplit`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_type` attribute.
    pub fn split_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.split_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_calculate_best_feature_split.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_id_range: &T0,
        stats_summary: &T1,
        l1: &T2,
        l2: &T3,
        tree_complexity: &T4,
        min_node_weight: &T5,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCalculateBestFeatureSplit")?;

        // Required input arguments
        op.add_input(&node_id_range.to_handle(ctx)?)?;
        op.add_input(&stats_summary.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&tree_complexity.to_handle(ctx)?)?;
        op.add_input(&min_node_weight.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.split_type {
            op.set_attr_string("split_type", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<7>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesCalculateBestFeatureSplit::new().call(&ctx, &node_id_range, &stats_summary, &l1, &l2, &tree_complexity, &min_node_weight)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestFeatureSplit>
pub fn boosted_trees_calculate_best_feature_split<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_id_range: &T0,
    stats_summary: &T1,
    l1: &T2,
    l2: &T3,
    tree_complexity: &T4,
    min_node_weight: &T5,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
    let op = BoostedTreesCalculateBestFeatureSplit::new();
    op.call(
        ctx,
        node_id_range,
        stats_summary,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
    )
}

/// BoostedTreesCalculateBestFeatureSplitV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestFeatureSplitV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCalculateBestFeatureSplitV2 {
    logits_dimension: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCalculateBestFeatureSplitV2 {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesCalculateBestFeatureSplitV2 {
    /// Creates a new `BoostedTreesCalculateBestFeatureSplitV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_calculate_best_feature_split_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_id_range: &T0,
        stats_summaries_list: &[&T1],
        split_types: &T2,
        candidate_feature_ids: &T3,
        l1: &T4,
        l2: &T5,
        tree_complexity: &T6,
        min_node_weight: &T7,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCalculateBestFeatureSplitV2")?;

        // Required input arguments
        op.add_input(&node_id_range.to_handle(ctx)?)?;
        let mut stats_summaries_list_list = Vec::new();

        for t in stats_summaries_list {
            stats_summaries_list_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&stats_summaries_list_list)?;
        op.add_input(&split_types.to_handle(ctx)?)?;
        op.add_input(&candidate_feature_ids.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&tree_complexity.to_handle(ctx)?)?;
        op.add_input(&min_node_weight.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<8>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesCalculateBestFeatureSplitV2::new().call(&ctx, &node_id_range, &stats_summaries_list, &split_types, &candidate_feature_ids, &l1, &l2, &tree_complexity, &min_node_weight)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestFeatureSplitV2>
pub fn boosted_trees_calculate_best_feature_split_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_id_range: &T0,
    stats_summaries_list: &[&T1],
    split_types: &T2,
    candidate_feature_ids: &T3,
    l1: &T4,
    l2: &T5,
    tree_complexity: &T6,
    min_node_weight: &T7,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 8]> {
    let op = BoostedTreesCalculateBestFeatureSplitV2::new();
    op.call(
        ctx,
        node_id_range,
        stats_summaries_list,
        split_types,
        candidate_feature_ids,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
    )
}

/// BoostedTreesCalculateBestGainsPerFeature
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestGainsPerFeature>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCalculateBestGainsPerFeature {
    max_splits: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCalculateBestGainsPerFeature {
    fn default() -> Self {
        Self {
            max_splits: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesCalculateBestGainsPerFeature {
    /// Creates a new `BoostedTreesCalculateBestGainsPerFeature`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_calculate_best_gains_per_feature.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_id_range: &T0,
        stats_summary_list: &[&T1],
        l1: &T2,
        l2: &T3,
        tree_complexity: &T4,
        min_node_weight: &T5,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCalculateBestGainsPerFeature")?;

        // Required input arguments
        op.add_input(&node_id_range.to_handle(ctx)?)?;
        let mut stats_summary_list_list = Vec::new();

        for t in stats_summary_list {
            stats_summary_list_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&stats_summary_list_list)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&tree_complexity.to_handle(ctx)?)?;
        op.add_input(&min_node_weight.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_splits {
            op.set_attr_int("max_splits", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<5>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesCalculateBestGainsPerFeature::new().call(&ctx, &node_id_range, &stats_summary_list, &l1, &l2, &tree_complexity, &min_node_weight)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCalculateBestGainsPerFeature>
pub fn boosted_trees_calculate_best_gains_per_feature<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_id_range: &T0,
    stats_summary_list: &[&T1],
    l1: &T2,
    l2: &T3,
    tree_complexity: &T4,
    min_node_weight: &T5,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
    let op = BoostedTreesCalculateBestGainsPerFeature::new();
    op.call(
        ctx,
        node_id_range,
        stats_summary_list,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
    )
}

/// BoostedTreesCenterBias
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCenterBias>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCenterBias {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCenterBias {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesCenterBias {
    /// Creates a new `BoostedTreesCenterBias`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_center_bias.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        mean_gradients: &T1,
        mean_hessians: &T2,
        l1: &T3,
        l2: &T4,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCenterBias")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        op.add_input(&mean_gradients.to_handle(ctx)?)?;
        op.add_input(&mean_hessians.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesCenterBias::new().call(&ctx, &tree_ensemble_handle, &mean_gradients, &mean_hessians, &l1, &l2)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCenterBias>
pub fn boosted_trees_center_bias<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    mean_gradients: &T1,
    mean_hessians: &T2,
    l1: &T3,
    l2: &T4,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesCenterBias::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        mean_gradients,
        mean_hessians,
        l1,
        l2,
    )
}

/// BoostedTreesCreateEnsemble
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCreateEnsemble>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCreateEnsemble {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCreateEnsemble {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesCreateEnsemble {
    /// Creates a new `BoostedTreesCreateEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_create_ensemble.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        stamp_token: &T1,
        tree_ensemble_serialized: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCreateEnsemble")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        op.add_input(&stamp_token.to_handle(ctx)?)?;
        op.add_input(&tree_ensemble_serialized.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesCreateEnsemble::new().call(&ctx, &tree_ensemble_handle, &stamp_token, &tree_ensemble_serialized)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCreateEnsemble>
pub fn boosted_trees_create_ensemble<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    stamp_token: &T1,
    tree_ensemble_serialized: &T2,
) -> crate::Result<()> {
    let op = BoostedTreesCreateEnsemble::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        stamp_token,
        tree_ensemble_serialized,
    )
}

/// BoostedTreesCreateQuantileStreamResource
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCreateQuantileStreamResource>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesCreateQuantileStreamResource {
    max_elements: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesCreateQuantileStreamResource {
    fn default() -> Self {
        Self {
            max_elements: Some(1099511627776i64),
            target_device_name: None,
        }
    }
}
impl BoostedTreesCreateQuantileStreamResource {
    /// Creates a new `BoostedTreesCreateQuantileStreamResource`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_elements` attribute.
    pub fn max_elements<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_elements = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_create_quantile_stream_resource.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
        epsilon: &T1,
        num_streams: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesCreateQuantileStreamResource")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;
        op.add_input(&num_streams.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_elements {
            op.set_attr_int("max_elements", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesCreateQuantileStreamResource::new().call(&ctx, &quantile_stream_resource_handle, &epsilon, &num_streams)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesCreateQuantileStreamResource>
pub fn boosted_trees_create_quantile_stream_resource<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
    epsilon: &T1,
    num_streams: &T2,
) -> crate::Result<()> {
    let op = BoostedTreesCreateQuantileStreamResource::new();
    op.call(ctx, quantile_stream_resource_handle, epsilon, num_streams)
}

/// BoostedTreesDeserializeEnsemble
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesDeserializeEnsemble>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesDeserializeEnsemble {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesDeserializeEnsemble {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesDeserializeEnsemble {
    /// Creates a new `BoostedTreesDeserializeEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_deserialize_ensemble.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        stamp_token: &T1,
        tree_ensemble_serialized: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesDeserializeEnsemble")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        op.add_input(&stamp_token.to_handle(ctx)?)?;
        op.add_input(&tree_ensemble_serialized.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesDeserializeEnsemble::new().call(&ctx, &tree_ensemble_handle, &stamp_token, &tree_ensemble_serialized)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesDeserializeEnsemble>
pub fn boosted_trees_deserialize_ensemble<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    stamp_token: &T1,
    tree_ensemble_serialized: &T2,
) -> crate::Result<()> {
    let op = BoostedTreesDeserializeEnsemble::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        stamp_token,
        tree_ensemble_serialized,
    )
}

/// BoostedTreesEnsembleResourceHandleOp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesEnsembleResourceHandleOp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesEnsembleResourceHandleOp {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesEnsembleResourceHandleOp {
    fn default() -> Self {
        Self {
            container: None,
            shared_name: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesEnsembleResourceHandleOp {
    /// Creates a new `BoostedTreesEnsembleResourceHandleOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_ensemble_resource_handle_op.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesEnsembleResourceHandleOp")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesEnsembleResourceHandleOp::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesEnsembleResourceHandleOp>
pub fn boosted_trees_ensemble_resource_handle_op<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesEnsembleResourceHandleOp::new();
    op.call(ctx)
}

/// BoostedTreesExampleDebugOutputs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesExampleDebugOutputs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesExampleDebugOutputs {
    logits_dimension: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesExampleDebugOutputs {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesExampleDebugOutputs {
    /// Creates a new `BoostedTreesExampleDebugOutputs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_example_debug_outputs.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        bucketized_features: &[&T1],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesExampleDebugOutputs")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        let mut bucketized_features_list = Vec::new();

        for t in bucketized_features {
            bucketized_features_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucketized_features_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesExampleDebugOutputs::new().call(&ctx, &tree_ensemble_handle, &bucketized_features)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesExampleDebugOutputs>
pub fn boosted_trees_example_debug_outputs<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    bucketized_features: &[&T1],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesExampleDebugOutputs::new();
    op.call(ctx, tree_ensemble_handle, bucketized_features)
}

/// BoostedTreesFlushQuantileSummaries
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesFlushQuantileSummaries>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesFlushQuantileSummaries {
    num_features: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesFlushQuantileSummaries {
    fn default() -> Self {
        Self {
            num_features: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesFlushQuantileSummaries {
    /// Creates a new `BoostedTreesFlushQuantileSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_flush_quantile_summaries.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesFlushQuantileSummaries")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_features {
            op.set_attr_int("num_features", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesFlushQuantileSummaries::new().call(&ctx, &quantile_stream_resource_handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesFlushQuantileSummaries>
pub fn boosted_trees_flush_quantile_summaries<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesFlushQuantileSummaries::new();
    op.call(ctx, quantile_stream_resource_handle)
}

/// BoostedTreesGetEnsembleStates
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesGetEnsembleStates>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesGetEnsembleStates {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesGetEnsembleStates {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesGetEnsembleStates {
    /// Creates a new `BoostedTreesGetEnsembleStates`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_get_ensemble_states.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesGetEnsembleStates")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<5>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesGetEnsembleStates::new().call(&ctx, &tree_ensemble_handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesGetEnsembleStates>
pub fn boosted_trees_get_ensemble_states<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
    let op = BoostedTreesGetEnsembleStates::new();
    op.call(ctx, tree_ensemble_handle)
}

/// BoostedTreesMakeQuantileSummaries
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesMakeQuantileSummaries>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesMakeQuantileSummaries {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesMakeQuantileSummaries {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesMakeQuantileSummaries {
    /// Creates a new `BoostedTreesMakeQuantileSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_make_quantile_summaries.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        float_values: &[&T0],
        example_weights: &T1,
        epsilon: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesMakeQuantileSummaries")?;

        // Required input arguments
        let mut float_values_list = Vec::new();

        for t in float_values {
            float_values_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&float_values_list)?;
        op.add_input(&example_weights.to_handle(ctx)?)?;
        op.add_input(&epsilon.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesMakeQuantileSummaries::new().call(&ctx, &float_values, &example_weights, &epsilon)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesMakeQuantileSummaries>
pub fn boosted_trees_make_quantile_summaries<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    float_values: &[&T0],
    example_weights: &T1,
    epsilon: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesMakeQuantileSummaries::new();
    op.call(ctx, float_values, example_weights, epsilon)
}

/// BoostedTreesMakeStatsSummary
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesMakeStatsSummary>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesMakeStatsSummary {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesMakeStatsSummary {
    fn default() -> Self {
        Self {
            max_splits: None,
            num_buckets: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesMakeStatsSummary {
    /// Creates a new `BoostedTreesMakeStatsSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_make_stats_summary.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_ids: &T0,
        gradients: &T1,
        hessians: &T2,
        bucketized_features_list: &[&T3],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesMakeStatsSummary")?;

        // Required input arguments
        op.add_input(&node_ids.to_handle(ctx)?)?;
        op.add_input(&gradients.to_handle(ctx)?)?;
        op.add_input(&hessians.to_handle(ctx)?)?;
        let mut bucketized_features_list_list = Vec::new();

        for t in bucketized_features_list {
            bucketized_features_list_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucketized_features_list_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_splits {
            op.set_attr_int("max_splits", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_buckets {
            op.set_attr_int("num_buckets", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesMakeStatsSummary::new().call(&ctx, &node_ids, &gradients, &hessians, &bucketized_features_list)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesMakeStatsSummary>
pub fn boosted_trees_make_stats_summary<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_ids: &T0,
    gradients: &T1,
    hessians: &T2,
    bucketized_features_list: &[&T3],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesMakeStatsSummary::new();
    op.call(ctx, node_ids, gradients, hessians, bucketized_features_list)
}

/// BoostedTreesPredict
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesPredict>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesPredict {
    logits_dimension: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesPredict {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesPredict {
    /// Creates a new `BoostedTreesPredict`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_predict.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        bucketized_features: &[&T1],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesPredict")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        let mut bucketized_features_list = Vec::new();

        for t in bucketized_features {
            bucketized_features_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucketized_features_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesPredict::new().call(&ctx, &tree_ensemble_handle, &bucketized_features)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesPredict>
pub fn boosted_trees_predict<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    bucketized_features: &[&T1],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesPredict::new();
    op.call(ctx, tree_ensemble_handle, bucketized_features)
}

/// BoostedTreesQuantileStreamResourceAddSummaries
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceAddSummaries>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesQuantileStreamResourceAddSummaries {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesQuantileStreamResourceAddSummaries {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesQuantileStreamResourceAddSummaries {
    /// Creates a new `BoostedTreesQuantileStreamResourceAddSummaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_quantile_stream_resource_add_summaries.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
        summaries: &[&T1],
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesQuantileStreamResourceAddSummaries")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;
        let mut summaries_list = Vec::new();

        for t in summaries {
            summaries_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&summaries_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceAddSummaries::new().call(&ctx, &quantile_stream_resource_handle, &summaries)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceAddSummaries>
pub fn boosted_trees_quantile_stream_resource_add_summaries<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
    summaries: &[&T1],
) -> crate::Result<()> {
    let op = BoostedTreesQuantileStreamResourceAddSummaries::new();
    op.call(ctx, quantile_stream_resource_handle, summaries)
}

/// BoostedTreesQuantileStreamResourceDeserialize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceDeserialize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesQuantileStreamResourceDeserialize {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesQuantileStreamResourceDeserialize {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesQuantileStreamResourceDeserialize {
    /// Creates a new `BoostedTreesQuantileStreamResourceDeserialize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_quantile_stream_resource_deserialize.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
        bucket_boundaries: &[&T1],
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesQuantileStreamResourceDeserialize")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;
        let mut bucket_boundaries_list = Vec::new();

        for t in bucket_boundaries {
            bucket_boundaries_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucket_boundaries_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceDeserialize::new().call(&ctx, &quantile_stream_resource_handle, &bucket_boundaries)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceDeserialize>
pub fn boosted_trees_quantile_stream_resource_deserialize<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
    bucket_boundaries: &[&T1],
) -> crate::Result<()> {
    let op = BoostedTreesQuantileStreamResourceDeserialize::new();
    op.call(ctx, quantile_stream_resource_handle, bucket_boundaries)
}

/// BoostedTreesQuantileStreamResourceFlush
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceFlush>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesQuantileStreamResourceFlush {
    generate_quantiles: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesQuantileStreamResourceFlush {
    fn default() -> Self {
        Self {
            generate_quantiles: Some(false),
            target_device_name: None,
        }
    }
}
impl BoostedTreesQuantileStreamResourceFlush {
    /// Creates a new `BoostedTreesQuantileStreamResourceFlush`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `generate_quantiles` attribute.
    pub fn generate_quantiles<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.generate_quantiles = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_quantile_stream_resource_flush.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
        num_buckets: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesQuantileStreamResourceFlush")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;
        op.add_input(&num_buckets.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.generate_quantiles {
            op.set_attr_bool("generate_quantiles", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceFlush::new().call(&ctx, &quantile_stream_resource_handle, &num_buckets)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceFlush>
pub fn boosted_trees_quantile_stream_resource_flush<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
    num_buckets: &T1,
) -> crate::Result<()> {
    let op = BoostedTreesQuantileStreamResourceFlush::new();
    op.call(ctx, quantile_stream_resource_handle, num_buckets)
}

/// BoostedTreesQuantileStreamResourceGetBucketBoundaries
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceGetBucketBoundaries>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesQuantileStreamResourceGetBucketBoundaries {
    num_features: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesQuantileStreamResourceGetBucketBoundaries {
    fn default() -> Self {
        Self {
            num_features: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesQuantileStreamResourceGetBucketBoundaries {
    /// Creates a new `BoostedTreesQuantileStreamResourceGetBucketBoundaries`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_features` attribute.
    pub fn num_features<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_features = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_quantile_stream_resource_get_bucket_boundaries.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        quantile_stream_resource_handle: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesQuantileStreamResourceGetBucketBoundaries")?;

        // Required input arguments
        op.add_input(&quantile_stream_resource_handle.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_features {
            op.set_attr_int("num_features", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceGetBucketBoundaries::new().call(&ctx, &quantile_stream_resource_handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceGetBucketBoundaries>
pub fn boosted_trees_quantile_stream_resource_get_bucket_boundaries<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    quantile_stream_resource_handle: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesQuantileStreamResourceGetBucketBoundaries::new();
    op.call(ctx, quantile_stream_resource_handle)
}

/// BoostedTreesQuantileStreamResourceHandleOp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceHandleOp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesQuantileStreamResourceHandleOp {
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesQuantileStreamResourceHandleOp {
    fn default() -> Self {
        Self {
            container: None,
            shared_name: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesQuantileStreamResourceHandleOp {
    /// Creates a new `BoostedTreesQuantileStreamResourceHandleOp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_quantile_stream_resource_handle_op.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesQuantileStreamResourceHandleOp")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BoostedTreesQuantileStreamResourceHandleOp::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesQuantileStreamResourceHandleOp>
pub fn boosted_trees_quantile_stream_resource_handle_op<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BoostedTreesQuantileStreamResourceHandleOp::new();
    op.call(ctx)
}

/// BoostedTreesSerializeEnsemble
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSerializeEnsemble>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesSerializeEnsemble {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesSerializeEnsemble {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BoostedTreesSerializeEnsemble {
    /// Creates a new `BoostedTreesSerializeEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_serialize_ensemble.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesSerializeEnsemble")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesSerializeEnsemble::new().call(&ctx, &tree_ensemble_handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSerializeEnsemble>
pub fn boosted_trees_serialize_ensemble<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = BoostedTreesSerializeEnsemble::new();
    op.call(ctx, tree_ensemble_handle)
}

/// BoostedTreesSparseAggregateStats
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSparseAggregateStats>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesSparseAggregateStats {
    max_splits: ::std::option::Option<i64>,
    num_buckets: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesSparseAggregateStats {
    fn default() -> Self {
        Self {
            max_splits: None,
            num_buckets: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesSparseAggregateStats {
    /// Creates a new `BoostedTreesSparseAggregateStats`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `max_splits` attribute.
    pub fn max_splits<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.max_splits = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_buckets` attribute.
    pub fn num_buckets<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_buckets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_sparse_aggregate_stats.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_ids: &T0,
        gradients: &T1,
        hessians: &T2,
        feature_indices: &T3,
        feature_values: &T4,
        feature_shape: &T5,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesSparseAggregateStats")?;

        // Required input arguments
        op.add_input(&node_ids.to_handle(ctx)?)?;
        op.add_input(&gradients.to_handle(ctx)?)?;
        op.add_input(&hessians.to_handle(ctx)?)?;
        op.add_input(&feature_indices.to_handle(ctx)?)?;
        op.add_input(&feature_values.to_handle(ctx)?)?;
        op.add_input(&feature_shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.max_splits {
            op.set_attr_int("max_splits", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_buckets {
            op.set_attr_int("num_buckets", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesSparseAggregateStats::new().call(&ctx, &node_ids, &gradients, &hessians, &feature_indices, &feature_values, &feature_shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSparseAggregateStats>
pub fn boosted_trees_sparse_aggregate_stats<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_ids: &T0,
    gradients: &T1,
    hessians: &T2,
    feature_indices: &T3,
    feature_values: &T4,
    feature_shape: &T5,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = BoostedTreesSparseAggregateStats::new();
    op.call(
        ctx,
        node_ids,
        gradients,
        hessians,
        feature_indices,
        feature_values,
        feature_shape,
    )
}

/// BoostedTreesSparseCalculateBestFeatureSplit
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSparseCalculateBestFeatureSplit>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesSparseCalculateBestFeatureSplit {
    logits_dimension: ::std::option::Option<i64>,
    split_type: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesSparseCalculateBestFeatureSplit {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            split_type: Some(::std::string::String::from("inequality")),
            target_device_name: None,
        }
    }
}
impl BoostedTreesSparseCalculateBestFeatureSplit {
    /// Creates a new `BoostedTreesSparseCalculateBestFeatureSplit`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `split_type` attribute.
    pub fn split_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.split_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_sparse_calculate_best_feature_split.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        node_id_range: &T0,
        stats_summary_indices: &T1,
        stats_summary_values: &T2,
        stats_summary_shape: &T3,
        l1: &T4,
        l2: &T5,
        tree_complexity: &T6,
        min_node_weight: &T7,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesSparseCalculateBestFeatureSplit")?;

        // Required input arguments
        op.add_input(&node_id_range.to_handle(ctx)?)?;
        op.add_input(&stats_summary_indices.to_handle(ctx)?)?;
        op.add_input(&stats_summary_values.to_handle(ctx)?)?;
        op.add_input(&stats_summary_shape.to_handle(ctx)?)?;
        op.add_input(&l1.to_handle(ctx)?)?;
        op.add_input(&l2.to_handle(ctx)?)?;
        op.add_input(&tree_complexity.to_handle(ctx)?)?;
        op.add_input(&min_node_weight.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.split_type {
            op.set_attr_string("split_type", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<7>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesSparseCalculateBestFeatureSplit::new().call(&ctx, &node_id_range, &stats_summary_indices, &stats_summary_values, &stats_summary_shape, &l1, &l2, &tree_complexity, &min_node_weight)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesSparseCalculateBestFeatureSplit>
pub fn boosted_trees_sparse_calculate_best_feature_split<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    node_id_range: &T0,
    stats_summary_indices: &T1,
    stats_summary_values: &T2,
    stats_summary_shape: &T3,
    l1: &T4,
    l2: &T5,
    tree_complexity: &T6,
    min_node_weight: &T7,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 7]> {
    let op = BoostedTreesSparseCalculateBestFeatureSplit::new();
    op.call(
        ctx,
        node_id_range,
        stats_summary_indices,
        stats_summary_values,
        stats_summary_shape,
        l1,
        l2,
        tree_complexity,
        min_node_weight,
    )
}

/// BoostedTreesTrainingPredict
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesTrainingPredict>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesTrainingPredict {
    logits_dimension: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesTrainingPredict {
    fn default() -> Self {
        Self {
            logits_dimension: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesTrainingPredict {
    /// Creates a new `BoostedTreesTrainingPredict`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_training_predict.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        cached_tree_ids: &T1,
        cached_node_ids: &T2,
        bucketized_features: &[&T3],
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesTrainingPredict")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        op.add_input(&cached_tree_ids.to_handle(ctx)?)?;
        op.add_input(&cached_node_ids.to_handle(ctx)?)?;
        let mut bucketized_features_list = Vec::new();

        for t in bucketized_features {
            bucketized_features_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&bucketized_features_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BoostedTreesTrainingPredict::new().call(&ctx, &tree_ensemble_handle, &cached_tree_ids, &cached_node_ids, &bucketized_features)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesTrainingPredict>
pub fn boosted_trees_training_predict<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    cached_tree_ids: &T1,
    cached_node_ids: &T2,
    bucketized_features: &[&T3],
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = BoostedTreesTrainingPredict::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        cached_tree_ids,
        cached_node_ids,
        bucketized_features,
    )
}

/// BoostedTreesUpdateEnsemble
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesUpdateEnsemble>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesUpdateEnsemble {
    pruning_mode: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesUpdateEnsemble {
    fn default() -> Self {
        Self {
            pruning_mode: None,
            target_device_name: None,
        }
    }
}
impl BoostedTreesUpdateEnsemble {
    /// Creates a new `BoostedTreesUpdateEnsemble`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `pruning_mode` attribute.
    pub fn pruning_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.pruning_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_update_ensemble.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        feature_ids: &T1,
        node_ids: &[&T2],
        gains: &[&T3],
        thresholds: &[&T4],
        left_node_contribs: &[&T5],
        right_node_contribs: &[&T6],
        max_depth: &T7,
        learning_rate: &T8,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesUpdateEnsemble")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        op.add_input(&feature_ids.to_handle(ctx)?)?;
        let mut node_ids_list = Vec::new();

        for t in node_ids {
            node_ids_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&node_ids_list)?;
        let mut gains_list = Vec::new();

        for t in gains {
            gains_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&gains_list)?;
        let mut thresholds_list = Vec::new();

        for t in thresholds {
            thresholds_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&thresholds_list)?;
        let mut left_node_contribs_list = Vec::new();

        for t in left_node_contribs {
            left_node_contribs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&left_node_contribs_list)?;
        let mut right_node_contribs_list = Vec::new();

        for t in right_node_contribs {
            right_node_contribs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&right_node_contribs_list)?;
        op.add_input(&max_depth.to_handle(ctx)?)?;
        op.add_input(&learning_rate.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.pruning_mode {
            op.set_attr_int("pruning_mode", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesUpdateEnsemble::new().call(&ctx, &tree_ensemble_handle, &feature_ids, &node_ids, &gains, &thresholds, &left_node_contribs, &right_node_contribs, &max_depth, &learning_rate)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesUpdateEnsemble>
pub fn boosted_trees_update_ensemble<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    feature_ids: &T1,
    node_ids: &[&T2],
    gains: &[&T3],
    thresholds: &[&T4],
    left_node_contribs: &[&T5],
    right_node_contribs: &[&T6],
    max_depth: &T7,
    learning_rate: &T8,
) -> crate::Result<()> {
    let op = BoostedTreesUpdateEnsemble::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        feature_ids,
        node_ids,
        gains,
        thresholds,
        left_node_contribs,
        right_node_contribs,
        max_depth,
        learning_rate,
    )
}

/// BoostedTreesUpdateEnsembleV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesUpdateEnsembleV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BoostedTreesUpdateEnsembleV2 {
    logits_dimension: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BoostedTreesUpdateEnsembleV2 {
    fn default() -> Self {
        Self {
            logits_dimension: Some(1i64),
            target_device_name: None,
        }
    }
}
impl BoostedTreesUpdateEnsembleV2 {
    /// Creates a new `BoostedTreesUpdateEnsembleV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `logits_dimension` attribute.
    pub fn logits_dimension<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.logits_dimension = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute boosted_trees_update_ensemble_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
        T11: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        tree_ensemble_handle: &T0,
        feature_ids: &[&T1],
        dimension_ids: &[&T2],
        node_ids: &[&T3],
        gains: &[&T4],
        thresholds: &[&T5],
        left_node_contribs: &[&T6],
        right_node_contribs: &[&T7],
        split_types: &[&T8],
        max_depth: &T9,
        learning_rate: &T10,
        pruning_mode: &T11,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "BoostedTreesUpdateEnsembleV2")?;

        // Required input arguments
        op.add_input(&tree_ensemble_handle.to_handle(ctx)?)?;
        let mut feature_ids_list = Vec::new();

        for t in feature_ids {
            feature_ids_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&feature_ids_list)?;
        let mut dimension_ids_list = Vec::new();

        for t in dimension_ids {
            dimension_ids_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&dimension_ids_list)?;
        let mut node_ids_list = Vec::new();

        for t in node_ids {
            node_ids_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&node_ids_list)?;
        let mut gains_list = Vec::new();

        for t in gains {
            gains_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&gains_list)?;
        let mut thresholds_list = Vec::new();

        for t in thresholds {
            thresholds_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&thresholds_list)?;
        let mut left_node_contribs_list = Vec::new();

        for t in left_node_contribs {
            left_node_contribs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&left_node_contribs_list)?;
        let mut right_node_contribs_list = Vec::new();

        for t in right_node_contribs {
            right_node_contribs_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&right_node_contribs_list)?;
        let mut split_types_list = Vec::new();

        for t in split_types {
            split_types_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&split_types_list)?;
        op.add_input(&max_depth.to_handle(ctx)?)?;
        op.add_input(&learning_rate.to_handle(ctx)?)?;
        op.add_input(&pruning_mode.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.logits_dimension {
            op.set_attr_int("logits_dimension", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `BoostedTreesUpdateEnsembleV2::new().call(&ctx, &tree_ensemble_handle, &feature_ids, &dimension_ids, &node_ids, &gains, &thresholds, &left_node_contribs, &right_node_contribs, &split_types, &max_depth, &learning_rate, &pruning_mode)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BoostedTreesUpdateEnsembleV2>
pub fn boosted_trees_update_ensemble_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
    T11: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    tree_ensemble_handle: &T0,
    feature_ids: &[&T1],
    dimension_ids: &[&T2],
    node_ids: &[&T3],
    gains: &[&T4],
    thresholds: &[&T5],
    left_node_contribs: &[&T6],
    right_node_contribs: &[&T7],
    split_types: &[&T8],
    max_depth: &T9,
    learning_rate: &T10,
    pruning_mode: &T11,
) -> crate::Result<()> {
    let op = BoostedTreesUpdateEnsembleV2::new();
    op.call(
        ctx,
        tree_ensemble_handle,
        feature_ids,
        dimension_ids,
        node_ids,
        gains,
        thresholds,
        left_node_contribs,
        right_node_contribs,
        split_types,
        max_depth,
        learning_rate,
        pruning_mode,
    )
}

/// BroadcastArgs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastArgs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BroadcastArgs {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BroadcastArgs {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BroadcastArgs {
    /// Creates a new `BroadcastArgs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute broadcast_args.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        s0: &T0,
        s1: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BroadcastArgs")?;

        // Required input arguments
        op.add_input(&s0.to_handle(ctx)?)?;
        op.add_input(&s1.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BroadcastArgs::new().call(&ctx, &s0, &s1)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastArgs>
pub fn broadcast_args<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    s0: &T0,
    s1: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BroadcastArgs::new();
    op.call(ctx, s0, s1)
}

/// BroadcastGradientArgs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastGradientArgs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BroadcastGradientArgs {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BroadcastGradientArgs {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BroadcastGradientArgs {
    /// Creates a new `BroadcastGradientArgs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute broadcast_gradient_args.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        s0: &T0,
        s1: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "BroadcastGradientArgs")?;

        // Required input arguments
        op.add_input(&s0.to_handle(ctx)?)?;
        op.add_input(&s1.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `BroadcastGradientArgs::new().call(&ctx, &s0, &s1)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastGradientArgs>
pub fn broadcast_gradient_args<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    s0: &T0,
    s1: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = BroadcastGradientArgs::new();
    op.call(ctx, s0, s1)
}

/// BroadcastTo
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastTo>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BroadcastTo {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BroadcastTo {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl BroadcastTo {
    /// Creates a new `BroadcastTo`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute broadcast_to.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        shape: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BroadcastTo")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&shape.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BroadcastTo::new().call(&ctx, &input, &shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BroadcastTo>
pub fn broadcast_to<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    shape: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BroadcastTo::new();
    op.call(ctx, input, shape)
}

/// Bucketize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bucketize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Bucketize {
    boundaries: ::std::option::Option<::std::vec::Vec<f32>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Bucketize {
    fn default() -> Self {
        Self {
            boundaries: None,
            target_device_name: None,
        }
    }
}
impl Bucketize {
    /// Creates a new `Bucketize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `boundaries` attribute.
    pub fn boundaries<ArgType: ::std::convert::Into<::std::vec::Vec<f32>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.boundaries = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bucketize.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Bucketize")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.boundaries {
            op.set_attr_float_list("boundaries", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Bucketize::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Bucketize>
pub fn bucketize<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Bucketize::new();
    op.call(ctx, input)
}

/// BytesProducedStatsDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BytesProducedStatsDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct BytesProducedStatsDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for BytesProducedStatsDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl BytesProducedStatsDataset {
    /// Creates a new `BytesProducedStatsDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute bytes_produced_stats_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        tag: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "BytesProducedStatsDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&tag.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `BytesProducedStatsDataset::new().call(&ctx, &input_dataset, &tag)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/BytesProducedStatsDataset>
pub fn bytes_produced_stats_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    tag: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = BytesProducedStatsDataset::new();
    op.call(ctx, input_dataset, tag)
}

/// CSRSparseMatrixComponents
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixComponents>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CSRSparseMatrixComponents {
    type_: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CSRSparseMatrixComponents {
    fn default() -> Self {
        Self {
            type_: None,
            target_device_name: None,
        }
    }
}
impl CSRSparseMatrixComponents {
    /// Creates a new `CSRSparseMatrixComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute csrsparse_matrix_components.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        csr_sparse_matrix: &T0,
        index: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CSRSparseMatrixComponents")?;

        // Required input arguments
        op.add_input(&csr_sparse_matrix.to_handle(ctx)?)?;
        op.add_input(&index.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.type_ {
            op.set_attr_type("type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CSRSparseMatrixComponents::new().call(&ctx, &csr_sparse_matrix, &index)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixComponents>
pub fn csrsparse_matrix_components<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    csr_sparse_matrix: &T0,
    index: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = CSRSparseMatrixComponents::new();
    op.call(ctx, csr_sparse_matrix, index)
}

/// CSRSparseMatrixToDense
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixToDense>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CSRSparseMatrixToDense {
    type_: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CSRSparseMatrixToDense {
    fn default() -> Self {
        Self {
            type_: None,
            target_device_name: None,
        }
    }
}
impl CSRSparseMatrixToDense {
    /// Creates a new `CSRSparseMatrixToDense`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute csrsparse_matrix_to_dense.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        sparse_input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CSRSparseMatrixToDense")?;

        // Required input arguments
        op.add_input(&sparse_input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.type_ {
            op.set_attr_type("type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CSRSparseMatrixToDense::new().call(&ctx, &sparse_input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixToDense>
pub fn csrsparse_matrix_to_dense<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    sparse_input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CSRSparseMatrixToDense::new();
    op.call(ctx, sparse_input)
}

/// CSRSparseMatrixToSparseTensor
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixToSparseTensor>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CSRSparseMatrixToSparseTensor {
    type_: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CSRSparseMatrixToSparseTensor {
    fn default() -> Self {
        Self {
            type_: None,
            target_device_name: None,
        }
    }
}
impl CSRSparseMatrixToSparseTensor {
    /// Creates a new `CSRSparseMatrixToSparseTensor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `type` attribute.
    pub fn type_<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.type_ = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute csrsparse_matrix_to_sparse_tensor.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        sparse_matrix: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CSRSparseMatrixToSparseTensor")?;

        // Required input arguments
        op.add_input(&sparse_matrix.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.type_ {
            op.set_attr_type("type", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CSRSparseMatrixToSparseTensor::new().call(&ctx, &sparse_matrix)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSRSparseMatrixToSparseTensor>
pub fn csrsparse_matrix_to_sparse_tensor<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    sparse_matrix: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = CSRSparseMatrixToSparseTensor::new();
    op.call(ctx, sparse_matrix)
}

/// CSVDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSVDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CSVDataset {
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CSVDataset {
    fn default() -> Self {
        Self {
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl CSVDataset {
    /// Creates a new `CSVDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute csvdataset.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        filenames: &T0,
        compression_type: &T1,
        buffer_size: &T2,
        header: &T3,
        field_delim: &T4,
        use_quote_delim: &T5,
        na_value: &T6,
        select_cols: &T7,
        record_defaults: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CSVDataset")?;

        // Required input arguments
        op.add_input(&filenames.to_handle(ctx)?)?;
        op.add_input(&compression_type.to_handle(ctx)?)?;
        op.add_input(&buffer_size.to_handle(ctx)?)?;
        op.add_input(&header.to_handle(ctx)?)?;
        op.add_input(&field_delim.to_handle(ctx)?)?;
        op.add_input(&use_quote_delim.to_handle(ctx)?)?;
        op.add_input(&na_value.to_handle(ctx)?)?;
        op.add_input(&select_cols.to_handle(ctx)?)?;
        op.add_input(&record_defaults.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CSVDataset::new().call(&ctx, &filenames, &compression_type, &buffer_size, &header, &field_delim, &use_quote_delim, &na_value, &select_cols, &record_defaults)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSVDataset>
pub fn csvdataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    filenames: &T0,
    compression_type: &T1,
    buffer_size: &T2,
    header: &T3,
    field_delim: &T4,
    use_quote_delim: &T5,
    na_value: &T6,
    select_cols: &T7,
    record_defaults: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CSVDataset::new();
    op.call(
        ctx,
        filenames,
        compression_type,
        buffer_size,
        header,
        field_delim,
        use_quote_delim,
        na_value,
        select_cols,
        record_defaults,
    )
}

/// CSVDatasetV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSVDatasetV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CSVDatasetV2 {
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CSVDatasetV2 {
    fn default() -> Self {
        Self {
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl CSVDatasetV2 {
    /// Creates a new `CSVDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute csvdataset_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        filenames: &T0,
        compression_type: &T1,
        buffer_size: &T2,
        header: &T3,
        field_delim: &T4,
        use_quote_delim: &T5,
        na_value: &T6,
        select_cols: &T7,
        record_defaults: &T8,
        exclude_cols: &T9,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CSVDatasetV2")?;

        // Required input arguments
        op.add_input(&filenames.to_handle(ctx)?)?;
        op.add_input(&compression_type.to_handle(ctx)?)?;
        op.add_input(&buffer_size.to_handle(ctx)?)?;
        op.add_input(&header.to_handle(ctx)?)?;
        op.add_input(&field_delim.to_handle(ctx)?)?;
        op.add_input(&use_quote_delim.to_handle(ctx)?)?;
        op.add_input(&na_value.to_handle(ctx)?)?;
        op.add_input(&select_cols.to_handle(ctx)?)?;
        op.add_input(&record_defaults.to_handle(ctx)?)?;
        op.add_input(&exclude_cols.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CSVDatasetV2::new().call(&ctx, &filenames, &compression_type, &buffer_size, &header, &field_delim, &use_quote_delim, &na_value, &select_cols, &record_defaults, &exclude_cols)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CSVDatasetV2>
pub fn csvdataset_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    filenames: &T0,
    compression_type: &T1,
    buffer_size: &T2,
    header: &T3,
    field_delim: &T4,
    use_quote_delim: &T5,
    na_value: &T6,
    select_cols: &T7,
    record_defaults: &T8,
    exclude_cols: &T9,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CSVDatasetV2::new();
    op.call(
        ctx,
        filenames,
        compression_type,
        buffer_size,
        header,
        field_delim,
        use_quote_delim,
        na_value,
        select_cols,
        record_defaults,
        exclude_cols,
    )
}

/// CTCBeamSearchDecoder
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCBeamSearchDecoder>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CTCBeamSearchDecoder {
    beam_width: ::std::option::Option<i64>,
    top_paths: ::std::option::Option<i64>,
    merge_repeated: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CTCBeamSearchDecoder {
    fn default() -> Self {
        Self {
            beam_width: None,
            top_paths: None,
            merge_repeated: Some(true),
            target_device_name: None,
        }
    }
}
impl CTCBeamSearchDecoder {
    /// Creates a new `CTCBeamSearchDecoder`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `beam_width` attribute.
    pub fn beam_width<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.beam_width = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `top_paths` attribute.
    pub fn top_paths<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.top_paths = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `merge_repeated` attribute.
    pub fn merge_repeated<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute ctcbeam_search_decoder.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &T0,
        sequence_length: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CTCBeamSearchDecoder")?;

        // Required input arguments
        op.add_input(&inputs.to_handle(ctx)?)?;
        op.add_input(&sequence_length.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.beam_width {
            op.set_attr_int("beam_width", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.top_paths {
            op.set_attr_int("top_paths", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.merge_repeated {
            op.set_attr_bool("merge_repeated", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CTCBeamSearchDecoder::new().call(&ctx, &inputs, &sequence_length)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCBeamSearchDecoder>
pub fn ctcbeam_search_decoder<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    inputs: &T0,
    sequence_length: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CTCBeamSearchDecoder::new();
    op.call(ctx, inputs, sequence_length)
}

/// CTCGreedyDecoder
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCGreedyDecoder>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CTCGreedyDecoder {
    merge_repeated: ::std::option::Option<bool>,
    blank_index: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CTCGreedyDecoder {
    fn default() -> Self {
        Self {
            merge_repeated: Some(false),
            blank_index: Some(-1i64),
            target_device_name: None,
        }
    }
}
impl CTCGreedyDecoder {
    /// Creates a new `CTCGreedyDecoder`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `merge_repeated` attribute.
    pub fn merge_repeated<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `blank_index` attribute.
    pub fn blank_index<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.blank_index = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute ctcgreedy_decoder.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &T0,
        sequence_length: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CTCGreedyDecoder")?;

        // Required input arguments
        op.add_input(&inputs.to_handle(ctx)?)?;
        op.add_input(&sequence_length.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.merge_repeated {
            op.set_attr_bool("merge_repeated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.blank_index {
            op.set_attr_int("blank_index", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CTCGreedyDecoder::new().call(&ctx, &inputs, &sequence_length)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCGreedyDecoder>
pub fn ctcgreedy_decoder<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    inputs: &T0,
    sequence_length: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CTCGreedyDecoder::new();
    op.call(ctx, inputs, sequence_length)
}

/// CTCLoss
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCLoss>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CTCLoss {
    preprocess_collapse_repeated: ::std::option::Option<bool>,
    ctc_merge_repeated: ::std::option::Option<bool>,
    ignore_longer_outputs_than_inputs: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CTCLoss {
    fn default() -> Self {
        Self {
            preprocess_collapse_repeated: Some(false),
            ctc_merge_repeated: Some(true),
            ignore_longer_outputs_than_inputs: Some(false),
            target_device_name: None,
        }
    }
}
impl CTCLoss {
    /// Creates a new `CTCLoss`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `preprocess_collapse_repeated` attribute.
    pub fn preprocess_collapse_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.preprocess_collapse_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ctc_merge_repeated` attribute.
    pub fn ctc_merge_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ctc_merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ignore_longer_outputs_than_inputs` attribute.
    pub fn ignore_longer_outputs_than_inputs<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ignore_longer_outputs_than_inputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute ctcloss.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &T0,
        labels_indices: &T1,
        labels_values: &T2,
        sequence_length: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CTCLoss")?;

        // Required input arguments
        op.add_input(&inputs.to_handle(ctx)?)?;
        op.add_input(&labels_indices.to_handle(ctx)?)?;
        op.add_input(&labels_values.to_handle(ctx)?)?;
        op.add_input(&sequence_length.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.preprocess_collapse_repeated {
            op.set_attr_bool("preprocess_collapse_repeated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ctc_merge_repeated {
            op.set_attr_bool("ctc_merge_repeated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ignore_longer_outputs_than_inputs {
            op.set_attr_bool("ignore_longer_outputs_than_inputs", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CTCLoss::new().call(&ctx, &inputs, &labels_indices, &labels_values, &sequence_length)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCLoss>
pub fn ctcloss<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    inputs: &T0,
    labels_indices: &T1,
    labels_values: &T2,
    sequence_length: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = CTCLoss::new();
    op.call(ctx, inputs, labels_indices, labels_values, sequence_length)
}

/// CTCLossV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCLossV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CTCLossV2 {
    preprocess_collapse_repeated: ::std::option::Option<bool>,
    ctc_merge_repeated: ::std::option::Option<bool>,
    ignore_longer_outputs_than_inputs: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CTCLossV2 {
    fn default() -> Self {
        Self {
            preprocess_collapse_repeated: Some(false),
            ctc_merge_repeated: Some(true),
            ignore_longer_outputs_than_inputs: Some(false),
            target_device_name: None,
        }
    }
}
impl CTCLossV2 {
    /// Creates a new `CTCLossV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `preprocess_collapse_repeated` attribute.
    pub fn preprocess_collapse_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.preprocess_collapse_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ctc_merge_repeated` attribute.
    pub fn ctc_merge_repeated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ctc_merge_repeated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ignore_longer_outputs_than_inputs` attribute.
    pub fn ignore_longer_outputs_than_inputs<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.ignore_longer_outputs_than_inputs = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute ctcloss_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        inputs: &T0,
        labels_indices: &T1,
        labels_values: &T2,
        sequence_length: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CTCLossV2")?;

        // Required input arguments
        op.add_input(&inputs.to_handle(ctx)?)?;
        op.add_input(&labels_indices.to_handle(ctx)?)?;
        op.add_input(&labels_values.to_handle(ctx)?)?;
        op.add_input(&sequence_length.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.preprocess_collapse_repeated {
            op.set_attr_bool("preprocess_collapse_repeated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ctc_merge_repeated {
            op.set_attr_bool("ctc_merge_repeated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ignore_longer_outputs_than_inputs {
            op.set_attr_bool("ignore_longer_outputs_than_inputs", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CTCLossV2::new().call(&ctx, &inputs, &labels_indices, &labels_values, &sequence_length)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CTCLossV2>
pub fn ctcloss_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    inputs: &T0,
    labels_indices: &T1,
    labels_values: &T2,
    sequence_length: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = CTCLossV2::new();
    op.call(ctx, inputs, labels_indices, labels_values, sequence_length)
}

/// CacheDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CacheDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CacheDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CacheDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl CacheDataset {
    /// Creates a new `CacheDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cache_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        filename: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CacheDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&filename.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CacheDataset::new().call(&ctx, &input_dataset, &filename)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CacheDataset>
pub fn cache_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    filename: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CacheDataset::new();
    op.call(ctx, input_dataset, filename)
}

/// CacheDatasetV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CacheDatasetV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CacheDatasetV2 {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CacheDatasetV2 {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl CacheDatasetV2 {
    /// Creates a new `CacheDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cache_dataset_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        filename: &T1,
        cache: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CacheDatasetV2")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&filename.to_handle(ctx)?)?;
        op.add_input(&cache.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CacheDatasetV2::new().call(&ctx, &input_dataset, &filename, &cache)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CacheDatasetV2>
pub fn cache_dataset_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    filename: &T1,
    cache: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CacheDatasetV2::new();
    op.call(ctx, input_dataset, filename, cache)
}

/// Case
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Case>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Case {
    Tout: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    branches: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Case {
    fn default() -> Self {
        Self {
            Tout: None,
            branches: None,
            output_shapes: Some(vec![]),
            target_device_name: None,
        }
    }
}
impl Case {
    /// Creates a new `Case`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `branches` attribute.
    pub fn branches<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.branches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute case.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        branch_index: &T0,
        input: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Case")?;

        // Required input arguments
        op.add_input(&branch_index.to_handle(ctx)?)?;
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type_list("Tout", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.branches {
            op.set_attr_string_list("branches", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Case::new().call(&ctx, &branch_index, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Case>
pub fn case<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    branch_index: &T0,
    input: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Case::new();
    op.call(ctx, branch_index, input)
}

/// Cast
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cast>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cast {
    DstT: ::std::option::Option<crate::DataType>,
    Truncate: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cast {
    fn default() -> Self {
        Self {
            DstT: None,
            Truncate: Some(false),
            target_device_name: None,
        }
    }
}
impl Cast {
    /// Creates a new `Cast`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `DstT` attribute.
    pub fn DstT<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.DstT = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Truncate` attribute.
    pub fn Truncate<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.Truncate = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cast.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cast")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.DstT {
            op.set_attr_type("DstT", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.Truncate {
            op.set_attr_bool("Truncate", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cast::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cast>
pub fn cast<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cast::new();
    op.call(ctx, x)
}

/// Ceil
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Ceil>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Ceil {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Ceil {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Ceil {
    /// Creates a new `Ceil`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute ceil.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Ceil")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Ceil::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Ceil>
pub fn ceil<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Ceil::new();
    op.call(ctx, x)
}

/// CheckNumerics
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CheckNumerics>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CheckNumerics {
    message: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CheckNumerics {
    fn default() -> Self {
        Self {
            message: None,
            target_device_name: None,
        }
    }
}
impl CheckNumerics {
    /// Creates a new `CheckNumerics`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `message` attribute.
    pub fn message<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute check_numerics.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tensor: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CheckNumerics")?;

        // Required input arguments
        op.add_input(&tensor.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.message {
            op.set_attr_string("message", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CheckNumerics::new().call(&ctx, &tensor)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CheckNumerics>
pub fn check_numerics<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    tensor: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CheckNumerics::new();
    op.call(ctx, tensor)
}

/// CheckNumericsV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CheckNumericsV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CheckNumericsV2 {
    message: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CheckNumericsV2 {
    fn default() -> Self {
        Self {
            message: None,
            target_device_name: None,
        }
    }
}
impl CheckNumericsV2 {
    /// Creates a new `CheckNumericsV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `message` attribute.
    pub fn message<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute check_numerics_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        tensor: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CheckNumericsV2")?;

        // Required input arguments
        op.add_input(&tensor.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.message {
            op.set_attr_string("message", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CheckNumericsV2::new().call(&ctx, &tensor)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CheckNumericsV2>
pub fn check_numerics_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    tensor: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CheckNumericsV2::new();
    op.call(ctx, tensor)
}

/// Cholesky
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cholesky>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cholesky {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cholesky {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Cholesky {
    /// Creates a new `Cholesky`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cholesky.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cholesky")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cholesky::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cholesky>
pub fn cholesky<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cholesky::new();
    op.call(ctx, input)
}

/// CholeskyGrad
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CholeskyGrad>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CholeskyGrad {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CholeskyGrad {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CholeskyGrad {
    /// Creates a new `CholeskyGrad`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cholesky_grad.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        l: &T0,
        grad: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CholeskyGrad")?;

        // Required input arguments
        op.add_input(&l.to_handle(ctx)?)?;
        op.add_input(&grad.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CholeskyGrad::new().call(&ctx, &l, &grad)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CholeskyGrad>
pub fn cholesky_grad<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    l: &T0,
    grad: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CholeskyGrad::new();
    op.call(ctx, l, grad)
}

/// ChooseFastestBranchDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ChooseFastestBranchDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ChooseFastestBranchDataset {
    num_elements_per_branch: ::std::option::Option<i64>,
    branches: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    other_arguments_lengths: ::std::option::Option<::std::vec::Vec<i64>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ChooseFastestBranchDataset {
    fn default() -> Self {
        Self {
            num_elements_per_branch: None,
            branches: None,
            other_arguments_lengths: None,
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl ChooseFastestBranchDataset {
    /// Creates a new `ChooseFastestBranchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_elements_per_branch` attribute.
    pub fn num_elements_per_branch<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_elements_per_branch = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `branches` attribute.
    pub fn branches<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.branches = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `other_arguments_lengths` attribute.
    pub fn other_arguments_lengths<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.other_arguments_lengths = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute choose_fastest_branch_dataset.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        ratio_numerator: &T1,
        ratio_denominator: &T2,
        other_arguments: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ChooseFastestBranchDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&ratio_numerator.to_handle(ctx)?)?;
        op.add_input(&ratio_denominator.to_handle(ctx)?)?;
        op.add_input(&other_arguments.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_elements_per_branch {
            op.set_attr_int("num_elements_per_branch", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.branches {
            op.set_attr_string_list("branches", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.other_arguments_lengths {
            op.set_attr_int_list("other_arguments_lengths", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ChooseFastestBranchDataset::new().call(&ctx, &input_dataset, &ratio_numerator, &ratio_denominator, &other_arguments)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ChooseFastestBranchDataset>
pub fn choose_fastest_branch_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    ratio_numerator: &T1,
    ratio_denominator: &T2,
    other_arguments: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ChooseFastestBranchDataset::new();
    op.call(
        ctx,
        input_dataset,
        ratio_numerator,
        ratio_denominator,
        other_arguments,
    )
}

/// ChooseFastestDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ChooseFastestDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ChooseFastestDataset {
    num_experiments: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ChooseFastestDataset {
    fn default() -> Self {
        Self {
            num_experiments: None,
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl ChooseFastestDataset {
    /// Creates a new `ChooseFastestDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_experiments` attribute.
    pub fn num_experiments<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_experiments = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute choose_fastest_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_datasets: &[&T0],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ChooseFastestDataset")?;

        // Required input arguments
        let mut input_datasets_list = Vec::new();

        for t in input_datasets {
            input_datasets_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&input_datasets_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_experiments {
            op.set_attr_int("num_experiments", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ChooseFastestDataset::new().call(&ctx, &input_datasets)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ChooseFastestDataset>
pub fn choose_fastest_dataset<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input_datasets: &[&T0],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ChooseFastestDataset::new();
    op.call(ctx, input_datasets)
}

/// ClipByValue
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ClipByValue>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ClipByValue {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ClipByValue {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ClipByValue {
    /// Creates a new `ClipByValue`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute clip_by_value.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        t: &T0,
        clip_value_min: &T1,
        clip_value_max: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ClipByValue")?;

        // Required input arguments
        op.add_input(&t.to_handle(ctx)?)?;
        op.add_input(&clip_value_min.to_handle(ctx)?)?;
        op.add_input(&clip_value_max.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ClipByValue::new().call(&ctx, &t, &clip_value_min, &clip_value_max)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ClipByValue>
pub fn clip_by_value<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    t: &T0,
    clip_value_min: &T1,
    clip_value_max: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ClipByValue::new();
    op.call(ctx, t, clip_value_min, clip_value_max)
}

/// CloseSummaryWriter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CloseSummaryWriter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CloseSummaryWriter {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CloseSummaryWriter {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CloseSummaryWriter {
    /// Creates a new `CloseSummaryWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute close_summary_writer.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        writer: &T0,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "CloseSummaryWriter")?;

        // Required input arguments
        op.add_input(&writer.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `CloseSummaryWriter::new().call(&ctx, &writer)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CloseSummaryWriter>
pub fn close_summary_writer<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    writer: &T0,
) -> crate::Result<()> {
    let op = CloseSummaryWriter::new();
    op.call(ctx, writer)
}

/// CollectiveAllToAllV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveAllToAllV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveAllToAllV3 {
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveAllToAllV3 {
    fn default() -> Self {
        Self {
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveAllToAllV3 {
    /// Creates a new `CollectiveAllToAllV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_all_to_all_v3.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        communicator: &T1,
        group_assignment: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveAllToAllV3")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&communicator.to_handle(ctx)?)?;
        op.add_input(&group_assignment.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveAllToAllV3::new().call(&ctx, &input, &communicator, &group_assignment)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveAllToAllV3>
pub fn collective_all_to_all_v3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    communicator: &T1,
    group_assignment: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveAllToAllV3::new();
    op.call(ctx, input, communicator, group_assignment)
}

/// CollectiveBcastRecv
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastRecv>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveBcastRecv {
    T: ::std::option::Option<crate::DataType>,
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveBcastRecv {
    fn default() -> Self {
        Self {
            T: None,
            group_size: None,
            group_key: None,
            instance_key: None,
            shape: None,
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveBcastRecv {
    /// Creates a new `CollectiveBcastRecv`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_bcast_recv.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveBcastRecv")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.T {
            op.set_attr_type("T", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.group_size {
            op.set_attr_int("group_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.group_key {
            op.set_attr_int("group_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.instance_key {
            op.set_attr_int("instance_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shape {
            op.set_attr_shape("shape", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveBcastRecv::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastRecv>
pub fn collective_bcast_recv<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveBcastRecv::new();
    op.call(ctx)
}

/// CollectiveBcastRecvV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastRecvV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveBcastRecvV2 {
    T: ::std::option::Option<crate::DataType>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveBcastRecvV2 {
    fn default() -> Self {
        Self {
            T: None,
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveBcastRecvV2 {
    /// Creates a new `CollectiveBcastRecvV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_bcast_recv_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        group_size: &T0,
        group_key: &T1,
        instance_key: &T2,
        shape: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveBcastRecvV2")?;

        // Required input arguments
        op.add_input(&group_size.to_handle(ctx)?)?;
        op.add_input(&group_key.to_handle(ctx)?)?;
        op.add_input(&instance_key.to_handle(ctx)?)?;
        op.add_input(&shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.T {
            op.set_attr_type("T", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveBcastRecvV2::new().call(&ctx, &group_size, &group_key, &instance_key, &shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastRecvV2>
pub fn collective_bcast_recv_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    group_size: &T0,
    group_key: &T1,
    instance_key: &T2,
    shape: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveBcastRecvV2::new();
    op.call(ctx, group_size, group_key, instance_key, shape)
}

/// CollectiveBcastSend
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastSend>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveBcastSend {
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveBcastSend {
    fn default() -> Self {
        Self {
            group_size: None,
            group_key: None,
            instance_key: None,
            shape: None,
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveBcastSend {
    /// Creates a new `CollectiveBcastSend`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_bcast_send.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveBcastSend")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.group_size {
            op.set_attr_int("group_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.group_key {
            op.set_attr_int("group_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.instance_key {
            op.set_attr_int("instance_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shape {
            op.set_attr_shape("shape", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveBcastSend::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastSend>
pub fn collective_bcast_send<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveBcastSend::new();
    op.call(ctx, input)
}

/// CollectiveBcastSendV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastSendV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveBcastSendV2 {
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveBcastSendV2 {
    fn default() -> Self {
        Self {
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveBcastSendV2 {
    /// Creates a new `CollectiveBcastSendV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_bcast_send_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        group_size: &T1,
        group_key: &T2,
        instance_key: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveBcastSendV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&group_size.to_handle(ctx)?)?;
        op.add_input(&group_key.to_handle(ctx)?)?;
        op.add_input(&instance_key.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveBcastSendV2::new().call(&ctx, &input, &group_size, &group_key, &instance_key)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveBcastSendV2>
pub fn collective_bcast_send_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    group_size: &T1,
    group_key: &T2,
    instance_key: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveBcastSendV2::new();
    op.call(ctx, input, group_size, group_key, instance_key)
}

/// CollectiveGather
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveGather>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveGather {
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    shape: ::std::option::Option<crate::Shape>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveGather {
    fn default() -> Self {
        Self {
            group_size: None,
            group_key: None,
            instance_key: None,
            shape: None,
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveGather {
    /// Creates a new `CollectiveGather`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_gather.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveGather")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.group_size {
            op.set_attr_int("group_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.group_key {
            op.set_attr_int("group_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.instance_key {
            op.set_attr_int("instance_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shape {
            op.set_attr_shape("shape", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveGather::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveGather>
pub fn collective_gather<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveGather::new();
    op.call(ctx, input)
}

/// CollectiveGatherV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveGatherV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveGatherV2 {
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveGatherV2 {
    fn default() -> Self {
        Self {
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveGatherV2 {
    /// Creates a new `CollectiveGatherV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_gather_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        group_size: &T1,
        group_key: &T2,
        instance_key: &T3,
        ordering_token: &[&T4],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveGatherV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&group_size.to_handle(ctx)?)?;
        op.add_input(&group_key.to_handle(ctx)?)?;
        op.add_input(&instance_key.to_handle(ctx)?)?;
        let mut ordering_token_list = Vec::new();

        for t in ordering_token {
            ordering_token_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&ordering_token_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveGatherV2::new().call(&ctx, &input, &group_size, &group_key, &instance_key, &ordering_token)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveGatherV2>
pub fn collective_gather_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    group_size: &T1,
    group_key: &T2,
    instance_key: &T3,
    ordering_token: &[&T4],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveGatherV2::new();
    op.call(
        ctx,
        input,
        group_size,
        group_key,
        instance_key,
        ordering_token,
    )
}

/// CollectiveInitializeCommunicator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveInitializeCommunicator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveInitializeCommunicator {
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveInitializeCommunicator {
    fn default() -> Self {
        Self {
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveInitializeCommunicator {
    /// Creates a new `CollectiveInitializeCommunicator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_initialize_communicator.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        group_key: &T0,
        rank: &T1,
        group_size: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveInitializeCommunicator")?;

        // Required input arguments
        op.add_input(&group_key.to_handle(ctx)?)?;
        op.add_input(&rank.to_handle(ctx)?)?;
        op.add_input(&group_size.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveInitializeCommunicator::new().call(&ctx, &group_key, &rank, &group_size)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveInitializeCommunicator>
pub fn collective_initialize_communicator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    group_key: &T0,
    rank: &T1,
    group_size: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveInitializeCommunicator::new();
    op.call(ctx, group_key, rank, group_size)
}

/// CollectivePermute
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectivePermute>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectivePermute {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectivePermute {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CollectivePermute {
    /// Creates a new `CollectivePermute`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_permute.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        source_target_pairs: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectivePermute")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&source_target_pairs.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectivePermute::new().call(&ctx, &input, &source_target_pairs)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectivePermute>
pub fn collective_permute<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    source_target_pairs: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectivePermute::new();
    op.call(ctx, input, source_target_pairs)
}

/// CollectiveReduce
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduce>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveReduce {
    group_size: ::std::option::Option<i64>,
    group_key: ::std::option::Option<i64>,
    instance_key: ::std::option::Option<i64>,
    merge_op: ::std::option::Option<::std::string::String>,
    final_op: ::std::option::Option<::std::string::String>,
    subdiv_offsets: ::std::option::Option<::std::vec::Vec<i64>>,
    wait_for: ::std::option::Option<::std::vec::Vec<i64>>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveReduce {
    fn default() -> Self {
        Self {
            group_size: None,
            group_key: None,
            instance_key: None,
            merge_op: None,
            final_op: None,
            subdiv_offsets: None,
            wait_for: Some(vec![]),
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveReduce {
    /// Creates a new `CollectiveReduce`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `group_size` attribute.
    pub fn group_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `group_key` attribute.
    pub fn group_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.group_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `instance_key` attribute.
    pub fn instance_key<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.instance_key = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `merge_op` attribute.
    pub fn merge_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.merge_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `final_op` attribute.
    pub fn final_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.final_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `subdiv_offsets` attribute.
    pub fn subdiv_offsets<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.subdiv_offsets = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `wait_for` attribute.
    pub fn wait_for<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.wait_for = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_reduce.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveReduce")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.group_size {
            op.set_attr_int("group_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.group_key {
            op.set_attr_int("group_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.instance_key {
            op.set_attr_int("instance_key", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.merge_op {
            op.set_attr_string("merge_op", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.final_op {
            op.set_attr_string("final_op", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.subdiv_offsets {
            op.set_attr_int_list("subdiv_offsets", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.wait_for {
            op.set_attr_int_list("wait_for", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveReduce::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduce>
pub fn collective_reduce<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveReduce::new();
    op.call(ctx, input)
}

/// CollectiveReduceV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduceV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveReduceV2 {
    merge_op: ::std::option::Option<::std::string::String>,
    final_op: ::std::option::Option<::std::string::String>,
    communication_hint: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    max_subdivs_per_device: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveReduceV2 {
    fn default() -> Self {
        Self {
            merge_op: None,
            final_op: None,
            communication_hint: Some(::std::string::String::from("auto")),
            timeout_seconds: Some(0f32),
            max_subdivs_per_device: Some(-1i64),
            target_device_name: None,
        }
    }
}
impl CollectiveReduceV2 {
    /// Creates a new `CollectiveReduceV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `merge_op` attribute.
    pub fn merge_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.merge_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `final_op` attribute.
    pub fn final_op<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.final_op = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `communication_hint` attribute.
    pub fn communication_hint<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.communication_hint = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `max_subdivs_per_device` attribute.
    pub fn max_subdivs_per_device<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.max_subdivs_per_device = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_reduce_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        group_size: &T1,
        group_key: &T2,
        instance_key: &T3,
        ordering_token: &[&T4],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveReduceV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&group_size.to_handle(ctx)?)?;
        op.add_input(&group_key.to_handle(ctx)?)?;
        op.add_input(&instance_key.to_handle(ctx)?)?;
        let mut ordering_token_list = Vec::new();

        for t in ordering_token {
            ordering_token_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&ordering_token_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.merge_op {
            op.set_attr_string("merge_op", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.final_op {
            op.set_attr_string("final_op", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.communication_hint {
            op.set_attr_string("communication_hint", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.max_subdivs_per_device {
            op.set_attr_int("max_subdivs_per_device", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveReduceV2::new().call(&ctx, &input, &group_size, &group_key, &instance_key, &ordering_token)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduceV2>
pub fn collective_reduce_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    group_size: &T1,
    group_key: &T2,
    instance_key: &T3,
    ordering_token: &[&T4],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveReduceV2::new();
    op.call(
        ctx,
        input,
        group_size,
        group_key,
        instance_key,
        ordering_token,
    )
}

/// CollectiveReduceV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduceV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CollectiveReduceV3 {
    reduction: ::std::option::Option<::std::string::String>,
    timeout_seconds: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CollectiveReduceV3 {
    fn default() -> Self {
        Self {
            reduction: None,
            timeout_seconds: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CollectiveReduceV3 {
    /// Creates a new `CollectiveReduceV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `reduction` attribute.
    pub fn reduction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.reduction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `timeout_seconds` attribute.
    pub fn timeout_seconds<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.timeout_seconds = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute collective_reduce_v3.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        communicator: &T1,
        group_assignment: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CollectiveReduceV3")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&communicator.to_handle(ctx)?)?;
        op.add_input(&group_assignment.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.reduction {
            op.set_attr_string("reduction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.timeout_seconds {
            op.set_attr_float("timeout_seconds", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CollectiveReduceV3::new().call(&ctx, &input, &communicator, &group_assignment)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CollectiveReduceV3>
pub fn collective_reduce_v3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    communicator: &T1,
    group_assignment: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CollectiveReduceV3::new();
    op.call(ctx, input, communicator, group_assignment)
}

/// CombinedNonMaxSuppression
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CombinedNonMaxSuppression>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CombinedNonMaxSuppression {
    pad_per_class: ::std::option::Option<bool>,
    clip_boxes: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CombinedNonMaxSuppression {
    fn default() -> Self {
        Self {
            pad_per_class: Some(false),
            clip_boxes: Some(true),
            target_device_name: None,
        }
    }
}
impl CombinedNonMaxSuppression {
    /// Creates a new `CombinedNonMaxSuppression`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `pad_per_class` attribute.
    pub fn pad_per_class<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.pad_per_class = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `clip_boxes` attribute.
    pub fn clip_boxes<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.clip_boxes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute combined_non_max_suppression.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        boxes: &T0,
        scores: &T1,
        max_output_size_per_class: &T2,
        max_total_size: &T3,
        iou_threshold: &T4,
        score_threshold: &T5,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CombinedNonMaxSuppression")?;

        // Required input arguments
        op.add_input(&boxes.to_handle(ctx)?)?;
        op.add_input(&scores.to_handle(ctx)?)?;
        op.add_input(&max_output_size_per_class.to_handle(ctx)?)?;
        op.add_input(&max_total_size.to_handle(ctx)?)?;
        op.add_input(&iou_threshold.to_handle(ctx)?)?;
        op.add_input(&score_threshold.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.pad_per_class {
            op.set_attr_bool("pad_per_class", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.clip_boxes {
            op.set_attr_bool("clip_boxes", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CombinedNonMaxSuppression::new().call(&ctx, &boxes, &scores, &max_output_size_per_class, &max_total_size, &iou_threshold, &score_threshold)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CombinedNonMaxSuppression>
pub fn combined_non_max_suppression<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    boxes: &T0,
    scores: &T1,
    max_output_size_per_class: &T2,
    max_total_size: &T3,
    iou_threshold: &T4,
    score_threshold: &T5,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CombinedNonMaxSuppression::new();
    op.call(
        ctx,
        boxes,
        scores,
        max_output_size_per_class,
        max_total_size,
        iou_threshold,
        score_threshold,
    )
}

/// Complex
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Complex>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Complex {
    Tout: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Complex {
    fn default() -> Self {
        Self {
            Tout: Some(crate::DataType::Complex64),
            target_device_name: None,
        }
    }
}
impl Complex {
    /// Creates a new `Complex`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute complex.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        real: &T0,
        imag: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Complex")?;

        // Required input arguments
        op.add_input(&real.to_handle(ctx)?)?;
        op.add_input(&imag.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type("Tout", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Complex::new().call(&ctx, &real, &imag)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Complex>
pub fn complex<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    real: &T0,
    imag: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Complex::new();
    op.call(ctx, real, imag)
}

/// ComplexAbs
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComplexAbs>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ComplexAbs {
    Tout: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ComplexAbs {
    fn default() -> Self {
        Self {
            Tout: Some(crate::DataType::Float),
            target_device_name: None,
        }
    }
}
impl ComplexAbs {
    /// Creates a new `ComplexAbs`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `Tout` attribute.
    pub fn Tout<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.Tout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute complex_abs.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ComplexAbs")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.Tout {
            op.set_attr_type("Tout", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ComplexAbs::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComplexAbs>
pub fn complex_abs<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ComplexAbs::new();
    op.call(ctx, x)
}

/// CompositeTensorVariantFromComponents
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompositeTensorVariantFromComponents>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CompositeTensorVariantFromComponents {
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CompositeTensorVariantFromComponents {
    fn default() -> Self {
        Self {
            metadata: None,
            target_device_name: None,
        }
    }
}
impl CompositeTensorVariantFromComponents {
    /// Creates a new `CompositeTensorVariantFromComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute composite_tensor_variant_from_components.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        components: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CompositeTensorVariantFromComponents")?;

        // Required input arguments
        op.add_input(&components.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CompositeTensorVariantFromComponents::new().call(&ctx, &components)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompositeTensorVariantFromComponents>
pub fn composite_tensor_variant_from_components<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    components: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CompositeTensorVariantFromComponents::new();
    op.call(ctx, components)
}

/// CompositeTensorVariantToComponents
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompositeTensorVariantToComponents>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CompositeTensorVariantToComponents {
    metadata: ::std::option::Option<::std::string::String>,
    Tcomponents: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CompositeTensorVariantToComponents {
    fn default() -> Self {
        Self {
            metadata: None,
            Tcomponents: None,
            target_device_name: None,
        }
    }
}
impl CompositeTensorVariantToComponents {
    /// Creates a new `CompositeTensorVariantToComponents`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `Tcomponents` attribute.
    pub fn Tcomponents<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.Tcomponents = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute composite_tensor_variant_to_components.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        encoded: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CompositeTensorVariantToComponents")?;

        // Required input arguments
        op.add_input(&encoded.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.Tcomponents {
            op.set_attr_type_list("Tcomponents", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CompositeTensorVariantToComponents::new().call(&ctx, &encoded)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompositeTensorVariantToComponents>
pub fn composite_tensor_variant_to_components<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    encoded: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CompositeTensorVariantToComponents::new();
    op.call(ctx, encoded)
}

/// CompressElement
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompressElement>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CompressElement {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CompressElement {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CompressElement {
    /// Creates a new `CompressElement`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute compress_element.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        components: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CompressElement")?;

        // Required input arguments
        op.add_input(&components.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CompressElement::new().call(&ctx, &components)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CompressElement>
pub fn compress_element<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    components: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CompressElement::new();
    op.call(ctx, components)
}

/// ComputeAccidentalHits
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComputeAccidentalHits>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ComputeAccidentalHits {
    num_true: ::std::option::Option<i64>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ComputeAccidentalHits {
    fn default() -> Self {
        Self {
            num_true: None,
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl ComputeAccidentalHits {
    /// Creates a new `ComputeAccidentalHits`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_true` attribute.
    pub fn num_true<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_true = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute compute_accidental_hits.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        true_classes: &T0,
        sampled_candidates: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "ComputeAccidentalHits")?;

        // Required input arguments
        op.add_input(&true_classes.to_handle(ctx)?)?;
        op.add_input(&sampled_candidates.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_true {
            op.set_attr_int("num_true", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `ComputeAccidentalHits::new().call(&ctx, &true_classes, &sampled_candidates)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComputeAccidentalHits>
pub fn compute_accidental_hits<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    true_classes: &T0,
    sampled_candidates: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = ComputeAccidentalHits::new();
    op.call(ctx, true_classes, sampled_candidates)
}

/// ComputeBatchSize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComputeBatchSize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ComputeBatchSize {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ComputeBatchSize {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ComputeBatchSize {
    /// Creates a new `ComputeBatchSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute compute_batch_size.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ComputeBatchSize")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ComputeBatchSize::new().call(&ctx, &input_dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ComputeBatchSize>
pub fn compute_batch_size<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ComputeBatchSize::new();
    op.call(ctx, input_dataset)
}

/// Concat
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Concat>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Concat {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Concat {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Concat {
    /// Creates a new `Concat`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute concat.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        concat_dim: &T0,
        values: &[&T1],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Concat")?;

        // Required input arguments
        op.add_input(&concat_dim.to_handle(ctx)?)?;
        let mut values_list = Vec::new();

        for t in values {
            values_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&values_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Concat::new().call(&ctx, &concat_dim, &values)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Concat>
pub fn concat<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    concat_dim: &T0,
    values: &[&T1],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Concat::new();
    op.call(ctx, concat_dim, values)
}

/// ConcatOffset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatOffset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConcatOffset {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConcatOffset {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ConcatOffset {
    /// Creates a new `ConcatOffset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute concat_offset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        concat_dim: &T0,
        shape: &[&T1],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConcatOffset")?;

        // Required input arguments
        op.add_input(&concat_dim.to_handle(ctx)?)?;
        let mut shape_list = Vec::new();

        for t in shape {
            shape_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&shape_list)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConcatOffset::new().call(&ctx, &concat_dim, &shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatOffset>
pub fn concat_offset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    concat_dim: &T0,
    shape: &[&T1],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConcatOffset::new();
    op.call(ctx, concat_dim, shape)
}

/// ConcatV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConcatV2 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConcatV2 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ConcatV2 {
    /// Creates a new `ConcatV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute concat_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        values: &[&T0],
        axis: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConcatV2")?;

        // Required input arguments
        let mut values_list = Vec::new();

        for t in values {
            values_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&values_list)?;
        op.add_input(&axis.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConcatV2::new().call(&ctx, &values, &axis)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatV2>
pub fn concat_v2<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    values: &[&T0],
    axis: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConcatV2::new();
    op.call(ctx, values, axis)
}

/// ConcatenateDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatenateDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConcatenateDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConcatenateDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl ConcatenateDataset {
    /// Creates a new `ConcatenateDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute concatenate_dataset.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        another_dataset: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConcatenateDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&another_dataset.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConcatenateDataset::new().call(&ctx, &input_dataset, &another_dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConcatenateDataset>
pub fn concatenate_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    another_dataset: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConcatenateDataset::new();
    op.call(ctx, input_dataset, another_dataset)
}

/// ConditionalAccumulator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConditionalAccumulator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConditionalAccumulator {
    dtype: ::std::option::Option<crate::DataType>,
    shape: ::std::option::Option<crate::Shape>,
    container: ::std::option::Option<::std::string::String>,
    shared_name: ::std::option::Option<::std::string::String>,
    reduction_type: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConditionalAccumulator {
    fn default() -> Self {
        Self {
            dtype: None,
            shape: None,
            container: None,
            shared_name: None,
            reduction_type: Some(::std::string::String::from("MEAN")),
            target_device_name: None,
        }
    }
}
impl ConditionalAccumulator {
    /// Creates a new `ConditionalAccumulator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shape` attribute.
    pub fn shape<ArgType: ::std::convert::Into<crate::Shape>>(mut self, value: ArgType) -> Self {
        self.shape = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `container` attribute.
    pub fn container<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.container = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `shared_name` attribute.
    pub fn shared_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.shared_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reduction_type` attribute.
    pub fn reduction_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.reduction_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conditional_accumulator.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConditionalAccumulator")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.dtype {
            op.set_attr_type("dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shape {
            op.set_attr_shape("shape", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.container {
            op.set_attr_string("container", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.shared_name {
            op.set_attr_string("shared_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.reduction_type {
            op.set_attr_string("reduction_type", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConditionalAccumulator::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConditionalAccumulator>
pub fn conditional_accumulator<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConditionalAccumulator::new();
    op.call(ctx)
}

/// ConfigureDistributedTPU
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConfigureDistributedTPU>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConfigureDistributedTPU {
    embedding_config: ::std::option::Option<::std::string::String>,
    tpu_embedding_config: ::std::option::Option<::std::string::String>,
    is_global_init: ::std::option::Option<bool>,
    enable_whole_mesh_compilations: ::std::option::Option<bool>,
    compilation_failure_closes_chips: ::std::option::Option<bool>,
    tpu_cancellation_closes_chips: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConfigureDistributedTPU {
    fn default() -> Self {
        Self {
            embedding_config: None,
            tpu_embedding_config: None,
            is_global_init: Some(false),
            enable_whole_mesh_compilations: Some(false),
            compilation_failure_closes_chips: Some(true),
            tpu_cancellation_closes_chips: Some(0i64),
            target_device_name: None,
        }
    }
}
impl ConfigureDistributedTPU {
    /// Creates a new `ConfigureDistributedTPU`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `embedding_config` attribute.
    pub fn embedding_config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.embedding_config = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tpu_embedding_config` attribute.
    pub fn tpu_embedding_config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tpu_embedding_config = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_global_init` attribute.
    pub fn is_global_init<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_global_init = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `enable_whole_mesh_compilations` attribute.
    pub fn enable_whole_mesh_compilations<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.enable_whole_mesh_compilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `compilation_failure_closes_chips` attribute.
    pub fn compilation_failure_closes_chips<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.compilation_failure_closes_chips = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tpu_cancellation_closes_chips` attribute.
    pub fn tpu_cancellation_closes_chips<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tpu_cancellation_closes_chips = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute configure_distributed_tpu.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConfigureDistributedTPU")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.embedding_config {
            op.set_attr_string("embedding_config", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tpu_embedding_config {
            op.set_attr_string("tpu_embedding_config", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.is_global_init {
            op.set_attr_bool("is_global_init", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.enable_whole_mesh_compilations {
            op.set_attr_bool("enable_whole_mesh_compilations", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.compilation_failure_closes_chips {
            op.set_attr_bool("compilation_failure_closes_chips", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tpu_cancellation_closes_chips {
            op.set_attr_int("tpu_cancellation_closes_chips", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConfigureDistributedTPU::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConfigureDistributedTPU>
pub fn configure_distributed_tpu<'a>(
    ctx: &'a crate::eager::Context,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConfigureDistributedTPU::new();
    op.call(ctx)
}

/// ConfigureTPUEmbedding
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConfigureTPUEmbedding>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConfigureTPUEmbedding {
    config: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConfigureTPUEmbedding {
    fn default() -> Self {
        Self {
            config: None,
            target_device_name: None,
        }
    }
}
impl ConfigureTPUEmbedding {
    /// Creates a new `ConfigureTPUEmbedding`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `config` attribute.
    pub fn config<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.config = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute configure_tpuembedding.
    pub fn call<'a>(&self, ctx: &'a crate::eager::Context) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConfigureTPUEmbedding")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.config {
            op.set_attr_string("config", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `ConfigureTPUEmbedding::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConfigureTPUEmbedding>
pub fn configure_tpuembedding<'a>(ctx: &'a crate::eager::Context) -> crate::Result<()> {
    let op = ConfigureTPUEmbedding::new();
    op.call(ctx)
}

/// Conj
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conj>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conj {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conj {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Conj {
    /// Creates a new `Conj`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conj.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conj")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conj::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conj>
pub fn conj<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conj::new();
    op.call(ctx, input)
}

/// ConjugateTranspose
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConjugateTranspose>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConjugateTranspose {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConjugateTranspose {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ConjugateTranspose {
    /// Creates a new `ConjugateTranspose`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conjugate_transpose.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        perm: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConjugateTranspose")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&perm.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `ConjugateTranspose::new().call(&ctx, &x, &perm)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConjugateTranspose>
pub fn conjugate_transpose<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    perm: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = ConjugateTranspose::new();
    op.call(ctx, x, perm)
}

/// Const
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Const>
#[derive(::std::fmt::Debug)]
pub struct Const {
    value: ::std::option::Option<::std::boxed::Box<dyn crate::AnyTensor>>,
    dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Const {
    fn default() -> Self {
        Self {
            value: None,
            dtype: None,
            target_device_name: None,
        }
    }
}
impl Const {
    /// Creates a new `Const`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `value` attribute.
    pub fn value<T: crate::TensorType, ArgType: ::std::convert::Into<crate::Tensor<T>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.value = ::std::option::Option::Some(
            ::std::boxed::Box::new(value.into()) as ::std::boxed::Box<dyn crate::AnyTensor>
        );
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute const_.
    pub fn call<'a>(
        &self,
        ctx: &'a crate::eager::Context,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Const")?;

        // Required input arguments

        // Attributes
        if let ::std::option::Option::Some(value) = &self.value {
            op.set_attr_any_tensor("value", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dtype {
            op.set_attr_type("dtype", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Const::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Const>
pub fn const_<'a>(ctx: &'a crate::eager::Context) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Const::new();
    op.call(ctx)
}

/// ConsumeMutexLock
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConsumeMutexLock>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ConsumeMutexLock {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ConsumeMutexLock {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ConsumeMutexLock {
    /// Creates a new `ConsumeMutexLock`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute consume_mutex_lock.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        mutex_lock: &T0,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "ConsumeMutexLock")?;

        // Required input arguments
        op.add_input(&mutex_lock.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `ConsumeMutexLock::new().call(&ctx, &mutex_lock)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ConsumeMutexLock>
pub fn consume_mutex_lock<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    mutex_lock: &T0,
) -> crate::Result<()> {
    let op = ConsumeMutexLock::new();
    op.call(ctx, mutex_lock)
}

/// ControlTrigger
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ControlTrigger>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct ControlTrigger {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for ControlTrigger {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl ControlTrigger {
    /// Creates a new `ControlTrigger`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute control_trigger.
    pub fn call<'a>(&self, ctx: &'a crate::eager::Context) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "ControlTrigger")?;

        // Required input arguments

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `ControlTrigger::new().call(&ctx)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/ControlTrigger>
pub fn control_trigger<'a>(ctx: &'a crate::eager::Context) -> crate::Result<()> {
    let op = ControlTrigger::new();
    op.call(ctx)
}

/// Conv2D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv2D {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv2D {
    fn default() -> Self {
        Self {
            strides: None,
            use_cudnn_on_gpu: Some(true),
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv2D {
    /// Creates a new `Conv2D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv2_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv2D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
            op.set_attr_bool("use_cudnn_on_gpu", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv2D::new().call(&ctx, &input, &filter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2D>
pub fn conv2_d<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv2D::new();
    op.call(ctx, input, filter)
}

/// Conv2DBackpropFilter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2DBackpropFilter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv2DBackpropFilter {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv2DBackpropFilter {
    fn default() -> Self {
        Self {
            strides: None,
            use_cudnn_on_gpu: Some(true),
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv2DBackpropFilter {
    /// Creates a new `Conv2DBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv2_dbackprop_filter.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter_sizes: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv2DBackpropFilter")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter_sizes.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
            op.set_attr_bool("use_cudnn_on_gpu", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv2DBackpropFilter::new().call(&ctx, &input, &filter_sizes, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2DBackpropFilter>
pub fn conv2_dbackprop_filter<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter_sizes: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv2DBackpropFilter::new();
    op.call(ctx, input, filter_sizes, out_backprop)
}

/// Conv2DBackpropInput
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2DBackpropInput>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv2DBackpropInput {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    use_cudnn_on_gpu: ::std::option::Option<bool>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv2DBackpropInput {
    fn default() -> Self {
        Self {
            strides: None,
            use_cudnn_on_gpu: Some(true),
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv2DBackpropInput {
    /// Creates a new `Conv2DBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_cudnn_on_gpu` attribute.
    pub fn use_cudnn_on_gpu<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_cudnn_on_gpu = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv2_dbackprop_input.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_sizes: &T0,
        filter: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv2DBackpropInput")?;

        // Required input arguments
        op.add_input(&input_sizes.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_cudnn_on_gpu {
            op.set_attr_bool("use_cudnn_on_gpu", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv2DBackpropInput::new().call(&ctx, &input_sizes, &filter, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv2DBackpropInput>
pub fn conv2_dbackprop_input<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_sizes: &T0,
    filter: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv2DBackpropInput::new();
    op.call(ctx, input_sizes, filter, out_backprop)
}

/// Conv3D
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3D>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv3D {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv3D {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NDHWC")),
            dilations: Some(vec![1, 1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv3D {
    /// Creates a new `Conv3D`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv3_d.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv3D")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv3D::new().call(&ctx, &input, &filter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3D>
pub fn conv3_d<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv3D::new();
    op.call(ctx, input, filter)
}

/// Conv3DBackpropFilter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropFilter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv3DBackpropFilter {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv3DBackpropFilter {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            dilations: Some(vec![1, 1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv3DBackpropFilter {
    /// Creates a new `Conv3DBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv3_dbackprop_filter.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv3DBackpropFilter")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv3DBackpropFilter::new().call(&ctx, &input, &filter, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropFilter>
pub fn conv3_dbackprop_filter<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv3DBackpropFilter::new();
    op.call(ctx, input, filter, out_backprop)
}

/// Conv3DBackpropFilterV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropFilterV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv3DBackpropFilterV2 {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv3DBackpropFilterV2 {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NDHWC")),
            dilations: Some(vec![1, 1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv3DBackpropFilterV2 {
    /// Creates a new `Conv3DBackpropFilterV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv3_dbackprop_filter_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter_sizes: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv3DBackpropFilterV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter_sizes.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv3DBackpropFilterV2::new().call(&ctx, &input, &filter_sizes, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropFilterV2>
pub fn conv3_dbackprop_filter_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter_sizes: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv3DBackpropFilterV2::new();
    op.call(ctx, input, filter_sizes, out_backprop)
}

/// Conv3DBackpropInput
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropInput>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv3DBackpropInput {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv3DBackpropInput {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            dilations: Some(vec![1, 1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv3DBackpropInput {
    /// Creates a new `Conv3DBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv3_dbackprop_input.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv3DBackpropInput")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv3DBackpropInput::new().call(&ctx, &input, &filter, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropInput>
pub fn conv3_dbackprop_input<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv3DBackpropInput::new();
    op.call(ctx, input, filter, out_backprop)
}

/// Conv3DBackpropInputV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropInputV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Conv3DBackpropInputV2 {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Conv3DBackpropInputV2 {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            data_format: Some(::std::string::String::from("NDHWC")),
            dilations: Some(vec![1, 1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl Conv3DBackpropInputV2 {
    /// Creates a new `Conv3DBackpropInputV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute conv3_dbackprop_input_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_sizes: &T0,
        filter: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Conv3DBackpropInputV2")?;

        // Required input arguments
        op.add_input(&input_sizes.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Conv3DBackpropInputV2::new().call(&ctx, &input_sizes, &filter, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Conv3DBackpropInputV2>
pub fn conv3_dbackprop_input_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_sizes: &T0,
    filter: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Conv3DBackpropInputV2::new();
    op.call(ctx, input_sizes, filter, out_backprop)
}

/// Copy
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Copy>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Copy {
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_ops_spec: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Copy {
    fn default() -> Self {
        Self {
            tensor_name: None,
            debug_ops_spec: Some(vec![]),
            target_device_name: None,
        }
    }
}
impl Copy {
    /// Creates a new `Copy`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_ops_spec` attribute.
    pub fn debug_ops_spec<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_ops_spec = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute copy.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Copy")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.tensor_name {
            op.set_attr_string("tensor_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_ops_spec {
            op.set_attr_string_list("debug_ops_spec", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Copy::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Copy>
pub fn copy<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Copy::new();
    op.call(ctx, input)
}

/// CopyHost
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CopyHost>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CopyHost {
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_ops_spec: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CopyHost {
    fn default() -> Self {
        Self {
            tensor_name: None,
            debug_ops_spec: Some(vec![]),
            target_device_name: None,
        }
    }
}
impl CopyHost {
    /// Creates a new `CopyHost`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_ops_spec` attribute.
    pub fn debug_ops_spec<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_ops_spec = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute copy_host.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CopyHost")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.tensor_name {
            op.set_attr_string("tensor_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_ops_spec {
            op.set_attr_string_list("debug_ops_spec", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CopyHost::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CopyHost>
pub fn copy_host<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CopyHost::new();
    op.call(ctx, input)
}

/// Cos
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cos>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cos {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cos {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Cos {
    /// Creates a new `Cos`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cos.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cos")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cos::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cos>
pub fn cos<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cos::new();
    op.call(ctx, x)
}

/// Cosh
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cosh>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cosh {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cosh {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Cosh {
    /// Creates a new `Cosh`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cosh.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cosh")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cosh::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cosh>
pub fn cosh<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cosh::new();
    op.call(ctx, x)
}

/// CountUpTo
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CountUpTo>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CountUpTo {
    limit: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CountUpTo {
    fn default() -> Self {
        Self {
            limit: None,
            target_device_name: None,
        }
    }
}
impl CountUpTo {
    /// Creates a new `CountUpTo`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `limit` attribute.
    pub fn limit<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.limit = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute count_up_to.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        ref_: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CountUpTo")?;

        // Required input arguments
        op.add_input(&ref_.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.limit {
            op.set_attr_int("limit", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CountUpTo::new().call(&ctx, &ref_)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CountUpTo>
pub fn count_up_to<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    ref_: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CountUpTo::new();
    op.call(ctx, ref_)
}

/// CreateSummaryDbWriter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CreateSummaryDbWriter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CreateSummaryDbWriter {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CreateSummaryDbWriter {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CreateSummaryDbWriter {
    /// Creates a new `CreateSummaryDbWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute create_summary_db_writer.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        writer: &T0,
        db_uri: &T1,
        experiment_name: &T2,
        run_name: &T3,
        user_name: &T4,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "CreateSummaryDbWriter")?;

        // Required input arguments
        op.add_input(&writer.to_handle(ctx)?)?;
        op.add_input(&db_uri.to_handle(ctx)?)?;
        op.add_input(&experiment_name.to_handle(ctx)?)?;
        op.add_input(&run_name.to_handle(ctx)?)?;
        op.add_input(&user_name.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `CreateSummaryDbWriter::new().call(&ctx, &writer, &db_uri, &experiment_name, &run_name, &user_name)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CreateSummaryDbWriter>
pub fn create_summary_db_writer<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    writer: &T0,
    db_uri: &T1,
    experiment_name: &T2,
    run_name: &T3,
    user_name: &T4,
) -> crate::Result<()> {
    let op = CreateSummaryDbWriter::new();
    op.call(ctx, writer, db_uri, experiment_name, run_name, user_name)
}

/// CreateSummaryFileWriter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CreateSummaryFileWriter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CreateSummaryFileWriter {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CreateSummaryFileWriter {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CreateSummaryFileWriter {
    /// Creates a new `CreateSummaryFileWriter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute create_summary_file_writer.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        writer: &T0,
        logdir: &T1,
        max_queue: &T2,
        flush_millis: &T3,
        filename_suffix: &T4,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "CreateSummaryFileWriter")?;

        // Required input arguments
        op.add_input(&writer.to_handle(ctx)?)?;
        op.add_input(&logdir.to_handle(ctx)?)?;
        op.add_input(&max_queue.to_handle(ctx)?)?;
        op.add_input(&flush_millis.to_handle(ctx)?)?;
        op.add_input(&filename_suffix.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `CreateSummaryFileWriter::new().call(&ctx, &writer, &logdir, &max_queue, &flush_millis, &filename_suffix)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CreateSummaryFileWriter>
pub fn create_summary_file_writer<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    writer: &T0,
    logdir: &T1,
    max_queue: &T2,
    flush_millis: &T3,
    filename_suffix: &T4,
) -> crate::Result<()> {
    let op = CreateSummaryFileWriter::new();
    op.call(
        ctx,
        writer,
        logdir,
        max_queue,
        flush_millis,
        filename_suffix,
    )
}

/// CropAndResize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CropAndResize {
    method: ::std::option::Option<::std::string::String>,
    extrapolation_value: ::std::option::Option<f32>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CropAndResize {
    fn default() -> Self {
        Self {
            method: Some(::std::string::String::from("bilinear")),
            extrapolation_value: Some(0f32),
            target_device_name: None,
        }
    }
}
impl CropAndResize {
    /// Creates a new `CropAndResize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `extrapolation_value` attribute.
    pub fn extrapolation_value<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.extrapolation_value = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute crop_and_resize.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        image: &T0,
        boxes: &T1,
        box_ind: &T2,
        crop_size: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CropAndResize")?;

        // Required input arguments
        op.add_input(&image.to_handle(ctx)?)?;
        op.add_input(&boxes.to_handle(ctx)?)?;
        op.add_input(&box_ind.to_handle(ctx)?)?;
        op.add_input(&crop_size.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.method {
            op.set_attr_string("method", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.extrapolation_value {
            op.set_attr_float("extrapolation_value", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CropAndResize::new().call(&ctx, &image, &boxes, &box_ind, &crop_size)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResize>
pub fn crop_and_resize<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    image: &T0,
    boxes: &T1,
    box_ind: &T2,
    crop_size: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CropAndResize::new();
    op.call(ctx, image, boxes, box_ind, crop_size)
}

/// CropAndResizeGradBoxes
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResizeGradBoxes>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CropAndResizeGradBoxes {
    method: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CropAndResizeGradBoxes {
    fn default() -> Self {
        Self {
            method: Some(::std::string::String::from("bilinear")),
            target_device_name: None,
        }
    }
}
impl CropAndResizeGradBoxes {
    /// Creates a new `CropAndResizeGradBoxes`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute crop_and_resize_grad_boxes.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        grads: &T0,
        image: &T1,
        boxes: &T2,
        box_ind: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CropAndResizeGradBoxes")?;

        // Required input arguments
        op.add_input(&grads.to_handle(ctx)?)?;
        op.add_input(&image.to_handle(ctx)?)?;
        op.add_input(&boxes.to_handle(ctx)?)?;
        op.add_input(&box_ind.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.method {
            op.set_attr_string("method", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CropAndResizeGradBoxes::new().call(&ctx, &grads, &image, &boxes, &box_ind)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResizeGradBoxes>
pub fn crop_and_resize_grad_boxes<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    grads: &T0,
    image: &T1,
    boxes: &T2,
    box_ind: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CropAndResizeGradBoxes::new();
    op.call(ctx, grads, image, boxes, box_ind)
}

/// CropAndResizeGradImage
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResizeGradImage>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CropAndResizeGradImage {
    T: ::std::option::Option<crate::DataType>,
    method: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CropAndResizeGradImage {
    fn default() -> Self {
        Self {
            T: None,
            method: Some(::std::string::String::from("bilinear")),
            target_device_name: None,
        }
    }
}
impl CropAndResizeGradImage {
    /// Creates a new `CropAndResizeGradImage`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `method` attribute.
    pub fn method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute crop_and_resize_grad_image.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        grads: &T0,
        boxes: &T1,
        box_ind: &T2,
        image_size: &T3,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CropAndResizeGradImage")?;

        // Required input arguments
        op.add_input(&grads.to_handle(ctx)?)?;
        op.add_input(&boxes.to_handle(ctx)?)?;
        op.add_input(&box_ind.to_handle(ctx)?)?;
        op.add_input(&image_size.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.T {
            op.set_attr_type("T", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.method {
            op.set_attr_string("method", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CropAndResizeGradImage::new().call(&ctx, &grads, &boxes, &box_ind, &image_size)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CropAndResizeGradImage>
pub fn crop_and_resize_grad_image<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    grads: &T0,
    boxes: &T1,
    box_ind: &T2,
    image_size: &T3,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CropAndResizeGradImage::new();
    op.call(ctx, grads, boxes, box_ind, image_size)
}

/// Cross
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cross>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cross {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cross {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Cross {
    /// Creates a new `Cross`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cross.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        a: &T0,
        b: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cross")?;

        // Required input arguments
        op.add_input(&a.to_handle(ctx)?)?;
        op.add_input(&b.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cross::new().call(&ctx, &a, &b)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cross>
pub fn cross<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    a: &T0,
    b: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cross::new();
    op.call(ctx, a, b)
}

/// CrossReplicaSum
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CrossReplicaSum>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CrossReplicaSum {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CrossReplicaSum {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl CrossReplicaSum {
    /// Creates a new `CrossReplicaSum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cross_replica_sum.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        group_assignment: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CrossReplicaSum")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&group_assignment.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CrossReplicaSum::new().call(&ctx, &input, &group_assignment)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CrossReplicaSum>
pub fn cross_replica_sum<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    group_assignment: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CrossReplicaSum::new();
    op.call(ctx, input, group_assignment)
}

/// CudnnRNN
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNN>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNN {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNN {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            is_training: Some(true),
            target_device_name: None,
        }
    }
}
impl CudnnRNN {
    /// Creates a new `CudnnRNN`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnn.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNN")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.is_training {
            op.set_attr_bool("is_training", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNN::new().call(&ctx, &input, &input_h, &input_c, &params)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNN>
pub fn cudnn_rnn<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CudnnRNN::new();
    op.call(ctx, input, input_h, input_c, params)
}

/// CudnnRNNBackprop
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackprop>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNBackprop {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNBackprop {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNBackprop {
    /// Creates a new `CudnnRNNBackprop`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnbackprop.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
        output: &T4,
        output_h: &T5,
        output_c: &T6,
        output_backprop: &T7,
        output_h_backprop: &T8,
        output_c_backprop: &T9,
        reserve_space: &T10,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNBackprop")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;
        op.add_input(&output.to_handle(ctx)?)?;
        op.add_input(&output_h.to_handle(ctx)?)?;
        op.add_input(&output_c.to_handle(ctx)?)?;
        op.add_input(&output_backprop.to_handle(ctx)?)?;
        op.add_input(&output_h_backprop.to_handle(ctx)?)?;
        op.add_input(&output_c_backprop.to_handle(ctx)?)?;
        op.add_input(&reserve_space.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNBackprop::new().call(&ctx, &input, &input_h, &input_c, &params, &output, &output_h, &output_c, &output_backprop, &output_h_backprop, &output_c_backprop, &reserve_space)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackprop>
pub fn cudnn_rnnbackprop<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
    output: &T4,
    output_h: &T5,
    output_c: &T6,
    output_backprop: &T7,
    output_h_backprop: &T8,
    output_c_backprop: &T9,
    reserve_space: &T10,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CudnnRNNBackprop::new();
    op.call(
        ctx,
        input,
        input_h,
        input_c,
        params,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
    )
}

/// CudnnRNNBackpropV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackpropV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNBackpropV2 {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNBackpropV2 {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNBackpropV2 {
    /// Creates a new `CudnnRNNBackpropV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnbackprop_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
        T11: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
        output: &T4,
        output_h: &T5,
        output_c: &T6,
        output_backprop: &T7,
        output_h_backprop: &T8,
        output_c_backprop: &T9,
        reserve_space: &T10,
        host_reserved: &T11,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNBackpropV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;
        op.add_input(&output.to_handle(ctx)?)?;
        op.add_input(&output_h.to_handle(ctx)?)?;
        op.add_input(&output_c.to_handle(ctx)?)?;
        op.add_input(&output_backprop.to_handle(ctx)?)?;
        op.add_input(&output_h_backprop.to_handle(ctx)?)?;
        op.add_input(&output_c_backprop.to_handle(ctx)?)?;
        op.add_input(&reserve_space.to_handle(ctx)?)?;
        op.add_input(&host_reserved.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNBackpropV2::new().call(&ctx, &input, &input_h, &input_c, &params, &output, &output_h, &output_c, &output_backprop, &output_h_backprop, &output_c_backprop, &reserve_space, &host_reserved)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackpropV2>
pub fn cudnn_rnnbackprop_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
    T11: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
    output: &T4,
    output_h: &T5,
    output_c: &T6,
    output_backprop: &T7,
    output_h_backprop: &T8,
    output_c_backprop: &T9,
    reserve_space: &T10,
    host_reserved: &T11,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CudnnRNNBackpropV2::new();
    op.call(
        ctx,
        input,
        input_h,
        input_c,
        params,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
        host_reserved,
    )
}

/// CudnnRNNBackpropV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackpropV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNBackpropV3 {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    time_major: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNBackpropV3 {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            num_proj: Some(0i64),
            time_major: Some(true),
            target_device_name: None,
        }
    }
}
impl CudnnRNNBackpropV3 {
    /// Creates a new `CudnnRNNBackpropV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `time_major` attribute.
    pub fn time_major<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.time_major = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnbackprop_v3.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
        T9: crate::eager::ToTensorHandle<'a>,
        T10: crate::eager::ToTensorHandle<'a>,
        T11: crate::eager::ToTensorHandle<'a>,
        T12: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
        sequence_lengths: &T4,
        output: &T5,
        output_h: &T6,
        output_c: &T7,
        output_backprop: &T8,
        output_h_backprop: &T9,
        output_c_backprop: &T10,
        reserve_space: &T11,
        host_reserved: &T12,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNBackpropV3")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;
        op.add_input(&sequence_lengths.to_handle(ctx)?)?;
        op.add_input(&output.to_handle(ctx)?)?;
        op.add_input(&output_h.to_handle(ctx)?)?;
        op.add_input(&output_c.to_handle(ctx)?)?;
        op.add_input(&output_backprop.to_handle(ctx)?)?;
        op.add_input(&output_h_backprop.to_handle(ctx)?)?;
        op.add_input(&output_c_backprop.to_handle(ctx)?)?;
        op.add_input(&reserve_space.to_handle(ctx)?)?;
        op.add_input(&host_reserved.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_proj {
            op.set_attr_int("num_proj", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.time_major {
            op.set_attr_bool("time_major", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<4>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNBackpropV3::new().call(&ctx, &input, &input_h, &input_c, &params, &sequence_lengths, &output, &output_h, &output_c, &output_backprop, &output_h_backprop, &output_c_backprop, &reserve_space, &host_reserved)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNBackpropV3>
pub fn cudnn_rnnbackprop_v3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
    T9: crate::eager::ToTensorHandle<'a>,
    T10: crate::eager::ToTensorHandle<'a>,
    T11: crate::eager::ToTensorHandle<'a>,
    T12: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
    sequence_lengths: &T4,
    output: &T5,
    output_h: &T6,
    output_c: &T7,
    output_backprop: &T8,
    output_h_backprop: &T9,
    output_c_backprop: &T10,
    reserve_space: &T11,
    host_reserved: &T12,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 4]> {
    let op = CudnnRNNBackpropV3::new();
    op.call(
        ctx,
        input,
        input_h,
        input_c,
        params,
        sequence_lengths,
        output,
        output_h,
        output_c,
        output_backprop,
        output_h_backprop,
        output_c_backprop,
        reserve_space,
        host_reserved,
    )
}

/// CudnnRNNCanonicalToParams
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNCanonicalToParams>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNCanonicalToParams {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNCanonicalToParams {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNCanonicalToParams {
    /// Creates a new `CudnnRNNCanonicalToParams`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnncanonical_to_params.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        num_layers: &T0,
        num_units: &T1,
        input_size: &T2,
        weights: &[&T3],
        biases: &[&T4],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNCanonicalToParams")?;

        // Required input arguments
        op.add_input(&num_layers.to_handle(ctx)?)?;
        op.add_input(&num_units.to_handle(ctx)?)?;
        op.add_input(&input_size.to_handle(ctx)?)?;
        let mut weights_list = Vec::new();

        for t in weights {
            weights_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&weights_list)?;
        let mut biases_list = Vec::new();

        for t in biases {
            biases_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&biases_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CudnnRNNCanonicalToParams::new().call(&ctx, &num_layers, &num_units, &input_size, &weights, &biases)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNCanonicalToParams>
pub fn cudnn_rnncanonical_to_params<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    num_layers: &T0,
    num_units: &T1,
    input_size: &T2,
    weights: &[&T3],
    biases: &[&T4],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CudnnRNNCanonicalToParams::new();
    op.call(ctx, num_layers, num_units, input_size, weights, biases)
}

/// CudnnRNNCanonicalToParamsV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNCanonicalToParamsV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNCanonicalToParamsV2 {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNCanonicalToParamsV2 {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            num_proj: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNCanonicalToParamsV2 {
    /// Creates a new `CudnnRNNCanonicalToParamsV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnncanonical_to_params_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        num_layers: &T0,
        num_units: &T1,
        input_size: &T2,
        weights: &[&T3],
        biases: &[&T4],
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNCanonicalToParamsV2")?;

        // Required input arguments
        op.add_input(&num_layers.to_handle(ctx)?)?;
        op.add_input(&num_units.to_handle(ctx)?)?;
        op.add_input(&input_size.to_handle(ctx)?)?;
        let mut weights_list = Vec::new();

        for t in weights {
            weights_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&weights_list)?;
        let mut biases_list = Vec::new();

        for t in biases {
            biases_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&biases_list)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_proj {
            op.set_attr_int("num_proj", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CudnnRNNCanonicalToParamsV2::new().call(&ctx, &num_layers, &num_units, &input_size, &weights, &biases)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNCanonicalToParamsV2>
pub fn cudnn_rnncanonical_to_params_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    num_layers: &T0,
    num_units: &T1,
    input_size: &T2,
    weights: &[&T3],
    biases: &[&T4],
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CudnnRNNCanonicalToParamsV2::new();
    op.call(ctx, num_layers, num_units, input_size, weights, biases)
}

/// CudnnRNNParamsSize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsSize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNParamsSize {
    T: ::std::option::Option<crate::DataType>,
    S: ::std::option::Option<crate::DataType>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNParamsSize {
    fn default() -> Self {
        Self {
            T: None,
            S: None,
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            num_proj: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNParamsSize {
    /// Creates a new `CudnnRNNParamsSize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `T` attribute.
    pub fn T<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.T = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `S` attribute.
    pub fn S<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.S = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnparams_size.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        num_layers: &T0,
        num_units: &T1,
        input_size: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNParamsSize")?;

        // Required input arguments
        op.add_input(&num_layers.to_handle(ctx)?)?;
        op.add_input(&num_units.to_handle(ctx)?)?;
        op.add_input(&input_size.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.T {
            op.set_attr_type("T", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.S {
            op.set_attr_type("S", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_proj {
            op.set_attr_int("num_proj", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CudnnRNNParamsSize::new().call(&ctx, &num_layers, &num_units, &input_size)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsSize>
pub fn cudnn_rnnparams_size<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    num_layers: &T0,
    num_units: &T1,
    input_size: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CudnnRNNParamsSize::new();
    op.call(ctx, num_layers, num_units, input_size)
}

/// CudnnRNNParamsToCanonical
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsToCanonical>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNParamsToCanonical {
    num_params: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNParamsToCanonical {
    fn default() -> Self {
        Self {
            num_params: None,
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNParamsToCanonical {
    /// Creates a new `CudnnRNNParamsToCanonical`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_params` attribute.
    pub fn num_params<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnparams_to_canonical.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        num_layers: &T0,
        num_units: &T1,
        input_size: &T2,
        params: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNParamsToCanonical")?;

        // Required input arguments
        op.add_input(&num_layers.to_handle(ctx)?)?;
        op.add_input(&num_units.to_handle(ctx)?)?;
        op.add_input(&input_size.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_params {
            op.set_attr_int("num_params", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNParamsToCanonical::new().call(&ctx, &num_layers, &num_units, &input_size, &params)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsToCanonical>
pub fn cudnn_rnnparams_to_canonical<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    num_layers: &T0,
    num_units: &T1,
    input_size: &T2,
    params: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = CudnnRNNParamsToCanonical::new();
    op.call(ctx, num_layers, num_units, input_size, params)
}

/// CudnnRNNParamsToCanonicalV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsToCanonicalV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNParamsToCanonicalV2 {
    num_params_weights: ::std::option::Option<i64>,
    num_params_biases: ::std::option::Option<i64>,
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNParamsToCanonicalV2 {
    fn default() -> Self {
        Self {
            num_params_weights: None,
            num_params_biases: None,
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            num_proj: Some(0i64),
            target_device_name: None,
        }
    }
}
impl CudnnRNNParamsToCanonicalV2 {
    /// Creates a new `CudnnRNNParamsToCanonicalV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `num_params_weights` attribute.
    pub fn num_params_weights<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.num_params_weights = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_params_biases` attribute.
    pub fn num_params_biases<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_params_biases = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnparams_to_canonical_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        num_layers: &T0,
        num_units: &T1,
        input_size: &T2,
        params: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNParamsToCanonicalV2")?;

        // Required input arguments
        op.add_input(&num_layers.to_handle(ctx)?)?;
        op.add_input(&num_units.to_handle(ctx)?)?;
        op.add_input(&input_size.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.num_params_weights {
            op.set_attr_int("num_params_weights", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_params_biases {
            op.set_attr_int("num_params_biases", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_proj {
            op.set_attr_int("num_proj", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNParamsToCanonicalV2::new().call(&ctx, &num_layers, &num_units, &input_size, &params)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNParamsToCanonicalV2>
pub fn cudnn_rnnparams_to_canonical_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    num_layers: &T0,
    num_units: &T1,
    input_size: &T2,
    params: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = CudnnRNNParamsToCanonicalV2::new();
    op.call(ctx, num_layers, num_units, input_size, params)
}

/// CudnnRNNV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNV2 {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNV2 {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            is_training: Some(true),
            target_device_name: None,
        }
    }
}
impl CudnnRNNV2 {
    /// Creates a new `CudnnRNNV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnv2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.is_training {
            op.set_attr_bool("is_training", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<5>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNV2::new().call(&ctx, &input, &input_h, &input_c, &params)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNV2>
pub fn cudnn_rnnv2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
    let op = CudnnRNNV2::new();
    op.call(ctx, input, input_h, input_c, params)
}

/// CudnnRNNV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CudnnRNNV3 {
    rnn_mode: ::std::option::Option<::std::string::String>,
    input_mode: ::std::option::Option<::std::string::String>,
    direction: ::std::option::Option<::std::string::String>,
    dropout: ::std::option::Option<f32>,
    seed: ::std::option::Option<i64>,
    seed2: ::std::option::Option<i64>,
    num_proj: ::std::option::Option<i64>,
    is_training: ::std::option::Option<bool>,
    time_major: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CudnnRNNV3 {
    fn default() -> Self {
        Self {
            rnn_mode: Some(::std::string::String::from("lstm")),
            input_mode: Some(::std::string::String::from("linear_input")),
            direction: Some(::std::string::String::from("unidirectional")),
            dropout: Some(0f32),
            seed: Some(0i64),
            seed2: Some(0i64),
            num_proj: Some(0i64),
            is_training: Some(true),
            time_major: Some(true),
            target_device_name: None,
        }
    }
}
impl CudnnRNNV3 {
    /// Creates a new `CudnnRNNV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `rnn_mode` attribute.
    pub fn rnn_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.rnn_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `input_mode` attribute.
    pub fn input_mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.input_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `direction` attribute.
    pub fn direction<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.direction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dropout` attribute.
    pub fn dropout<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.dropout = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed` attribute.
    pub fn seed<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `seed2` attribute.
    pub fn seed2<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.seed2 = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `num_proj` attribute.
    pub fn num_proj<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.num_proj = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `is_training` attribute.
    pub fn is_training<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.is_training = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `time_major` attribute.
    pub fn time_major<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.time_major = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cudnn_rnnv3.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        input_h: &T1,
        input_c: &T2,
        params: &T3,
        sequence_lengths: &T4,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
        // Define Op
        let mut op = super::Op::new(ctx, "CudnnRNNV3")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&input_h.to_handle(ctx)?)?;
        op.add_input(&input_c.to_handle(ctx)?)?;
        op.add_input(&params.to_handle(ctx)?)?;
        op.add_input(&sequence_lengths.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.rnn_mode {
            op.set_attr_string("rnn_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.input_mode {
            op.set_attr_string("input_mode", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.direction {
            op.set_attr_string("direction", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dropout {
            op.set_attr_float("dropout", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed {
            op.set_attr_int("seed", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.seed2 {
            op.set_attr_int("seed2", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.num_proj {
            op.set_attr_int("num_proj", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.is_training {
            op.set_attr_bool("is_training", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.time_major {
            op.set_attr_bool("time_major", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<5>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `CudnnRNNV3::new().call(&ctx, &input, &input_h, &input_c, &params, &sequence_lengths)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CudnnRNNV3>
pub fn cudnn_rnnv3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    input_h: &T1,
    input_c: &T2,
    params: &T3,
    sequence_lengths: &T4,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 5]> {
    let op = CudnnRNNV3::new();
    op.call(ctx, input, input_h, input_c, params, sequence_lengths)
}

/// Cumprod
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cumprod>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cumprod {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cumprod {
    fn default() -> Self {
        Self {
            exclusive: Some(false),
            reverse: Some(false),
            target_device_name: None,
        }
    }
}
impl Cumprod {
    /// Creates a new `Cumprod`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cumprod.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        axis: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cumprod")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&axis.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.exclusive {
            op.set_attr_bool("exclusive", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.reverse {
            op.set_attr_bool("reverse", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cumprod::new().call(&ctx, &x, &axis)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cumprod>
pub fn cumprod<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    axis: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cumprod::new();
    op.call(ctx, x, axis)
}

/// Cumsum
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cumsum>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Cumsum {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Cumsum {
    fn default() -> Self {
        Self {
            exclusive: Some(false),
            reverse: Some(false),
            target_device_name: None,
        }
    }
}
impl Cumsum {
    /// Creates a new `Cumsum`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cumsum.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        axis: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Cumsum")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&axis.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.exclusive {
            op.set_attr_bool("exclusive", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.reverse {
            op.set_attr_bool("reverse", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Cumsum::new().call(&ctx, &x, &axis)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Cumsum>
pub fn cumsum<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    axis: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Cumsum::new();
    op.call(ctx, x, axis)
}

/// CumulativeLogsumexp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CumulativeLogsumexp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct CumulativeLogsumexp {
    exclusive: ::std::option::Option<bool>,
    reverse: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for CumulativeLogsumexp {
    fn default() -> Self {
        Self {
            exclusive: Some(false),
            reverse: Some(false),
            target_device_name: None,
        }
    }
}
impl CumulativeLogsumexp {
    /// Creates a new `CumulativeLogsumexp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `exclusive` attribute.
    pub fn exclusive<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.exclusive = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `reverse` attribute.
    pub fn reverse<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.reverse = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute cumulative_logsumexp.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
        axis: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "CumulativeLogsumexp")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;
        op.add_input(&axis.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.exclusive {
            op.set_attr_bool("exclusive", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.reverse {
            op.set_attr_bool("reverse", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `CumulativeLogsumexp::new().call(&ctx, &x, &axis)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/CumulativeLogsumexp>
pub fn cumulative_logsumexp<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    x: &T0,
    axis: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = CumulativeLogsumexp::new();
    op.call(ctx, x, axis)
}

/// DataFormatDimMap
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataFormatDimMap>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DataFormatDimMap {
    src_format: ::std::option::Option<::std::string::String>,
    dst_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DataFormatDimMap {
    fn default() -> Self {
        Self {
            src_format: Some(::std::string::String::from("NHWC")),
            dst_format: Some(::std::string::String::from("NCHW")),
            target_device_name: None,
        }
    }
}
impl DataFormatDimMap {
    /// Creates a new `DataFormatDimMap`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `src_format` attribute.
    pub fn src_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.src_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dst_format` attribute.
    pub fn dst_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dst_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute data_format_dim_map.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DataFormatDimMap")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.src_format {
            op.set_attr_string("src_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dst_format {
            op.set_attr_string("dst_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DataFormatDimMap::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataFormatDimMap>
pub fn data_format_dim_map<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DataFormatDimMap::new();
    op.call(ctx, x)
}

/// DataFormatVecPermute
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataFormatVecPermute>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DataFormatVecPermute {
    src_format: ::std::option::Option<::std::string::String>,
    dst_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DataFormatVecPermute {
    fn default() -> Self {
        Self {
            src_format: Some(::std::string::String::from("NHWC")),
            dst_format: Some(::std::string::String::from("NCHW")),
            target_device_name: None,
        }
    }
}
impl DataFormatVecPermute {
    /// Creates a new `DataFormatVecPermute`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `src_format` attribute.
    pub fn src_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.src_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dst_format` attribute.
    pub fn dst_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dst_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute data_format_vec_permute.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DataFormatVecPermute")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.src_format {
            op.set_attr_string("src_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dst_format {
            op.set_attr_string("dst_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DataFormatVecPermute::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataFormatVecPermute>
pub fn data_format_vec_permute<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DataFormatVecPermute::new();
    op.call(ctx, x)
}

/// DataServiceDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DataServiceDataset {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DataServiceDataset {
    fn default() -> Self {
        Self {
            task_refresh_interval_hint_ms: Some(-1i64),
            output_types: None,
            output_shapes: None,
            data_transfer_protocol: None,
            target_workers: Some(::std::string::String::from("AUTO")),
            target_device_name: None,
        }
    }
}
impl DataServiceDataset {
    /// Creates a new `DataServiceDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute data_service_dataset.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        dataset_id: &T0,
        processing_mode: &T1,
        address: &T2,
        protocol: &T3,
        job_name: &T4,
        max_outstanding_requests: &T5,
        iteration_counter: &T6,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DataServiceDataset")?;

        // Required input arguments
        op.add_input(&dataset_id.to_handle(ctx)?)?;
        op.add_input(&processing_mode.to_handle(ctx)?)?;
        op.add_input(&address.to_handle(ctx)?)?;
        op.add_input(&protocol.to_handle(ctx)?)?;
        op.add_input(&job_name.to_handle(ctx)?)?;
        op.add_input(&max_outstanding_requests.to_handle(ctx)?)?;
        op.add_input(&iteration_counter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
            op.set_attr_int("task_refresh_interval_hint_ms", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
            op.set_attr_string("data_transfer_protocol", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.target_workers {
            op.set_attr_string("target_workers", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DataServiceDataset::new().call(&ctx, &dataset_id, &processing_mode, &address, &protocol, &job_name, &max_outstanding_requests, &iteration_counter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDataset>
pub fn data_service_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    dataset_id: &T0,
    processing_mode: &T1,
    address: &T2,
    protocol: &T3,
    job_name: &T4,
    max_outstanding_requests: &T5,
    iteration_counter: &T6,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DataServiceDataset::new();
    op.call(
        ctx,
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        max_outstanding_requests,
        iteration_counter,
    )
}

/// DataServiceDatasetV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDatasetV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DataServiceDatasetV2 {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DataServiceDatasetV2 {
    fn default() -> Self {
        Self {
            task_refresh_interval_hint_ms: Some(-1i64),
            output_types: None,
            output_shapes: None,
            data_transfer_protocol: None,
            target_workers: Some(::std::string::String::from("AUTO")),
            target_device_name: None,
        }
    }
}
impl DataServiceDatasetV2 {
    /// Creates a new `DataServiceDatasetV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute data_service_dataset_v2.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        dataset_id: &T0,
        processing_mode: &T1,
        address: &T2,
        protocol: &T3,
        job_name: &T4,
        consumer_index: &T5,
        num_consumers: &T6,
        max_outstanding_requests: &T7,
        iteration_counter: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DataServiceDatasetV2")?;

        // Required input arguments
        op.add_input(&dataset_id.to_handle(ctx)?)?;
        op.add_input(&processing_mode.to_handle(ctx)?)?;
        op.add_input(&address.to_handle(ctx)?)?;
        op.add_input(&protocol.to_handle(ctx)?)?;
        op.add_input(&job_name.to_handle(ctx)?)?;
        op.add_input(&consumer_index.to_handle(ctx)?)?;
        op.add_input(&num_consumers.to_handle(ctx)?)?;
        op.add_input(&max_outstanding_requests.to_handle(ctx)?)?;
        op.add_input(&iteration_counter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
            op.set_attr_int("task_refresh_interval_hint_ms", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
            op.set_attr_string("data_transfer_protocol", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.target_workers {
            op.set_attr_string("target_workers", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DataServiceDatasetV2::new().call(&ctx, &dataset_id, &processing_mode, &address, &protocol, &job_name, &consumer_index, &num_consumers, &max_outstanding_requests, &iteration_counter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDatasetV2>
pub fn data_service_dataset_v2<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    dataset_id: &T0,
    processing_mode: &T1,
    address: &T2,
    protocol: &T3,
    job_name: &T4,
    consumer_index: &T5,
    num_consumers: &T6,
    max_outstanding_requests: &T7,
    iteration_counter: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DataServiceDatasetV2::new();
    op.call(
        ctx,
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        consumer_index,
        num_consumers,
        max_outstanding_requests,
        iteration_counter,
    )
}

/// DataServiceDatasetV3
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDatasetV3>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DataServiceDatasetV3 {
    task_refresh_interval_hint_ms: ::std::option::Option<i64>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    data_transfer_protocol: ::std::option::Option<::std::string::String>,
    target_workers: ::std::option::Option<::std::string::String>,
    uncompress: ::std::option::Option<bool>,
    uncompress_fn: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DataServiceDatasetV3 {
    fn default() -> Self {
        Self {
            task_refresh_interval_hint_ms: Some(-1i64),
            output_types: None,
            output_shapes: None,
            data_transfer_protocol: None,
            target_workers: Some(::std::string::String::from("AUTO")),
            uncompress: Some(false),
            uncompress_fn: None,
            target_device_name: None,
        }
    }
}
impl DataServiceDatasetV3 {
    /// Creates a new `DataServiceDatasetV3`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `task_refresh_interval_hint_ms` attribute.
    pub fn task_refresh_interval_hint_ms<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.task_refresh_interval_hint_ms = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_transfer_protocol` attribute.
    pub fn data_transfer_protocol<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_transfer_protocol = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `target_workers` attribute.
    pub fn target_workers<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_workers = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `uncompress` attribute.
    pub fn uncompress<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.uncompress = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `uncompress_fn` attribute.
    pub fn uncompress_fn<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.uncompress_fn = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute data_service_dataset_v3.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
        T4: crate::eager::ToTensorHandle<'a>,
        T5: crate::eager::ToTensorHandle<'a>,
        T6: crate::eager::ToTensorHandle<'a>,
        T7: crate::eager::ToTensorHandle<'a>,
        T8: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        dataset_id: &T0,
        processing_mode: &T1,
        address: &T2,
        protocol: &T3,
        job_name: &T4,
        consumer_index: &T5,
        num_consumers: &T6,
        max_outstanding_requests: &T7,
        iteration_counter: &T8,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DataServiceDatasetV3")?;

        // Required input arguments
        op.add_input(&dataset_id.to_handle(ctx)?)?;
        op.add_input(&processing_mode.to_handle(ctx)?)?;
        op.add_input(&address.to_handle(ctx)?)?;
        op.add_input(&protocol.to_handle(ctx)?)?;
        op.add_input(&job_name.to_handle(ctx)?)?;
        op.add_input(&consumer_index.to_handle(ctx)?)?;
        op.add_input(&num_consumers.to_handle(ctx)?)?;
        op.add_input(&max_outstanding_requests.to_handle(ctx)?)?;
        op.add_input(&iteration_counter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.task_refresh_interval_hint_ms {
            op.set_attr_int("task_refresh_interval_hint_ms", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_transfer_protocol {
            op.set_attr_string("data_transfer_protocol", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.target_workers {
            op.set_attr_string("target_workers", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.uncompress {
            op.set_attr_bool("uncompress", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.uncompress_fn {
            op.set_attr_string("uncompress_fn", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DataServiceDatasetV3::new().call(&ctx, &dataset_id, &processing_mode, &address, &protocol, &job_name, &consumer_index, &num_consumers, &max_outstanding_requests, &iteration_counter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DataServiceDatasetV3>
pub fn data_service_dataset_v3<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
    T4: crate::eager::ToTensorHandle<'a>,
    T5: crate::eager::ToTensorHandle<'a>,
    T6: crate::eager::ToTensorHandle<'a>,
    T7: crate::eager::ToTensorHandle<'a>,
    T8: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    dataset_id: &T0,
    processing_mode: &T1,
    address: &T2,
    protocol: &T3,
    job_name: &T4,
    consumer_index: &T5,
    num_consumers: &T6,
    max_outstanding_requests: &T7,
    iteration_counter: &T8,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DataServiceDatasetV3::new();
    op.call(
        ctx,
        dataset_id,
        processing_mode,
        address,
        protocol,
        job_name,
        consumer_index,
        num_consumers,
        max_outstanding_requests,
        iteration_counter,
    )
}

/// DatasetCardinality
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetCardinality>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetCardinality {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetCardinality {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DatasetCardinality {
    /// Creates a new `DatasetCardinality`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_cardinality.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetCardinality")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DatasetCardinality::new().call(&ctx, &input_dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetCardinality>
pub fn dataset_cardinality<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DatasetCardinality::new();
    op.call(ctx, input_dataset)
}

/// DatasetFromGraph
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetFromGraph>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetFromGraph {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetFromGraph {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DatasetFromGraph {
    /// Creates a new `DatasetFromGraph`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_from_graph.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        graph_def: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetFromGraph")?;

        // Required input arguments
        op.add_input(&graph_def.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DatasetFromGraph::new().call(&ctx, &graph_def)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetFromGraph>
pub fn dataset_from_graph<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    graph_def: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DatasetFromGraph::new();
    op.call(ctx, graph_def)
}

/// DatasetToGraph
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToGraph>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetToGraph {
    stateful_whitelist: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    allow_stateful: ::std::option::Option<bool>,
    strip_device_assignment: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetToGraph {
    fn default() -> Self {
        Self {
            stateful_whitelist: Some(vec![]),
            allow_stateful: Some(false),
            strip_device_assignment: Some(false),
            target_device_name: None,
        }
    }
}
impl DatasetToGraph {
    /// Creates a new `DatasetToGraph`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `stateful_whitelist` attribute.
    pub fn stateful_whitelist<
        ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>,
    >(
        mut self,
        value: ArgType,
    ) -> Self {
        self.stateful_whitelist = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `allow_stateful` attribute.
    pub fn allow_stateful<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.allow_stateful = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strip_device_assignment` attribute.
    pub fn strip_device_assignment<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strip_device_assignment = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_to_graph.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetToGraph")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.stateful_whitelist {
            op.set_attr_string_list("stateful_whitelist", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.allow_stateful {
            op.set_attr_bool("allow_stateful", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strip_device_assignment {
            op.set_attr_bool("strip_device_assignment", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DatasetToGraph::new().call(&ctx, &input_dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToGraph>
pub fn dataset_to_graph<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DatasetToGraph::new();
    op.call(ctx, input_dataset)
}

/// DatasetToGraphV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToGraphV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetToGraphV2 {
    external_state_policy: ::std::option::Option<i64>,
    strip_device_assignment: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetToGraphV2 {
    fn default() -> Self {
        Self {
            external_state_policy: Some(0i64),
            strip_device_assignment: Some(false),
            target_device_name: None,
        }
    }
}
impl DatasetToGraphV2 {
    /// Creates a new `DatasetToGraphV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `external_state_policy` attribute.
    pub fn external_state_policy<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.external_state_policy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `strip_device_assignment` attribute.
    pub fn strip_device_assignment<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strip_device_assignment = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_to_graph_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetToGraphV2")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.external_state_policy {
            op.set_attr_int("external_state_policy", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.strip_device_assignment {
            op.set_attr_bool("strip_device_assignment", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DatasetToGraphV2::new().call(&ctx, &input_dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToGraphV2>
pub fn dataset_to_graph_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DatasetToGraphV2::new();
    op.call(ctx, input_dataset)
}

/// DatasetToSingleElement
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToSingleElement>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetToSingleElement {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    metadata: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetToSingleElement {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            metadata: None,
            target_device_name: None,
        }
    }
}
impl DatasetToSingleElement {
    /// Creates a new `DatasetToSingleElement`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `metadata` attribute.
    pub fn metadata<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.metadata = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_to_single_element.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        dataset: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetToSingleElement")?;

        // Required input arguments
        op.add_input(&dataset.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.metadata {
            op.set_attr_string("metadata", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DatasetToSingleElement::new().call(&ctx, &dataset)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToSingleElement>
pub fn dataset_to_single_element<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    dataset: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DatasetToSingleElement::new();
    op.call(ctx, dataset)
}

/// DatasetToTFRecord
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToTFRecord>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DatasetToTFRecord {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DatasetToTFRecord {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DatasetToTFRecord {
    /// Creates a new `DatasetToTFRecord`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dataset_to_tfrecord.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        filename: &T1,
        compression_type: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DatasetToTFRecord")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&filename.to_handle(ctx)?)?;
        op.add_input(&compression_type.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DatasetToTFRecord::new().call(&ctx, &input_dataset, &filename, &compression_type)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DatasetToTFRecord>
pub fn dataset_to_tfrecord<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    filename: &T1,
    compression_type: &T2,
) -> crate::Result<()> {
    let op = DatasetToTFRecord::new();
    op.call(ctx, input_dataset, filename, compression_type)
}

/// Dawsn
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Dawsn>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Dawsn {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Dawsn {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl Dawsn {
    /// Creates a new `Dawsn`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dawsn.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Dawsn")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `Dawsn::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Dawsn>
pub fn dawsn<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = Dawsn::new();
    op.call(ctx, x)
}

/// DebugGradientIdentity
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugGradientIdentity>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugGradientIdentity {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugGradientIdentity {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DebugGradientIdentity {
    /// Creates a new `DebugGradientIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_gradient_identity.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugGradientIdentity")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugGradientIdentity::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugGradientIdentity>
pub fn debug_gradient_identity<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugGradientIdentity::new();
    op.call(ctx, input)
}

/// DebugGradientRefIdentity
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugGradientRefIdentity>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugGradientRefIdentity {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugGradientRefIdentity {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DebugGradientRefIdentity {
    /// Creates a new `DebugGradientRefIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_gradient_ref_identity.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugGradientRefIdentity")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugGradientRefIdentity::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugGradientRefIdentity>
pub fn debug_gradient_ref_identity<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugGradientRefIdentity::new();
    op.call(ctx, input)
}

/// DebugIdentity
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugIdentity>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugIdentity {
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    gated_grpc: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugIdentity {
    fn default() -> Self {
        Self {
            device_name: None,
            tensor_name: None,
            debug_urls: Some(vec![]),
            gated_grpc: Some(false),
            target_device_name: None,
        }
    }
}
impl DebugIdentity {
    /// Creates a new `DebugIdentity`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_identity.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugIdentity")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.device_name {
            op.set_attr_string("device_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_name {
            op.set_attr_string("tensor_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_urls {
            op.set_attr_string_list("debug_urls", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.gated_grpc {
            op.set_attr_bool("gated_grpc", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugIdentity::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugIdentity>
pub fn debug_identity<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugIdentity::new();
    op.call(ctx, input)
}

/// DebugIdentityV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugIdentityV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugIdentityV2 {
    tfdbg_context_id: ::std::option::Option<::std::string::String>,
    op_name: ::std::option::Option<::std::string::String>,
    output_slot: ::std::option::Option<i64>,
    tensor_debug_mode: ::std::option::Option<i64>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    circular_buffer_size: ::std::option::Option<i64>,
    tfdbg_run_id: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugIdentityV2 {
    fn default() -> Self {
        Self {
            tfdbg_context_id: None,
            op_name: None,
            output_slot: Some(-1i64),
            tensor_debug_mode: Some(-1i64),
            debug_urls: Some(vec![]),
            circular_buffer_size: Some(1000i64),
            tfdbg_run_id: None,
            target_device_name: None,
        }
    }
}
impl DebugIdentityV2 {
    /// Creates a new `DebugIdentityV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `tfdbg_context_id` attribute.
    pub fn tfdbg_context_id<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tfdbg_context_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `op_name` attribute.
    pub fn op_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.op_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_slot` attribute.
    pub fn output_slot<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.output_slot = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_debug_mode` attribute.
    pub fn tensor_debug_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_debug_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `circular_buffer_size` attribute.
    pub fn circular_buffer_size<ArgType: ::std::convert::Into<i64>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.circular_buffer_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tfdbg_run_id` attribute.
    pub fn tfdbg_run_id<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tfdbg_run_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_identity_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugIdentityV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.tfdbg_context_id {
            op.set_attr_string("tfdbg_context_id", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.op_name {
            op.set_attr_string("op_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_slot {
            op.set_attr_int("output_slot", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_debug_mode {
            op.set_attr_int("tensor_debug_mode", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_urls {
            op.set_attr_string_list("debug_urls", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.circular_buffer_size {
            op.set_attr_int("circular_buffer_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tfdbg_run_id {
            op.set_attr_string("tfdbg_run_id", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugIdentityV2::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugIdentityV2>
pub fn debug_identity_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugIdentityV2::new();
    op.call(ctx, input)
}

/// DebugNanCount
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNanCount>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugNanCount {
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    gated_grpc: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugNanCount {
    fn default() -> Self {
        Self {
            device_name: None,
            tensor_name: None,
            debug_urls: Some(vec![]),
            gated_grpc: Some(false),
            target_device_name: None,
        }
    }
}
impl DebugNanCount {
    /// Creates a new `DebugNanCount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_nan_count.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugNanCount")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.device_name {
            op.set_attr_string("device_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_name {
            op.set_attr_string("tensor_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_urls {
            op.set_attr_string_list("debug_urls", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.gated_grpc {
            op.set_attr_bool("gated_grpc", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugNanCount::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNanCount>
pub fn debug_nan_count<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugNanCount::new();
    op.call(ctx, input)
}

/// DebugNumericSummary
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNumericSummary>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugNumericSummary {
    device_name: ::std::option::Option<::std::string::String>,
    tensor_name: ::std::option::Option<::std::string::String>,
    debug_urls: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    lower_bound: ::std::option::Option<f32>,
    upper_bound: ::std::option::Option<f32>,
    mute_if_healthy: ::std::option::Option<bool>,
    gated_grpc: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugNumericSummary {
    fn default() -> Self {
        Self {
            device_name: None,
            tensor_name: None,
            debug_urls: Some(vec![]),
            lower_bound: Some(f32::NEG_INFINITY),
            upper_bound: Some(f32::INFINITY),
            mute_if_healthy: Some(false),
            gated_grpc: Some(false),
            target_device_name: None,
        }
    }
}
impl DebugNumericSummary {
    /// Creates a new `DebugNumericSummary`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `device_name` attribute.
    pub fn device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_name` attribute.
    pub fn tensor_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.tensor_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `debug_urls` attribute.
    pub fn debug_urls<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.debug_urls = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `lower_bound` attribute.
    pub fn lower_bound<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.lower_bound = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `upper_bound` attribute.
    pub fn upper_bound<ArgType: ::std::convert::Into<f32>>(mut self, value: ArgType) -> Self {
        self.upper_bound = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `mute_if_healthy` attribute.
    pub fn mute_if_healthy<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.mute_if_healthy = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `gated_grpc` attribute.
    pub fn gated_grpc<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.gated_grpc = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_numeric_summary.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugNumericSummary")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.device_name {
            op.set_attr_string("device_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_name {
            op.set_attr_string("tensor_name", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.debug_urls {
            op.set_attr_string_list("debug_urls", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.lower_bound {
            op.set_attr_float("lower_bound", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.upper_bound {
            op.set_attr_float("upper_bound", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.mute_if_healthy {
            op.set_attr_bool("mute_if_healthy", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.gated_grpc {
            op.set_attr_bool("gated_grpc", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugNumericSummary::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNumericSummary>
pub fn debug_numeric_summary<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugNumericSummary::new();
    op.call(ctx, input)
}

/// DebugNumericSummaryV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNumericSummaryV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DebugNumericSummaryV2 {
    output_dtype: ::std::option::Option<crate::DataType>,
    tensor_debug_mode: ::std::option::Option<i64>,
    tensor_id: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DebugNumericSummaryV2 {
    fn default() -> Self {
        Self {
            output_dtype: Some(crate::DataType::Float),
            tensor_debug_mode: Some(-1i64),
            tensor_id: Some(-1i64),
            target_device_name: None,
        }
    }
}
impl DebugNumericSummaryV2 {
    /// Creates a new `DebugNumericSummaryV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_dtype` attribute.
    pub fn output_dtype<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_debug_mode` attribute.
    pub fn tensor_debug_mode<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_debug_mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `tensor_id` attribute.
    pub fn tensor_id<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.tensor_id = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute debug_numeric_summary_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DebugNumericSummaryV2")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_dtype {
            op.set_attr_type("output_dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_debug_mode {
            op.set_attr_int("tensor_debug_mode", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.tensor_id {
            op.set_attr_int("tensor_id", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DebugNumericSummaryV2::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DebugNumericSummaryV2>
pub fn debug_numeric_summary_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DebugNumericSummaryV2::new();
    op.call(ctx, input)
}

/// DecodeAndCropJpeg
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeAndCropJpeg>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeAndCropJpeg {
    channels: ::std::option::Option<i64>,
    ratio: ::std::option::Option<i64>,
    fancy_upscaling: ::std::option::Option<bool>,
    try_recover_truncated: ::std::option::Option<bool>,
    acceptable_fraction: ::std::option::Option<f32>,
    dct_method: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeAndCropJpeg {
    fn default() -> Self {
        Self {
            channels: Some(0i64),
            ratio: Some(1i64),
            fancy_upscaling: Some(true),
            try_recover_truncated: Some(false),
            acceptable_fraction: Some(1f32),
            dct_method: None,
            target_device_name: None,
        }
    }
}
impl DecodeAndCropJpeg {
    /// Creates a new `DecodeAndCropJpeg`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ratio` attribute.
    pub fn ratio<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.ratio = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fancy_upscaling` attribute.
    pub fn fancy_upscaling<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fancy_upscaling = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `try_recover_truncated` attribute.
    pub fn try_recover_truncated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.try_recover_truncated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `acceptable_fraction` attribute.
    pub fn acceptable_fraction<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.acceptable_fraction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dct_method` attribute.
    pub fn dct_method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dct_method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_and_crop_jpeg.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
        crop_window: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeAndCropJpeg")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;
        op.add_input(&crop_window.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.channels {
            op.set_attr_int("channels", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ratio {
            op.set_attr_int("ratio", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.fancy_upscaling {
            op.set_attr_bool("fancy_upscaling", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.try_recover_truncated {
            op.set_attr_bool("try_recover_truncated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.acceptable_fraction {
            op.set_attr_float("acceptable_fraction", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dct_method {
            op.set_attr_string("dct_method", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeAndCropJpeg::new().call(&ctx, &contents, &crop_window)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeAndCropJpeg>
pub fn decode_and_crop_jpeg<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
    crop_window: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeAndCropJpeg::new();
    op.call(ctx, contents, crop_window)
}

/// DecodeBase64
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeBase64>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeBase64 {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeBase64 {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DecodeBase64 {
    /// Creates a new `DecodeBase64`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_base64.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeBase64")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeBase64::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeBase64>
pub fn decode_base64<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeBase64::new();
    op.call(ctx, input)
}

/// DecodeBmp
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeBmp>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeBmp {
    channels: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeBmp {
    fn default() -> Self {
        Self {
            channels: Some(0i64),
            target_device_name: None,
        }
    }
}
impl DecodeBmp {
    /// Creates a new `DecodeBmp`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_bmp.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeBmp")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.channels {
            op.set_attr_int("channels", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeBmp::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeBmp>
pub fn decode_bmp<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeBmp::new();
    op.call(ctx, contents)
}

/// DecodeCSV
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeCSV>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeCSV {
    field_delim: ::std::option::Option<::std::string::String>,
    use_quote_delim: ::std::option::Option<bool>,
    na_value: ::std::option::Option<::std::string::String>,
    select_cols: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeCSV {
    fn default() -> Self {
        Self {
            field_delim: Some(::std::string::String::from(",")),
            use_quote_delim: Some(true),
            na_value: None,
            select_cols: Some(vec![]),
            target_device_name: None,
        }
    }
}
impl DecodeCSV {
    /// Creates a new `DecodeCSV`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `field_delim` attribute.
    pub fn field_delim<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.field_delim = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `use_quote_delim` attribute.
    pub fn use_quote_delim<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.use_quote_delim = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `na_value` attribute.
    pub fn na_value<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.na_value = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `select_cols` attribute.
    pub fn select_cols<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.select_cols = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_csv.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        records: &T0,
        record_defaults: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeCSV")?;

        // Required input arguments
        op.add_input(&records.to_handle(ctx)?)?;
        op.add_input(&record_defaults.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.field_delim {
            op.set_attr_string("field_delim", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.use_quote_delim {
            op.set_attr_bool("use_quote_delim", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.na_value {
            op.set_attr_string("na_value", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.select_cols {
            op.set_attr_int_list("select_cols", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeCSV::new().call(&ctx, &records, &record_defaults)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeCSV>
pub fn decode_csv<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    records: &T0,
    record_defaults: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeCSV::new();
    op.call(ctx, records, record_defaults)
}

/// DecodeCompressed
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeCompressed>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeCompressed {
    compression_type: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeCompressed {
    fn default() -> Self {
        Self {
            compression_type: None,
            target_device_name: None,
        }
    }
}
impl DecodeCompressed {
    /// Creates a new `DecodeCompressed`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `compression_type` attribute.
    pub fn compression_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.compression_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_compressed.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        bytes: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeCompressed")?;

        // Required input arguments
        op.add_input(&bytes.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.compression_type {
            op.set_attr_string("compression_type", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeCompressed::new().call(&ctx, &bytes)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeCompressed>
pub fn decode_compressed<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    bytes: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeCompressed::new();
    op.call(ctx, bytes)
}

/// DecodeGif
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeGif>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeGif {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeGif {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DecodeGif {
    /// Creates a new `DecodeGif`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_gif.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeGif")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeGif::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeGif>
pub fn decode_gif<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeGif::new();
    op.call(ctx, contents)
}

/// DecodeImage
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeImage>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeImage {
    channels: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    expand_animations: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeImage {
    fn default() -> Self {
        Self {
            channels: Some(0i64),
            dtype: Some(crate::DataType::UInt8),
            expand_animations: Some(true),
            target_device_name: None,
        }
    }
}
impl DecodeImage {
    /// Creates a new `DecodeImage`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `expand_animations` attribute.
    pub fn expand_animations<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.expand_animations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_image.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeImage")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.channels {
            op.set_attr_int("channels", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dtype {
            op.set_attr_type("dtype", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.expand_animations {
            op.set_attr_bool("expand_animations", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeImage::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeImage>
pub fn decode_image<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeImage::new();
    op.call(ctx, contents)
}

/// DecodeJSONExample
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeJSONExample>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeJSONExample {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeJSONExample {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DecodeJSONExample {
    /// Creates a new `DecodeJSONExample`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_jsonexample.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        json_examples: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeJSONExample")?;

        // Required input arguments
        op.add_input(&json_examples.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeJSONExample::new().call(&ctx, &json_examples)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeJSONExample>
pub fn decode_jsonexample<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    json_examples: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeJSONExample::new();
    op.call(ctx, json_examples)
}

/// DecodeJpeg
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeJpeg>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeJpeg {
    channels: ::std::option::Option<i64>,
    ratio: ::std::option::Option<i64>,
    fancy_upscaling: ::std::option::Option<bool>,
    try_recover_truncated: ::std::option::Option<bool>,
    acceptable_fraction: ::std::option::Option<f32>,
    dct_method: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeJpeg {
    fn default() -> Self {
        Self {
            channels: Some(0i64),
            ratio: Some(1i64),
            fancy_upscaling: Some(true),
            try_recover_truncated: Some(false),
            acceptable_fraction: Some(1f32),
            dct_method: None,
            target_device_name: None,
        }
    }
}
impl DecodeJpeg {
    /// Creates a new `DecodeJpeg`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `ratio` attribute.
    pub fn ratio<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.ratio = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `fancy_upscaling` attribute.
    pub fn fancy_upscaling<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.fancy_upscaling = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `try_recover_truncated` attribute.
    pub fn try_recover_truncated<ArgType: ::std::convert::Into<bool>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.try_recover_truncated = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `acceptable_fraction` attribute.
    pub fn acceptable_fraction<ArgType: ::std::convert::Into<f32>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.acceptable_fraction = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dct_method` attribute.
    pub fn dct_method<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dct_method = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_jpeg.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeJpeg")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.channels {
            op.set_attr_int("channels", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.ratio {
            op.set_attr_int("ratio", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.fancy_upscaling {
            op.set_attr_bool("fancy_upscaling", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.try_recover_truncated {
            op.set_attr_bool("try_recover_truncated", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.acceptable_fraction {
            op.set_attr_float("acceptable_fraction", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dct_method {
            op.set_attr_string("dct_method", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeJpeg::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeJpeg>
pub fn decode_jpeg<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeJpeg::new();
    op.call(ctx, contents)
}

/// DecodePaddedRaw
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodePaddedRaw>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodePaddedRaw {
    out_type: ::std::option::Option<crate::DataType>,
    little_endian: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodePaddedRaw {
    fn default() -> Self {
        Self {
            out_type: None,
            little_endian: Some(true),
            target_device_name: None,
        }
    }
}
impl DecodePaddedRaw {
    /// Creates a new `DecodePaddedRaw`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `out_type` attribute.
    pub fn out_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.out_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `little_endian` attribute.
    pub fn little_endian<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.little_endian = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_padded_raw.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input_bytes: &T0,
        fixed_length: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodePaddedRaw")?;

        // Required input arguments
        op.add_input(&input_bytes.to_handle(ctx)?)?;
        op.add_input(&fixed_length.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.out_type {
            op.set_attr_type("out_type", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.little_endian {
            op.set_attr_bool("little_endian", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodePaddedRaw::new().call(&ctx, &input_bytes, &fixed_length)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodePaddedRaw>
pub fn decode_padded_raw<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_bytes: &T0,
    fixed_length: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodePaddedRaw::new();
    op.call(ctx, input_bytes, fixed_length)
}

/// DecodePng
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodePng>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodePng {
    channels: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodePng {
    fn default() -> Self {
        Self {
            channels: Some(0i64),
            dtype: Some(crate::DataType::UInt8),
            target_device_name: None,
        }
    }
}
impl DecodePng {
    /// Creates a new `DecodePng`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `channels` attribute.
    pub fn channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_png.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodePng")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.channels {
            op.set_attr_int("channels", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dtype {
            op.set_attr_type("dtype", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodePng::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodePng>
pub fn decode_png<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodePng::new();
    op.call(ctx, contents)
}

/// DecodeProtoV2
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeProtoV2>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeProtoV2 {
    message_type: ::std::option::Option<::std::string::String>,
    field_names: ::std::option::Option<::std::vec::Vec<::std::string::String>>,
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    descriptor_source: ::std::option::Option<::std::string::String>,
    message_format: ::std::option::Option<::std::string::String>,
    sanitize: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeProtoV2 {
    fn default() -> Self {
        Self {
            message_type: None,
            field_names: None,
            output_types: None,
            descriptor_source: Some(::std::string::String::from("local://")),
            message_format: Some(::std::string::String::from("binary")),
            sanitize: Some(false),
            target_device_name: None,
        }
    }
}
impl DecodeProtoV2 {
    /// Creates a new `DecodeProtoV2`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `message_type` attribute.
    pub fn message_type<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `field_names` attribute.
    pub fn field_names<ArgType: ::std::convert::Into<::std::vec::Vec<::std::string::String>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.field_names = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `descriptor_source` attribute.
    pub fn descriptor_source<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.descriptor_source = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `message_format` attribute.
    pub fn message_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.message_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `sanitize` attribute.
    pub fn sanitize<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.sanitize = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_proto_v2.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        bytes: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeProtoV2")?;

        // Required input arguments
        op.add_input(&bytes.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.message_type {
            op.set_attr_string("message_type", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.field_names {
            op.set_attr_string_list("field_names", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.descriptor_source {
            op.set_attr_string("descriptor_source", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.message_format {
            op.set_attr_string("message_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.sanitize {
            op.set_attr_bool("sanitize", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `DecodeProtoV2::new().call(&ctx, &bytes)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeProtoV2>
pub fn decode_proto_v2<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    bytes: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = DecodeProtoV2::new();
    op.call(ctx, bytes)
}

/// DecodeRaw
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeRaw>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeRaw {
    out_type: ::std::option::Option<crate::DataType>,
    little_endian: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeRaw {
    fn default() -> Self {
        Self {
            out_type: None,
            little_endian: Some(true),
            target_device_name: None,
        }
    }
}
impl DecodeRaw {
    /// Creates a new `DecodeRaw`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `out_type` attribute.
    pub fn out_type<ArgType: ::std::convert::Into<crate::DataType>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.out_type = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `little_endian` attribute.
    pub fn little_endian<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.little_endian = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_raw.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        bytes: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeRaw")?;

        // Required input arguments
        op.add_input(&bytes.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.out_type {
            op.set_attr_type("out_type", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.little_endian {
            op.set_attr_bool("little_endian", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DecodeRaw::new().call(&ctx, &bytes)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeRaw>
pub fn decode_raw<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    bytes: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DecodeRaw::new();
    op.call(ctx, bytes)
}

/// DecodeWav
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeWav>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DecodeWav {
    desired_channels: ::std::option::Option<i64>,
    desired_samples: ::std::option::Option<i64>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DecodeWav {
    fn default() -> Self {
        Self {
            desired_channels: Some(-1i64),
            desired_samples: Some(-1i64),
            target_device_name: None,
        }
    }
}
impl DecodeWav {
    /// Creates a new `DecodeWav`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `desired_channels` attribute.
    pub fn desired_channels<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.desired_channels = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `desired_samples` attribute.
    pub fn desired_samples<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.desired_samples = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute decode_wav.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        contents: &T0,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
        // Define Op
        let mut op = super::Op::new(ctx, "DecodeWav")?;

        // Required input arguments
        op.add_input(&contents.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.desired_channels {
            op.set_attr_int("desired_channels", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.desired_samples {
            op.set_attr_int("desired_samples", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<2>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `DecodeWav::new().call(&ctx, &contents)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DecodeWav>
pub fn decode_wav<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    contents: &T0,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 2]> {
    let op = DecodeWav::new();
    op.call(ctx, contents)
}

/// DeepCopy
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeepCopy>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeepCopy {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeepCopy {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeepCopy {
    /// Creates a new `DeepCopy`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute deep_copy.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        x: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeepCopy")?;

        // Required input arguments
        op.add_input(&x.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DeepCopy::new().call(&ctx, &x)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeepCopy>
pub fn deep_copy<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    x: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DeepCopy::new();
    op.call(ctx, x)
}

/// DeleteIterator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteIterator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteIterator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteIterator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteIterator {
    /// Creates a new `DeleteIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_iterator.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        deleter: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteIterator")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&deleter.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteIterator::new().call(&ctx, &handle, &deleter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteIterator>
pub fn delete_iterator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    deleter: &T1,
) -> crate::Result<()> {
    let op = DeleteIterator::new();
    op.call(ctx, handle, deleter)
}

/// DeleteMemoryCache
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteMemoryCache>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteMemoryCache {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteMemoryCache {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteMemoryCache {
    /// Creates a new `DeleteMemoryCache`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_memory_cache.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        deleter: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteMemoryCache")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&deleter.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteMemoryCache::new().call(&ctx, &handle, &deleter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteMemoryCache>
pub fn delete_memory_cache<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    deleter: &T1,
) -> crate::Result<()> {
    let op = DeleteMemoryCache::new();
    op.call(ctx, handle, deleter)
}

/// DeleteMultiDeviceIterator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteMultiDeviceIterator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteMultiDeviceIterator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteMultiDeviceIterator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteMultiDeviceIterator {
    /// Creates a new `DeleteMultiDeviceIterator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_multi_device_iterator.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        multi_device_iterator: &T0,
        iterators: &[&T1],
        deleter: &T2,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteMultiDeviceIterator")?;

        // Required input arguments
        op.add_input(&multi_device_iterator.to_handle(ctx)?)?;
        let mut iterators_list = Vec::new();

        for t in iterators {
            iterators_list.push(t.to_handle(ctx)?);
        }

        op.add_input_list(&iterators_list)?;
        op.add_input(&deleter.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteMultiDeviceIterator::new().call(&ctx, &multi_device_iterator, &iterators, &deleter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteMultiDeviceIterator>
pub fn delete_multi_device_iterator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    multi_device_iterator: &T0,
    iterators: &[&T1],
    deleter: &T2,
) -> crate::Result<()> {
    let op = DeleteMultiDeviceIterator::new();
    op.call(ctx, multi_device_iterator, iterators, deleter)
}

/// DeleteRandomSeedGenerator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteRandomSeedGenerator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteRandomSeedGenerator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteRandomSeedGenerator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteRandomSeedGenerator {
    /// Creates a new `DeleteRandomSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_random_seed_generator.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        deleter: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteRandomSeedGenerator")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&deleter.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteRandomSeedGenerator::new().call(&ctx, &handle, &deleter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteRandomSeedGenerator>
pub fn delete_random_seed_generator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    deleter: &T1,
) -> crate::Result<()> {
    let op = DeleteRandomSeedGenerator::new();
    op.call(ctx, handle, deleter)
}

/// DeleteSeedGenerator
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteSeedGenerator>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteSeedGenerator {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteSeedGenerator {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteSeedGenerator {
    /// Creates a new `DeleteSeedGenerator`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_seed_generator.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
        deleter: &T1,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteSeedGenerator")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;
        op.add_input(&deleter.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteSeedGenerator::new().call(&ctx, &handle, &deleter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteSeedGenerator>
pub fn delete_seed_generator<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
    deleter: &T1,
) -> crate::Result<()> {
    let op = DeleteSeedGenerator::new();
    op.call(ctx, handle, deleter)
}

/// DeleteSessionTensor
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteSessionTensor>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DeleteSessionTensor {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DeleteSessionTensor {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DeleteSessionTensor {
    /// Creates a new `DeleteSessionTensor`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute delete_session_tensor.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        handle: &T0,
    ) -> crate::Result<()> {
        // Define Op
        let mut op = super::Op::new(ctx, "DeleteSessionTensor")?;

        // Required input arguments
        op.add_input(&handle.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let _ = op.execute::<0>(ctx)?;
        Ok(())
    }
}

/// Shorthand for `DeleteSessionTensor::new().call(&ctx, &handle)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DeleteSessionTensor>
pub fn delete_session_tensor<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    handle: &T0,
) -> crate::Result<()> {
    let op = DeleteSessionTensor::new();
    op.call(ctx, handle)
}

/// DenseBincount
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseBincount>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseBincount {
    binary_output: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseBincount {
    fn default() -> Self {
        Self {
            binary_output: Some(false),
            target_device_name: None,
        }
    }
}
impl DenseBincount {
    /// Creates a new `DenseBincount`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `binary_output` attribute.
    pub fn binary_output<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.binary_output = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_bincount.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        size: &T1,
        weights: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseBincount")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&size.to_handle(ctx)?)?;
        op.add_input(&weights.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.binary_output {
            op.set_attr_bool("binary_output", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DenseBincount::new().call(&ctx, &input, &size, &weights)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseBincount>
pub fn dense_bincount<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    size: &T1,
    weights: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DenseBincount::new();
    op.call(ctx, input, size, weights)
}

/// DenseCountSparseOutput
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseCountSparseOutput>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseCountSparseOutput {
    minlength: ::std::option::Option<i64>,
    maxlength: ::std::option::Option<i64>,
    binary_output: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseCountSparseOutput {
    fn default() -> Self {
        Self {
            minlength: Some(-1i64),
            maxlength: Some(-1i64),
            binary_output: None,
            target_device_name: None,
        }
    }
}
impl DenseCountSparseOutput {
    /// Creates a new `DenseCountSparseOutput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `minlength` attribute.
    pub fn minlength<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.minlength = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `maxlength` attribute.
    pub fn maxlength<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.maxlength = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `binary_output` attribute.
    pub fn binary_output<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.binary_output = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_count_sparse_output.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        values: &T0,
        weights: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseCountSparseOutput")?;

        // Required input arguments
        op.add_input(&values.to_handle(ctx)?)?;
        op.add_input(&weights.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.minlength {
            op.set_attr_int("minlength", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.maxlength {
            op.set_attr_int("maxlength", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.binary_output {
            op.set_attr_bool("binary_output", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `DenseCountSparseOutput::new().call(&ctx, &values, &weights)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseCountSparseOutput>
pub fn dense_count_sparse_output<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    values: &T0,
    weights: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = DenseCountSparseOutput::new();
    op.call(ctx, values, weights)
}

/// DenseToCSRSparseMatrix
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToCSRSparseMatrix>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseToCSRSparseMatrix {
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseToCSRSparseMatrix {
    fn default() -> Self {
        Self {
            target_device_name: None,
        }
    }
}
impl DenseToCSRSparseMatrix {
    /// Creates a new `DenseToCSRSparseMatrix`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_to_csrsparse_matrix.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        dense_input: &T0,
        indices: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseToCSRSparseMatrix")?;

        // Required input arguments
        op.add_input(&dense_input.to_handle(ctx)?)?;
        op.add_input(&indices.to_handle(ctx)?)?;

        // Attributes

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DenseToCSRSparseMatrix::new().call(&ctx, &dense_input, &indices)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToCSRSparseMatrix>
pub fn dense_to_csrsparse_matrix<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    dense_input: &T0,
    indices: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DenseToCSRSparseMatrix::new();
    op.call(ctx, dense_input, indices)
}

/// DenseToDenseSetOperation
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToDenseSetOperation>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseToDenseSetOperation {
    set_operation: ::std::option::Option<::std::string::String>,
    validate_indices: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseToDenseSetOperation {
    fn default() -> Self {
        Self {
            set_operation: None,
            validate_indices: Some(true),
            target_device_name: None,
        }
    }
}
impl DenseToDenseSetOperation {
    /// Creates a new `DenseToDenseSetOperation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `set_operation` attribute.
    pub fn set_operation<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.set_operation = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_indices` attribute.
    pub fn validate_indices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_indices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_to_dense_set_operation.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        set1: &T0,
        set2: &T1,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseToDenseSetOperation")?;

        // Required input arguments
        op.add_input(&set1.to_handle(ctx)?)?;
        op.add_input(&set2.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.set_operation {
            op.set_attr_string("set_operation", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.validate_indices {
            op.set_attr_bool("validate_indices", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `DenseToDenseSetOperation::new().call(&ctx, &set1, &set2)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToDenseSetOperation>
pub fn dense_to_dense_set_operation<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    set1: &T0,
    set2: &T1,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = DenseToDenseSetOperation::new();
    op.call(ctx, set1, set2)
}

/// DenseToSparseBatchDataset
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToSparseBatchDataset>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseToSparseBatchDataset {
    output_types: ::std::option::Option<::std::vec::Vec<crate::DataType>>,
    output_shapes: ::std::option::Option<::std::vec::Vec<crate::Shape>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseToSparseBatchDataset {
    fn default() -> Self {
        Self {
            output_types: None,
            output_shapes: None,
            target_device_name: None,
        }
    }
}
impl DenseToSparseBatchDataset {
    /// Creates a new `DenseToSparseBatchDataset`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `output_types` attribute.
    pub fn output_types<ArgType: ::std::convert::Into<::std::vec::Vec<crate::DataType>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_types = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `output_shapes` attribute.
    pub fn output_shapes<ArgType: ::std::convert::Into<::std::vec::Vec<crate::Shape>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.output_shapes = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_to_sparse_batch_dataset.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_dataset: &T0,
        batch_size: &T1,
        row_shape: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseToSparseBatchDataset")?;

        // Required input arguments
        op.add_input(&input_dataset.to_handle(ctx)?)?;
        op.add_input(&batch_size.to_handle(ctx)?)?;
        op.add_input(&row_shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.output_types {
            op.set_attr_type_list("output_types", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.output_shapes {
            op.set_attr_shape_list("output_shapes", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DenseToSparseBatchDataset::new().call(&ctx, &input_dataset, &batch_size, &row_shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToSparseBatchDataset>
pub fn dense_to_sparse_batch_dataset<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_dataset: &T0,
    batch_size: &T1,
    row_shape: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DenseToSparseBatchDataset::new();
    op.call(ctx, input_dataset, batch_size, row_shape)
}

/// DenseToSparseSetOperation
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToSparseSetOperation>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DenseToSparseSetOperation {
    set_operation: ::std::option::Option<::std::string::String>,
    validate_indices: ::std::option::Option<bool>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DenseToSparseSetOperation {
    fn default() -> Self {
        Self {
            set_operation: None,
            validate_indices: Some(true),
            target_device_name: None,
        }
    }
}
impl DenseToSparseSetOperation {
    /// Creates a new `DenseToSparseSetOperation`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `set_operation` attribute.
    pub fn set_operation<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.set_operation = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `validate_indices` attribute.
    pub fn validate_indices<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.validate_indices = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dense_to_sparse_set_operation.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
        T3: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        set1: &T0,
        set2_indices: &T1,
        set2_values: &T2,
        set2_shape: &T3,
    ) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
        // Define Op
        let mut op = super::Op::new(ctx, "DenseToSparseSetOperation")?;

        // Required input arguments
        op.add_input(&set1.to_handle(ctx)?)?;
        op.add_input(&set2_indices.to_handle(ctx)?)?;
        op.add_input(&set2_values.to_handle(ctx)?)?;
        op.add_input(&set2_shape.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.set_operation {
            op.set_attr_string("set_operation", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.validate_indices {
            op.set_attr_bool("validate_indices", *value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let handles = op.execute::<3>(ctx)?;
        Ok(handles)
    }
}

/// Shorthand for `DenseToSparseSetOperation::new().call(&ctx, &set1, &set2_indices, &set2_values, &set2_shape)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DenseToSparseSetOperation>
pub fn dense_to_sparse_set_operation<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
    T3: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    set1: &T0,
    set2_indices: &T1,
    set2_values: &T2,
    set2_shape: &T3,
) -> crate::Result<[crate::eager::TensorHandle<'a>; 3]> {
    let op = DenseToSparseSetOperation::new();
    op.call(ctx, set1, set2_indices, set2_values, set2_shape)
}

/// DepthToSpace
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthToSpace>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DepthToSpace {
    block_size: ::std::option::Option<i64>,
    data_format: ::std::option::Option<::std::string::String>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DepthToSpace {
    fn default() -> Self {
        Self {
            block_size: None,
            data_format: Some(::std::string::String::from("NHWC")),
            target_device_name: None,
        }
    }
}
impl DepthToSpace {
    /// Creates a new `DepthToSpace`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `block_size` attribute.
    pub fn block_size<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.block_size = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute depth_to_space.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DepthToSpace")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.block_size {
            op.set_attr_int("block_size", *value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DepthToSpace::new().call(&ctx, &input)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthToSpace>
pub fn depth_to_space<'a, T0: crate::eager::ToTensorHandle<'a>>(
    ctx: &'a crate::eager::Context,
    input: &T0,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DepthToSpace::new();
    op.call(ctx, input)
}

/// DepthwiseConv2dNative
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNative>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DepthwiseConv2dNative {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DepthwiseConv2dNative {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl DepthwiseConv2dNative {
    /// Creates a new `DepthwiseConv2dNative`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute depthwise_conv2d_native.
    pub fn call<'a, T0: crate::eager::ToTensorHandle<'a>, T1: crate::eager::ToTensorHandle<'a>>(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter: &T1,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DepthwiseConv2dNative")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DepthwiseConv2dNative::new().call(&ctx, &input, &filter)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNative>
pub fn depthwise_conv2d_native<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter: &T1,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DepthwiseConv2dNative::new();
    op.call(ctx, input, filter)
}

/// DepthwiseConv2dNativeBackpropFilter
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNativeBackpropFilter>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DepthwiseConv2dNativeBackpropFilter {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DepthwiseConv2dNativeBackpropFilter {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl DepthwiseConv2dNativeBackpropFilter {
    /// Creates a new `DepthwiseConv2dNativeBackpropFilter`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute depthwise_conv2d_native_backprop_filter.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        filter_sizes: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DepthwiseConv2dNativeBackpropFilter")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&filter_sizes.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DepthwiseConv2dNativeBackpropFilter::new().call(&ctx, &input, &filter_sizes, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNativeBackpropFilter>
pub fn depthwise_conv2d_native_backprop_filter<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input: &T0,
    filter_sizes: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DepthwiseConv2dNativeBackpropFilter::new();
    op.call(ctx, input, filter_sizes, out_backprop)
}

/// DepthwiseConv2dNativeBackpropInput
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNativeBackpropInput>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct DepthwiseConv2dNativeBackpropInput {
    strides: ::std::option::Option<::std::vec::Vec<i64>>,
    padding: ::std::option::Option<::std::string::String>,
    explicit_paddings: ::std::option::Option<::std::vec::Vec<i64>>,
    data_format: ::std::option::Option<::std::string::String>,
    dilations: ::std::option::Option<::std::vec::Vec<i64>>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for DepthwiseConv2dNativeBackpropInput {
    fn default() -> Self {
        Self {
            strides: None,
            padding: None,
            explicit_paddings: Some(vec![]),
            data_format: Some(::std::string::String::from("NHWC")),
            dilations: Some(vec![1, 1, 1, 1]),
            target_device_name: None,
        }
    }
}
impl DepthwiseConv2dNativeBackpropInput {
    /// Creates a new `DepthwiseConv2dNativeBackpropInput`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `strides` attribute.
    pub fn strides<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.strides = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `padding` attribute.
    pub fn padding<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.padding = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `explicit_paddings` attribute.
    pub fn explicit_paddings<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.explicit_paddings = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `data_format` attribute.
    pub fn data_format<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.data_format = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dilations` attribute.
    pub fn dilations<ArgType: ::std::convert::Into<::std::vec::Vec<i64>>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.dilations = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute depthwise_conv2d_native_backprop_input.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input_sizes: &T0,
        filter: &T1,
        out_backprop: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "DepthwiseConv2dNativeBackpropInput")?;

        // Required input arguments
        op.add_input(&input_sizes.to_handle(ctx)?)?;
        op.add_input(&filter.to_handle(ctx)?)?;
        op.add_input(&out_backprop.to_handle(ctx)?)?;

        // Attributes
        if let ::std::option::Option::Some(value) = &self.strides {
            op.set_attr_int_list("strides", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.padding {
            op.set_attr_string("padding", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.explicit_paddings {
            op.set_attr_int_list("explicit_paddings", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.data_format {
            op.set_attr_string("data_format", value)?;
        }
        if let ::std::option::Option::Some(value) = &self.dilations {
            op.set_attr_int_list("dilations", value)?;
        }

        // Set the device name where this Op will be executed
        if let ::std::option::Option::Some(value) = &self.target_device_name {
            op.set_device(value)?;
        }
        // Execute Op
        let [h] = op.execute::<1>(ctx)?;
        Ok(h)
    }
}

/// Shorthand for `DepthwiseConv2dNativeBackpropInput::new().call(&ctx, &input_sizes, &filter, &out_backprop)`.
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/DepthwiseConv2dNativeBackpropInput>
pub fn depthwise_conv2d_native_backprop_input<
    'a,
    T0: crate::eager::ToTensorHandle<'a>,
    T1: crate::eager::ToTensorHandle<'a>,
    T2: crate::eager::ToTensorHandle<'a>,
>(
    ctx: &'a crate::eager::Context,
    input_sizes: &T0,
    filter: &T1,
    out_backprop: &T2,
) -> crate::Result<crate::eager::TensorHandle<'a>> {
    let op = DepthwiseConv2dNativeBackpropInput::new();
    op.call(ctx, input_sizes, filter, out_backprop)
}

/// Dequantize
///
/// See : <https://www.tensorflow.org/api_docs/python/tf/raw_ops/Dequantize>
#[derive(::std::fmt::Debug, ::std::clone::Clone)]
pub struct Dequantize {
    mode: ::std::option::Option<::std::string::String>,
    narrow_range: ::std::option::Option<bool>,
    axis: ::std::option::Option<i64>,
    dtype: ::std::option::Option<crate::DataType>,
    /// (Rust wrapper specific) A device name where this op will be executed
    target_device_name: ::std::option::Option<::std::string::String>,
}
impl ::std::default::Default for Dequantize {
    fn default() -> Self {
        Self {
            mode: Some(::std::string::String::from("MIN_COMBINED")),
            narrow_range: Some(false),
            axis: Some(-1i64),
            dtype: Some(crate::DataType::Float),
            target_device_name: None,
        }
    }
}
impl Dequantize {
    /// Creates a new `Dequantize`.
    pub fn new() -> Self {
        Self::default()
    }

    /// Sets the `mode` attribute.
    pub fn mode<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.mode = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `narrow_range` attribute.
    pub fn narrow_range<ArgType: ::std::convert::Into<bool>>(mut self, value: ArgType) -> Self {
        self.narrow_range = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `axis` attribute.
    pub fn axis<ArgType: ::std::convert::Into<i64>>(mut self, value: ArgType) -> Self {
        self.axis = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `dtype` attribute.
    pub fn dtype<ArgType: ::std::convert::Into<crate::DataType>>(mut self, value: ArgType) -> Self {
        self.dtype = ::std::option::Option::Some(value.into());
        self
    }

    /// Sets the `` attribute.
    pub fn target_device_name<ArgType: ::std::convert::Into<::std::string::String>>(
        mut self,
        value: ArgType,
    ) -> Self {
        self.target_device_name = ::std::option::Option::Some(value.into());
        self
    }

    /// Execute dequantize.
    pub fn call<
        'a,
        T0: crate::eager::ToTensorHandle<'a>,
        T1: crate::eager::ToTensorHandle<'a>,
        T2: crate::eager::ToTensorHandle<'a>,
    >(
        &self,
        ctx: &'a crate::eager::Context,
        input: &T0,
        min_range: &T1,
        max_range: &T2,
    ) -> crate::Result<crate::eager::TensorHandle<'a>> {
        // Define Op
        let mut op = super::Op::new(ctx, "Dequantize")?;

        // Required input arguments
        op.add_input(&input.to_handle(ctx)?)?;
        op.add_input(&min_range.to_handle(ctx)?)?;
        op.add_input(&max_range.to_handle(ctx)?)?;

        // Attrib