use clap::{App, Arg};

use crate::util::consts::{DESC, NAME, VERSION};

pub fn parse_opts() -> App<'static, 'static> {
    App::new(NAME)
        .version(VERSION)
        .author("Jacob Menke. <linux.dev25@gmail.com>")
        .about(DESC)
        .arg(Arg::with_name("input")
            .short("i")
            .long("input")
            .value_name("INDEX")
            .help("Set tempfile INDEX to write into")
            .takes_value(true))
        .arg(Arg::with_name("output")
            .short("o")
            .long("output")
            .value_name("INDEX")
            .allow_hyphen_values(true)
            .help("Set tempfile INDEX to read from")
            .takes_value(true))
        .arg(Arg::with_name("add")
            .short("a")
            .long("add")
            .value_name("INDEX")
            .allow_hyphen_values(true)
            .help("Insert tempfile at INDEX")
            .takes_value(true))
        .arg(Arg::with_name("remove")
            .short("r")
            .long("remove")
            .value_name("INDEX")
            .allow_hyphen_values(true)
            .help("Set tempfile INDEX to remove")
            .takes_value(true))
        .arg(Arg::with_name("pop")
            .short("p")
            .long("pop")
            .help("Remove from top of stack"))
        .arg(Arg::with_name("shift")
            .short("s")
            .long("shift")
            .help("Remove from bottom of stack"))
        .arg(Arg::with_name("argfile")
            .help("Read input FILE into a new tempfile. If stdin is present the tempfile is created from stdin instead.")
            .required(false)
            .index(1))
        .arg(Arg::with_name("list_files")
            .short("l")
            .long("list-files")
            .help("List all tempfiles on the stack to stdout"))
        .arg(Arg::with_name("list_contents")
            .short("L")
            .long("list-contents")
            .help("List all tempfiles with contents on the stack to stdout"))
        .arg(Arg::with_name("silent")
            .short("q")
            .long("quiet")
            .help("No output when creating tempfile"))
        .arg(Arg::with_name("clear")
            .short("c")
            .long("clear")
            .help("Remove all tempfiles"))
        .arg(Arg::with_name("verbose")
            .short("v")
            .long("verbose")
            .help("Set the level of verbosity"))
}
