// This file is auto generated by [`cg`] from [`schema`].
//
// **DO NOT EDIT THIS FILE**,
//
// Edit `cg` or `schema` instead.
//
// [cg]: https://github.com/teloxide/cg
// [`schema`]: https://github.com/WaffleLapkin/tg-methods-schema
use serde::Serialize;
use url::Url;

use crate::types::True;

impl_payload! {
    /// Use this method to send answers to callback queries sent from [inline keyboards]. The answer will be displayed to the user as a notification at the top of the chat screen or as an alert. On success, True is returned.
    ///
    /// >Alternatively, the user can be redirected to the specified Game URL. For this option to work, you must first create a game for your bot via [@Botfather] and accept the terms. Otherwise, you may use links like `t.me/your_bot?start=XXXX` that open your bot with a parameter.
    ///
    /// [inline keyboards]: https://core.telegram.org/bots#inline-keyboards-and-on-the-fly-updating
    /// [@Botfather]: https://t.me/botfather
    #[derive(Debug, PartialEq, Eq, Hash, Clone, Serialize)]
    pub AnswerCallbackQuery (AnswerCallbackQuerySetters) => True {
        required {
            /// Unique identifier for the query to be answered
            pub callback_query_id: String [into],
        }
        optional {
            /// Text of the notification. If not specified, nothing will be shown to the user, 0-200 characters
            pub text: String [into],
            /// If true, an alert will be shown by the client instead of a notification at the top of the chat screen. Defaults to false.
            pub show_alert: bool,
            /// URL that will be opened by the user's client. If you have created a [`Game`] and accepted the conditions via [@Botfather], specify the URL that opens your game — note that this will only work if the query comes from a _[callback\_game]_ button.
            ///
            /// Otherwise, you may use links like `t.me/your\_bot?start=XXXX` that open your bot with a parameter.
            ///
            /// [callback_game]: https://core.telegram.org/bots/api#inlinekeyboardbutton
            /// [@Botfather]: https://t.me/botfather
            /// [`Game`]: crate::types::Game
            pub url: Url,
            /// The maximum amount of time in seconds that the result of the callback query may be cached client-side. Telegram apps will support caching starting in version 3.14. Defaults to 0.
            pub cache_time: u32,
        }
    }
}
