// This file is auto generated by [`cg`] from [`schema`].
//
// **DO NOT EDIT THIS FILE**,
//
// Edit `cg` or `schema` instead.
//
// [cg]: https://github.com/teloxide/cg
// [`schema`]: https://github.com/WaffleLapkin/tg-methods-schema
use serde::Serialize;
use url::Url;

use crate::types::{AllowedUpdate, InputFile, True};

impl_payload! {
    @[multipart = certificate]
    /// Use this method to specify a url and receive incoming updates via an outgoing webhook. Whenever there is an update for the bot, we will send an HTTPS POST request to the specified url, containing a JSON-serialized [`Update`]. In case of an unsuccessful request, we will give up after a reasonable amount of attempts. Returns True on success.
    ///
    /// If you'd like to make sure that the Webhook request comes from Telegram, we recommend using a secret path in the URL, e.g. `https://www.example.com/<token>`. Since nobody else knows your bot's token, you can be pretty sure it's us.
    ///
    /// [`Update`]: crate::types::Update
    #[derive(Debug, Clone, Serialize)]
    pub SetWebhook (SetWebhookSetters) => True {
        required {
            /// HTTPS url to send updates to. Use an empty string to remove webhook integration
            pub url: Url,
        }
        optional {
            /// Upload your public key certificate so that the root certificate in use can be checked. See our [self-signed guide] for details.
            ///
            /// [self-signed guide]: https://core.telegram.org/bots/self-signed
            pub certificate: InputFile,
            /// The fixed IP address which will be used to send webhook requests instead of the IP address resolved through DNS
            pub ip_address: String [into],
            /// Maximum allowed number of simultaneous HTTPS connections to the webhook for update delivery, 1-100. Defaults to 40. Use lower values to limit the load on your bot's server, and higher values to increase your bot's throughput.
            pub max_connections: u8,
            /// A JSON-serialized list of the update types you want your bot to receive. For example, specify [“message”, “edited_channel_post”, “callback_query”] to only receive updates of these types. See [`Update`] for a complete list of available update types. Specify an empty list to receive all updates regardless of type (default). If not specified, the previous setting will be used.
            ///
            /// Please note that this parameter doesn't affect updates created before the call to the setWebhook, so unwanted updates may be received for a short period of time.
            ///
            /// [`Update`]: crate::types::Update
            pub allowed_updates: Vec<AllowedUpdate> [collect],
            /// Pass _True_ to drop all pending updates
            pub drop_pending_updates: bool,
        }
    }
}
