use crate::Error;

#[cfg(target_os = "macos")]
mod macos;

#[cfg(target_os = "linux")]
mod linux;

#[cfg(target_os = "windows")]
mod windows;

pub trait Vulnerability {
    fn backend_name() -> &'static str;
    fn trigger(&self, length: usize) -> Result<(), Error>;
    fn supported(&self) -> bool;
}
