use crate::Error;
use std::time::Duration;

use super::Vulnerability;
use crate::SwitchDevice;

impl Vulnerability for SwitchDevice {
    fn backend_name() -> &'static str {
        "macos"
    }

    fn trigger(&self, length: usize) -> Result<(), Error> {
        const GET_STATUS: u8 = 0x0;
        const STANDARD_REQUEST_DEVICE_TO_HOST_TO_ENDPOINT: u8 = 0x82;

        let mut buf = vec![0u8; length];

        self.device().read_control(
            STANDARD_REQUEST_DEVICE_TO_HOST_TO_ENDPOINT,
            GET_STATUS,
            0,
            0,
            &mut buf,
            Duration::from_secs(1),
        )?;

        Ok(())
    }

    fn supported(&self) -> bool {
        true
    }
}
