//! Physical addresses to various
//! peripherals and settings.
#![allow(dead_code)]
pub const NVIC_IRQ_ENABLE_REG: u32 = 0xE000E100;
pub const NVIC_IRQ_CLEAR_REG: u32 = 0xE000E180;
pub const NVIC_IRQ_CLEAR_PENDING_REG: u32 = 0xE000E280;
pub const NVIC_IRQ_PRIORITY_REG: u32 = 0xE000E400;
/** UART */
pub const UART1: u32 = 0x4018_4000;
pub const UART2: u32 = 0x4018_8000;
pub const UART3: u32 = 0x4018_C000;
pub const UART4: u32 = 0x4019_0000;
pub const UART5: u32 = 0x4019_4000;
pub const UART6: u32 = 0x4019_8000;
pub const UART7: u32 = 0x4019_C000;
pub const UART8: u32 = 0x401A_0000;
/** Fast Ram (512kb) */
pub const OCRAM: u32 = 0x2028_0000;
/** Slow Ram (512kb) */
pub const OCRAM2: u32 = 0x2020_0000;
/** GPIO Registers */
pub const GPIO1: u32 = 0x401B_8000;
pub const GPIO2: u32 = 0x401B_C000;
pub const GPIO3: u32 = 0x401C_0000;
pub const GPIO4: u32 = 0x401C_4000;
pub const GPIO5: u32 = 0x400C_0000;
pub const GPIO6: u32 = 0x4200_0000;
pub const GPIO7: u32 = 0x4200_4000;
pub const GPIO8: u32 = 0x4200_8000;
pub const GPIO9: u32 = 0x4200_C000;
/** General Purpose Timers */
pub const GPT1: u32 = 0x401E_C000;
pub const GPT2: u32 = 0x401F_0000;
/** Periodic Timers */
pub const PIT: u32 = 0x4008_4000;
/** GPIO General Purpose Registers */
pub const IOMUXC_GPR_GPR26: u32 = 0x400A_C068; // GPIO1 and GPIO6 mux settings
pub const IOMUXC_GPR_GPR27: u32 = 0x400A_C06C; // GPIO2 and GPIO7 mux settings
pub const IOMUXC_GPR_GPR28: u32 = 0x400A_C070; // GPIO3 and GPIO8 mux settings
pub const IOMUXC_GPR_GPR29: u32 = 0x400A_C074; // GPIO4 and GPIO9 mux settings
/** GPIO Mux Pads */
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_01: u32 = 0x401F_80C0;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_00: u32 = 0x401F_80BC;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_03: u32 = 0x401F_80C8;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_02: u32 = 0x401F_80C4;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_04: u32 = 0x401F_8024;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_05: u32 = 0x401F_8028;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_06: u32 = 0x401F_802C;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_08: u32 = 0x401F_8034;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_10: u32 = 0x401F_8164;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B1_01: u32 = 0x401F_8180;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B1_00: u32 = 0x401F_817C;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_11: u32 = 0x401F_8168;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_00: u32 = 0x401F_813C;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_02: u32 = 0x401F_8144;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_01: u32 = 0x401F_8140;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_03: u32 = 0x401F_8148;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_02: u32 = 0x401F_8104;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_03: u32 = 0x401F_8108;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_07: u32 = 0x401F_8118;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_06: u32 = 0x401F_8114;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_01: u32 = 0x401F_8100;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_00: u32 = 0x401F_80FC;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_10: u32 = 0x401F_8124;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_11: u32 = 0x401F_8128;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_08: u32 = 0x401F_811C;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_09: u32 = 0x401F_8120;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_12: u32 = 0x401F_80EC;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_13: u32 = 0x401F_80F0;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_14: u32 = 0x401F_8134;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B1_15: u32 = 0x401F_8138;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_32: u32 = 0x401F_8094;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_31: u32 = 0x401F_8090;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_37: u32 = 0x401F_80A8;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_36: u32 = 0x401F_80A4;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_B0_12: u32 = 0x401F_816C;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_EMC_07: u32 = 0x401F_8030;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_03: u32 = 0x401F_81C8;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_02: u32 = 0x401F_81C4;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_01: u32 = 0x401F_81C0;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_00: u32 = 0x401F_81BC;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_05: u32 = 0x401F_81D0;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_SD_B0_04: u32 = 0x401F_81CC;
pub const SW_MUX_CTL_PAD_GPIO_B0_14: u32 = 0x401F_8174;
pub const IOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_12: u32 = 0x401F_82DC;
pub const IOMUXC_SW_MUX_CTL_PAD_GPIO_AD_B0_14: u32 = 0x401F_80F4;
pub const IOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_02: u32 = 0x401F_82B4;
pub const IOMUXC_SW_PAD_CTL_PAD_GPIO_AD_B0_03: u32 = 0x401F_82B8;
pub const IOMUXC_LPUART2_RX_SELECT_INPUT: u32 = 0x401F_852C;
pub const IOMUXC_LPUART3_RX_SELECT_INPUT: u32 = 0x401F_8538;
pub const IOMUXC_LPUART4_RX_SELECT_INPUT: u32 = 0x401F_8540;
pub const IOMUXC_LPUART5_RX_SELECT_INPUT: u32 = 0x401F_8548;
pub const IOMUXC_LPUART6_RX_SELECT_INPUT: u32 = 0x401F_8550;
pub const IOMUXC_LPUART7_RX_SELECT_INPUT: u32 = 0x401F_8558;
pub const IOMUXC_LPUART8_RX_SELECT_INPUT: u32 = 0x401F_8560;
/** Clocks */
pub const CCM_CACRR: u32 = 0x400F_C010;
pub const CCM_CBCMR: u32 = 0x400F_C018;
pub const CCM_CBCDR: u32 = 0x400F_C014;
pub const CCM_ANALOG_PLL_ARM: u32 = 0x400D_8000;
pub const CCM_ANALOG_PLL_ARM_SET: u32 = 0x400D_8004;
pub const CCM_ANALOG_PLL_ARM_CLR: u32 = 0x400D_8008;
/** DMA */
pub const DMA: u32 = 0x400E_8000;
pub const DMAMUX: u32 = 0x400E_C000;
/** XBAR */
pub const IMXRT_XBARA1: u32 = 0x403B_C000;
pub const IMXRT_XBARB2: u32 = 0x403C_0000;
pub const IMXRT_XBARB3: u32 = 0x403C4000;
/** Misc */
pub const CCM_CSCMR1: u32 = 0x400F_C01C; // CCM Serial Clock Multiplexer Register 1
pub const CCM_CCGR0: u32 = 0x400F_C068; // Clock Gating Register 1
pub const CCM_CCGR1: u32 = 0x400F_C06C; // Clock Gating Register 1
pub const CCM_CCGR2: u32 = 0x400F_C070;
pub const CCM_CCGR3: u32 = 0x400F_C074;
pub const CCM_CCGR4: u32 = 0x400F_C078;
pub const CCM_CCGR5: u32 = 0x400F_C07C;