pub mod api;
pub mod error;
pub mod response;
mod client;
use api::{account::*, message::*};
use client::Client as Clientx;

#[derive(Clone)]
pub struct Client {
    client: Clientx
}

impl Client {
    pub fn new<T: Into<String>>(sdkappid: u64, identifier: T, key: T) -> Client {
        Client {client: Clientx::new(sdkappid, identifier, key)}
    }

    pub fn account(&self) -> AccountApi {
        AccountApi::new(&self.client)
    }

    pub fn message(&self) -> MessageApi {
        MessageApi::new(&self.client)
    }
}
