use thiserror::Error;

#[derive(Error, Debug)]
pub enum Error {
    #[error(transparent)]
    IO(#[from] std::io::Error),
    #[error(transparent)]
    Net(#[from] reqwest::Error),
    #[error(transparent)]
    JsonSerdeError(#[from] serde_json::error::Error),
    #[error("failed to request, code: {code}, msg: {msg}")]
    RemoteError{
        code: u32,
        msg: String
    },
    #[error("unknown error occurred")]
    Unknown,
}
