use crate::client::Client;
use serde::{Serialize, Deserialize};


#[derive(Debug, Serialize, Deserialize)]
pub struct Message {

}

#[derive(Debug, Deserialize)]
pub struct SendResp {

}

#[derive(Debug, Serialize, Deserialize)]
pub struct BatchMessage {

}

#[derive(Debug, Deserialize)]
pub struct BatchSendResp {

}

pub struct MessageApi<'a> {
    pub inner: &'a Client
}

impl<'a> MessageApi<'a> {
    define_api!(send, "v4/openim/sendmsg", Message, SendResp);
    define_api!(batch_send, "v4/openim/batchsendmsg", BatchMessage, BatchSendResp);
    define_api!(import, "v4/openim/importmsg", BatchMessage, BatchSendResp);
    // 查询消息
    define_api!(roamnsg, "v4/openim/admin_getroammsg", BatchMessage, BatchSendResp);
    // 撤回
    define_api!(draw, "v4/openim/admin_msgwithdraw", BatchMessage, BatchSendResp);
    // 设置为已读
    define_api!(mark_read, "v4/openim/admin_set_msg_read", BatchMessage, BatchSendResp);
    // 未读计数
    define_api!(unread_count, "v4/openim/get_c2c_unread_msg_num", BatchMessage, BatchSendResp);
}