macro_rules! define_api {
    ($name:ident, $url:expr, $req:ty, $resp:ty) => {
        pub async fn $name<R: Into<$req>>(&self, data: R) -> Result<$resp, crate::error::Error> {
            self.inner.request(
                &format!("https://console.tim.qq.com{}", $url),
                &data.into()
            ).await
        }
    };
}