pub mod api;
pub mod error;
pub mod response;
mod client;
use api::{account::AccountApi, message::MessageApi};
use client::Client as Clientx;

pub struct Client {
    client: Clientx
}

impl Client {
    pub fn new<T: Into<String>>(sdkappid: u64, identifier: T, key: T) -> Client {
        Client {client: Clientx::new(sdkappid, identifier, key)}
    }

    pub fn account(&self) -> AccountApi {
        AccountApi {inner: &self.client}
    }

    pub fn message(&self) -> MessageApi {
        MessageApi {inner: &self.client}
    }
}
