use argh::FromArgs;
use std::io::{Read, Write};
use std::process::{Command, Stdio};
use std::thread;


mod app;

use app::App;


#[derive(FromArgs)]
// Foo
#[argh(description = "asd")]
struct Args {
    #[argh(
        switch,
        description = "don't add a carriage return on new lines received from child command's stdout"
    )]
    //Bar
    no_crlf: bool,

    #[argh(positional, description = "asd")]
    // foo
    command: String,

    #[argh(positional, description = "asd")]
    // foo
    args: Vec<String>,
}

fn main() {
    let args: Args = argh::from_env();

    let command = args.command;
    let command_args = args.args;

    let child = Command::new(&command)
        .args(&command_args[..])
        .stdin(Stdio::piped())
        .stdout(Stdio::piped())
        .spawn()
        .unwrap();

    let mut child_stdin = child.stdin.unwrap();
    let mut child_stdout = child.stdout.unwrap();

    let handler = |command: String| -> Result<(), String> {
        child_stdin
            .write_all(command.as_bytes())
            .map_err(|e| format!("Error writing to child process: {:?}", e.kind()))
    };

    thread::spawn(move || -> ! {
        let mut buf = [0, 128];
        loop {
            let read_size = child_stdout.read(&mut buf);
            if let Ok(n) = read_size {
                let read_string = String::from_utf8_lossy(&buf[0..n]);

                if !args.no_crlf {
                    print!("{}", read_string.replace("\n", "\r\n"));
                } else {
                    print!("{}", read_string);
                };
            }
        }
    });

    let app = App::new(handler);

    app.run();
}
