pub use crate::blocks::chain::*;
use std::fs;
use std::io::ErrorKind;

///
/// Creates a directory for the node to store data
/// such as keys and logs
///
pub fn create_node_file() {
    // Create file for node
    match fs::create_dir("./.node") {
        Ok(nodefd) => nodefd,
        Err(error) => {
            if error.kind() == ErrorKind::AlreadyExists {
                println!("{:?}", error);
            } else {
                panic!("Problem opening file: {}", error)
            }
        }
    };
}

///
/// Start a loop for main interface
/// (Not an actual daemon)
///
pub fn daemon_startup(bc_file: &'static str) -> std::io::Result<()> {
    let _bc_db = get_lmdb_connection(bc_file).unwrap();
    let mut bc = std::collections::HashMap::new();
    let current_block: Block = Block::default();

    bc.insert(
        &mut current_block.header.index.to_string().as_str(),
        current_block,
    );

    Ok(())
}
