extern crate openssl;

use openssl::rsa::Rsa;
use std::fs;
use std::io::ErrorKind;

///
/// Generate a new 4096 bit RSA private key
///
/// # Examples
/// ```
/// use crate::tcrypto::gen_key::crypto::gen_key;
///
/// fn main() {
///     gen_key();
/// }
/// ```
///
pub fn gen_key() {
    // Create directory for keys
    let key_path = std::path::Path::new("./.keys");

    let key_dir = fs::create_dir(key_path);
    match key_dir {
        Err(why) => {
            if why.kind() == ErrorKind::AlreadyExists {
                println!("Already have keys");
            } else {
                panic!("Problem creating keys directory: {}", why)
            }
        }
        Ok(_) => {
            println!("Key directory created")
        }
    }

    // Generate 4096 bit RSA private key
    let priv_key = Rsa::generate(4096).expect("ERROR").private_key_to_pem();

    // Write new key to file
    match fs::write(".keys/privkey.pem", priv_key.unwrap()) {
        Err(why) => panic!("ERROR: {}", why.to_string()),
        Ok(_) => println!("Private key file created"),
    }
}
