//!
//! Contians structs and methods for
//! Interacting with the blockchain
//!
pub mod block;
pub mod chain;

#[cfg(test)]
mod tests {
    use crate::blocks::chain::*;

    #[test]
    fn test_new_block() -> std::io::Result<()> {
        let _new_block: Block = Block::default();
        Ok(())
    }

    #[test]
    fn test_get_lmdb_connection() -> std::io::Result<()> {
        let db = get_lmdb_connection("test_blockchaindb").unwrap();
        let block = Block::default();
        let tx = lmdb_zero::WriteTransaction::new(db.env()).unwrap();
        {
            let mut access = tx.access();
            access
                .put(&db, "test", &block, lmdb_zero::put::Flags::empty())
                .unwrap();
        }
        tx.commit().unwrap();

        let new_tx = lmdb_zero::ReadTransaction::new(db.env()).unwrap();
        {
            let access = new_tx.access();
            let n_block = access.get::<str, Block>(&db, "test").unwrap();
            assert_eq!(n_block.header.index, block.header.index);
        }
        Ok(())
    }

    #[test]
    fn test_blockchain() {
        let _bc: Blockchain = init_blockchain("test_blockchaindb").unwrap();
    }

    #[test]
    fn test_get_blockchain_tip() {
        let bc = Blockchain::default();
        bc.get_tip();
    }
}
