use std::marker::PhantomData;
pub trait USizeWrapper {
    fn usize_unwrap(self) -> usize;
    fn usize_wrap(_: usize) -> Self;
}

macro_rules! id_wrappers {
    ( $( $x:ident ),* $(,)* ) => {
        $(
            #[derive(Serialize,Deserialize,Clone,Copy,Debug,Default,PartialEq,Eq,PartialOrd,Ord,Hash)]
            pub struct $x(usize);

            impl USizeWrapper for $x {
                fn usize_unwrap(self) -> usize {
                    let $x(ix) = self;
                    ix
                }
                fn usize_wrap(id: usize) -> $x {
                    $x(id)
                }
            }
        )*
    }
}

#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, Default)]
pub struct IDCounter<ID>(usize, PhantomData<ID>);

impl<ID> IDCounter<ID>
where
    ID: USizeWrapper,
{
    pub fn increment(&mut self) -> ID {
        let id = USizeWrapper::usize_wrap(self.0);
        self.0 += 1;
        id
    }
}

id_wrappers!(PlayerID, DeckID, CardID, GridID, EventID,);
