#![allow(dead_code)]
pub type Point = (isize, isize);

#[derive(Clone, Copy, Debug)]
pub struct Degree(i8);
pub const DEG_45: Degree = Degree(1);
pub const DEG_90: Degree = Degree(2);
pub const DEG_135: Degree = Degree(3);
pub const DEG_180: Degree = Degree(4);

pub const NORTH: Ordinal = Ordinal(0);
pub const NORTHEAST: Ordinal = Ordinal(1);
pub const EAST: Ordinal = Ordinal(2);
pub const SOUTHEAST: Ordinal = Ordinal(3);
pub const SOUTH: Ordinal = Ordinal(4);
pub const SOUTHWEST: Ordinal = Ordinal(5);
pub const WEST: Ordinal = Ordinal(6);
pub const NORTHWEST: Ordinal = Ordinal(7);

#[derive(Clone, Copy, Debug, PartialEq, Eq, PartialOrd, Ord, Hash, Serialize, Deserialize)]
pub struct Ordinal(pub i8);

impl Ordinal {
    #[inline]
    pub fn is_diag(self) -> bool {
        self.0 % 2 != 0
    }

    pub fn is_horz(self) -> bool {
        self.0 % 2 == 0
    }
}

#[inline]
pub fn rotate_c(Degree(rot): Degree, Ordinal(d): Ordinal) -> Ordinal {
    let d2 = d + rot;
    if d2 >= 8 {
        Ordinal(d2 - 8)
    } else {
        Ordinal(d2)
    }
}

#[inline]
pub fn rotate_cc(Degree(rot): Degree, Ordinal(d): Ordinal) -> Ordinal {
    if rot > d {
        Ordinal(8 + d - rot)
    } else {
        Ordinal(d - rot)
    }
}

#[inline]
pub fn translate(n: isize, ord: Ordinal, (x, y): Point) -> Point {
    match ord {
        NORTH => (x, y + n),
        NORTHEAST => (x + n, y + n),
        EAST => (x + n, y),
        SOUTHEAST => (x + n, y - n),
        SOUTH => (x, y - n),
        SOUTHWEST => (x - n, y - n),
        WEST => (x - n, y),
        _ => (x - n, y + n),
        //Ordinal(_) => panic!("translate: Ordinal is out of range [0-8)."),
    }
}
