use crate::usize_wrapper::{CardID, DeckID, GridID, PlayerID};
use crate::attribute::Attribute;
use std::collections::{BTreeMap, BTreeSet};
#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, Default)]
pub struct Player<AttName>
where
    AttName: Ord,
{
    id: PlayerID,
    name: String,
    attributes: BTreeMap<AttName, Attribute>,
}

impl<AttName> Player<AttName>
where
    AttName: Ord,
{
    pub fn new(id: PlayerID, name: String) -> Player<AttName> {
        Player {
            id,
            name: name,
            attributes: BTreeMap::new(),
        }
    }
    pub fn id(&self) -> PlayerID {
        self.id
    }

    pub fn name(&self) -> &str {
        &self.name
    }

    pub fn int(&self, att: AttName) -> Option<isize> {
        self.attributes.get(&att)?.int()
    }

    pub fn text(&self, att: AttName) -> Option<&str> {
        self.attributes.get(&att)?.text()
    }

    pub fn flag(&self, att: AttName) -> Option<bool> {
        self.attributes.get(&att)?.flag()
    }

    pub fn set(&self, att: AttName) -> Option<&BTreeSet<Attribute>> {
        self.attributes.get(&att)?.set()
    }

    pub fn card_id(&self, att: AttName) -> Option<CardID> {
        self.attributes.get(&att)?.card_id()
    }

    pub fn deck_id(&self, att: AttName) -> Option<DeckID> {
        self.attributes.get(&att)?.deck_id()
    }

    pub fn grid_id(&self, att: AttName) -> Option<GridID> {
        self.attributes.get(&att)?.grid_id()
    }

    pub fn player_id(&self, att: AttName) -> Option<PlayerID> {
        self.attributes.get(&att)?.player_id()
    }

    pub fn att(&mut self, name: AttName, att: Attribute) {
        self.attributes.insert(name, att);
    }
}
