use crate::usize_wrapper::{CardID, DeckID, GridID, PlayerID};
use crate::cardinal::Point;
use std::collections::{BTreeSet};

#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, PartialOrd, Ord, Hash, Debug)]
pub enum Attribute {
    Text(String),
    Int(isize),
    Flag(bool),
    Set(BTreeSet<Attribute>),
    CardID(CardID),
    PlayerID(PlayerID),
    GridID(GridID),
    DeckID(DeckID),
    GridPoint((GridID,Point)),
}

impl Attribute {
    pub fn int(&self) -> Option<isize> {
        if let Attribute::Int(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn text(&self) -> Option<&str> {
        if let Attribute::Text(a) = self {
            Some(a)
        } else {
            None
        }
    }

    pub fn flag(&self) -> Option<bool> {
        if let Attribute::Flag(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn set(&self) -> Option<&BTreeSet<Attribute>> {
        if let Attribute::Set(a) = self {
            Some(a)
        } else {
            None
        }
    }

    pub fn card_id(&self) -> Option<CardID> {
        if let Attribute::CardID(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn deck_id(&self) -> Option<DeckID> {
        if let Attribute::DeckID(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn player_id(&self) -> Option<PlayerID> {
        if let Attribute::PlayerID(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn grid_id(&self) -> Option<GridID> {
        if let Attribute::GridID(a) = self {
            Some(*a)
        } else {
            None
        }
    }

    pub fn grid_point(&self) -> Option<(GridID,Point)> {
        if let Attribute::GridPoint(a) = self {
            Some(*a)
        } else {
            None
        }
    }
}
