# TBG (Turn Based Game)

Provides an easy to use template for turn based games logic.
You just need to implement 3 functions and provide some enums.
While the main "entity" is called *Card*, a Card can be anything.

```rust
type MyMsg = ...

#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, Debug)]
enum MyEvent {
    GameStart,
    CardPlayed(CardID),
    PlayerTurnedBlue(PlayerID),
    GameEnd,
    ...
}

#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, Debug)]
enum MyTrigger {
    YouHaveWonTheGame(PlayerID),
    FlipTheTable(PlayerID),
    ...
}

#[derive(Serialize, Deserialize, Clone, PartialEq, Eq, Debug)]
enum MyEffect {
    PlusOneAllStats(CardID),
    TurnPlayerBlue(PlayerID),
    ...
}

// Similar effect layers to Magic The Gathering
#[derive(Serialize, Deserialize, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
enum MyEffectLayer {
    AttBase,
    Control,
    Mimic,
    Text,
    Flag,
    Ability,
    AttSet,
    AttAdd,
    AttMul,
    AttDiv,
    AttSub,
    AttSwap,
    React,
    ...
}

#[derive(Serialize, Deserialize, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
enum MyAttName {
    PlayerColor,
    Wealth,
    Health,
    ...
}

#[derive(Serialize, Deserialize, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
enum MyDeckType {
    Hand,
    Discard,
    Remove,
    Sideboard,
    Main,
    ...
}

#[derive(Serialize, Deserialize, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
enum MyCardType {
    PocketSand,
    AntsOnFire,
    QueenOfDarts,
    ...
}

#[derive(Serialize, Deserialize, Copy, Clone, PartialEq, Eq, PartialOrd, Ord, Debug)]
enum MyPhaseType {
    Untap,
    Upkeep,
    Draw,
    Main,
    Fight,
    Die,
    ...
}

type MyGame = TBG<MyMsg,MyEvent,MyTrigger,MyEffect,MyEffectLayer,MyAttName,MyDeckType,MyCardType,MyPhaseType>;

impl TurnBasedGame<MyTrigger, MyEvent, MyEffect, MyEffectLayer, MyMsg> for MyGame {
    fn handle_trigger(&mut self, event: &Event, trigger: &Trigger) -> bool {
        ...
    }
    fn handle_effect(&mut self, effect: &LayeredEffect<Effect, EffectLayer>) {
        ...
    }
    fn handle_msg(&mut self, msg: &Msg) {
        ...
    }
}

```