# webkit2gtk [![Build Status](https://travis-ci.org/gtk-rs/webkit2gtk-rs.png?branch=master)](https://travis-ci.org/gtk-rs/webkit2gtk-rs) [![Gitter](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/gtk-rs/gtk)

[Project site](http://gtk-rs.org/) | [Online documentation](http://gtk-rs.org/docs/)

__Rust__ bindings and wrappers for __webkit2gtk__.

## Building

__webkit2gtk-rs__ expects __GTK+__, __GLib__ and __webkit2gtk__ development files to be installed on your system.
See the [requirements page](http://gtk-rs.org/docs/requirements.html).

## Using

We recommend using [crates from crates.io](https://crates.io/keywords/gtk-rs),
as [demonstrated here](http://gtk-rs.org/#using).

If you want to track the bleeding edge, use the git dependency instead:

```toml
[dependencies]
webkit2gtk-rs = { git = "https://github.com/gtk-rs/webkit2gtk-rs.git" }
```

Avoid mixing versioned and git crates like this:

```toml
# This will not compile
[dependencies]
gtk = "0.2"
webkit2gtk-rs = { git = "https://github.com/gtk-rs/webkit2gtk-rs.git" }
```

## Contribute

Contributor you're welcome!

See the general [bindings documentation](http://gtk-rs.org/docs/glib/).

Most of the bindings ([`src/auto`](src/auto)) are generated by [gir](https://github.com/gtk-rs/gir) using [this configuration file](Gir.toml). After editing `Gir.toml` the sources can be regenerated with

```shell
> make gir
```

When opening a PR please put the changes to the `src/auto` directory in a separate commit.

## License

__webkit2gtk-rs__ is available under the MIT License, please refer to it.
