// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::URI;
use crate::WebsocketConnectionType;
#[cfg(any(feature = "v2_68", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_68")))]
use crate::WebsocketExtension;
use crate::WebsocketState;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SoupWebsocketConnection")]
    pub struct WebsocketConnection(Object<ffi::SoupWebsocketConnection, ffi::SoupWebsocketConnectionClass>);

    match fn {
        type_ => || ffi::soup_websocket_connection_get_type(),
    }
}

impl WebsocketConnection {
    #[doc(alias = "soup_websocket_connection_new")]
    pub fn new<P: IsA<gio::IOStream>>(stream: &P, uri: &mut URI, type_: WebsocketConnectionType, origin: Option<&str>, protocol: Option<&str>) -> WebsocketConnection {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_websocket_connection_new(stream.as_ref().to_glib_none().0, uri.to_glib_none_mut().0, type_.into_glib(), origin.to_glib_none().0, protocol.to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_68", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_68")))]
    #[doc(alias = "soup_websocket_connection_new_with_extensions")]
    #[doc(alias = "new_with_extensions")]
    pub fn with_extensions<P: IsA<gio::IOStream>>(stream: &P, uri: &mut URI, type_: WebsocketConnectionType, origin: Option<&str>, protocol: Option<&str>, extensions: &[WebsocketExtension]) -> WebsocketConnection {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_websocket_connection_new_with_extensions(stream.as_ref().to_glib_none().0, uri.to_glib_none_mut().0, type_.into_glib(), origin.to_glib_none().0, protocol.to_glib_none().0, extensions.to_glib_full()))
        }
    }
}

pub const NONE_WEBSOCKET_CONNECTION: Option<&WebsocketConnection> = None;

pub trait WebsocketConnectionExt: 'static {
    #[doc(alias = "soup_websocket_connection_close")]
    fn close(&self, code: libc::c_ushort, data: Option<&str>);

    #[doc(alias = "soup_websocket_connection_get_close_code")]
    #[doc(alias = "get_close_code")]
    fn close_code(&self) -> libc::c_ushort;

    #[doc(alias = "soup_websocket_connection_get_close_data")]
    #[doc(alias = "get_close_data")]
    fn close_data(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_websocket_connection_get_connection_type")]
    #[doc(alias = "get_connection_type")]
    fn connection_type(&self) -> WebsocketConnectionType;

    #[cfg(any(feature = "v2_68", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_68")))]
    #[doc(alias = "soup_websocket_connection_get_extensions")]
    #[doc(alias = "get_extensions")]
    fn extensions(&self) -> Vec<WebsocketExtension>;

    #[doc(alias = "soup_websocket_connection_get_io_stream")]
    #[doc(alias = "get_io_stream")]
    fn io_stream(&self) -> Option<gio::IOStream>;

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    #[doc(alias = "soup_websocket_connection_get_keepalive_interval")]
    #[doc(alias = "get_keepalive_interval")]
    fn keepalive_interval(&self) -> u32;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "soup_websocket_connection_get_max_incoming_payload_size")]
    #[doc(alias = "get_max_incoming_payload_size")]
    fn max_incoming_payload_size(&self) -> u64;

    #[doc(alias = "soup_websocket_connection_get_origin")]
    #[doc(alias = "get_origin")]
    fn origin(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_websocket_connection_get_protocol")]
    #[doc(alias = "get_protocol")]
    fn protocol(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_websocket_connection_get_state")]
    #[doc(alias = "get_state")]
    fn state(&self) -> WebsocketState;

    #[doc(alias = "soup_websocket_connection_get_uri")]
    #[doc(alias = "get_uri")]
    fn uri(&self) -> Option<URI>;

    #[doc(alias = "soup_websocket_connection_send_text")]
    fn send_text(&self, text: &str);

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    #[doc(alias = "soup_websocket_connection_set_keepalive_interval")]
    fn set_keepalive_interval(&self, interval: u32);

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "soup_websocket_connection_set_max_incoming_payload_size")]
    fn set_max_incoming_payload_size(&self, max_incoming_payload_size: u64);

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "closed")]
    fn connect_closed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "closing")]
    fn connect_closing<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "error")]
    fn connect_error<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "message")]
    fn connect_message<F: Fn(&Self, i32, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    #[doc(alias = "pong")]
    fn connect_pong<F: Fn(&Self, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    #[doc(alias = "keepalive-interval")]
    fn connect_keepalive_interval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    #[doc(alias = "max-incoming-payload-size")]
    fn connect_max_incoming_payload_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "state")]
    fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<WebsocketConnection>> WebsocketConnectionExt for O {
    fn close(&self, code: libc::c_ushort, data: Option<&str>) {
        unsafe {
            ffi::soup_websocket_connection_close(self.as_ref().to_glib_none().0, code, data.to_glib_none().0);
        }
    }

    fn close_code(&self) -> libc::c_ushort {
        unsafe {
            ffi::soup_websocket_connection_get_close_code(self.as_ref().to_glib_none().0)
        }
    }

    fn close_data(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_close_data(self.as_ref().to_glib_none().0))
        }
    }

    fn connection_type(&self) -> WebsocketConnectionType {
        unsafe {
            from_glib(ffi::soup_websocket_connection_get_connection_type(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_68", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_68")))]
    fn extensions(&self) -> Vec<WebsocketExtension> {
        unsafe {
            FromGlibPtrContainer::from_glib_none(ffi::soup_websocket_connection_get_extensions(self.as_ref().to_glib_none().0))
        }
    }

    fn io_stream(&self) -> Option<gio::IOStream> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_io_stream(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    fn keepalive_interval(&self) -> u32 {
        unsafe {
            ffi::soup_websocket_connection_get_keepalive_interval(self.as_ref().to_glib_none().0)
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn max_incoming_payload_size(&self) -> u64 {
        unsafe {
            ffi::soup_websocket_connection_get_max_incoming_payload_size(self.as_ref().to_glib_none().0)
        }
    }

    fn origin(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_origin(self.as_ref().to_glib_none().0))
        }
    }

    fn protocol(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_protocol(self.as_ref().to_glib_none().0))
        }
    }

    fn state(&self) -> WebsocketState {
        unsafe {
            from_glib(ffi::soup_websocket_connection_get_state(self.as_ref().to_glib_none().0))
        }
    }

    fn uri(&self) -> Option<URI> {
        unsafe {
            from_glib_none(ffi::soup_websocket_connection_get_uri(self.as_ref().to_glib_none().0))
        }
    }

    fn send_text(&self, text: &str) {
        unsafe {
            ffi::soup_websocket_connection_send_text(self.as_ref().to_glib_none().0, text.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    fn set_keepalive_interval(&self, interval: u32) {
        unsafe {
            ffi::soup_websocket_connection_set_keepalive_interval(self.as_ref().to_glib_none().0, interval);
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn set_max_incoming_payload_size(&self, max_incoming_payload_size: u64) {
        unsafe {
            ffi::soup_websocket_connection_set_max_incoming_payload_size(self.as_ref().to_glib_none().0, max_incoming_payload_size);
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_closed<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn closed_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P) + 'static>(this: *mut ffi::SoupWebsocketConnection, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"closed\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(closed_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_closing<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn closing_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P) + 'static>(this: *mut ffi::SoupWebsocketConnection, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"closing\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(closing_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_error<F: Fn(&Self, &glib::Error) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn error_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P, &glib::Error) + 'static>(this: *mut ffi::SoupWebsocketConnection, error: *mut glib::ffi::GError, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(error))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"error\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(error_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_message<F: Fn(&Self, i32, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn message_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P, i32, &glib::Bytes) + 'static>(this: *mut ffi::SoupWebsocketConnection, type_: libc::c_int, message: *mut glib::ffi::GBytes, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref(), type_, &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"message\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(message_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_60", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_60")))]
    fn connect_pong<F: Fn(&Self, &glib::Bytes) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn pong_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P, &glib::Bytes) + 'static>(this: *mut ffi::SoupWebsocketConnection, message: *mut glib::ffi::GBytes, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(message))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"pong\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(pong_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_58", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_58")))]
    fn connect_keepalive_interval_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_keepalive_interval_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P) + 'static>(this: *mut ffi::SoupWebsocketConnection, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::keepalive-interval\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_keepalive_interval_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_56", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_56")))]
    fn connect_max_incoming_payload_size_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_max_incoming_payload_size_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P) + 'static>(this: *mut ffi::SoupWebsocketConnection, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::max-incoming-payload-size\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_max_incoming_payload_size_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_state_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_state_trampoline<P: IsA<WebsocketConnection>, F: Fn(&P) + 'static>(this: *mut ffi::SoupWebsocketConnection, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(WebsocketConnection::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::state\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_state_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for WebsocketConnection {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("WebsocketConnection")
    }
}
