// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

#[cfg(any(feature = "v2_26", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
use crate::Address;
use crate::Buffer;
use crate::HTTPVersion;
use crate::MemoryUse;
use crate::MessageBody;
use crate::MessageFlags;
use crate::MessageHeaders;
use crate::MessagePriority;
#[cfg(any(feature = "v2_42", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
use crate::Request;
use crate::URI;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::StaticType;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
use std::mem;
use std::mem::transmute;
#[cfg(any(feature = "v2_34", feature = "dox"))]
#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
use std::ptr;

glib::wrapper! {
    #[doc(alias = "SoupMessage")]
    pub struct Message(Object<ffi::SoupMessage, ffi::SoupMessageClass>);

    match fn {
        type_ => || ffi::soup_message_get_type(),
    }
}

impl Message {
    #[doc(alias = "soup_message_new")]
    pub fn new(method: &str, uri_string: &str) -> Option<Message> {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new(method.to_glib_none().0, uri_string.to_glib_none().0))
        }
    }

    #[doc(alias = "soup_message_new_from_uri")]
    #[doc(alias = "new_from_uri")]
    pub fn from_uri(method: &str, uri: &mut URI) -> Message {
        assert_initialized_main_thread!();
        unsafe {
            from_glib_full(ffi::soup_message_new_from_uri(method.to_glib_none().0, uri.to_glib_none_mut().0))
        }
    }
}

pub const NONE_MESSAGE: Option<&Message> = None;

pub trait MessageExt: 'static {
    //#[doc(alias = "soup_message_add_header_handler")]
    //fn add_header_handler<P: Fn() + 'static>(&self, signal: &str, header: &str, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32;

    //#[doc(alias = "soup_message_add_status_code_handler")]
    //fn add_status_code_handler<P: Fn() + 'static>(&self, signal: &str, status_code: u32, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32;

    //#[doc(alias = "soup_message_content_sniffed")]
    //fn content_sniffed(&self, content_type: &str, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 });

    #[cfg(any(feature = "v2_28", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    #[doc(alias = "soup_message_disable_feature")]
    fn disable_feature(&self, feature_type: glib::types::Type);

    #[doc(alias = "soup_message_finished")]
    fn finished(&self);

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    #[doc(alias = "soup_message_get_address")]
    #[doc(alias = "get_address")]
    fn address(&self) -> Option<Address>;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "soup_message_get_first_party")]
    #[doc(alias = "get_first_party")]
    fn first_party(&self) -> Option<URI>;

    #[doc(alias = "soup_message_get_flags")]
    #[doc(alias = "get_flags")]
    fn flags(&self) -> MessageFlags;

    #[doc(alias = "soup_message_get_http_version")]
    #[doc(alias = "get_http_version")]
    fn http_version(&self) -> HTTPVersion;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "soup_message_get_https_status")]
    #[doc(alias = "get_https_status")]
    fn https_status(&self) -> Option<(gio::TlsCertificate, gio::TlsCertificateFlags)>;

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    #[doc(alias = "soup_message_get_is_top_level_navigation")]
    #[doc(alias = "get_is_top_level_navigation")]
    fn is_top_level_navigation(&self) -> bool;

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_44")))]
    #[doc(alias = "soup_message_get_priority")]
    #[doc(alias = "get_priority")]
    fn priority(&self) -> MessagePriority;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_message_get_soup_request")]
    #[doc(alias = "get_soup_request")]
    fn soup_request(&self) -> Option<Request>;

    #[doc(alias = "soup_message_get_uri")]
    #[doc(alias = "get_uri")]
    fn uri(&self) -> Option<URI>;

    #[doc(alias = "soup_message_got_body")]
    fn got_body(&self);

    #[doc(alias = "soup_message_got_chunk")]
    fn got_chunk(&self, chunk: &mut Buffer);

    #[doc(alias = "soup_message_got_headers")]
    fn got_headers(&self);

    #[doc(alias = "soup_message_got_informational")]
    fn got_informational(&self);

    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    #[doc(alias = "soup_message_is_feature_disabled")]
    fn is_feature_disabled(&self, feature_type: glib::types::Type) -> bool;

    #[doc(alias = "soup_message_is_keepalive")]
    fn is_keepalive(&self) -> bool;

    #[doc(alias = "soup_message_restarted")]
    fn restarted(&self);

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "soup_message_set_first_party")]
    fn set_first_party(&self, first_party: &mut URI);

    #[doc(alias = "soup_message_set_flags")]
    fn set_flags(&self, flags: MessageFlags);

    #[doc(alias = "soup_message_set_http_version")]
    fn set_http_version(&self, version: HTTPVersion);

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    #[doc(alias = "soup_message_set_is_top_level_navigation")]
    fn set_is_top_level_navigation(&self, is_top_level_navigation: bool);

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_44")))]
    #[doc(alias = "soup_message_set_priority")]
    fn set_priority(&self, priority: MessagePriority);

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "soup_message_set_redirect")]
    fn set_redirect(&self, status_code: u32, redirect_uri: &str);

    #[doc(alias = "soup_message_set_request")]
    fn set_request(&self, content_type: Option<&str>, req_use: MemoryUse, req_body: &[u8]);

    #[doc(alias = "soup_message_set_response")]
    fn set_response(&self, content_type: Option<&str>, resp_use: MemoryUse, resp_body: &[u8]);

    #[doc(alias = "soup_message_set_status")]
    fn set_status(&self, status_code: u32);

    #[doc(alias = "soup_message_set_status_full")]
    fn set_status_full(&self, status_code: u32, reason_phrase: &str);

    #[doc(alias = "soup_message_set_uri")]
    fn set_uri(&self, uri: &mut URI);

    #[doc(alias = "soup_message_starting")]
    fn starting(&self);

    #[doc(alias = "soup_message_wrote_body")]
    fn wrote_body(&self);

    #[doc(alias = "soup_message_wrote_body_data")]
    fn wrote_body_data(&self, chunk: &mut Buffer);

    #[doc(alias = "soup_message_wrote_chunk")]
    fn wrote_chunk(&self);

    #[doc(alias = "soup_message_wrote_headers")]
    fn wrote_headers(&self);

    #[doc(alias = "soup_message_wrote_informational")]
    fn wrote_informational(&self);

    fn method(&self) -> Option<glib::GString>;

    fn set_method(&self, method: Option<&str>);

    fn get_property_priority(&self) -> MessagePriority;

    fn set_property_priority(&self, priority: MessagePriority);

    #[doc(alias = "reason-phrase")]
    fn reason_phrase(&self) -> Option<glib::GString>;

    #[doc(alias = "reason-phrase")]
    fn set_reason_phrase(&self, reason_phrase: Option<&str>);

    #[doc(alias = "request-body")]
    fn request_body(&self) -> Option<MessageBody>;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    #[doc(alias = "request-body-data")]
    fn request_body_data(&self) -> Option<glib::Bytes>;

    #[doc(alias = "request-headers")]
    fn request_headers(&self) -> Option<MessageHeaders>;

    #[doc(alias = "response-body")]
    fn response_body(&self) -> Option<MessageBody>;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    #[doc(alias = "response-body-data")]
    fn response_body_data(&self) -> Option<glib::Bytes>;

    #[doc(alias = "response-headers")]
    fn response_headers(&self) -> Option<MessageHeaders>;

    #[doc(alias = "server-side")]
    fn is_server_side(&self) -> bool;

    #[doc(alias = "site-for-cookies")]
    fn site_for_cookies(&self) -> Option<URI>;

    #[doc(alias = "site-for-cookies")]
    fn set_site_for_cookies(&self, site_for_cookies: Option<&URI>);

    #[doc(alias = "status-code")]
    fn status_code(&self) -> u32;

    #[doc(alias = "status-code")]
    fn set_status_code(&self, status_code: u32);

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-certificate")]
    fn tls_certificate(&self) -> Option<gio::TlsCertificate>;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-certificate")]
    fn set_tls_certificate<P: IsA<gio::TlsCertificate>>(&self, tls_certificate: Option<&P>);

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-errors")]
    fn tls_errors(&self) -> gio::TlsCertificateFlags;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-errors")]
    fn set_tls_errors(&self, tls_errors: gio::TlsCertificateFlags);

    //#[cfg(any(feature = "v2_28", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    //#[doc(alias = "content-sniffed")]
    //fn connect_content_sniffed<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "finished")]
    fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "got-body")]
    fn connect_got_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "got-chunk")]
    fn connect_got_chunk<F: Fn(&Self, &Buffer) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "got-headers")]
    fn connect_got_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "got-informational")]
    fn connect_got_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    #[doc(alias = "network-event")]
    fn connect_network_event<F: Fn(&Self, gio::SocketClientEvent, &gio::IOStream) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "restarted")]
    fn connect_restarted<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    #[doc(alias = "starting")]
    fn connect_starting<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrote-body")]
    fn connect_wrote_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    #[doc(alias = "wrote-body-data")]
    fn connect_wrote_body_data<F: Fn(&Self, &Buffer) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrote-chunk")]
    fn connect_wrote_chunk<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrote-headers")]
    fn connect_wrote_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "wrote-informational")]
    fn connect_wrote_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    #[doc(alias = "first-party")]
    fn connect_first_party_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "flags")]
    fn connect_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "http-version")]
    fn connect_http_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    #[doc(alias = "is-top-level-navigation")]
    fn connect_is_top_level_navigation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "method")]
    fn connect_method_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "priority")]
    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "reason-phrase")]
    fn connect_reason_phrase_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "request-body")]
    fn connect_request_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    #[doc(alias = "request-body-data")]
    fn connect_request_body_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "request-headers")]
    fn connect_request_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "response-body")]
    fn connect_response_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    #[doc(alias = "response-body-data")]
    fn connect_response_body_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "response-headers")]
    fn connect_response_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "site-for-cookies")]
    fn connect_site_for_cookies_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "status-code")]
    fn connect_status_code_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-certificate")]
    fn connect_tls_certificate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    #[doc(alias = "tls-errors")]
    fn connect_tls_errors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "uri")]
    fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Message>> MessageExt for O {
    //fn add_header_handler<P: Fn() + 'static>(&self, signal: &str, header: &str, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32 {
    //    unsafe { TODO: call ffi:soup_message_add_header_handler() }
    //}

    //fn add_status_code_handler<P: Fn() + 'static>(&self, signal: &str, status_code: u32, callback: P, user_data: /*Unimplemented*/Option<Fundamental: Pointer>) -> u32 {
    //    unsafe { TODO: call ffi:soup_message_add_status_code_handler() }
    //}

    //fn content_sniffed(&self, content_type: &str, params: /*Unknown conversion*//*Unimplemented*/HashTable TypeId { ns_id: 0, id: 25 }/TypeId { ns_id: 0, id: 25 }) {
    //    unsafe { TODO: call ffi:soup_message_content_sniffed() }
    //}

    #[cfg(any(feature = "v2_28", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    fn disable_feature(&self, feature_type: glib::types::Type) {
        unsafe {
            ffi::soup_message_disable_feature(self.as_ref().to_glib_none().0, feature_type.into_glib());
        }
    }

    fn finished(&self) {
        unsafe {
            ffi::soup_message_finished(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_26", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_26")))]
    fn address(&self) -> Option<Address> {
        unsafe {
            from_glib_none(ffi::soup_message_get_address(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn first_party(&self) -> Option<URI> {
        unsafe {
            from_glib_none(ffi::soup_message_get_first_party(self.as_ref().to_glib_none().0))
        }
    }

    fn flags(&self) -> MessageFlags {
        unsafe {
            from_glib(ffi::soup_message_get_flags(self.as_ref().to_glib_none().0))
        }
    }

    fn http_version(&self) -> HTTPVersion {
        unsafe {
            from_glib(ffi::soup_message_get_http_version(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn https_status(&self) -> Option<(gio::TlsCertificate, gio::TlsCertificateFlags)> {
        unsafe {
            let mut certificate = ptr::null_mut();
            let mut errors = mem::MaybeUninit::uninit();
            let ret = from_glib(ffi::soup_message_get_https_status(self.as_ref().to_glib_none().0, &mut certificate, errors.as_mut_ptr()));
            let errors = errors.assume_init();
            if ret { Some((from_glib_none(certificate), from_glib(errors))) } else { None }
        }
    }

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    fn is_top_level_navigation(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_message_get_is_top_level_navigation(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_44")))]
    fn priority(&self) -> MessagePriority {
        unsafe {
            from_glib(ffi::soup_message_get_priority(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn soup_request(&self) -> Option<Request> {
        unsafe {
            from_glib_none(ffi::soup_message_get_soup_request(self.as_ref().to_glib_none().0))
        }
    }

    fn uri(&self) -> Option<URI> {
        unsafe {
            from_glib_none(ffi::soup_message_get_uri(self.as_ref().to_glib_none().0))
        }
    }

    fn got_body(&self) {
        unsafe {
            ffi::soup_message_got_body(self.as_ref().to_glib_none().0);
        }
    }

    fn got_chunk(&self, chunk: &mut Buffer) {
        unsafe {
            ffi::soup_message_got_chunk(self.as_ref().to_glib_none().0, chunk.to_glib_none_mut().0);
        }
    }

    fn got_headers(&self) {
        unsafe {
            ffi::soup_message_got_headers(self.as_ref().to_glib_none().0);
        }
    }

    fn got_informational(&self) {
        unsafe {
            ffi::soup_message_got_informational(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_72", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_72")))]
    fn is_feature_disabled(&self, feature_type: glib::types::Type) -> bool {
        unsafe {
            from_glib(ffi::soup_message_is_feature_disabled(self.as_ref().to_glib_none().0, feature_type.into_glib()))
        }
    }

    fn is_keepalive(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_message_is_keepalive(self.as_ref().to_glib_none().0))
        }
    }

    fn restarted(&self) {
        unsafe {
            ffi::soup_message_restarted(self.as_ref().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn set_first_party(&self, first_party: &mut URI) {
        unsafe {
            ffi::soup_message_set_first_party(self.as_ref().to_glib_none().0, first_party.to_glib_none_mut().0);
        }
    }

    fn set_flags(&self, flags: MessageFlags) {
        unsafe {
            ffi::soup_message_set_flags(self.as_ref().to_glib_none().0, flags.into_glib());
        }
    }

    fn set_http_version(&self, version: HTTPVersion) {
        unsafe {
            ffi::soup_message_set_http_version(self.as_ref().to_glib_none().0, version.into_glib());
        }
    }

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    fn set_is_top_level_navigation(&self, is_top_level_navigation: bool) {
        unsafe {
            ffi::soup_message_set_is_top_level_navigation(self.as_ref().to_glib_none().0, is_top_level_navigation.into_glib());
        }
    }

    #[cfg(any(feature = "v2_44", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_44")))]
    fn set_priority(&self, priority: MessagePriority) {
        unsafe {
            ffi::soup_message_set_priority(self.as_ref().to_glib_none().0, priority.into_glib());
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn set_redirect(&self, status_code: u32, redirect_uri: &str) {
        unsafe {
            ffi::soup_message_set_redirect(self.as_ref().to_glib_none().0, status_code, redirect_uri.to_glib_none().0);
        }
    }

    fn set_request(&self, content_type: Option<&str>, req_use: MemoryUse, req_body: &[u8]) {
        let req_length = req_body.len() as usize;
        unsafe {
            ffi::soup_message_set_request(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, req_use.into_glib(), req_body.to_glib_none().0, req_length);
        }
    }

    fn set_response(&self, content_type: Option<&str>, resp_use: MemoryUse, resp_body: &[u8]) {
        let resp_length = resp_body.len() as usize;
        unsafe {
            ffi::soup_message_set_response(self.as_ref().to_glib_none().0, content_type.to_glib_none().0, resp_use.into_glib(), resp_body.to_glib_none().0, resp_length);
        }
    }

    fn set_status(&self, status_code: u32) {
        unsafe {
            ffi::soup_message_set_status(self.as_ref().to_glib_none().0, status_code);
        }
    }

    fn set_status_full(&self, status_code: u32, reason_phrase: &str) {
        unsafe {
            ffi::soup_message_set_status_full(self.as_ref().to_glib_none().0, status_code, reason_phrase.to_glib_none().0);
        }
    }

    fn set_uri(&self, uri: &mut URI) {
        unsafe {
            ffi::soup_message_set_uri(self.as_ref().to_glib_none().0, uri.to_glib_none_mut().0);
        }
    }

    fn starting(&self) {
        unsafe {
            ffi::soup_message_starting(self.as_ref().to_glib_none().0);
        }
    }

    fn wrote_body(&self) {
        unsafe {
            ffi::soup_message_wrote_body(self.as_ref().to_glib_none().0);
        }
    }

    fn wrote_body_data(&self, chunk: &mut Buffer) {
        unsafe {
            ffi::soup_message_wrote_body_data(self.as_ref().to_glib_none().0, chunk.to_glib_none_mut().0);
        }
    }

    fn wrote_chunk(&self) {
        unsafe {
            ffi::soup_message_wrote_chunk(self.as_ref().to_glib_none().0);
        }
    }

    fn wrote_headers(&self) {
        unsafe {
            ffi::soup_message_wrote_headers(self.as_ref().to_glib_none().0);
        }
    }

    fn wrote_informational(&self) {
        unsafe {
            ffi::soup_message_wrote_informational(self.as_ref().to_glib_none().0);
        }
    }

    fn method(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"method\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `method` getter")
        }
    }

    fn set_method(&self, method: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"method\0".as_ptr() as *const _, method.to_value().to_glib_none().0);
        }
    }

    fn get_property_priority(&self) -> MessagePriority {
        unsafe {
            let mut value = glib::Value::from_type(<MessagePriority as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"priority\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `priority` getter")
        }
    }

    fn set_property_priority(&self, priority: MessagePriority) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"priority\0".as_ptr() as *const _, priority.to_value().to_glib_none().0);
        }
    }

    fn reason_phrase(&self) -> Option<glib::GString> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::GString as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"reason-phrase\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `reason-phrase` getter")
        }
    }

    fn set_reason_phrase(&self, reason_phrase: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"reason-phrase\0".as_ptr() as *const _, reason_phrase.to_value().to_glib_none().0);
        }
    }

    fn request_body(&self) -> Option<MessageBody> {
        unsafe {
            let mut value = glib::Value::from_type(<MessageBody as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"request-body\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `request-body` getter")
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    fn request_body_data(&self) -> Option<glib::Bytes> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::Bytes as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"request-body-data\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `request-body-data` getter")
        }
    }

    fn request_headers(&self) -> Option<MessageHeaders> {
        unsafe {
            let mut value = glib::Value::from_type(<MessageHeaders as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"request-headers\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `request-headers` getter")
        }
    }

    fn response_body(&self) -> Option<MessageBody> {
        unsafe {
            let mut value = glib::Value::from_type(<MessageBody as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"response-body\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `response-body` getter")
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    fn response_body_data(&self) -> Option<glib::Bytes> {
        unsafe {
            let mut value = glib::Value::from_type(<glib::Bytes as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"response-body-data\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `response-body-data` getter")
        }
    }

    fn response_headers(&self) -> Option<MessageHeaders> {
        unsafe {
            let mut value = glib::Value::from_type(<MessageHeaders as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"response-headers\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `response-headers` getter")
        }
    }

    fn is_server_side(&self) -> bool {
        unsafe {
            let mut value = glib::Value::from_type(<bool as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"server-side\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `server-side` getter")
        }
    }

    fn site_for_cookies(&self) -> Option<URI> {
        unsafe {
            let mut value = glib::Value::from_type(<URI as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"site-for-cookies\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `site-for-cookies` getter")
        }
    }

    fn set_site_for_cookies(&self, site_for_cookies: Option<&URI>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"site-for-cookies\0".as_ptr() as *const _, site_for_cookies.to_value().to_glib_none().0);
        }
    }

    fn status_code(&self) -> u32 {
        unsafe {
            let mut value = glib::Value::from_type(<u32 as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"status-code\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `status-code` getter")
        }
    }

    fn set_status_code(&self, status_code: u32) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"status-code\0".as_ptr() as *const _, status_code.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn tls_certificate(&self) -> Option<gio::TlsCertificate> {
        unsafe {
            let mut value = glib::Value::from_type(<gio::TlsCertificate as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-certificate\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `tls-certificate` getter")
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn set_tls_certificate<P: IsA<gio::TlsCertificate>>(&self, tls_certificate: Option<&P>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-certificate\0".as_ptr() as *const _, tls_certificate.to_value().to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn tls_errors(&self) -> gio::TlsCertificateFlags {
        unsafe {
            let mut value = glib::Value::from_type(<gio::TlsCertificateFlags as StaticType>::static_type());
            glib::gobject_ffi::g_object_get_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-errors\0".as_ptr() as *const _, value.to_glib_none_mut().0);
            value.get().expect("Return Value for property `tls-errors` getter")
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn set_tls_errors(&self, tls_errors: gio::TlsCertificateFlags) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"tls-errors\0".as_ptr() as *const _, tls_errors.to_value().to_glib_none().0);
        }
    }

    //#[cfg(any(feature = "v2_28", feature = "dox"))]
    //#[cfg_attr(feature = "dox", doc(cfg(feature = "v2_28")))]
    //fn connect_content_sniffed<Unsupported or ignored types>(&self, f: F) -> SignalHandlerId {
    //    Empty ctype params: *.HashTable TypeId { ns_id: 0, id: 28 }/TypeId { ns_id: 0, id: 28 }
    //}

    fn connect_finished<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn finished_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"finished\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(finished_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_got_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_body_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"got-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(got_body_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_got_chunk<F: Fn(&Self, &Buffer) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_chunk_trampoline<P: IsA<Message>, F: Fn(&P, &Buffer) + 'static>(this: *mut ffi::SoupMessage, chunk: *mut ffi::SoupBuffer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(chunk))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"got-chunk\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(got_chunk_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_got_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_headers_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"got-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(got_headers_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_got_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn got_informational_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"got-informational\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(got_informational_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_38", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_38")))]
    fn connect_network_event<F: Fn(&Self, gio::SocketClientEvent, &gio::IOStream) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn network_event_trampoline<P: IsA<Message>, F: Fn(&P, gio::SocketClientEvent, &gio::IOStream) + 'static>(this: *mut ffi::SoupMessage, event: gio::ffi::GSocketClientEvent, connection: *mut gio::ffi::GIOStream, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref(), from_glib(event), &from_glib_borrow(connection))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"network-event\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(network_event_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_restarted<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn restarted_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"restarted\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(restarted_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_50", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_50")))]
    fn connect_starting<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn starting_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"starting\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(starting_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_wrote_body<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"wrote-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(wrote_body_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_24", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_24")))]
    fn connect_wrote_body_data<F: Fn(&Self, &Buffer) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_body_data_trampoline<P: IsA<Message>, F: Fn(&P, &Buffer) + 'static>(this: *mut ffi::SoupMessage, chunk: *mut ffi::SoupBuffer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref(), &from_glib_borrow(chunk))
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"wrote-body-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(wrote_body_data_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_wrote_chunk<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_chunk_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"wrote-chunk\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(wrote_chunk_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_wrote_headers<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_headers_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"wrote-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(wrote_headers_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_wrote_informational<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn wrote_informational_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"wrote-informational\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(wrote_informational_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_30", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_30")))]
    fn connect_first_party_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_first_party_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::first-party\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_first_party_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_flags_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_flags_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::flags\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_flags_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_http_version_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_http_version_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::http-version\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_http_version_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_70", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_70")))]
    fn connect_is_top_level_navigation_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_top_level_navigation_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::is-top-level-navigation\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_is_top_level_navigation_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_method_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_method_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::method\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_method_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_priority_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_priority_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::priority\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_priority_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_reason_phrase_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_reason_phrase_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::reason-phrase\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_reason_phrase_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_request_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_request_body_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::request-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_request_body_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    fn connect_request_body_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_request_body_data_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::request-body-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_request_body_data_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_request_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_request_headers_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::request-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_request_headers_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_response_body_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_response_body_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::response-body\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_response_body_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_46", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_46")))]
    fn connect_response_body_data_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_response_body_data_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::response-body-data\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_response_body_data_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_response_headers_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_response_headers_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::response-headers\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_response_headers_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_site_for_cookies_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_site_for_cookies_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::site-for-cookies\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_site_for_cookies_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_status_code_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_status_code_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::status-code\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_status_code_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn connect_tls_certificate_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_certificate_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::tls-certificate\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_tls_certificate_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    #[cfg(any(feature = "v2_34", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_34")))]
    fn connect_tls_errors_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_tls_errors_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::tls-errors\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_tls_errors_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_uri_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_uri_trampoline<P: IsA<Message>, F: Fn(&P) + 'static>(this: *mut ffi::SoupMessage, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Message::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::uri\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_uri_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Message {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Message")
    }
}
