// This file was generated by gir (https://github.com/gtk-rs/gir)
// from ../gir-files
// DO NOT EDIT

use crate::Message;
use crate::URI;
use glib::object::Cast;
use glib::object::IsA;
use glib::signal::connect_raw;
use glib::signal::SignalHandlerId;
use glib::translate::*;
use glib::ToValue;
use std::boxed::Box as Box_;
use std::fmt;
use std::mem::transmute;

glib::wrapper! {
    #[doc(alias = "SoupAuth")]
    pub struct Auth(Object<ffi::SoupAuth, ffi::SoupAuthClass>);

    match fn {
        type_ => || ffi::soup_auth_get_type(),
    }
}

impl Auth {
    #[doc(alias = "soup_auth_new")]
    pub fn new<P: IsA<Message>>(type_: glib::types::Type, msg: &P, auth_header: &str) -> Option<Auth> {
        skip_assert_initialized!();
        unsafe {
            from_glib_full(ffi::soup_auth_new(type_.into_glib(), msg.as_ref().to_glib_none().0, auth_header.to_glib_none().0))
        }
    }
}

pub const NONE_AUTH: Option<&Auth> = None;

pub trait AuthExt: 'static {
    #[doc(alias = "soup_auth_authenticate")]
    fn authenticate(&self, username: &str, password: &str);

    #[cfg(any(feature = "v2_54", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_54")))]
    #[doc(alias = "soup_auth_can_authenticate")]
    fn can_authenticate(&self) -> bool;

    //#[doc(alias = "soup_auth_free_protection_space")]
    //fn free_protection_space(&self, space: /*Unimplemented*/&[&Fundamental: Pointer]);

    #[doc(alias = "soup_auth_get_authorization")]
    #[doc(alias = "get_authorization")]
    fn authorization<P: IsA<Message>>(&self, msg: &P) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_get_host")]
    #[doc(alias = "get_host")]
    fn host(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_get_info")]
    #[doc(alias = "get_info")]
    fn info(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_get_protection_space")]
    #[doc(alias = "get_protection_space")]
    fn protection_space(&self, source_uri: &mut URI) -> Vec<glib::GString>;

    #[doc(alias = "soup_auth_get_realm")]
    #[doc(alias = "get_realm")]
    fn realm(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_get_saved_password")]
    #[doc(alias = "get_saved_password")]
    fn saved_password(&self, user: &str) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_get_saved_users")]
    #[doc(alias = "get_saved_users")]
    fn saved_users(&self) -> Vec<glib::GString>;

    #[doc(alias = "soup_auth_get_scheme_name")]
    #[doc(alias = "get_scheme_name")]
    fn scheme_name(&self) -> Option<glib::GString>;

    #[doc(alias = "soup_auth_has_saved_password")]
    fn has_saved_password(&self, username: &str, password: &str);

    #[doc(alias = "soup_auth_is_authenticated")]
    fn is_authenticated(&self) -> bool;

    #[doc(alias = "soup_auth_is_for_proxy")]
    fn is_for_proxy(&self) -> bool;

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    #[doc(alias = "soup_auth_is_ready")]
    fn is_ready<P: IsA<Message>>(&self, msg: &P) -> bool;

    #[doc(alias = "soup_auth_save_password")]
    fn save_password(&self, username: &str, password: &str);

    #[doc(alias = "soup_auth_update")]
    fn update<P: IsA<Message>>(&self, msg: &P, auth_header: &str) -> bool;

    fn set_host(&self, host: Option<&str>);

    #[doc(alias = "is-for-proxy")]
    fn set_is_for_proxy(&self, is_for_proxy: bool);

    fn set_realm(&self, realm: Option<&str>);

    #[doc(alias = "host")]
    fn connect_host_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "is-authenticated")]
    fn connect_is_authenticated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "is-for-proxy")]
    fn connect_is_for_proxy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "realm")]
    fn connect_realm_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;

    #[doc(alias = "scheme-name")]
    fn connect_scheme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId;
}

impl<O: IsA<Auth>> AuthExt for O {
    fn authenticate(&self, username: &str, password: &str) {
        unsafe {
            ffi::soup_auth_authenticate(self.as_ref().to_glib_none().0, username.to_glib_none().0, password.to_glib_none().0);
        }
    }

    #[cfg(any(feature = "v2_54", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_54")))]
    fn can_authenticate(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_can_authenticate(self.as_ref().to_glib_none().0))
        }
    }

    //fn free_protection_space(&self, space: /*Unimplemented*/&[&Fundamental: Pointer]) {
    //    unsafe { TODO: call ffi:soup_auth_free_protection_space() }
    //}

    fn authorization<P: IsA<Message>>(&self, msg: &P) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_auth_get_authorization(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0))
        }
    }

    fn host(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_get_host(self.as_ref().to_glib_none().0))
        }
    }

    fn info(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_full(ffi::soup_auth_get_info(self.as_ref().to_glib_none().0))
        }
    }

    fn protection_space(&self, source_uri: &mut URI) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_auth_get_protection_space(self.as_ref().to_glib_none().0, source_uri.to_glib_none_mut().0))
        }
    }

    fn realm(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_get_realm(self.as_ref().to_glib_none().0))
        }
    }

    fn saved_password(&self, user: &str) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_get_saved_password(self.as_ref().to_glib_none().0, user.to_glib_none().0))
        }
    }

    fn saved_users(&self) -> Vec<glib::GString> {
        unsafe {
            FromGlibPtrContainer::from_glib_full(ffi::soup_auth_get_saved_users(self.as_ref().to_glib_none().0))
        }
    }

    fn scheme_name(&self) -> Option<glib::GString> {
        unsafe {
            from_glib_none(ffi::soup_auth_get_scheme_name(self.as_ref().to_glib_none().0))
        }
    }

    fn has_saved_password(&self, username: &str, password: &str) {
        unsafe {
            ffi::soup_auth_has_saved_password(self.as_ref().to_glib_none().0, username.to_glib_none().0, password.to_glib_none().0);
        }
    }

    fn is_authenticated(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_is_authenticated(self.as_ref().to_glib_none().0))
        }
    }

    fn is_for_proxy(&self) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_is_for_proxy(self.as_ref().to_glib_none().0))
        }
    }

    #[cfg(any(feature = "v2_42", feature = "dox"))]
    #[cfg_attr(feature = "dox", doc(cfg(feature = "v2_42")))]
    fn is_ready<P: IsA<Message>>(&self, msg: &P) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_is_ready(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0))
        }
    }

    fn save_password(&self, username: &str, password: &str) {
        unsafe {
            ffi::soup_auth_save_password(self.as_ref().to_glib_none().0, username.to_glib_none().0, password.to_glib_none().0);
        }
    }

    fn update<P: IsA<Message>>(&self, msg: &P, auth_header: &str) -> bool {
        unsafe {
            from_glib(ffi::soup_auth_update(self.as_ref().to_glib_none().0, msg.as_ref().to_glib_none().0, auth_header.to_glib_none().0))
        }
    }

    fn set_host(&self, host: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"host\0".as_ptr() as *const _, host.to_value().to_glib_none().0);
        }
    }

    fn set_is_for_proxy(&self, is_for_proxy: bool) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"is-for-proxy\0".as_ptr() as *const _, is_for_proxy.to_value().to_glib_none().0);
        }
    }

    fn set_realm(&self, realm: Option<&str>) {
        unsafe {
            glib::gobject_ffi::g_object_set_property(self.to_glib_none().0 as *mut glib::gobject_ffi::GObject, b"realm\0".as_ptr() as *const _, realm.to_value().to_glib_none().0);
        }
    }

    fn connect_host_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_host_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(this: *mut ffi::SoupAuth, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::host\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_host_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_is_authenticated_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_authenticated_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(this: *mut ffi::SoupAuth, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::is-authenticated\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_is_authenticated_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_is_for_proxy_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_is_for_proxy_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(this: *mut ffi::SoupAuth, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::is-for-proxy\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_is_for_proxy_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_realm_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_realm_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(this: *mut ffi::SoupAuth, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::realm\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_realm_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }

    fn connect_scheme_name_notify<F: Fn(&Self) + 'static>(&self, f: F) -> SignalHandlerId {
        unsafe extern "C" fn notify_scheme_name_trampoline<P: IsA<Auth>, F: Fn(&P) + 'static>(this: *mut ffi::SoupAuth, _param_spec: glib::ffi::gpointer, f: glib::ffi::gpointer) {
            let f: &F = &*(f as *const F);
            f(Auth::from_glib_borrow(this).unsafe_cast_ref())
        }
        unsafe {
            let f: Box_<F> = Box_::new(f);
            connect_raw(self.as_ptr() as *mut _, b"notify::scheme-name\0".as_ptr() as *const _,
                Some(transmute::<_, unsafe extern "C" fn()>(notify_scheme_name_trampoline::<Self, F> as *const ())), Box_::into_raw(f))
        }
    }
}

impl fmt::Display for Auth {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("Auth")
    }
}
