#![allow(unused_imports)]
#![cfg_attr(rustfmt, rustfmt_skip)]
/* THIS FILE IS AUTOMATICALLY GENERATED. DO NOT EDIT */
use crate::{Client, ClientBuilder, Credentials, Retry};
use anyhow::Error;
use serde_json::Value;
use std::time::Duration;
use crate::util::urlencode;

/// GitHub Service
///
/// The github service is responsible for creating tasks in response
/// to GitHub events, and posting results to the GitHub UI.
///
/// This document describes the API end-point for consuming GitHub
/// web hooks, as well as some useful consumer APIs.
///
/// When Github forbids an action, this service returns an HTTP 403
/// with code ForbiddenByGithub.
pub struct Github {
    /// The underlying client used to make API calls for this service.
    pub client: Client
}

#[allow(non_snake_case)]
impl Github {
    /// Create a new Github instance, based on the given client builder
    pub fn new<CB: Into<ClientBuilder>>(client_builder: CB) -> Result<Self, Error> {
        Ok(Self{
            client: client_builder
                .into()
                .path_prefix("api/github/v1/")
                .build()?,
        })
    }

    /// Ping Server
    /// 
    /// Respond without doing anything.
    /// This endpoint is used to check that the service is up.
    pub async fn ping(&self) -> Result<(), Error> {
        let method = "GET";
        let (path, query) = Self::ping_details();
        let body = None;
        let resp = self.client.request(method, path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Generate an unsigned URL for the ping endpoint
    pub fn ping_url(&self) -> Result<String, Error> {
        let (path, query) = Self::ping_details();
        self.client.make_url(path, query)
    }

    /// Generate a signed URL for the ping endpoint
    pub fn ping_signed_url(&self, ttl: Duration) -> Result<String, Error> {
        let (path, query) = Self::ping_details();
        self.client.make_signed_url(path, query, ttl)
    }

    /// Determine the HTTP request details for ping
    fn ping_details<'a>() -> (&'static str, Option<Vec<(&'static str, &'a str)>>) {
        let path = "ping";
        let query = None;

        (path, query)
    }

    /// Consume GitHub WebHook
    /// 
    /// Capture a GitHub event and publish it via pulse, if it's a push,
    /// release or pull request.
    pub async fn githubWebHookConsumer(&self) -> Result<(), Error> {
        let method = "POST";
        let (path, query) = Self::githubWebHookConsumer_details();
        let body = None;
        let resp = self.client.request(method, path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Determine the HTTP request details for githubWebHookConsumer
    fn githubWebHookConsumer_details<'a>() -> (&'static str, Option<Vec<(&'static str, &'a str)>>) {
        let path = "github";
        let query = None;

        (path, query)
    }

    /// List of Builds
    /// 
    /// A paginated list of builds that have been run in
    /// Taskcluster. Can be filtered on various git-specific
    /// fields.
    pub async fn builds(&self, continuationToken: Option<&str>, limit: Option<&str>, organization: Option<&str>, repository: Option<&str>, sha: Option<&str>) -> Result<Value, Error> {
        let method = "GET";
        let (path, query) = Self::builds_details(continuationToken, limit, organization, repository, sha);
        let body = None;
        let resp = self.client.request(method, path, query, body).await?;
        Ok(resp.json().await?)
    }

    /// Generate an unsigned URL for the builds endpoint
    pub fn builds_url(&self, continuationToken: Option<&str>, limit: Option<&str>, organization: Option<&str>, repository: Option<&str>, sha: Option<&str>) -> Result<String, Error> {
        let (path, query) = Self::builds_details(continuationToken, limit, organization, repository, sha);
        self.client.make_url(path, query)
    }

    /// Generate a signed URL for the builds endpoint
    pub fn builds_signed_url(&self, continuationToken: Option<&str>, limit: Option<&str>, organization: Option<&str>, repository: Option<&str>, sha: Option<&str>, ttl: Duration) -> Result<String, Error> {
        let (path, query) = Self::builds_details(continuationToken, limit, organization, repository, sha);
        self.client.make_signed_url(path, query, ttl)
    }

    /// Determine the HTTP request details for builds
    fn builds_details<'a>(continuationToken: Option<&'a str>, limit: Option<&'a str>, organization: Option<&'a str>, repository: Option<&'a str>, sha: Option<&'a str>) -> (&'static str, Option<Vec<(&'static str, &'a str)>>) {
        let path = "builds";
        let mut query = None;
        if let Some(q) = continuationToken {
            query.get_or_insert_with(Vec::new).push(("continuationToken", q));
        }
        if let Some(q) = limit {
            query.get_or_insert_with(Vec::new).push(("limit", q));
        }
        if let Some(q) = organization {
            query.get_or_insert_with(Vec::new).push(("organization", q));
        }
        if let Some(q) = repository {
            query.get_or_insert_with(Vec::new).push(("repository", q));
        }
        if let Some(q) = sha {
            query.get_or_insert_with(Vec::new).push(("sha", q));
        }

        (path, query)
    }

    /// Latest Build Status Badge
    /// 
    /// Checks the status of the latest build of a given branch
    /// and returns corresponding badge svg.
    pub async fn badge(&self, owner: &str, repo: &str, branch: &str) -> Result<(), Error> {
        let method = "GET";
        let (path, query) = Self::badge_details(owner, repo, branch);
        let body = None;
        let resp = self.client.request(method, &path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Generate an unsigned URL for the badge endpoint
    pub fn badge_url(&self, owner: &str, repo: &str, branch: &str) -> Result<String, Error> {
        let (path, query) = Self::badge_details(owner, repo, branch);
        self.client.make_url(&path, query)
    }

    /// Generate a signed URL for the badge endpoint
    pub fn badge_signed_url(&self, owner: &str, repo: &str, branch: &str, ttl: Duration) -> Result<String, Error> {
        let (path, query) = Self::badge_details(owner, repo, branch);
        self.client.make_signed_url(&path, query, ttl)
    }

    /// Determine the HTTP request details for badge
    fn badge_details<'a>(owner: &'a str, repo: &'a str, branch: &'a str) -> (String, Option<Vec<(&'static str, &'a str)>>) {
        let path = format!("repository/{}/{}/{}/badge.svg", urlencode(owner), urlencode(repo), urlencode(branch));
        let query = None;

        (path, query)
    }

    /// Get Repository Info
    /// 
    /// Returns any repository metadata that is
    /// useful within Taskcluster related services.
    pub async fn repository(&self, owner: &str, repo: &str) -> Result<Value, Error> {
        let method = "GET";
        let (path, query) = Self::repository_details(owner, repo);
        let body = None;
        let resp = self.client.request(method, &path, query, body).await?;
        Ok(resp.json().await?)
    }

    /// Generate an unsigned URL for the repository endpoint
    pub fn repository_url(&self, owner: &str, repo: &str) -> Result<String, Error> {
        let (path, query) = Self::repository_details(owner, repo);
        self.client.make_url(&path, query)
    }

    /// Generate a signed URL for the repository endpoint
    pub fn repository_signed_url(&self, owner: &str, repo: &str, ttl: Duration) -> Result<String, Error> {
        let (path, query) = Self::repository_details(owner, repo);
        self.client.make_signed_url(&path, query, ttl)
    }

    /// Determine the HTTP request details for repository
    fn repository_details<'a>(owner: &'a str, repo: &'a str) -> (String, Option<Vec<(&'static str, &'a str)>>) {
        let path = format!("repository/{}/{}", urlencode(owner), urlencode(repo));
        let query = None;

        (path, query)
    }

    /// Latest Status for Branch
    /// 
    /// For a given branch of a repository, this will always point
    /// to a status page for the most recent task triggered by that
    /// branch.
    /// 
    /// Note: This is a redirect rather than a direct link.
    pub async fn latest(&self, owner: &str, repo: &str, branch: &str) -> Result<(), Error> {
        let method = "GET";
        let (path, query) = Self::latest_details(owner, repo, branch);
        let body = None;
        let resp = self.client.request(method, &path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Generate an unsigned URL for the latest endpoint
    pub fn latest_url(&self, owner: &str, repo: &str, branch: &str) -> Result<String, Error> {
        let (path, query) = Self::latest_details(owner, repo, branch);
        self.client.make_url(&path, query)
    }

    /// Generate a signed URL for the latest endpoint
    pub fn latest_signed_url(&self, owner: &str, repo: &str, branch: &str, ttl: Duration) -> Result<String, Error> {
        let (path, query) = Self::latest_details(owner, repo, branch);
        self.client.make_signed_url(&path, query, ttl)
    }

    /// Determine the HTTP request details for latest
    fn latest_details<'a>(owner: &'a str, repo: &'a str, branch: &'a str) -> (String, Option<Vec<(&'static str, &'a str)>>) {
        let path = format!("repository/{}/{}/{}/latest", urlencode(owner), urlencode(repo), urlencode(branch));
        let query = None;

        (path, query)
    }

    /// Post a status against a given changeset
    /// 
    /// For a given changeset (SHA) of a repository, this will attach a "commit status"
    /// on github. These statuses are links displayed next to each revision.
    /// The status is either OK (green check) or FAILURE (red cross), 
    /// made of a custom title and link.
    pub async fn createStatus(&self, owner: &str, repo: &str, sha: &str, payload: &Value) -> Result<(), Error> {
        let method = "POST";
        let (path, query) = Self::createStatus_details(owner, repo, sha);
        let body = Some(payload);
        let resp = self.client.request(method, &path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Determine the HTTP request details for createStatus
    fn createStatus_details<'a>(owner: &'a str, repo: &'a str, sha: &'a str) -> (String, Option<Vec<(&'static str, &'a str)>>) {
        let path = format!("repository/{}/{}/statuses/{}", urlencode(owner), urlencode(repo), urlencode(sha));
        let query = None;

        (path, query)
    }

    /// Post a comment on a given GitHub Issue or Pull Request
    /// 
    /// For a given Issue or Pull Request of a repository, this will write a new message.
    pub async fn createComment(&self, owner: &str, repo: &str, number: &str, payload: &Value) -> Result<(), Error> {
        let method = "POST";
        let (path, query) = Self::createComment_details(owner, repo, number);
        let body = Some(payload);
        let resp = self.client.request(method, &path, query, body).await?;
        resp.bytes().await?;
        Ok(())
    }

    /// Determine the HTTP request details for createComment
    fn createComment_details<'a>(owner: &'a str, repo: &'a str, number: &'a str) -> (String, Option<Vec<(&'static str, &'a str)>>) {
        let path = format!("repository/{}/{}/issues/{}/comments", urlencode(owner), urlencode(repo), urlencode(number));
        let query = None;

        (path, query)
    }
}
