use maplit::btreemap;
use ndarray::prelude::*;
use rayon::prelude::*;
use serde_json::json;
use std::path::Path;
use tangram_linear::Progress;
use tangram_table::prelude::*;
use tangram_zip::pzip;

fn main() {
	// Load the data.
	let csv_file_path_train = Path::new("data/allstate_train.csv");
	let csv_file_path_test = Path::new("data/allstate_test.csv");
	let target_column_index = 34;
	let blind_make_variants = [
		"AU", "BF", "AR", "AJ", "BO", "BW", "BH", "AQ", "L", "BP", "AN", "K", "AO", "AH", "D", "X",
		"Y", "W", "BU", "Q", "R", "AL", "BV", "M", "I", "BG", "BT", "E", "S", "AY", "P", "N", "O",
		"AI", "Z", "BZ", "BY", "BM", "AX", "J", "BN", "BS", "AZ", "BB", "AV", "BD", "AF", "G",
		"AC", "AW", "?", "BR", "BA", "V", "AD", "AE", "B", "U", "AP", "AM", "BC", "CB", "AT", "BL",
		"F", "AG", "A", "AS", "BQ", "AK", "CA", "BK", "H", "C", "AB",
	]
	.iter()
	.map(ToString::to_string)
	.collect();
	let blind_model_variants = [
		"AU.54", "BF.36", "AR.41", "AJ.129", "AU.58", "BO.52", "BW.156", "BO.38", "BH.12", "AQ.17",
		"L.29", "BW.3", "BP.24", "AN.16", "K.3", "AR.35", "AO.29", "BH.18", "AU.14", "AU.40",
		"AH.77", "AH.164", "D.25", "AJ.49", "L.26", "AJ.121", "AJ.122", "L.49", "L.28", "AJ.52",
		"K.34", "AJ.40", "X.45", "K.2", "Y.10", "W.4", "K.7", "BU.36", "Q.36", "BP.6", "R.30",
		"AJ.29", "AO.1", "L.56", "AL.88", "AU.11", "AJ.77", "BV.17", "BU.38", "M.16", "Y.29",
		"I.15", "BG.19", "AH.6", "BW.49", "BT.72", "Y.9", "E.28", "R.15", "W.28", "S.1", "AJ.54",
		"AJ.14", "AJ.58", "AU.1", "AJ.9", "W.16", "Y.42", "AY.37", "BT.43", "AQ.39", "W.11",
		"K.63", "AQ.31", "K.31", "AJ.35", "AJ.123", "AY.47", "Y.34", "K.60", "AH.168", "P.34",
		"X.25", "N.8", "AL.24", "AU.50", "AJ.48", "BP.17", "BW.157", "I.29", "X.12", "D.21",
		"Y.15", "AH.125", "K.65", "X.38", "AU.35", "BV.6", "BT.69", "AL.71", "BU.3", "BO.58",
		"AL.16", "AU.27", "L.55", "K.81", "BW.115", "BH.20", "O.23", "X.24", "X.9", "BO.32",
		"BU.1", "Q.3", "BO.36", "BF.18", "W.10", "BW.178", "BW.126", "BW.96", "AI.17", "L.20",
		"AU.68", "AU.25", "BT.11", "P.9", "Z.38", "K.39", "AJ.38", "AJ.59", "AO.7", "Q.43",
		"BW.95", "BZ.14", "BW.160", "AH.69", "P.33", "BO.35", "BO.51", "BP.15", "AJ.1", "BV.3",
		"Q.40", "D.19", "BV.20", "BY.4", "AJ.5", "X.28", "BO.3", "X.3", "BO.53", "AH.107", "BF.22",
		"L.51", "L.57", "BY.6", "BU.35", "Y.5", "AR.16", "BT.63", "AI.4", "X.52", "K.86", "AJ.43",
		"AH.8", "BV.24", "K.62", "BV.8", "BW.42", "R.23", "AN.12", "Y.32", "AJ.17", "AJ.23",
		"R.48", "AL.110", "BW.132", "N.23", "Q.22", "AQ.14", "AO.33", "BW.92", "BM.1", "BO.47",
		"L.14", "BH.30", "AO.6", "O.19", "BW.17", "N.22", "AU.2", "K.52", "P.18", "AX.4", "AR.14",
		"J.6", "AH.106", "X.1", "BT.10", "AJ.89", "BW.167", "X.49", "K.13", "AJ.42", "AH.39",
		"P.13", "AL.14", "BF.10", "BN.3", "BS.1", "AO.13", "BH.7", "AU.34", "BW.166", "D.20",
		"BV.9", "BW.164", "P.30", "AO.20", "I.3", "Y.21", "R.20", "K.40", "BW.176", "AI.27",
		"AZ.21", "P.15", "BF.44", "BZ.26", "K.74", "AI.2", "AR.11", "AN.3", "AI.20", "K.80",
		"BO.69", "AQ.20", "P.10", "BW.112", "W.20", "BO.44", "K.61", "BU.20", "BV.33", "AL.64",
		"BO.15", "BV.11", "AH.70", "N.7", "Y.4", "J.10", "BW.69", "M.19", "Y.36", "AJ.7", "R.18",
		"AU.77", "AJ.19", "AI.16", "AH.101", "BW.13", "BH.13", "BW.183", "BW.159", "AU.49", "R.27",
		"AU.73", "BG.16", "BW.79", "BB.12", "BZ.11", "BW.163", "AH.119", "AN.11", "AO.28", "O.10",
		"BT.54", "R.24", "K.50", "BW.150", "AJ.76", "AR.1", "BW.57", "AR.5", "BW.61", "AH.50",
		"D.6", "BO.39", "P.36", "BW.168", "K.35", "AL.31", "P.2", "AH.17", "K.78", "M.13", "AV.1",
		"AR.17", "K.85", "P.23", "K.11", "K.82", "BP.21", "BW.43", "AL.33", "P.45", "BP.20", "J.4",
		"I.24", "AL.42", "AH.36", "BD.3", "BW.107", "Q.16", "AR.3", "BW.48", "BB.10", "AQ.19",
		"AF.24", "I.16", "BW.40", "K.10", "AV.10", "BT.73", "BW.22", "AI.23", "AY.64", "AR.2",
		"AN.7", "AJ.113", "BZ.16", "R.32", "BU.5", "BO.72", "AH.7", "AO.25", "K.51", "O.2",
		"AH.68", "AZ.6", "BF.42", "BF.39", "K.12", "BO.66", "Y.38", "AZ.1", "AU.26", "BW.5",
		"AN.2", "K.46", "BW.58", "N.17", "AH.147", "AI.5", "K.75", "L.42", "BW.36", "W.17",
		"BW.33", "I.14", "AH.81", "P.24", "AU.16", "BG.4", "G.9", "AU.60", "K.24", "Z.34", "N.26",
		"BG.22", "I.41", "R.22", "L.15", "AC.4", "D.2", "AH.2", "BP.8", "AV.14", "BW.60", "K.92",
		"K.93", "AJ.112", "AL.69", "W.2", "P.35", "AL.21", "BT.45", "AH.67", "M.18", "BW.172",
		"I.25", "BG.13", "AY.17", "BW.125", "AY.43", "L.7", "AJ.114", "AR.25", "W.3", "AQ.32",
		"BT.31", "AZ.26", "BH.29", "BG.5", "BM.16", "BH.36", "BO.60", "AJ.64", "BU.9", "BT.15",
		"BP.18", "AF.8", "N.10", "BZ.9", "K.22", "BW.32", "AL.49", "K.53", "G.8", "BW.155", "L.43",
		"AX.2", "BW.37", "BT.49", "AJ.36", "BO.2", "BF.29", "AL.72", "AH.46", "AH.52", "AL.45",
		"AF.16", "K.4", "AX.1", "AR.36", "AL.5", "R.31", "W.5", "AY.26", "K.28", "Y.1", "AH.137",
		"BW.77", "Z.43", "BT.4", "X.40", "AC.2", "AJ.55", "Z.31", "BW.81", "BO.25", "AV.16",
		"AY.23", "I.18", "AH.122", "AY.24", "BU.29", "AJ.32", "K.79", "AI.12", "BD.2", "Y.2",
		"AH.86", "AW.4", "BO.65", "O.11", "BW.1", "I.8", "BF.20", "Q.15", "BB.6", "AJ.44", "BO.88",
		"Q.39", "K.103", "?", "AJ.15", "AJ.85", "AL.103", "AH.170", "AO.12", "AY.18", "AH.75",
		"BT.13", "BO.71", "N.25", "D.18", "AI.48", "AH.42", "AY.36", "AJ.88", "AF.21", "D.12",
		"BT.50", "J.7", "AL.36", "BW.154", "W.6", "BY.12", "AJ.37", "E.3", "L.6", "M.11", "BV.12",
		"AL.90", "Q.27", "Y.11", "BR.3", "AL.37", "R.29", "AZ.2", "BW.174", "BW.185", "X.15",
		"K.70", "M.8", "K.9", "AL.46", "BP.23", "K.68", "BG.14", "BF.35", "W.8", "BA.8", "L.3",
		"BW.66", "AL.13", "BO.104", "K.76", "AC.5", "AJ.30", "K.47", "BP.9", "K.66", "P.16",
		"BH.11", "I.12", "E.23", "L.13", "AU.69", "W.30", "AU.75", "BV.4", "AU.67", "BW.34",
		"BZ.32", "AQ.22", "BO.100", "AH.31", "BY.13", "AQ.4", "AL.77", "BZ.33", "AO.10", "Z.1",
		"BV.19", "AJ.27", "BB.3", "BH.22", "AC.1", "AY.30", "AL.44", "BW.73", "BW.63", "AV.9",
		"K.44", "W.29", "P.38", "BT.16", "R.7", "BW.21", "BU.31", "Q.2", "BZ.40", "X.57", "Z.15",
		"Q.23", "AO.21", "AX.6", "BT.1", "AH.83", "AO.11", "I.34", "AH.100", "AY.35", "AZ.35",
		"AZ.5", "L.31", "AU.8", "BZ.4", "AH.156", "AV.7", "BW.188", "AH.76", "AZ.19", "AC.3",
		"X.19", "AZ.28", "AF.4", "AR.20", "AH.118", "Z.39", "BV.21", "D.1", "X.41", "AU.43",
		"AI.13", "AY.28", "BT.23", "AL.43", "AH.19", "AY.55", "BT.14", "K.57", "K.69", "BW.131",
		"BU.39", "K.17", "AQ.16", "AN.14", "AH.35", "AL.73", "R.28", "AR.45", "AL.76", "BT.35",
		"AL.6", "AH.91", "BO.18", "K.33", "G.10", "AL.99", "R.37", "AR.37", "BT.25", "BO.50",
		"BO.98", "BO.89", "AH.148", "BW.129", "AW.1", "AV.6", "E.8", "BF.6", "AI.11", "BF.8",
		"BH.10", "K.67", "Y.40", "BT.46", "V.2", "BW.70", "AH.18", "BB.11", "R.1", "G.7", "BO.30",
		"I.33", "AL.85", "AF.15", "W.9", "AL.60", "Y.16", "BU.10", "AF.12", "D.24", "AJ.71",
		"AL.105", "AH.143", "BV.13", "L.1", "K.1", "AH.43", "R.39", "K.20", "AH.61", "AX.8",
		"L.59", "BW.76", "BF.31", "AL.108", "AN.5", "X.35", "BW.6", "BW.72", "BO.90", "AZ.22",
		"R.17", "W.13", "L.21", "BO.84", "AL.101", "K.58", "P.7", "AY.44", "Y.22", "K.96", "BZ.28",
		"Z.8", "AZ.17", "AD.4", "AI.18", "R.11", "AQ.11", "M.10", "BH.19", "AU.41", "BF.32",
		"AR.10", "L.19", "AY.65", "W.14", "AI.15", "AY.2", "AR.40", "BZ.36", "AH.21", "Z.27",
		"K.19", "BO.24", "AU.64", "AH.28", "AR.43", "AF.3", "AJ.117", "Z.45", "K.15", "BT.21",
		"E.6", "P.27", "BY.10", "AR.18", "X.21", "R.12", "BW.45", "M.3", "K.77", "R.49", "I.1",
		"BW.51", "BW.65", "BW.25", "BZ.27", "AL.53", "Y.39", "BW.46", "M.9", "AI.30", "BO.11",
		"BW.41", "AU.51", "BF.7", "AZ.25", "AH.33", "AL.23", "P.1", "M.15", "BG.3", "BW.85",
		"BF.11", "R.4", "AJ.18", "BW.54", "AL.63", "AU.30", "BM.4", "AZ.32", "R.43", "Z.11",
		"BO.1", "BZ.38", "BW.64", "AO.5", "AI.45", "BW.9", "AR.39", "R.16", "L.41", "BV.29", "X.2",
		"AH.38", "BF.37", "AR.22", "BU.22", "BZ.34", "AO.14", "AH.74", "AL.9", "AL.47", "BV.22",
		"BF.30", "Z.30", "AH.40", "O.9", "K.88", "BO.9", "AE.7", "AZ.39", "BA.1", "AL.87", "Q.18",
		"BH.24", "BO.76", "BV.10", "BP.22", "G.6", "P.25", "O.20", "Z.40", "AU.36", "I.32", "R.36",
		"L.35", "AJ.16", "B.3", "AJ.106", "BO.82", "BF.38", "G.4", "AF.22", "AQ.2", "BH.44",
		"BW.89", "AU.47", "BO.20", "AH.62", "W.23", "Z.12", "X.36", "AF.23", "AL.67", "AU.37",
		"BV.25", "G.3", "AZ.9", "AL.75", "BH.3", "BT.28", "BG.9", "BF.19", "Z.5", "BV.32", "N.19",
		"Q.4", "X.32", "BT.18", "AV.12", "BB.14", "K.48", "K.91", "I.35", "BW.182", "R.34",
		"AH.79", "AY.12", "AL.7", "U.5", "P.20", "BO.67", "P.11", "R.42", "BZ.2", "BF.34", "D.17",
		"BW.80", "BG.7", "P.8", "BH.43", "AY.38", "AP.11", "AY.62", "AO.16", "AZ.33", "AV.5",
		"BH.17", "AH.60", "AM.4", "D.7", "BO.92", "AY.60", "D.11", "I.11", "BH.16", "AD.1",
		"AQ.40", "AR.7", "U.7", "BW.118", "AQ.28", "AR.27", "K.25", "BN.2", "AR.32", "AL.51",
		"AV.11", "R.8", "AL.107", "BV.2", "BM.18", "BW.135", "BZ.23", "AH.41", "BC.1", "AJ.12",
		"BH.49", "BO.91", "AL.38", "Z.21", "AH.14", "AY.15", "AH.98", "AL.70", "Y.47", "AH.65",
		"R.10", "AD.3", "V.11", "CB.7", "AZ.12", "BM.15", "AH.55", "AQ.43", "L.53", "BP.10", "E.9",
		"AQ.24", "BW.87", "BW.88", "AY.9", "AR.28", "BO.96", "AY.13", "B.2", "R.19", "AJ.3",
		"X.34", "AR.4", "BW.27", "AL.58", "AL.66", "BO.102", "E.2", "L.34", "AR.6", "BW.35",
		"Y.46", "AT.1", "AX.5", "BO.17", "BL.3", "Q.10", "BW.102", "BW.149", "AL.17", "F.1", "K.8",
		"BA.13", "X.26", "BH.42", "AH.87", "BO.23", "J.1", "X.53", "Z.36", "K.49", "AZ.34",
		"AL.18", "AH.3", "AL.92", "AY.5", "AU.61", "Y.45", "AL.52", "AG.2", "BW.68", "AM.2",
		"AL.19", "AH.15", "AL.41", "AG.8", "Q.19", "AH.78", "AU.12", "AH.45", "AH.82", "AG.7",
		"N.20", "AL.82", "AU.42", "BW.91", "BT.40", "BM.17", "BL.1", "AJ.82", "D.22", "AE.2",
		"BW.52", "Q.25", "Z.14", "AY.21", "AQ.8", "BZ.30", "BA.10", "N.11", "BU.8", "AH.66",
		"BW.71", "AQ.33", "AU.65", "AZ.15", "BH.15", "BT.29", "AY.69", "AN.19", "BG.15", "BF.28",
		"AM.6", "BO.94", "AF.19", "BW.103", "Y.48", "BB.7", "AY.59", "BW.29", "BG.17", "Z.41",
		"P.29", "BT.9", "BG.1", "AH.97", "W.18", "BW.28", "BW.136", "AY.3", "AJ.83", "AI.49",
		"BV.1", "BW.94", "BW.138", "BG.10", "BW.142", "AJ.63", "Q.9", "E.24", "E.5", "BW.44",
		"R.51", "BV.30", "BW.97", "BL.2", "BV.26", "BW.84", "A.2", "X.46", "BH.4", "AU.66", "X.47",
		"AH.112", "BF.21", "BW.186", "BT.32", "AH.9", "AP.5", "BU.23", "AS.1", "AM.3", "AY.58",
		"AQ.37", "AJ.56", "AU.55", "AZ.4", "AH.90", "AL.50", "AJ.91", "AT.2", "AR.19", "Q.20",
		"Q.12", "BW.98", "AH.159", "AJ.22", "AQ.6", "BF.2", "BM.3", "AH.169", "BT.41", "D.5",
		"AE.5", "BG.18", "BW.82", "AY.27", "CB.3", "BH.46", "K.94", "AI.47", "K.38", "AH.12",
		"Q.5", "BF.4", "BG.6", "BF.1", "K.95", "X.18", "AY.54", "AJ.124", "AY.6", "AF.5", "AH.84",
		"X.6", "BG.11", "BT.24", "BQ.7", "AR.31", "AJ.102", "AE.3", "B.1", "AH.131", "BW.109",
		"AE.4", "AI.3", "AK.2", "BH.6", "V.5", "BB.1", "AJ.57", "AJ.25", "AG.5", "BA.2", "BT.6",
		"BH.45", "AF.13", "AU.21", "AQ.9", "BW.14", "L.10", "BQ.6", "BM.20", "BW.99", "Z.19",
		"AY.52", "Q.17", "AU.62", "AM.5", "CB.2", "AJ.75", "AF.25", "AZ.40", "BA.6", "I.5",
		"AJ.100", "V.6", "BW.119", "BW.104", "L.11", "Z.10", "K.26", "BU.15", "BM.2", "X.5",
		"BT.22", "BO.97", "BG.8", "BH.5", "AH.53", "E.27", "AL.80", "BH.41", "E.4", "R.38",
		"AQ.41", "AE.10", "L.45", "BW.108", "Q.47", "L.8", "U.6", "M.4", "BT.5", "CA.1", "BH.48",
		"AU.19", "AH.95", "BW.147", "BK.1", "AJ.90", "AH.13", "AH.114", "J.5", "U.9", "AJ.125",
		"BU.12", "R.5", "Q.46", "BM.8", "BM.13", "AE.1", "BQ.2", "AP.9", "AL.84", "BG.20", "BN.1",
		"AJ.94", "BO.99", "BM.6", "BT.74", "E.7", "K.27", "BO.19", "Z.24", "AP.6", "H.1", "AH.93",
		"AH.129", "AH.72", "CB.8", "AH.99", "AE.6", "E.17", "L.12", "BH.40", "BA.15", "BU.32",
		"Q.35", "AP.8", "C.1", "BA.4", "AR.34", "AI.28", "AQ.1", "U.1", "BW.86", "Q.13", "CA.5",
		"X.14", "AJ.96", "AI.7", "AG.6", "AU.70", "AO.24", "X.51", "E.15", "BA.7", "Q.44", "AR.23",
		"AU.52", "BO.26", "AI.32", "AY.61", "AJ.119", "BW.123", "AH.92", "AH.140", "AQ.29", "AK.1",
		"AH.11", "BW.124", "Q.7", "E.16", "I.6", "L.25", "AJ.118", "AU.53", "V.8", "AZ.31", "A.3",
		"AM.9", "Z.17", "L.16", "BF.23", "BW.146", "I.4", "BW.11", "AJ.45", "AH.128", "AM.7",
		"AM.10", "AH.117", "AJ.51", "BU.25", "AJ.66", "BO.22", "BW.55", "E.1", "AG.4", "R.35",
		"BQ.9", "BW.78", "AB.2", "R.9", "X.7", "Z.18", "BW.140", "AJ.107", "BW.139", "CA.2",
		"CA.4", "AM.1", "G.2", "U.2", "BW.128", "CB.6", "BU.37",
	]
	.iter()
	.map(ToString::to_string)
	.collect();

	let blind_submodel_variants = [
		"AU.54.3", "BF.36.3", "AR.41.1", "AJ.129.0", "AU.58.0", "BO.52.1", "BW.156.0", "BO.38.2",
		"BH.12.2", "AQ.17.1", "L.29.3", "BW.3.0", "BP.24.0", "AN.16.0", "K.3.5", "AR.35.0",
		"AO.29.2", "BH.18.6", "AU.14.1", "AU.40.0", "AH.77.1", "AH.164.1", "D.25.6", "AJ.49.1",
		"L.26.1", "AJ.121.1", "K.3.2", "AJ.122.3", "L.49.1", "L.28.4", "AJ.52.1", "K.34.4",
		"AJ.40.3", "X.45.8", "K.2.2", "Y.10.0", "W.4.5", "K.7.5", "BU.36.1", "Q.36.1", "AU.14.2",
		"BP.6.0", "AJ.40.0", "R.30.14", "AJ.29.2", "AO.1.3", "L.56.0", "D.25.8", "L.29.1",
		"AL.88.0", "AU.11.3", "AJ.77.2", "BV.17.2", "BU.38.8", "D.25.1", "AU.11.2", "K.7.3",
		"M.16.1", "Y.29.2", "I.15.2", "BG.19.0", "AH.6.1", "BW.49.1", "BT.72.2", "K.7.7",
		"BO.38.4", "Y.9.0", "E.28.0", "K.7.1", "R.15.2", "W.28.4", "S.1.1", "AJ.54.3", "AJ.14.3",
		"AJ.58.3", "AU.1.0", "AJ.9.1", "W.16.4", "Y.42.1", "AY.37.3", "BT.43.4", "AO.1.21",
		"AQ.39.1", "W.11.2", "L.28.2", "X.45.2", "K.63.3", "AU.54.2", "R.30.12", "BW.49.0",
		"AQ.31.0", "K.31.0", "AU.1.1", "AJ.35.0", "AJ.123.3", "AY.47.3", "Y.34.1", "K.60.0",
		"AJ.29.3", "BF.36.2", "AH.168.1", "P.34.0", "X.25.3", "N.8.0", "Y.29.0", "AL.24.0",
		"AU.50.0", "BT.43.3", "AJ.48.1", "BP.17.0", "BW.157.1", "I.29.1", "X.12.4", "D.21.0",
		"AU.14.0", "K.7.4", "Y.15.0", "AH.125.0", "K.65.3", "X.38.0", "AU.35.0", "BV.6.2",
		"BT.69.8", "AL.71.0", "BU.3.1", "BO.58.2", "AL.16.0", "AJ.58.2", "AU.27.0", "L.55.0",
		"K.81.2", "W.4.3", "BW.115.0", "BH.20.4", "O.23.0", "X.38.7", "X.24.8", "W.16.5", "X.24.1",
		"X.9.2", "BO.32.2", "BU.1.1", "Q.3.3", "BO.36.0", "BF.18.2", "W.10.1", "BW.178.0", "W.4.4",
		"BW.126.0", "BW.96.0", "D.25.7", "AI.17.0", "L.20.1", "AU.68.0", "AU.25.0", "BT.11.0",
		"P.9.0", "Z.38.0", "W.28.7", "K.39.0", "AJ.38.0", "AJ.59.2", "AJ.52.0", "AJ.54.1",
		"AO.7.10", "AJ.38.1", "Q.43.2", "BW.95.0", "Q.3.1", "BZ.14.1", "BW.160.1", "AH.69.0",
		"P.33.0", "BO.35.0", "BO.51.0", "AJ.40.2", "BP.15.0", "AJ.1.1", "BV.3.2", "Q.40.0",
		"AJ.129.3", "K.2.0", "D.19.0", "BV.20.4", "AJ.122.2", "BY.4.4", "AJ.5.1", "X.28.2",
		"BO.3.2", "X.3.6", "BO.53.1", "BO.32.3", "K.7.0", "AH.107.0", "BF.22.1", "BF.36.7",
		"L.51.1", "AJ.122.1", "L.57.0", "BO.38.1", "BY.6.2", "L.29.2", "BU.35.3", "W.4.0",
		"X.24.9", "BU.36.3", "Y.5.0", "X.45.10", "D.25.9", "AR.16.0", "BT.63.4", "AI.4.0",
		"X.52.1", "K.86.3", "AJ.43.0", "AH.8.1", "BO.38.0", "K.3.4", "BV.24.2", "BO.38.3",
		"W.16.3", "K.62.3", "BV.8.1", "BW.42.0", "BH.20.9", "Y.10.2", "BU.36.2", "R.23.7",
		"AN.12.0", "Y.32.0", "AJ.17.5", "AJ.14.1", "AJ.23.1", "R.48.9", "AL.110.0", "BW.132.0",
		"BT.63.5", "N.23.0", "Q.22.4", "Y.42.2", "AJ.77.1", "R.30.16", "AQ.14.1", "AO.33.2",
		"BW.92.0", "BM.1.0", "BO.47.1", "L.14.3", "BH.30.1", "AO.6.2", "O.19.0", "W.28.6",
		"BW.17.1", "Y.34.0", "BF.36.0", "N.22.1", "AU.2.4", "BY.4.0", "K.52.1", "K.60.3", "K.34.3",
		"P.18.0", "AX.4.1", "Q.40.2", "AR.14.2", "BO.35.2", "J.6.1", "X.3.1", "AH.106.0", "Y.32.1",
		"X.1.0", "L.29.0", "BT.10.0", "AJ.89.1", "BH.20.7", "BW.167.0", "X.38.5", "K.3.1",
		"Q.22.3", "X.49.1", "K.13.4", "AJ.42.0", "AH.39.0", "P.13.0", "AL.14.0", "BF.10.1",
		"K.2.4", "L.49.0", "BN.3.0", "K.86.2", "X.24.3", "W.11.0", "BS.1.4", "X.45.9", "M.16.2",
		"AO.13.1", "BH.7.2", "AO.7.6", "AU.34.0", "BW.166.0", "D.20.0", "BV.9.0", "K.13.8",
		"BW.164.1", "AU.11.0", "P.30.0", "AO.20.2", "Y.32.3", "I.3.4", "Y.21.2", "Y.29.5",
		"R.20.3", "BU.38.4", "K.40.3", "K.65.6", "BW.176.0", "AI.27.0", "AZ.21.1", "P.15.0",
		"AR.41.2", "BF.44.2", "BZ.26.1", "BH.18.2", "K.74.0", "AI.2.0", "AR.11.2", "AO.1.1",
		"AN.3.3", "AI.20.0", "X.45.7", "K.80.0", "BO.69.2", "BH.18.5", "AQ.20.0", "P.10.0",
		"BW.112.0", "BU.38.3", "AH.164.0", "AO.7.7", "Y.9.3", "W.20.1", "AJ.35.2", "Q.43.3",
		"K.34.0", "AO.7.8", "K.81.0", "BO.44.2", "BU.36.0", "X.3.2", "BT.11.1", "K.61.0", "Y.21.0",
		"AO.7.4", "X.3.5", "BU.20.1", "BV.33.0", "AU.2.5", "BH.30.2", "X.49.6", "BH.18.7",
		"AL.64.0", "K.65.1", "BO.35.5", "AJ.123.2", "X.45.5", "AH.168.0", "BO.15.1", "BV.11.0",
		"AH.70.0", "N.7.0", "Y.4.0", "BF.36.5", "J.10.1", "O.19.1", "BW.69.2", "L.28.1", "AO.7.13",
		"X.24.10", "AO.7.1", "M.19.2", "K.7.2", "Y.36.0", "AJ.7.1", "R.18.0", "AO.1.10", "AU.77.0",
		"K.7.6", "AJ.19.1", "AX.4.0", "AI.16.0", "AH.101.0", "AU.54.4", "L.29.5", "BW.13.1",
		"BH.13.1", "BW.183.1", "Y.42.0", "AQ.17.2", "AU.54.1", "D.25.3", "BW.159.1", "AU.49.0",
		"R.27.9", "AU.73.0", "BO.38.5", "BG.16.0", "BW.79.2", "BB.12.2", "BZ.11.2", "BW.163.1",
		"AH.119.0", "AZ.21.0", "AN.11.3", "AO.28.0", "BV.17.4", "O.10.3", "BT.54.1", "R.24.3",
		"K.50.1", "R.23.4", "BT.54.2", "BW.150.0", "AJ.76.2", "AR.1.1", "BW.57.0", "W.11.1",
		"K.65.5", "AR.5.1", "BW.61.0", "AH.50.0", "D.6.2", "BO.39.5", "P.36.0", "K.13.7",
		"BO.35.7", "BH.18.14", "BW.168.1", "K.35.4", "AL.31.0", "AN.11.1", "P.2.0", "AJ.40.1",
		"L.14.0", "AH.17.1", "K.78.1", "M.13.1", "AV.1.0", "AR.17.2", "K.85.0", "P.23.0", "K.11.2",
		"AY.37.4", "K.82.0", "BP.21.0", "BW.43.0", "R.30.10", "AL.33.0", "P.45.0", "BP.20.0",
		"J.4.1", "AO.1.8", "I.24.2", "AL.42.0", "X.9.4", "AH.36.3", "BD.3.0", "BW.107.0", "Q.16.0",
		"AR.3.0", "R.48.3", "BW.48.1", "K.13.2", "BB.10.3", "AQ.19.2", "AF.24.3", "X.45.4",
		"I.16.2", "J.4.0", "BW.40.1", "K.10.3", "AV.10.2", "BT.73.1", "BW.22.1", "AI.23.0",
		"AY.64.0", "AR.2.2", "AN.7.4", "M.19.1", "AJ.113.2", "BZ.16.1", "R.32.10", "BU.20.2",
		"BU.5.0", "AN.16.2", "BO.72.2", "BT.54.3", "BU.1.0", "R.48.8", "AH.7.0", "AO.25.1",
		"K.51.0", "O.2.1", "AH.68.0", "AZ.6.5", "BF.42.0", "BU.5.1", "AV.10.1", "R.23.0", "AR.1.2",
		"AN.11.0", "BF.39.0", "BO.36.3", "D.6.1", "K.80.2", "K.52.3", "K.12.2", "W.20.3",
		"BH.30.4", "BO.66.1", "Y.38.1", "W.4.6", "X.3.3", "AZ.1.2", "K.63.1", "AU.26.0", "BW.5.1",
		"AR.41.5", "AJ.17.4", "Y.32.4", "L.20.2", "M.13.2", "AN.2.0", "K.46.2", "BW.58.0",
		"N.17.0", "Y.29.4", "AH.147.0", "AJ.129.2", "AI.5.0", "K.75.0", "L.42.0", "BG.19.1",
		"AU.54.0", "AR.17.0", "K.10.2", "BV.6.1", "I.15.0", "I.24.1", "BW.36.1", "AZ.1.1",
		"W.17.1", "BW.33.1", "AJ.58.1", "I.14.0", "AH.81.0", "P.24.0", "AU.16.0", "Y.9.1",
		"X.28.3", "BG.4.1", "W.28.3", "G.9.1", "AU.60.0", "K.24.1", "BV.24.3", "Z.34.0", "W.10.0",
		"N.26.0", "BG.22.0", "X.45.3", "I.41.3", "R.22.7", "L.15.1", "BT.43.7", "AC.4.2", "D.2.1",
		"AH.2.1", "BP.8.0", "AV.14.2", "X.49.3", "R.20.1", "BW.60.0", "AJ.17.1", "K.92.1",
		"K.93.2", "AJ.112.5", "R.22.4", "AL.69.0", "Y.4.3", "W.2.2", "P.35.0", "J.6.0", "K.92.3",
		"AL.21.0", "R.23.1", "AN.2.1", "AQ.20.1", "BT.45.2", "Q.22.2", "AH.67.0", "BY.4.2",
		"M.18.2", "BW.172.0", "I.25.1", "BV.24.1", "BG.13.1", "AY.17.0", "BW.125.0", "AY.43.2",
		"L.7.0", "K.78.2", "AJ.114.1", "BT.73.4", "Y.34.3", "O.23.1", "AR.25.0", "W.3.3", "R.27.1",
		"AJ.35.1", "AQ.32.0", "K.2.5", "BT.69.5", "R.23.9", "W.2.4", "BT.31.0", "AV.10.3",
		"AZ.26.2", "AY.37.1", "BH.29.2", "BG.5.2", "R.27.7", "W.28.8", "BO.36.1", "R.30.15",
		"BM.16.0", "BH.36.1", "R.24.4", "BT.69.4", "AO.1.19", "AI.17.1", "BO.60.1", "AJ.64.2",
		"BU.9.0", "BT.15.0", "BP.18.0", "AF.8.1", "BO.36.8", "K.61.1", "BF.36.4", "N.10.1",
		"BO.36.4", "W.28.0", "BZ.9.0", "K.22.0", "Y.4.2", "AR.14.1", "BW.32.0", "X.9.1", "AL.49.0",
		"K.53.3", "K.10.1", "G.8.3", "BW.36.2", "BW.155.0", "R.30.6", "L.26.2", "L.43.0", "AX.2.1",
		"K.2.1", "BW.37.2", "M.18.1", "BT.49.1", "AJ.36.3", "AU.11.1", "BY.4.1", "BH.13.5",
		"Y.32.2", "BO.2.1", "BF.29.1", "I.14.2", "AY.37.13", "AL.72.0", "AH.46.1", "K.85.1",
		"Y.21.3", "BH.29.5", "AH.52.0", "AL.45.0", "BU.20.0", "AV.1.1", "BV.3.3", "AF.16.0",
		"K.4.1", "X.45.11", "AX.1.1", "BT.63.8", "AR.36.0", "AN.2.2", "Q.43.1", "BO.72.1",
		"AL.5.0", "R.31.1", "W.5.0", "AY.26.3", "K.28.1", "Y.1.0", "AJ.129.1", "AH.137.0",
		"BO.32.1", "K.82.2", "BO.44.1", "BW.77.1", "Z.43.0", "BT.4.0", "X.40.0", "AC.2.1",
		"X.25.1", "AJ.55.2", "X.45.1", "Z.31.0", "BW.81.1", "W.4.1", "O.10.1", "BO.25.1",
		"AV.16.0", "AY.23.0", "I.18.0", "AH.122.0", "AY.24.2", "AQ.39.0", "BU.29.1", "AJ.32.2",
		"O.10.4", "K.79.1", "AI.12.0", "BD.2.0", "M.16.0", "Y.2.1", "AC.4.1", "AH.86.0", "BZ.11.0",
		"R.20.4", "AJ.113.3", "AW.4.0", "AJ.42.1", "BU.35.2", "W.28.5", "BO.65.1", "AL.14.1",
		"O.11.1", "BW.69.1", "BH.30.3", "K.81.1", "AO.25.2", "BW.37.1", "BW.1.1", "L.51.2",
		"I.8.1", "X.3.4", "BF.20.2", "Q.15.0", "BB.6.3", "AJ.44.0", "BO.88.2", "X.25.2", "K.62.1",
		"Q.39.0", "AJ.129.5", "BV.24.4", "K.103.1", "?", "AJ.15.1", "AJ.85.1", "AV.10.0",
		"AL.103.0", "AH.170.0", "AO.12.1", "AY.18.1", "BT.69.3", "AH.75.1", "I.8.0", "X.49.7",
		"BT.13.0", "AO.1.7", "X.12.1", "BO.71.1", "BW.48.0", "N.25.0", "BV.3.1", "AJ.36.1",
		"BO.88.3", "D.18.0", "AI.48.0", "W.28.1", "AH.42.0", "BH.7.1", "W.2.0", "AY.36.3",
		"AJ.88.2", "AF.21.0", "D.12.0", "BV.8.3", "BT.50.3", "J.7.0", "AL.36.0", "BO.3.1",
		"AO.29.1", "BH.30.6", "BW.154.0", "W.6.0", "BY.12.3", "BT.43.5", "AF.8.0", "AJ.54.2",
		"AJ.37.2", "BO.38.6", "E.3.0", "L.6.0", "AJ.64.1", "AO.1.14", "M.11.0", "K.50.0", "Y.42.4",
		"BH.7.0", "BV.12.1", "AL.90.0", "Q.27.1", "Y.11.2", "AO.7.15", "R.23.10", "BR.3.1",
		"AL.37.0", "R.29.1", "BW.157.6", "K.46.1", "AJ.43.1", "AQ.19.3", "AO.1.0", "AZ.2.1",
		"AO.6.1", "BW.174.0", "BO.88.0", "BW.185.1", "BF.10.0", "X.15.0", "K.70.2", "Y.11.3",
		"AY.36.1", "Y.38.2", "BT.50.1", "M.8.4", "AR.41.3", "W.3.2", "K.9.0", "BT.69.6", "AL.46.0",
		"AO.20.3", "BP.23.0", "K.68.0", "BT.73.5", "BG.14.0", "BF.35.1", "R.31.4", "Y.9.4",
		"W.8.0", "BA.8.0", "AR.11.1", "L.3.1", "BU.38.5", "L.14.2", "BW.66.0", "BF.10.2",
		"AL.13.0", "BO.104.1", "BV.8.2", "K.76.1", "BH.20.2", "AN.16.5", "AC.5.1", "AQ.14.2",
		"AO.7.5", "AJ.30.0", "BU.20.3", "BT.50.2", "K.47.1", "BP.9.1", "K.66.2", "D.25.10",
		"P.16.0", "BH.11.1", "I.12.1", "AZ.2.0", "R.32.14", "Y.42.3", "AJ.112.4", "E.23.0",
		"K.80.1", "L.13.1", "X.28.1", "AU.69.0", "W.30.4", "AU.75.2", "K.74.1", "AJ.89.2",
		"BV.4.2", "AU.67.0", "K.3.0", "AZ.6.3", "BW.34.1", "K.93.1", "BZ.32.0", "BU.38.6",
		"BF.35.2", "AQ.22.0", "BO.100.1", "BF.44.3", "AH.31.1", "BY.13.1", "AQ.4.2", "K.51.1",
		"AL.77.0", "AR.17.1", "BZ.33.1", "J.7.1", "BW.157.2", "BV.20.3", "K.11.3", "K.35.1",
		"W.4.2", "AO.10.0", "K.12.1", "Z.1.0", "BV.19.4", "AJ.27.3", "K.13.6", "BB.3.0", "BH.22.0",
		"AC.1.1", "O.11.3", "BV.20.1", "AO.12.3", "AY.30.3", "K.28.0", "AL.44.0", "AO.12.2",
		"BO.32.4", "W.3.4", "BW.73.0", "W.2.3", "BW.63.1", "AV.9.2", "K.13.5", "K.44.0", "W.29.2",
		"R.27.10", "BH.18.16", "P.38.0", "AU.58.1", "BT.16.0", "AH.81.1", "R.7.4", "BW.21.1",
		"BR.3.0", "AV.16.1", "AY.30.4", "BU.31.0", "I.29.3", "Q.2.0", "BZ.40.0", "BF.44.1",
		"Q.36.3", "X.57.0", "Z.15.0", "Q.43.0", "BV.19.1", "Q.23.3", "AO.21.1", "AX.6.0", "Y.1.2",
		"M.8.3", "BT.1.2", "BF.36.6", "AJ.29.1", "BF.20.1", "AH.83.0", "AO.29.4", "AO.11.4",
		"I.34.1", "BH.29.6", "AQ.14.3", "BW.159.2", "L.13.2", "AJ.114.3", "AH.100.0", "AY.35.1",
		"BT.43.2", "AZ.35.0", "AZ.5.2", "BV.19.3", "X.57.1", "BO.39.2", "R.20.6", "K.82.1",
		"I.16.0", "L.31.4", "AU.8.0", "AJ.27.4", "BZ.4.0", "AH.156.0", "R.20.5", "AV.7.1",
		"BW.188.1", "AH.76.1", "AJ.32.3", "R.15.0", "BU.38.1", "BH.13.2", "AJ.59.1", "AZ.19.1",
		"AC.3.2", "X.19.2", "AZ.28.2", "AR.16.1", "AF.4.0", "R.23.8", "AR.20.0", "AH.118.0",
		"Z.39.0", "G.8.1", "BV.21.1", "BH.18.1", "AJ.14.6", "D.1.0", "BT.69.1", "I.14.1", "W.2.5",
		"X.41.0", "AU.2.6", "AU.43.0", "AI.13.0", "K.86.1", "W.28.2", "BH.22.2", "AY.28.2",
		"BT.23.0", "AY.23.3", "BO.35.8", "AL.43.0", "AH.19.1", "AY.55.2", "R.20.7", "BT.14.0",
		"BO.32.6", "W.30.2", "K.57.1", "K.69.1", "BW.131.0", "BU.39.0", "K.60.1", "BO.71.2",
		"K.17.0", "AQ.16.0", "AU.2.1", "R.7.3", "AN.14.0", "BH.29.7", "AZ.28.3", "BT.63.2",
		"R.30.4", "AY.55.1", "AN.16.4", "AH.35.1", "R.32.11", "K.65.2", "K.4.0", "AJ.112.2",
		"AN.16.3", "AO.1.12", "AL.73.0", "D.25.4", "O.10.2", "R.28.1", "AR.45.0", "AL.76.0",
		"BU.29.0", "BT.35.1", "AL.6.0", "Y.4.1", "AH.91.1", "K.40.4", "BO.18.1", "K.33.0",
		"G.10.1", "BO.35.6", "AY.37.6", "L.3.0", "AJ.112.3", "AL.99.0", "AX.2.2", "BU.38.2",
		"R.37.1", "R.24.1", "AR.37.0", "BT.25.0", "AQ.39.2", "BF.42.1", "O.10.5", "BY.6.3",
		"AJ.112.1", "BV.9.2", "Y.1.4", "AO.1.15", "BO.50.0", "R.24.5", "BO.98.1", "R.23.3",
		"BH.20.8", "Q.3.2", "BO.89.0", "BT.63.6", "K.68.1", "AH.148.1", "BW.129.0", "K.53.1",
		"R.22.10", "AW.1.0", "I.29.2", "AY.37.5", "AV.6.0", "E.8.0", "AV.9.1", "BF.6.1", "G.10.2",
		"R.30.2", "BW.168.2", "BO.69.1", "Y.1.1", "BT.43.6", "AI.11.0", "K.66.1", "K.35.0",
		"D.12.1", "BV.3.4", "BF.8.2", "I.29.0", "BH.10.1", "AC.3.3", "BF.22.3", "K.67.0", "Y.40.1",
		"BY.4.3", "AJ.76.1", "BT.46.1", "V.2.0", "BW.70.0", "BV.12.2", "AH.18.0", "BB.11.1",
		"AO.20.5", "BF.39.2", "AJ.123.1", "Q.40.1", "AO.10.1", "R.1.0", "BT.49.3", "BP.9.2",
		"G.7.1", "BW.156.1", "BO.30.1", "R.18.1", "AY.30.1", "I.33.1", "O.11.2", "AL.85.0",
		"AF.15.0", "X.49.2", "W.9.1", "Q.22.5", "AL.60.0", "R.31.7", "Y.16.0", "Y.2.4", "M.13.0",
		"BU.10.0", "BW.34.2", "X.52.4", "X.24.7", "AF.12.0", "D.24.1", "W.29.1", "D.2.0",
		"BW.79.1", "AJ.71.1", "AL.105.0", "R.24.6", "AH.143.0", "BH.18.9", "AU.2.3", "BV.13.0",
		"L.1.2", "K.1.2", "Q.40.3", "X.19.4", "AH.43.0", "R.39.1", "K.47.0", "W.16.6", "K.20.4",
		"AH.61.0", "BT.54.4", "AX.8.0", "L.59.1", "BT.72.5", "L.13.0", "AC.2.3", "BW.76.1",
		"AN.3.2", "BF.31.1", "AL.108.0", "BT.63.7", "AR.41.6", "AN.5.1", "BO.39.1", "X.35.0",
		"BW.6.1", "AO.1.11", "AU.77.1", "BW.72.0", "BO.90.0", "K.20.1", "I.8.4", "BV.9.1",
		"AZ.22.0", "BH.18.15", "R.17.5", "BH.12.1", "W.3.6", "BF.6.0", "W.13.2", "L.21.1", "Y.9.2",
		"BV.13.1", "BO.84.0", "AL.101.0", "BW.160.3", "BT.50.4", "K.58.0", "I.41.4", "AX.1.2",
		"L.26.0", "AN.11.2", "BO.58.1", "BT.10.1", "P.7.0", "AY.44.0", "AQ.4.4", "AF.24.2",
		"K.35.3", "Y.22.0", "K.96.1", "BV.19.2", "BH.30.5", "G.8.0", "BZ.28.0", "Z.8.0", "AF.24.1",
		"O.10.6", "AZ.17.3", "W.13.1", "BT.1.1", "AZ.35.1", "X.24.4", "AD.4.1", "BH.18.10",
		"R.30.17", "Q.36.4", "AI.18.0", "R.11.1", "R.17.3", "R.32.8", "AO.29.3", "L.1.3", "W.20.2",
		"AQ.11.2", "M.10.1", "Q.3.0", "BV.4.3", "BH.19.2", "BO.36.2", "I.33.0", "BO.32.5",
		"K.61.2", "AF.8.2", "AU.41.0", "BF.32.1", "AR.10.1", "AO.21.0", "L.19.1", "BH.22.1",
		"AY.65.0", "AJ.1.3", "X.52.2", "K.52.2", "W.14.0", "AI.15.0", "Y.2.2", "AY.2.2", "BU.35.0",
		"I.14.4", "AR.40.0", "O.11.4", "BZ.36.1", "X.19.1", "J.10.2", "Q.15.2", "AN.7.0", "AQ.4.1",
		"AC.4.3", "AH.21.1", "Z.27.2", "K.19.1", "BO.24.1", "M.8.2", "BZ.11.1", "BH.20.10",
		"AU.64.0", "AH.28.1", "AO.20.4", "AR.43.0", "BY.13.3", "AZ.26.4", "AF.3.1", "AJ.117.1",
		"X.52.5", "Z.45.0", "L.31.2", "K.15.1", "BT.21.0", "R.27.6", "E.6.0", "BH.18.0", "BG.4.2",
		"K.52.4", "AO.1.13", "BG.14.1", "BH.18.13", "P.27.0", "R.20.2", "BY.10.5", "R.15.1",
		"W.6.1", "L.15.0", "AR.18.0", "BH.18.11", "X.21.3", "R.32.16", "BZ.26.2", "R.12.1",
		"BW.45.0", "BY.6.0", "BO.39.3", "AO.1.5", "BY.12.1", "M.3.2", "BW.183.2", "K.77.1",
		"AF.24.5", "BF.39.1", "R.49.1", "J.10.0", "K.57.3", "BH.29.4", "L.28.5", "I.1.2",
		"BH.12.4", "BW.51.0", "BW.65.1", "BW.25.1", "Q.27.2", "BZ.27.1", "AU.25.1", "AQ.39.4",
		"BY.10.1", "AL.53.0", "AQ.32.1", "AO.20.1", "Y.39.0", "BW.46.1", "W.16.2", "M.9.1",
		"BF.35.0", "L.31.5", "R.22.6", "BT.72.3", "AI.30.1", "BO.11.1", "BW.41.1", "AN.5.2",
		"BV.24.0", "AU.51.2", "J.10.4", "AV.9.0", "Q.16.3", "BF.7.2", "K.61.3", "BO.39.4", "Q.2.1",
		"BW.159.5", "W.9.0", "AZ.25.1", "R.48.2", "BV.13.3", "AH.33.1", "AN.14.1", "AL.23.0",
		"BH.18.12", "P.1.0", "M.15.0", "BG.3.2", "Y.11.0", "W.10.2", "AQ.19.1", "BB.11.3",
		"BW.85.1", "X.38.6", "BF.11.2", "K.60.4", "AR.37.1", "V.2.7", "R.4.0", "I.16.1", "AC.3.1",
		"BW.174.1", "G.8.2", "X.3.7", "AY.26.1", "BV.17.3", "BH.11.3", "AJ.18.1", "Y.29.3",
		"BW.54.0", "AO.11.2", "AL.63.0", "BY.10.6", "AU.30.0", "BT.69.10", "BM.4.1", "AZ.32.0",
		"R.43.2", "Z.11.0", "BO.1.1", "BU.38.7", "BZ.38.1", "BW.64.1", "AO.5.0", "AI.45.0",
		"R.49.3", "BW.9.1", "R.27.2", "AO.11.1", "AC.2.2", "AO.1.4", "AR.39.0", "R.16.2", "L.41.0",
		"L.28.0", "BH.20.6", "BV.29.1", "AO.29.5", "X.2.0", "V.2.2", "M.15.1", "AO.11.3",
		"BZ.27.2", "BO.36.6", "AV.7.2", "AH.38.0", "BF.37.0", "AR.22.0", "BH.29.1", "W.16.1",
		"BU.22.1", "BZ.34.1", "K.1.1", "AO.14.0", "R.17.1", "BY.10.0", "AH.74.1", "AJ.14.7",
		"R.15.3", "K.65.4", "AL.9.0", "AL.47.0", "AO.7.14", "BV.22.2", "K.22.1", "BZ.28.1",
		"BF.30.1", "BO.35.3", "R.32.13", "K.68.2", "BT.73.2", "BH.12.5", "I.15.4", "Z.30.0",
		"AH.40.0", "M.18.4", "BU.35.1", "O.9.1", "K.88.2", "J.10.3", "BW.166.1", "W.8.1", "I.1.1",
		"BH.18.4", "AH.36.2", "Y.5.1", "BO.9.1", "BB.6.2", "AJ.88.1", "BW.183.0", "AE.7.2",
		"AY.35.3", "Y.38.3", "AZ.39.4", "BA.1.0", "BT.49.2", "BH.29.3", "AL.16.1", "BV.22.5",
		"BO.9.2", "AL.87.0", "AJ.32.1", "BH.11.5", "R.30.11", "I.8.3", "BU.3.2", "I.15.1", "X.9.0",
		"Q.18.0", "K.80.5", "BH.24.1", "BT.43.10", "M.3.1", "AU.49.1", "AZ.6.1", "BO.76.0",
		"R.30.13", "K.69.0", "BF.22.0", "BV.10.0", "R.30.8", "K.68.3", "BP.22.0", "M.8.1", "G.6.1",
		"P.25.0", "BY.6.1", "BH.22.3", "AZ.17.1", "W.3.5", "K.20.2", "O.20.0", "BH.11.2",
		"R.48.10", "AH.50.1", "Z.40.0", "AU.36.1", "AU.36.2", "I.32.1", "O.11.5", "AJ.113.1",
		"AU.2.2", "AR.16.2", "R.36.1", "L.35.1", "AV.1.2", "AJ.16.1", "K.80.3", "B.3.0", "AZ.17.2",
		"BU.22.0", "AJ.106.1", "BT.49.4", "BY.10.3", "BT.49.6", "BO.82.0", "BF.38.0", "G.4.1",
		"K.80.4", "G.4.2", "BO.36.7", "AF.22.0", "AQ.2.1", "R.16.1", "BH.44.2", "BW.89.0",
		"K.12.0", "Y.10.1", "R.30.1", "I.3.0", "AJ.114.2", "I.41.2", "L.29.4", "AU.47.1",
		"BO.20.1", "BZ.32.1", "AH.62.0", "AF.24.4", "W.23.1", "Z.12.0", "X.36.0", "R.48.5",
		"R.23.5", "BF.42.2", "K.34.1", "AF.23.0", "AL.67.0", "W.23.2", "BT.43.8", "Y.34.5",
		"X.12.3", "AU.37.0", "BV.25.1", "K.1.3", "BV.20.2", "G.3.3", "AZ.2.2", "AZ.9.1", "AL.75.0",
		"BH.3.1", "X.38.1", "I.1.3", "BT.28.0", "BG.9.0", "AR.5.0", "AQ.16.1", "BF.19.2", "Z.5.0",
		"M.19.4", "O.2.0", "BV.32.0", "W.2.1", "N.19.0", "Q.4.0", "X.32.1", "BT.18.0", "AV.12.1",
		"X.9.3", "BG.4.0", "BB.14.0", "K.48.0", "R.4.1", "K.91.1", "K.13.1", "I.35.1", "K.70.1",
		"BY.13.5", "L.3.2", "BH.11.4", "AJ.37.1", "BW.182.0", "W.3.0", "BG.16.2", "K.69.2",
		"R.34.1", "AH.79.0", "AY.12.1", "AL.7.0", "BV.12.0", "AU.27.1", "AR.14.3", "BT.11.2",
		"U.5.1", "P.20.0", "BO.67.1", "K.75.1", "P.11.0", "AV.7.0", "AZ.9.3", "AH.74.2", "BO.89.1",
		"R.42.0", "R.22.9", "BF.11.3", "BZ.2.0", "BV.22.1", "AO.5.1", "BF.34.2", "AJ.36.2",
		"D.17.0", "AJ.55.1", "BW.80.2", "AC.1.3", "BG.7.1", "P.8.0", "BH.43.1", "AY.38.1",
		"AJ.37.3", "R.32.12", "AP.11.1", "AO.29.9", "AQ.16.2", "AX.1.3", "I.41.1", "AY.62.1",
		"AO.16.0", "AZ.33.0", "X.19.3", "L.43.1", "AV.5.4", "BH.17.1", "AH.60.1", "AM.4.2",
		"D.7.0", "BO.88.1", "BO.92.1", "AY.60.1", "AU.26.1", "X.21.2", "AN.14.3", "D.11.2",
		"I.11.3", "BW.160.2", "AZ.21.2", "BH.16.0", "BZ.33.0", "Y.34.6", "AD.1.5", "AQ.40.1",
		"AR.7.0", "AN.16.1", "AH.67.1", "AO.1.6", "BV.22.4", "U.7.0", "X.49.4", "BW.92.1",
		"R.23.6", "I.11.1", "AN.5.0", "BW.118.1", "K.1.5", "R.15.4", "AQ.28.0", "AR.27.0",
		"K.25.1", "AX.4.2", "BT.72.1", "W.3.1", "BN.2.2", "K.92.2", "X.21.1", "AD.1.6", "AN.7.3",
		"AR.32.0", "I.8.2", "R.27.4", "BG.3.1", "AL.51.0", "AV.11.0", "R.27.8", "K.25.2",
		"AZ.22.1", "K.53.4", "R.8.1", "AL.107.0", "BT.43.9", "AV.16.2", "AO.1.9", "D.11.1",
		"BV.2.1", "L.19.2", "Q.16.2", "BO.82.1", "K.15.2", "BM.18.0", "AU.58.2", "BW.135.1",
		"AZ.19.2", "W.16.0", "BZ.23.1", "AH.41.0", "BC.1.0", "AJ.12.4", "BT.72.4", "BT.45.1",
		"K.35.2", "R.31.2", "BH.49.0", "X.52.6", "BF.29.2", "AJ.1.2", "K.53.2", "AY.28.4",
		"BO.91.0", "AL.38.0", "AO.1.17", "Y.2.0", "AR.14.0", "Z.21.0", "K.96.2", "BB.12.6",
		"I.3.2", "AH.14.1", "AV.12.2", "AY.15.1", "AY.35.0", "AH.98.0", "AL.70.0", "Y.47.0",
		"BH.16.1", "I.3.3", "AO.1.2", "AH.65.0", "BO.39.6", "AI.27.1", "R.10.0", "AD.3.1",
		"V.11.1", "BY.12.6", "CB.7.0", "AZ.12.4", "BM.15.0", "BA.1.3", "AZ.5.1", "AU.51.1",
		"BB.6.1", "AH.55.1", "BW.70.1", "BG.13.0", "AQ.43.1", "AZ.6.2", "L.53.0", "BP.10.0",
		"BF.36.1", "R.17.2", "E.9.0", "AQ.24.0", "BW.87.1", "Y.47.1", "BW.88.1", "AY.9.1",
		"X.38.3", "M.18.5", "AR.28.0", "BO.96.1", "AC.1.2", "AY.13.1", "B.2.0", "D.11.0", "R.19.0",
		"AJ.3.2", "X.34.0", "AU.47.0", "AY.35.6", "AR.4.1", "Q.15.3", "AJ.27.2", "R.30.9",
		"Q.16.1", "R.10.1", "AY.28.5", "D.25.2", "BW.27.1", "AL.58.0", "I.3.1", "BT.69.7",
		"K.60.2", "BF.22.2", "AZ.26.3", "BT.73.6", "AL.66.0", "BO.102.1", "R.49.2", "Q.15.1",
		"L.31.3", "E.2.0", "L.34.0", "AR.6.1", "BW.35.1", "BH.43.2", "R.32.2", "BT.50.5", "BU.1.2",
		"G.4.0", "Y.46.0", "AT.1.0", "AQ.4.3", "BY.13.0", "AX.5.0", "BO.17.1", "V.2.5", "AY.9.0",
		"BL.3.1", "AO.7.3", "Q.10.2", "BW.102.1", "AR.41.7", "BW.149.0", "L.34.1", "AL.17.0",
		"F.1.0", "AJ.17.3", "AU.50.1", "M.9.2", "K.8.2", "Z.27.1", "AH.83.1", "K.8.1", "BU.38.9",
		"AZ.26.0", "BA.13.0", "X.26.1", "AY.47.1", "L.28.6", "BH.42.2", "BU.9.1", "AH.87.0",
		"BO.23.1", "BG.4.3", "J.1.1", "BW.46.0", "X.53.1", "Z.36.0", "K.49.0", "AZ.34.0",
		"AL.18.0", "AZ.39.3", "AJ.85.2", "AH.3.1", "AL.92.0", "AY.5.0", "BY.12.2", "AU.61.1",
		"Y.45.0", "AL.52.0", "BF.11.1", "AG.2.0", "Q.23.1", "BW.68.2", "AM.2.1", "BG.22.1",
		"BH.24.2", "AL.19.0", "BF.8.0", "AJ.27.1", "AV.14.3", "AC.1.4", "BV.25.2", "AY.28.3",
		"BT.50.6", "AH.15.1", "AJ.3.1", "AL.41.0", "AG.8.0", "Q.19.0", "AH.78.1", "I.32.2",
		"K.17.1", "AU.12.0", "AY.23.1", "AV.14.1", "AH.45.1", "BF.22.4", "AH.82.1", "AG.7.0",
		"N.20.0", "AL.82.0", "AZ.1.5", "AU.42.0", "BW.91.0", "BT.40.0", "BM.17.0", "BY.13.4",
		"BL.1.1", "K.70.3", "R.30.3", "BO.36.9", "AJ.82.2", "K.82.3", "R.48.4", "R.43.3", "D.22.0",
		"AE.2.1", "BW.52.0", "R.30.7", "Q.25.1", "AJ.3.3", "Z.14.0", "AZ.12.3", "BT.43.1",
		"AZ.1.3", "L.20.0", "BH.44.1", "AY.21.4", "R.1.1", "R.1.2", "AQ.8.1", "BZ.30.2", "BA.10.0",
		"Q.36.2", "R.22.12", "BV.17.1", "BY.12.4", "BH.12.3", "K.11.1", "N.11.0", "W.30.1",
		"M.10.2", "Y.16.1", "BU.8.0", "BH.17.0", "BT.69.2", "BW.68.1", "AH.66.1", "L.35.0",
		"S.1.0", "R.22.5", "R.23.2", "BW.71.0", "BO.76.1", "R.27.3", "AQ.33.0", "BH.13.3",
		"AH.156.1", "AU.65.0", "AZ.15.0", "U.7.1", "AJ.129.4", "AD.1.2", "AO.6.3", "R.34.2",
		"R.7.2", "BH.15.1", "AY.47.2", "BT.29.0", "AZ.39.1", "BY.13.2", "AN.7.2", "AY.69.1",
		"R.31.5", "AN.19.2", "BF.38.1", "BG.15.1", "BF.28.0", "AQ.28.1", "AM.6.2", "AP.11.2",
		"BO.94.0", "BZ.4.1", "BT.43.11", "L.28.3", "D.24.3", "AF.19.0", "BW.103.0", "R.18.2",
		"Y.48.0", "BB.7.5", "AY.59.1", "L.21.2", "R.31.9", "BW.29.1", "BG.17.0", "Z.41.0",
		"K.69.3", "AZ.1.6", "P.29.0", "BG.5.1", "AU.12.1", "BT.9.0", "X.57.2", "BH.42.3", "BG.1.1",
		"AL.24.3", "AH.97.0", "BG.7.0", "AZ.17.0", "W.18.0", "R.22.8", "BW.28.1", "AQ.17.0",
		"BW.136.1", "BZ.28.2", "Q.10.1", "Y.38.0", "BH.13.4", "AY.47.8", "AY.3.1", "AJ.83.1",
		"AI.49.0", "AY.43.1", "BV.1.2", "V.2.4", "L.14.1", "AJ.14.4", "AJ.17.6", "BW.94.1",
		"BW.138.1", "Y.48.1", "Y.11.1", "BG.10.1", "BW.142.1", "AJ.63.1", "Q.9.1", "AJ.12.1",
		"E.24.0", "BT.69.9", "R.42.1", "E.5.0", "AZ.39.2", "BB.10.1", "BW.44.0", "R.51.0",
		"AZ.26.5", "R.32.4", "AO.7.9", "G.3.1", "BV.30.1", "AQ.39.5", "BW.97.0", "BT.46.2",
		"BT.63.9", "BV.12.3", "BL.2.0", "BV.26.0", "BY.12.0", "K.88.1", "BW.84.1", "A.2.0",
		"K.10.4", "AZ.5.4", "AZ.26.1", "X.46.1", "BH.4.1", "Y.21.4", "AZ.15.1", "BH.42.1",
		"AU.66.0", "AN.7.1", "G.6.2", "X.47.1", "M.16.3", "R.24.8", "D.25.5", "AJ.17.8",
		"AH.112.1", "AM.4.1", "BF.21.1", "BT.72.7", "I.34.2", "L.1.1", "R.17.4", "Y.46.1",
		"BT.54.5", "I.11.2", "BW.186.2", "AZ.5.3", "BN.2.4", "BT.32.0", "AJ.83.2", "AH.9.1",
		"AP.5.1", "AF.3.2", "BB.7.4", "AY.60.2", "BU.23.1", "AD.1.1", "AY.55.3", "I.32.3",
		"AS.1.0", "R.48.1", "AM.3.1", "AY.58.1", "AQ.37.0", "AQ.11.1", "AL.17.1", "BN.2.1",
		"D.24.2", "AJ.56.1", "BF.7.0", "R.32.9", "BW.51.1", "AH.79.1", "AU.55.0", "AR.41.4",
		"AZ.4.2", "BT.73.7", "R.31.10", "X.46.3", "AH.90.1", "BL.1.0", "AH.148.2", "AJ.14.2",
		"AL.50.0", "AJ.91.1", "BV.13.2", "Y.39.1", "BY.12.5", "AT.2.0", "AR.19.0", "X.49.5",
		"AY.37.12", "AY.47.6", "Q.20.0", "Q.12.1", "BW.52.1", "AV.12.0", "AH.68.1", "AZ.5.5",
		"I.3.7", "BW.98.0", "AH.159.0", "R.20.8", "AZ.28.1", "BA.1.1", "AJ.22.1", "AQ.6.2",
		"X.1.1", "BF.2.0", "AV.5.5", "BM.3.0", "Q.23.2", "AH.169.0", "BO.84.1", "BF.28.1",
		"BG.16.1", "BT.41.1", "D.5.1", "AE.5.0", "AZ.21.5", "BG.18.0", "K.34.2", "BZ.32.3",
		"D.24.4", "AX.1.0", "BW.82.1", "AY.27.1", "AQ.40.3", "CB.3.0", "BO.9.3", "BH.46.1",
		"K.94.2", "AI.47.0", "K.1.4", "BW.80.1", "K.38.0", "AH.12.1", "BY.6.4", "R.37.0", "M.18.3",
		"AH.147.1", "R.32.6", "I.12.2", "R.19.1", "Q.5.1", "K.94.1", "BF.4.0", "BG.6.0", "BF.1.0",
		"AF.15.1", "AH.90.0", "R.32.5", "K.95.1", "AZ.28.4", "R.32.3", "X.18.0", "AY.54.1",
		"I.3.5", "I.14.3", "AD.1.4", "AJ.124.3", "AY.6.1", "BT.50.7", "AF.5.0", "X.24.11",
		"AY.24.6", "R.27.5", "BZ.2.1", "AQ.2.4", "BG.14.2", "AH.84.0", "X.6.0", "BG.11.0",
		"K.50.2", "BT.24.0", "BQ.7.0", "AR.31.0", "BG.9.1", "AJ.102.1", "V.2.6", "AE.3.1",
		"BY.10.4", "B.1.0", "AH.131.1", "BW.109.0", "X.38.2", "AE.4.1", "AQ.2.2", "AI.3.0",
		"AZ.21.3", "AO.7.12", "AJ.16.2", "AZ.28.0", "AR.5.2", "AK.2.0", "BF.18.3", "AV.5.3",
		"AQ.40.2", "BH.6.1", "AV.6.1", "V.5.1", "BB.1.0", "R.30.5", "BM.17.1", "AJ.57.1", "R.7.1",
		"AJ.25.1", "AG.5.0", "AY.2.1", "AM.6.1", "BA.2.0", "BT.6.0", "AU.51.0", "AZ.6.4", "V.2.1",
		"BH.45.1", "AN.14.2", "AF.13.0", "AU.21.1", "AQ.9.1", "BB.11.2", "BW.14.1", "BF.7.1",
		"AJ.82.1", "AJ.19.2", "V.2.3", "L.10.0", "BQ.6.0", "R.32.15", "R.36.0", "BB.10.2",
		"BZ.33.2", "BM.20.0", "BW.99.1", "X.38.4", "K.10.5", "Z.19.0", "BH.15.0", "BS.1.5",
		"AD.3.2", "AE.2.0", "AJ.12.3", "AF.4.1", "AY.52.1", "AO.1.20", "X.26.2", "AQ.39.3",
		"Q.17.0", "AU.62.0", "AQ.43.2", "K.20.0", "AM.5.1", "CB.2.0", "AO.1.18", "AO.29.6",
		"BH.19.1", "AJ.75.1", "R.1.3", "AF.25.2", "BL.1.2", "AZ.40.1", "BA.6.0", "AJ.17.2",
		"I.5.1", "R.43.1", "BG.13.2", "BF.37.1", "AJ.100.1", "V.6.0", "L.31.0", "BW.119.1",
		"AF.8.3", "BW.104.0", "G.4.3", "K.22.2", "R.30.18", "Q.12.2", "AY.64.1", "BZ.40.1",
		"L.11.0", "BU.10.1", "Z.10.0", "AJ.12.2", "K.26.1", "BU.15.0", "BW.54.1", "AH.148.3",
		"AZ.9.2", "BZ.40.2", "BM.2.0", "BV.26.1", "X.5.0", "L.34.3", "AY.47.12", "AE.7.1",
		"BT.49.7", "BT.22.0", "K.57.2", "BO.97.1", "AY.37.10", "AU.60.1", "BG.8.1", "BW.35.2",
		"AE.5.1", "BH.5.0", "BW.95.1", "AH.53.0", "Q.10.3", "E.27.1", "BV.22.3", "BV.30.0",
		"AL.80.0", "BH.41.1", "AZ.4.1", "J.6.2", "BB.12.3", "BT.49.5", "E.4.0", "R.38.0",
		"AQ.41.0", "AH.82.0", "R.20.0", "AE.10.1", "K.57.4", "L.45.1", "BT.63.10", "AV.6.2",
		"BV.25.0", "AJ.15.2", "BS.1.1", "AZ.1.8", "BW.108.0", "Q.47.1", "L.8.1", "K.20.3", "U.6.1",
		"AL.72.1", "Q.4.1", "BV.29.0", "AQ.6.1", "AJ.18.2", "M.4.0", "BT.5.0", "CA.1.0", "X.52.3",
		"AD.4.2", "BH.48.1", "AU.19.0", "AH.95.1", "BL.3.2", "AM.3.2", "Z.41.1", "BF.34.1",
		"BW.147.0", "K.4.2", "AY.13.0", "AJ.124.2", "BK.1.0", "AJ.90.1", "U.5.2", "AC.5.2",
		"AY.24.1", "X.24.2", "AH.13.1", "R.24.7", "X.12.0", "AH.114.1", "J.5.1", "AF.25.1",
		"AZ.21.4", "AQ.37.1", "BT.1.3", "U.9.0", "AJ.125.3", "AE.10.0", "BU.12.1", "BF.1.1",
		"Q.23.0", "Q.25.0", "R.5.0", "Q.46.0", "BM.8.0", "AO.7.11", "BM.13.0", "AM.2.0", "AE.1.0",
		"BQ.2.1", "AP.9.0", "BL.3.3", "AZ.1.7", "AL.84.0", "BG.20.0", "AJ.125.2", "BW.76.0",
		"BW.186.1", "BQ.2.0", "AY.65.1", "R.31.3", "BN.1.2", "Q.22.1", "BH.43.3", "AJ.94.1",
		"BO.99.1", "AN.3.1", "BM.6.0", "AD.1.3", "AO.33.1", "AU.41.1", "BF.8.1", "AZ.12.1",
		"AJ.17.7", "K.26.2", "BT.74.1", "E.7.0", "K.27.1", "R.17.0", "X.26.0", "BO.19.1", "V.2.8",
		"I.5.2", "L.55.1", "Z.24.1", "AP.6.1", "H.1.0", "AH.93.0", "AH.129.1", "AH.72.1", "BU.8.1",
		"AV.5.2", "CB.8.1", "AH.99.1", "BG.5.3", "AE.6.1", "M.19.5", "E.17.0", "R.22.11",
		"BU.23.0", "L.12.1", "CB.8.0", "BH.40.1", "BV.1.1", "Q.9.0", "BA.15.0", "BU.32.0",
		"AQ.9.0", "Q.35.1", "AH.168.3", "AP.8.1", "C.1.1", "Q.35.0", "L.45.0", "R.31.6", "BA.4.0",
		"BH.49.1", "AR.34.0", "CB.7.1", "AI.28.2", "AQ.1.1", "AQ.40.4", "U.1.2", "BO.82.2",
		"BZ.30.0", "R.38.1", "AY.47.9", "X.47.2", "AQ.14.4", "BW.60.1", "BW.86.1", "Q.13.1",
		"BB.12.4", "Q.22.0", "L.34.2", "L.8.0", "BG.8.0", "CA.5.0", "Y.45.1", "X.14.0", "AJ.96.1",
		"I.15.3", "AE.3.2", "E.9.1", "BS.1.3", "AJ.124.1", "AH.72.2", "AI.7.1", "AG.6.0",
		"AU.70.0", "AO.24.0", "X.51.1", "AM.5.2", "E.15.0", "BA.7.0", "Q.44.0", "X.45.6", "Q.13.2",
		"AH.60.2", "AR.23.0", "AU.52.1", "AI.28.1", "BO.26.1", "AI.32.0", "BO.35.4", "L.19.3",
		"AZ.22.3", "AE.1.1", "BW.182.1", "AY.61.1", "BB.7.1", "BH.20.1", "L.45.2", "AJ.119.1",
		"BW.123.0", "AH.92.0", "AH.140.0", "AM.5.0", "G.3.2", "AQ.29.1", "AK.1.0", "AH.11.1",
		"L.20.3", "BW.124.1", "AO.13.0", "Q.7.1", "E.16.0", "BW.185.2", "I.6.1", "L.25.1",
		"AJ.118.1", "X.12.2", "AU.53.0", "AP.9.1", "V.8.0", "I.3.6", "BN.1.1", "AZ.31.1",
		"BF.38.4", "AZ.22.2", "J.7.2", "BY.10.2", "AY.62.2", "A.3.0", "AV.5.1", "BO.36.5",
		"AM.9.0", "AM.3.0", "Z.17.0", "AQ.37.2", "L.16.1", "AQ.40.5", "AZ.4.3", "AZ.19.3",
		"BA.1.2", "AZ.1.4", "R.32.1", "BF.23.1", "AY.24.7", "AH.170.2", "BL.3.4", "BN.2.3",
		"BW.146.1", "I.4.0", "BF.23.3", "BW.11.1", "AE.10.2", "AQ.2.3", "AJ.45.1", "K.13.3",
		"AH.128.1", "U.1.0", "BU.12.0", "AM.7.1", "AM.10.1", "AH.117.1", "BO.11.2", "AJ.51.1",
		"AO.7.2", "R.32.7", "BU.25.0", "U.1.1", "BH.41.2", "AY.36.6", "AJ.66.1", "AJ.125.1",
		"BO.22.1", "AM.2.2", "BO.67.2", "BW.55.1", "E.1.0", "AG.4.0", "R.35.0", "BQ.9.0",
		"AY.28.6", "BW.78.1", "BV.4.1", "AZ.31.2", "AB.2.0", "R.9.1", "X.7.0", "AB.2.1", "Z.18.0",
		"BF.38.3", "BW.140.0", "AE.6.2", "AV.5.0", "BH.20.3", "AZ.12.2", "AY.13.2", "AJ.107.1",
		"BW.139.1", "CA.2.0", "AS.1.1", "R.31.8", "M.19.3", "CA.4.1", "BS.1.2", "AM.1.1", "G.2.1",
		"U.2.1", "AE.3.0", "BW.128.0", "CB.6.0", "BU.37.1",
	]
	.iter()
	.map(ToString::to_string)
	.collect();
	let cat1_variants = ["G", "B", "D", "I", "F", "A", "E", "C", "H", "J", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat2_variants = ["B", "C", "?", "A"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat3_variants = ["A", "F", "B", "C", "E", "D", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat4_variants = ["A", "?", "C", "B"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat5_variants = ["C", "A", "?", "B"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat6_variants = ["D", "C", "E", "B", "F", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat7_variants = ["A", "C", "?", "D", "B"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat8_variants = ["A", "B", "C", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat9_variants = ["B", "A"].iter().map(ToString::to_string).collect();
	let cat10_variants = ["A", "B", "C", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat11_variants = ["B", "E", "C", "A", "D", "F", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let cat12_variants = ["C", "B", "E", "D", "F", "A"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let ordcat_variants = ["4", "2", "5", "3", "7", "6", "1", "?"]
		.iter()
		.map(ToString::to_string)
		.collect();
	let nvcat_variants = [
		"L", "N", "M", "J", "B", "E", "O", "F", "K", "D", "A", "H", "C", "G", "I",
	]
	.iter()
	.map(ToString::to_string)
	.collect();
	let options = tangram_table::FromCsvOptions {
		column_types: Some(btreemap! {
			"row_id".to_owned()=> TableColumnType::Number,
			"household_id".to_owned()=> TableColumnType::Number,
			"vehicle".to_owned()=> TableColumnType::Number,
			"calendar_year".to_owned()=> TableColumnType::Number,
			"model_year".to_owned()=> TableColumnType::Number,
			"blind_make".to_owned()=> TableColumnType::Enum { variants: blind_make_variants },
			"blind_model".to_owned()=> TableColumnType::Enum { variants: blind_model_variants },
			"blind_submodel".to_owned()=> TableColumnType::Enum { variants: blind_submodel_variants },
			"cat1".to_owned()=> TableColumnType::Enum { variants: cat1_variants },
			"cat2".to_owned()=>  TableColumnType::Enum { variants: cat2_variants },
			"cat3".to_owned()=>  TableColumnType::Enum { variants: cat3_variants },
			"cat4".to_owned()=>  TableColumnType::Enum { variants: cat4_variants },
			"cat5".to_owned()=>  TableColumnType::Enum { variants: cat5_variants },
			"cat6".to_owned()=>  TableColumnType::Enum { variants: cat6_variants },
			"cat7".to_owned()=>  TableColumnType::Enum { variants: cat7_variants },
			"cat8".to_owned()=>  TableColumnType::Enum { variants: cat8_variants },
			"cat9".to_owned()=>  TableColumnType::Enum { variants: cat9_variants },
			"cat10".to_owned()=>  TableColumnType::Enum { variants: cat10_variants },
			"cat11".to_owned()=>  TableColumnType::Enum { variants: cat11_variants },
			"cat12".to_owned()=>  TableColumnType::Enum { variants: cat12_variants },
			"ordcat".to_owned()=> TableColumnType::Enum { variants: ordcat_variants },
			"var1".to_owned()=> TableColumnType::Number,
			"var2".to_owned()=> TableColumnType::Number,
			"var3".to_owned()=> TableColumnType::Number,
			"var4".to_owned()=> TableColumnType::Number,
			"var5".to_owned()=> TableColumnType::Number,
			"var6".to_owned()=> TableColumnType::Number,
			"var7".to_owned()=> TableColumnType::Number,
			"var8".to_owned()=> TableColumnType::Number,
			"nvcat".to_owned()=> TableColumnType::Enum { variants: nvcat_variants },
			"nvvar2".to_owned()=> TableColumnType::Number,
			"nvvar3".to_owned()=> TableColumnType::Number,
			"nvvar4".to_owned()=> TableColumnType::Number ,
			"claim_amount".to_owned()=> TableColumnType::Number,
		}),
		..Default::default()
	};
	let mut features_train =
		Table::from_path(csv_file_path_train, options.clone(), &mut |_| {}).unwrap();
	let labels_train = features_train.columns_mut().remove(target_column_index);
	let labels_train = labels_train.as_number().unwrap();
	let mut features_test = Table::from_path(csv_file_path_test, options, &mut |_| {}).unwrap();
	let labels_test = features_test.columns_mut().remove(target_column_index);
	let labels_test = labels_test.as_number().unwrap();
	let feature_groups: Vec<tangram_features::FeatureGroup> = features_train
		.columns()
		.iter()
		.map(|column| match column {
			TableColumn::Number(_) => tangram_features::FeatureGroup::Normalized(
				tangram_features::NormalizedFeatureGroup::compute_for_column(column.view()),
			),
			TableColumn::Enum(_) => tangram_features::FeatureGroup::Normalized(
				tangram_features::NormalizedFeatureGroup::compute_for_column(column.view()),
			),
			_ => unreachable!(),
		})
		.collect();
	let features_train = tangram_features::compute_features_array_f32(
		&features_train.view(),
		feature_groups.as_slice(),
		&|| {},
	);
	let features_test = tangram_features::compute_features_array_f32(
		&features_test.view(),
		feature_groups.as_slice(),
		&|| {},
	);

	// Train the model.
	let train_options = tangram_linear::TrainOptions {
		learning_rate: 0.01,
		max_epochs: 1,
		n_examples_per_batch: 1000,
		..Default::default()
	};
	let train_output = tangram_linear::Regressor::train(
		features_train.view(),
		labels_train.view(),
		&train_options,
		Progress {
			kill_chip: &tangram_kill_chip::KillChip::default(),
			handle_progress_event: &mut |_| {},
		},
	);

	// Make predictions on the test data.
	let chunk_size =
		(features_test.nrows() + rayon::current_num_threads() - 1) / rayon::current_num_threads();
	let mut predictions = Array::zeros(labels_test.len());
	pzip!(
		features_test.axis_chunks_iter(Axis(0), chunk_size),
		predictions.axis_chunks_iter_mut(Axis(0), chunk_size),
	)
	.for_each(|(features_test_chunk, predictions_chunk)| {
		train_output
			.model
			.predict(features_test_chunk, predictions_chunk);
	});

	// Compute metrics.
	let mut metrics = tangram_metrics::RegressionMetrics::new();
	metrics.update(tangram_metrics::RegressionMetricsInput {
		predictions: predictions.as_slice().unwrap(),
		labels: labels_test.view().as_slice(),
	});
	let metrics = metrics.finalize();

	let output = json!({
		"mse": metrics.mse,
	});
	println!("{}", output);
}
