Helper macros for using the code generated by
[tailwindcss-to-rust](https://crates.io/crates/tailwindcss-to-rust).

The generated code provides a number of static structs where each field is
a class name or modifier (like "lg" or "hover"). In typical use, you need
to combine multiple names and modifiers into a single string to be set as
an element's `class` attribute. This crate provides two macros to make
using this a bit more ergonomic.

A [Dioxus](https://dioxuslabs.com/) example:

```rust,ignore
// Note that you have to write this css module to tie it all together.
use css::*;
use dioxus_prelude::*;

fn SomeComponent(cx: Scope) -> Element {
    cx.render(rsx! {
        div {
            // "grid-cols-3 md:grid-cols-6 lg:grid-cols-12"
            class: DC![
                C.fg.grid-cols-3,
                M![M.md, C.fg.grid-cols-6],
                M![M.lg, C.fg.grid-cols-12]
            ],
            div {
                // "text-lg text-white"
                class: DC![C.typ.text_lg, C.typ.text_white],
            }
        }
    })
}
```
