use crate::config::HtmlConfig;
use itertools::Itertools;
use tl::{parse, Node, ParserOptions};
#[cfg(test)]
mod test;

use crate::Result;

impl HtmlConfig {
    pub fn find_all_class(input: &str, buffer: &mut Vec<String>) -> Result<()> {
        let dom = parse(input, ParserOptions::default())?;
        for node in dom.nodes() {
            // ignore if any problem
            push_class(node, buffer);
        }
        Ok(())
    }
}

fn push_class(node: &Node, buffer: &mut Vec<String>) -> Option<()> {
    let attributes = node.as_tag()?.attributes();
    let class = attributes.class_iter()?.join(" ");
    buffer.push(class);
    Some(())
}
