pub mod breakpoints;
pub mod colors;
pub mod effects;
pub mod flexbox;
pub mod fonts;
pub mod layouts;
pub mod preflight;
pub mod sizes;
pub mod spaces;
pub mod tables;
pub mod typography;

use crate::{
    css_attributes,
    traits::{CssAttribute, ParsedItem, ParsedList},
    TailwindInstance,
};
use css_style::unit::{percent, px, rem, Length};
use nom::{
    branch::alt,
    bytes::complete::tag,
    character::complete::digit1,
    combinator::{map_res, opt, recognize},
    sequence::tuple,
    IResult,
};
use std::{
    collections::{BTreeSet, HashMap, HashSet},
    fmt::{Debug, Display, Formatter, Write},
};

pub(crate) fn as_list(out: ParsedItem) -> ParsedList {
    match out {
        Ok((rest, o)) => Ok((rest, HashSet::from_iter(vec![o]))),
        Err(e) => Err(e),
    }
}

/// Remove instance from builder
pub(crate) struct SealedRemover(String);
