use super::*;

impl Display for TailwindBlur {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "blur-{}px", self.px)
    }
}

impl TailwindInstance for TailwindBlur {
    fn attributes(&self, _: &TailwindBuilder) -> BTreeSet<CssAttribute> {
        let filter = match self.backdrop {
            true => "backdrop-filter",
            false => "filter",
        };
        let scale = format!("blur({}px)", self.px);
        css_attributes! {
            filter => scale
        }
    }
}

impl Display for TailwindBrightness {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "brightness-{}", self.percent)
    }
}

impl TailwindInstance for TailwindBrightness {
    fn attributes(&self, _: &TailwindBuilder) -> BTreeSet<CssAttribute> {
        let filter = match self.backdrop {
            true => "backdrop-filter",
            false => "filter",
        };
        let brightness = format!("brightness({})", self.percent as f32 / 100.0);
        css_attributes! {
            filter => brightness
        }
    }
}

impl Display for TailwindContrast {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "contrast-{}", self.percent)
    }
}

impl TailwindInstance for TailwindContrast {}

impl Display for TailwindGrayscale {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        debug_assert!(self.percent <= 100);
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "grayscale-{}", self.percent)
    }
}

impl TailwindInstance for TailwindGrayscale {}

impl Display for TailwindHueRotate {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "hue-rotate-{}", self.deg)
    }
}

impl TailwindInstance for TailwindHueRotate {}

impl Display for TailwindInvert {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        debug_assert!(self.percent <= 100);
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "invert-{}", self.percent)
    }
}

impl TailwindInstance for TailwindInvert {}

impl Display for TailwindSaturate {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "saturate-{}", self.percent)
    }
}

impl TailwindInstance for TailwindSaturate {}

impl Display for TailwindSepia {
    fn fmt(&self, f: &mut Formatter<'_>) -> std::fmt::Result {
        debug_assert!(self.percent <= 100);
        if self.backdrop {
            f.write_str("backdrop-")?;
        }
        write!(f, "sepia-{}", self.percent)
    }
}

impl TailwindInstance for TailwindSepia {}
