// This code was autogenerated with `dbus-codegen-rust `, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::nonblock;

pub trait OrgFreedesktopDBusPeer {
    fn ping(&self) -> nonblock::MethodReply<()>;
    fn get_machine_id(&self) -> nonblock::MethodReply<String>;
}

impl<'a, T: nonblock::NonblockReply, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusPeer for nonblock::Proxy<'a, C> {

    fn ping(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.DBus.Peer", "Ping", ())
    }

    fn get_machine_id(&self) -> nonblock::MethodReply<String> {
        self.method_call("org.freedesktop.DBus.Peer", "GetMachineId", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }
}

pub trait OrgFreedesktopDBusIntrospectable {
    fn introspect(&self) -> nonblock::MethodReply<String>;
}

impl<'a, T: nonblock::NonblockReply, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusIntrospectable for nonblock::Proxy<'a, C> {

    fn introspect(&self) -> nonblock::MethodReply<String> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }
}

pub trait OrgFreedesktopDBusProperties {
    fn get(&self, interface: &str, property: &str) -> nonblock::MethodReply<arg::Variant<Box<dyn arg::RefArg + 'static>>>;
    fn get_all(&self, interface: &str) -> nonblock::MethodReply<arg::PropMap>;
    fn set(&self, interface: &str, property: &str, value: arg::Variant<Box<dyn arg::RefArg>>) -> nonblock::MethodReply<()>;
}

#[derive(Debug)]
pub struct OrgFreedesktopDBusPropertiesPropertiesChanged {
    pub interface: String,
    pub changed_properties: arg::PropMap,
    pub invalidated_properties: Vec<String>,
}

impl arg::AppendAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.interface, i);
        arg::RefArg::append(&self.changed_properties, i);
        arg::RefArg::append(&self.invalidated_properties, i);
    }
}

impl arg::ReadAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopDBusPropertiesPropertiesChanged {
            interface: i.read()?,
            changed_properties: i.read()?,
            invalidated_properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopDBusPropertiesPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus.Properties";
}

impl<'a, T: nonblock::NonblockReply, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusProperties for nonblock::Proxy<'a, C> {

    fn get(&self, interface: &str, property: &str) -> nonblock::MethodReply<arg::Variant<Box<dyn arg::RefArg + 'static>>> {
        self.method_call("org.freedesktop.DBus.Properties", "Get", (interface, property, ))
            .and_then(|r: (arg::Variant<Box<dyn arg::RefArg + 'static>>, )| Ok(r.0, ))
    }

    fn get_all(&self, interface: &str) -> nonblock::MethodReply<arg::PropMap> {
        self.method_call("org.freedesktop.DBus.Properties", "GetAll", (interface, ))
            .and_then(|r: (arg::PropMap, )| Ok(r.0, ))
    }

    fn set(&self, interface: &str, property: &str, value: arg::Variant<Box<dyn arg::RefArg>>) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.DBus.Properties", "Set", (interface, property, value, ))
    }
}

pub trait OrgFreedesktopSystemd1Manager {
    fn get_unit(&self, arg0: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn get_unit_by_pid(&self, arg0: u32) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn load_unit(&self, arg0: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn start_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn start_unit_replace(&self, arg0: &str, arg1: &str, arg2: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn stop_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn reload_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn try_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn reload_or_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn reload_or_try_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn kill_unit(&self, arg0: &str, arg1: &str, arg2: i32) -> nonblock::MethodReply<()>;
    fn reset_failed_unit(&self, arg0: &str) -> nonblock::MethodReply<()>;
    fn set_unit_properties(&self, arg0: &str, arg1: bool, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>) -> nonblock::MethodReply<()>;
    fn start_transient_unit(&self, arg0: &str, arg1: &str, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>, arg3: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn get_job(&self, arg0: u32) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn cancel_job(&self, arg0: u32) -> nonblock::MethodReply<()>;
    fn clear_jobs(&self) -> nonblock::MethodReply<()>;
    fn reset_failed(&self) -> nonblock::MethodReply<()>;
    fn list_units(&self) -> nonblock::MethodReply<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>>;
    fn list_units_filtered(&self, arg0: Vec<&str>) -> nonblock::MethodReply<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>>;
    fn list_jobs(&self) -> nonblock::MethodReply<Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>>;
    fn subscribe(&self) -> nonblock::MethodReply<()>;
    fn unsubscribe(&self) -> nonblock::MethodReply<()>;
    fn dump(&self) -> nonblock::MethodReply<String>;
    fn create_snapshot(&self, arg0: &str, arg1: bool) -> nonblock::MethodReply<dbus::Path<'static>>;
    fn remove_snapshot(&self, arg0: &str) -> nonblock::MethodReply<()>;
    fn reload(&self) -> nonblock::MethodReply<()>;
    fn reexecute(&self) -> nonblock::MethodReply<()>;
    fn exit(&self) -> nonblock::MethodReply<()>;
    fn reboot(&self) -> nonblock::MethodReply<()>;
    fn power_off(&self) -> nonblock::MethodReply<()>;
    fn halt(&self) -> nonblock::MethodReply<()>;
    fn kexec(&self) -> nonblock::MethodReply<()>;
    fn switch_root(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<()>;
    fn set_environment_(&self, arg0: Vec<&str>) -> nonblock::MethodReply<()>;
    fn unset_environment(&self, arg0: Vec<&str>) -> nonblock::MethodReply<()>;
    fn unset_and_set_environment(&self, arg0: Vec<&str>, arg1: Vec<&str>) -> nonblock::MethodReply<()>;
    fn list_unit_files(&self) -> nonblock::MethodReply<Vec<(String, String)>>;
    fn get_unit_file_state(&self, arg0: &str) -> nonblock::MethodReply<String>;
    fn enable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)>;
    fn disable_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn reenable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)>;
    fn link_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn preset_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)>;
    fn preset_unit_files_with_mode(&self, arg0: Vec<&str>, arg1: &str, arg2: bool, arg3: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)>;
    fn mask_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn unmask_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn set_default_target(&self, arg0: &str, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn get_default_target(&self) -> nonblock::MethodReply<String>;
    fn preset_all_unit_files(&self, arg0: &str, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn add_dependency_unit_files(&self, arg0: Vec<&str>, arg1: &str, arg2: &str, arg3: bool, arg4: bool) -> nonblock::MethodReply<Vec<(String, String, String)>>;
    fn set_exit_code_(&self, arg0: u8) -> nonblock::MethodReply<()>;
    fn version(&self) -> nonblock::MethodReply<String>;
    fn features(&self) -> nonblock::MethodReply<String>;
    fn virtualization(&self) -> nonblock::MethodReply<String>;
    fn architecture(&self) -> nonblock::MethodReply<String>;
    fn tainted(&self) -> nonblock::MethodReply<String>;
    fn firmware_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn firmware_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn loader_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn loader_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn kernel_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn kernel_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn init_rdtimestamp(&self) -> nonblock::MethodReply<u64>;
    fn init_rdtimestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn userspace_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn userspace_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn finish_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn security_start_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn security_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn security_finish_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn security_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn generators_start_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn generators_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn generators_finish_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn generators_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn units_load_start_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn units_load_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn units_load_finish_timestamp(&self) -> nonblock::MethodReply<u64>;
    fn units_load_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64>;
    fn log_level(&self) -> nonblock::MethodReply<String>;
    fn set_log_level(&self, value: String) -> nonblock::MethodReply<()>;
    fn log_target(&self) -> nonblock::MethodReply<String>;
    fn set_log_target(&self, value: String) -> nonblock::MethodReply<()>;
    fn nnames(&self) -> nonblock::MethodReply<u32>;
    fn nfailed_units(&self) -> nonblock::MethodReply<u32>;
    fn njobs(&self) -> nonblock::MethodReply<u32>;
    fn ninstalled_jobs(&self) -> nonblock::MethodReply<u32>;
    fn nfailed_jobs(&self) -> nonblock::MethodReply<u32>;
    fn progress(&self) -> nonblock::MethodReply<f64>;
    fn environment(&self) -> nonblock::MethodReply<Vec<String>>;
    fn confirm_spawn(&self) -> nonblock::MethodReply<bool>;
    fn show_status(&self) -> nonblock::MethodReply<bool>;
    fn unit_path(&self) -> nonblock::MethodReply<Vec<String>>;
    fn default_standard_output(&self) -> nonblock::MethodReply<String>;
    fn default_standard_error(&self) -> nonblock::MethodReply<String>;
    fn runtime_watchdog_usec(&self) -> nonblock::MethodReply<u64>;
    fn set_runtime_watchdog_usec(&self, value: u64) -> nonblock::MethodReply<()>;
    fn shutdown_watchdog_usec(&self) -> nonblock::MethodReply<u64>;
    fn set_shutdown_watchdog_usec(&self, value: u64) -> nonblock::MethodReply<()>;
    fn control_group(&self) -> nonblock::MethodReply<String>;
    fn system_state(&self) -> nonblock::MethodReply<String>;
    fn exit_code(&self) -> nonblock::MethodReply<u8>;
    fn default_timer_accuracy_usec(&self) -> nonblock::MethodReply<u64>;
    fn default_timeout_start_usec(&self) -> nonblock::MethodReply<u64>;
    fn default_timeout_stop_usec(&self) -> nonblock::MethodReply<u64>;
    fn default_restart_usec(&self) -> nonblock::MethodReply<u64>;
    fn default_start_limit_interval(&self) -> nonblock::MethodReply<u64>;
    fn default_start_limit_burst(&self) -> nonblock::MethodReply<u32>;
    fn default_cpuaccounting(&self) -> nonblock::MethodReply<bool>;
    fn default_block_ioaccounting(&self) -> nonblock::MethodReply<bool>;
    fn default_memory_accounting(&self) -> nonblock::MethodReply<bool>;
    fn default_tasks_accounting(&self) -> nonblock::MethodReply<bool>;
    fn default_limit_cpu(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_cpusoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_fsize(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_fsizesoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_data(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_datasoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_stack(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_stacksoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_core(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_coresoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rss(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rsssoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nofile(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nofilesoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_as(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_assoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nproc(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nprocsoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_memlock(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_memlocksoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_locks(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_lockssoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_sigpending(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_sigpendingsoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_msgqueue(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_msgqueuesoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nice(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_nicesoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rtprio(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rtpriosoft(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rttime(&self) -> nonblock::MethodReply<u64>;
    fn default_limit_rttimesoft(&self) -> nonblock::MethodReply<u64>;
    fn default_tasks_max(&self) -> nonblock::MethodReply<u64>;
    fn timer_slack_nsec(&self) -> nonblock::MethodReply<u64>;
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitNew {
    pub arg0: String,
    pub arg1: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitNew {
            arg0: i.read()?,
            arg1: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitNew {
    const NAME: &'static str = "UnitNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitRemoved {
    pub arg0: String,
    pub arg1: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitRemoved {
            arg0: i.read()?,
            arg1: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitRemoved {
    const NAME: &'static str = "UnitRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobNew {
    pub arg0: u32,
    pub arg1: dbus::Path<'static>,
    pub arg2: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobNew {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobNew {
    const NAME: &'static str = "JobNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobRemoved {
    pub arg0: u32,
    pub arg1: dbus::Path<'static>,
    pub arg2: String,
    pub arg3: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
        arg::RefArg::append(&self.arg3, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobRemoved {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
            arg3: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobRemoved {
    const NAME: &'static str = "JobRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerStartupFinished {
    pub arg0: u64,
    pub arg1: u64,
    pub arg2: u64,
    pub arg3: u64,
    pub arg4: u64,
    pub arg5: u64,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
        arg::RefArg::append(&self.arg3, i);
        arg::RefArg::append(&self.arg4, i);
        arg::RefArg::append(&self.arg5, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerStartupFinished {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
            arg3: i.read()?,
            arg4: i.read()?,
            arg5: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerStartupFinished {
    const NAME: &'static str = "StartupFinished";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitFilesChanged {
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitFilesChanged {
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    const NAME: &'static str = "UnitFilesChanged";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerReloading {
    pub arg0: bool,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerReloading {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerReloading {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerReloading {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerReloading {
    const NAME: &'static str = "Reloading";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

impl<'a, T: nonblock::NonblockReply, C: ::std::ops::Deref<Target=T>> OrgFreedesktopSystemd1Manager for nonblock::Proxy<'a, C> {

    fn get_unit(&self, arg0: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnit", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn get_unit_by_pid(&self, arg0: u32) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnitByPID", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn load_unit(&self, arg0: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "LoadUnit", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn start_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn start_unit_replace(&self, arg0: &str, arg1: &str, arg2: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartUnitReplace", (arg0, arg1, arg2, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn stop_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "StopUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "RestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn try_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "TryRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_or_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadOrRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_or_try_restart_unit(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadOrTryRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn kill_unit(&self, arg0: &str, arg1: &str, arg2: i32) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "KillUnit", (arg0, arg1, arg2, ))
    }

    fn reset_failed_unit(&self, arg0: &str) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "ResetFailedUnit", (arg0, ))
    }

    fn set_unit_properties(&self, arg0: &str, arg1: bool, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetUnitProperties", (arg0, arg1, arg2, ))
    }

    fn start_transient_unit(&self, arg0: &str, arg1: &str, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>, arg3: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartTransientUnit", (arg0, arg1, arg2, arg3, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn get_job(&self, arg0: u32) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetJob", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn cancel_job(&self, arg0: u32) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "CancelJob", (arg0, ))
    }

    fn clear_jobs(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "ClearJobs", ())
    }

    fn reset_failed(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "ResetFailed", ())
    }

    fn list_units(&self) -> nonblock::MethodReply<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnits", ())
            .and_then(|r: (Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn list_units_filtered(&self, arg0: Vec<&str>) -> nonblock::MethodReply<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnitsFiltered", (arg0, ))
            .and_then(|r: (Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn list_jobs(&self) -> nonblock::MethodReply<Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListJobs", ())
            .and_then(|r: (Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn subscribe(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Subscribe", ())
    }

    fn unsubscribe(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Unsubscribe", ())
    }

    fn dump(&self) -> nonblock::MethodReply<String> {
        self.method_call("org.freedesktop.systemd1.Manager", "Dump", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn create_snapshot(&self, arg0: &str, arg1: bool) -> nonblock::MethodReply<dbus::Path<'static>> {
        self.method_call("org.freedesktop.systemd1.Manager", "CreateSnapshot", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn remove_snapshot(&self, arg0: &str) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "RemoveSnapshot", (arg0, ))
    }

    fn reload(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reload", ())
    }

    fn reexecute(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reexecute", ())
    }

    fn exit(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Exit", ())
    }

    fn reboot(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reboot", ())
    }

    fn power_off(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "PowerOff", ())
    }

    fn halt(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "Halt", ())
    }

    fn kexec(&self) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "KExec", ())
    }

    fn switch_root(&self, arg0: &str, arg1: &str) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "SwitchRoot", (arg0, arg1, ))
    }

    fn set_environment_(&self, arg0: Vec<&str>) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetEnvironment", (arg0, ))
    }

    fn unset_environment(&self, arg0: Vec<&str>) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnsetEnvironment", (arg0, ))
    }

    fn unset_and_set_environment(&self, arg0: Vec<&str>, arg1: Vec<&str>) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnsetAndSetEnvironment", (arg0, arg1, ))
    }

    fn list_unit_files(&self) -> nonblock::MethodReply<Vec<(String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnitFiles", ())
            .and_then(|r: (Vec<(String, String)>, )| Ok(r.0, ))
    }

    fn get_unit_file_state(&self, arg0: &str) -> nonblock::MethodReply<String> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnitFileState", (arg0, ))
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn enable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)> {
        self.method_call("org.freedesktop.systemd1.Manager", "EnableUnitFiles", (arg0, arg1, arg2, ))
    }

    fn disable_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "DisableUnitFiles", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn reenable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReenableUnitFiles", (arg0, arg1, arg2, ))
    }

    fn link_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "LinkUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn preset_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetUnitFiles", (arg0, arg1, arg2, ))
    }

    fn preset_unit_files_with_mode(&self, arg0: Vec<&str>, arg1: &str, arg2: bool, arg3: bool) -> nonblock::MethodReply<(bool, Vec<(String, String, String)>)> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetUnitFilesWithMode", (arg0, arg1, arg2, arg3, ))
    }

    fn mask_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "MaskUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn unmask_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnmaskUnitFiles", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn set_default_target(&self, arg0: &str, arg1: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetDefaultTarget", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn get_default_target(&self) -> nonblock::MethodReply<String> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetDefaultTarget", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn preset_all_unit_files(&self, arg0: &str, arg1: bool, arg2: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetAllUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn add_dependency_unit_files(&self, arg0: Vec<&str>, arg1: &str, arg2: &str, arg3: bool, arg4: bool) -> nonblock::MethodReply<Vec<(String, String, String)>> {
        self.method_call("org.freedesktop.systemd1.Manager", "AddDependencyUnitFiles", (arg0, arg1, arg2, arg3, arg4, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn set_exit_code_(&self, arg0: u8) -> nonblock::MethodReply<()> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetExitCode", (arg0, ))
    }

    fn version(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Version")
    }

    fn features(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Features")
    }

    fn virtualization(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Virtualization")
    }

    fn architecture(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Architecture")
    }

    fn tainted(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Tainted")
    }

    fn firmware_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FirmwareTimestamp")
    }

    fn firmware_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FirmwareTimestampMonotonic")
    }

    fn loader_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LoaderTimestamp")
    }

    fn loader_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LoaderTimestampMonotonic")
    }

    fn kernel_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "KernelTimestamp")
    }

    fn kernel_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "KernelTimestampMonotonic")
    }

    fn init_rdtimestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "InitRDTimestamp")
    }

    fn init_rdtimestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "InitRDTimestampMonotonic")
    }

    fn userspace_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UserspaceTimestamp")
    }

    fn userspace_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UserspaceTimestampMonotonic")
    }

    fn finish_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FinishTimestamp")
    }

    fn finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FinishTimestampMonotonic")
    }

    fn security_start_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityStartTimestamp")
    }

    fn security_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityStartTimestampMonotonic")
    }

    fn security_finish_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityFinishTimestamp")
    }

    fn security_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityFinishTimestampMonotonic")
    }

    fn generators_start_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsStartTimestamp")
    }

    fn generators_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsStartTimestampMonotonic")
    }

    fn generators_finish_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsFinishTimestamp")
    }

    fn generators_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsFinishTimestampMonotonic")
    }

    fn units_load_start_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadStartTimestamp")
    }

    fn units_load_start_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadStartTimestampMonotonic")
    }

    fn units_load_finish_timestamp(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadFinishTimestamp")
    }

    fn units_load_finish_timestamp_monotonic(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadFinishTimestampMonotonic")
    }

    fn log_level(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LogLevel")
    }

    fn log_target(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LogTarget")
    }

    fn nnames(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NNames")
    }

    fn nfailed_units(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NFailedUnits")
    }

    fn njobs(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NJobs")
    }

    fn ninstalled_jobs(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NInstalledJobs")
    }

    fn nfailed_jobs(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NFailedJobs")
    }

    fn progress(&self) -> nonblock::MethodReply<f64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Progress")
    }

    fn environment(&self) -> nonblock::MethodReply<Vec<String>> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Environment")
    }

    fn confirm_spawn(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ConfirmSpawn")
    }

    fn show_status(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ShowStatus")
    }

    fn unit_path(&self) -> nonblock::MethodReply<Vec<String>> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitPath")
    }

    fn default_standard_output(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStandardOutput")
    }

    fn default_standard_error(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStandardError")
    }

    fn runtime_watchdog_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "RuntimeWatchdogUSec")
    }

    fn shutdown_watchdog_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ShutdownWatchdogUSec")
    }

    fn control_group(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ControlGroup")
    }

    fn system_state(&self) -> nonblock::MethodReply<String> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SystemState")
    }

    fn exit_code(&self) -> nonblock::MethodReply<u8> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ExitCode")
    }

    fn default_timer_accuracy_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimerAccuracyUSec")
    }

    fn default_timeout_start_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimeoutStartUSec")
    }

    fn default_timeout_stop_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimeoutStopUSec")
    }

    fn default_restart_usec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultRestartUSec")
    }

    fn default_start_limit_interval(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStartLimitInterval")
    }

    fn default_start_limit_burst(&self) -> nonblock::MethodReply<u32> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStartLimitBurst")
    }

    fn default_cpuaccounting(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultCPUAccounting")
    }

    fn default_block_ioaccounting(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultBlockIOAccounting")
    }

    fn default_memory_accounting(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultMemoryAccounting")
    }

    fn default_tasks_accounting(&self) -> nonblock::MethodReply<bool> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTasksAccounting")
    }

    fn default_limit_cpu(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCPU")
    }

    fn default_limit_cpusoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCPUSoft")
    }

    fn default_limit_fsize(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitFSIZE")
    }

    fn default_limit_fsizesoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitFSIZESoft")
    }

    fn default_limit_data(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitDATA")
    }

    fn default_limit_datasoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitDATASoft")
    }

    fn default_limit_stack(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSTACK")
    }

    fn default_limit_stacksoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSTACKSoft")
    }

    fn default_limit_core(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCORE")
    }

    fn default_limit_coresoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCORESoft")
    }

    fn default_limit_rss(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRSS")
    }

    fn default_limit_rsssoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRSSSoft")
    }

    fn default_limit_nofile(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNOFILE")
    }

    fn default_limit_nofilesoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNOFILESoft")
    }

    fn default_limit_as(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitAS")
    }

    fn default_limit_assoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitASSoft")
    }

    fn default_limit_nproc(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNPROC")
    }

    fn default_limit_nprocsoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNPROCSoft")
    }

    fn default_limit_memlock(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMEMLOCK")
    }

    fn default_limit_memlocksoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMEMLOCKSoft")
    }

    fn default_limit_locks(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitLOCKS")
    }

    fn default_limit_lockssoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitLOCKSSoft")
    }

    fn default_limit_sigpending(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSIGPENDING")
    }

    fn default_limit_sigpendingsoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSIGPENDINGSoft")
    }

    fn default_limit_msgqueue(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMSGQUEUE")
    }

    fn default_limit_msgqueuesoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMSGQUEUESoft")
    }

    fn default_limit_nice(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNICE")
    }

    fn default_limit_nicesoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNICESoft")
    }

    fn default_limit_rtprio(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTPRIO")
    }

    fn default_limit_rtpriosoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTPRIOSoft")
    }

    fn default_limit_rttime(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTTIME")
    }

    fn default_limit_rttimesoft(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTTIMESoft")
    }

    fn default_tasks_max(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTasksMax")
    }

    fn timer_slack_nsec(&self) -> nonblock::MethodReply<u64> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "TimerSlackNSec")
    }

    fn set_log_level(&self, value: String) -> nonblock::MethodReply<()> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "LogLevel", value)
    }

    fn set_log_target(&self, value: String) -> nonblock::MethodReply<()> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "LogTarget", value)
    }

    fn set_runtime_watchdog_usec(&self, value: u64) -> nonblock::MethodReply<()> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "RuntimeWatchdogUSec", value)
    }

    fn set_shutdown_watchdog_usec(&self, value: u64) -> nonblock::MethodReply<()> {
        <Self as nonblock::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "ShutdownWatchdogUSec", value)
    }
}
