// This code was autogenerated with `dbus-codegen-rust `, see https://github.com/diwic/dbus-rs
use dbus as dbus;
#[allow(unused_imports)]
use dbus::arg;
use dbus::blocking;

pub trait OrgFreedesktopDBusPeer {
    fn ping(&self) -> Result<(), dbus::Error>;
    fn get_machine_id(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusPeer for blocking::Proxy<'a, C> {

    fn ping(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "Ping", ())
    }

    fn get_machine_id(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Peer", "GetMachineId", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }
}

pub trait OrgFreedesktopDBusIntrospectable {
    fn introspect(&self) -> Result<String, dbus::Error>;
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusIntrospectable for blocking::Proxy<'a, C> {

    fn introspect(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Introspectable", "Introspect", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }
}

pub trait OrgFreedesktopDBusProperties {
    fn get(&self, interface: &str, property: &str) -> Result<arg::Variant<Box<dyn arg::RefArg + 'static>>, dbus::Error>;
    fn get_all(&self, interface: &str) -> Result<arg::PropMap, dbus::Error>;
    fn set(&self, interface: &str, property: &str, value: arg::Variant<Box<dyn arg::RefArg>>) -> Result<(), dbus::Error>;
}

#[derive(Debug)]
pub struct OrgFreedesktopDBusPropertiesPropertiesChanged {
    pub interface: String,
    pub changed_properties: arg::PropMap,
    pub invalidated_properties: Vec<String>,
}

impl arg::AppendAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.interface, i);
        arg::RefArg::append(&self.changed_properties, i);
        arg::RefArg::append(&self.invalidated_properties, i);
    }
}

impl arg::ReadAll for OrgFreedesktopDBusPropertiesPropertiesChanged {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopDBusPropertiesPropertiesChanged {
            interface: i.read()?,
            changed_properties: i.read()?,
            invalidated_properties: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopDBusPropertiesPropertiesChanged {
    const NAME: &'static str = "PropertiesChanged";
    const INTERFACE: &'static str = "org.freedesktop.DBus.Properties";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopDBusProperties for blocking::Proxy<'a, C> {

    fn get(&self, interface: &str, property: &str) -> Result<arg::Variant<Box<dyn arg::RefArg + 'static>>, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "Get", (interface, property, ))
            .and_then(|r: (arg::Variant<Box<dyn arg::RefArg + 'static>>, )| Ok(r.0, ))
    }

    fn get_all(&self, interface: &str) -> Result<arg::PropMap, dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "GetAll", (interface, ))
            .and_then(|r: (arg::PropMap, )| Ok(r.0, ))
    }

    fn set(&self, interface: &str, property: &str, value: arg::Variant<Box<dyn arg::RefArg>>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.DBus.Properties", "Set", (interface, property, value, ))
    }
}

pub trait OrgFreedesktopSystemd1Manager {
    fn get_unit(&self, arg0: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_unit_by_pid(&self, arg0: u32) -> Result<dbus::Path<'static>, dbus::Error>;
    fn load_unit(&self, arg0: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn start_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn start_unit_replace(&self, arg0: &str, arg1: &str, arg2: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn stop_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn try_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_or_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn reload_or_try_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error>;
    fn kill_unit(&self, arg0: &str, arg1: &str, arg2: i32) -> Result<(), dbus::Error>;
    fn reset_failed_unit(&self, arg0: &str) -> Result<(), dbus::Error>;
    fn set_unit_properties(&self, arg0: &str, arg1: bool, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>) -> Result<(), dbus::Error>;
    fn start_transient_unit(&self, arg0: &str, arg1: &str, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>, arg3: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>) -> Result<dbus::Path<'static>, dbus::Error>;
    fn get_job(&self, arg0: u32) -> Result<dbus::Path<'static>, dbus::Error>;
    fn cancel_job(&self, arg0: u32) -> Result<(), dbus::Error>;
    fn clear_jobs(&self) -> Result<(), dbus::Error>;
    fn reset_failed(&self) -> Result<(), dbus::Error>;
    fn list_units(&self) -> Result<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, dbus::Error>;
    fn list_units_filtered(&self, arg0: Vec<&str>) -> Result<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, dbus::Error>;
    fn list_jobs(&self) -> Result<Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>, dbus::Error>;
    fn subscribe(&self) -> Result<(), dbus::Error>;
    fn unsubscribe(&self) -> Result<(), dbus::Error>;
    fn dump(&self) -> Result<String, dbus::Error>;
    fn create_snapshot(&self, arg0: &str, arg1: bool) -> Result<dbus::Path<'static>, dbus::Error>;
    fn remove_snapshot(&self, arg0: &str) -> Result<(), dbus::Error>;
    fn reload(&self) -> Result<(), dbus::Error>;
    fn reexecute(&self) -> Result<(), dbus::Error>;
    fn exit(&self) -> Result<(), dbus::Error>;
    fn reboot(&self) -> Result<(), dbus::Error>;
    fn power_off(&self) -> Result<(), dbus::Error>;
    fn halt(&self) -> Result<(), dbus::Error>;
    fn kexec(&self) -> Result<(), dbus::Error>;
    fn switch_root(&self, arg0: &str, arg1: &str) -> Result<(), dbus::Error>;
    fn set_environment_(&self, arg0: Vec<&str>) -> Result<(), dbus::Error>;
    fn unset_environment(&self, arg0: Vec<&str>) -> Result<(), dbus::Error>;
    fn unset_and_set_environment(&self, arg0: Vec<&str>, arg1: Vec<&str>) -> Result<(), dbus::Error>;
    fn list_unit_files(&self) -> Result<Vec<(String, String)>, dbus::Error>;
    fn get_unit_file_state(&self, arg0: &str) -> Result<String, dbus::Error>;
    fn enable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn disable_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn reenable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn link_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn preset_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn preset_unit_files_with_mode(&self, arg0: Vec<&str>, arg1: &str, arg2: bool, arg3: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error>;
    fn mask_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn unmask_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn set_default_target(&self, arg0: &str, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn get_default_target(&self) -> Result<String, dbus::Error>;
    fn preset_all_unit_files(&self, arg0: &str, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn add_dependency_unit_files(&self, arg0: Vec<&str>, arg1: &str, arg2: &str, arg3: bool, arg4: bool) -> Result<Vec<(String, String, String)>, dbus::Error>;
    fn set_exit_code_(&self, arg0: u8) -> Result<(), dbus::Error>;
    fn version(&self) -> Result<String, dbus::Error>;
    fn features(&self) -> Result<String, dbus::Error>;
    fn virtualization(&self) -> Result<String, dbus::Error>;
    fn architecture(&self) -> Result<String, dbus::Error>;
    fn tainted(&self) -> Result<String, dbus::Error>;
    fn firmware_timestamp(&self) -> Result<u64, dbus::Error>;
    fn firmware_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn loader_timestamp(&self) -> Result<u64, dbus::Error>;
    fn loader_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn kernel_timestamp(&self) -> Result<u64, dbus::Error>;
    fn kernel_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn init_rdtimestamp(&self) -> Result<u64, dbus::Error>;
    fn init_rdtimestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn userspace_timestamp(&self) -> Result<u64, dbus::Error>;
    fn userspace_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn security_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn security_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn security_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn security_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn generators_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn generators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn generators_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn generators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn units_load_start_timestamp(&self) -> Result<u64, dbus::Error>;
    fn units_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn units_load_finish_timestamp(&self) -> Result<u64, dbus::Error>;
    fn units_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error>;
    fn log_level(&self) -> Result<String, dbus::Error>;
    fn set_log_level(&self, value: String) -> Result<(), dbus::Error>;
    fn log_target(&self) -> Result<String, dbus::Error>;
    fn set_log_target(&self, value: String) -> Result<(), dbus::Error>;
    fn nnames(&self) -> Result<u32, dbus::Error>;
    fn nfailed_units(&self) -> Result<u32, dbus::Error>;
    fn njobs(&self) -> Result<u32, dbus::Error>;
    fn ninstalled_jobs(&self) -> Result<u32, dbus::Error>;
    fn nfailed_jobs(&self) -> Result<u32, dbus::Error>;
    fn progress(&self) -> Result<f64, dbus::Error>;
    fn environment(&self) -> Result<Vec<String>, dbus::Error>;
    fn confirm_spawn(&self) -> Result<bool, dbus::Error>;
    fn show_status(&self) -> Result<bool, dbus::Error>;
    fn unit_path(&self) -> Result<Vec<String>, dbus::Error>;
    fn default_standard_output(&self) -> Result<String, dbus::Error>;
    fn default_standard_error(&self) -> Result<String, dbus::Error>;
    fn runtime_watchdog_usec(&self) -> Result<u64, dbus::Error>;
    fn set_runtime_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error>;
    fn shutdown_watchdog_usec(&self) -> Result<u64, dbus::Error>;
    fn set_shutdown_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error>;
    fn control_group(&self) -> Result<String, dbus::Error>;
    fn system_state(&self) -> Result<String, dbus::Error>;
    fn exit_code(&self) -> Result<u8, dbus::Error>;
    fn default_timer_accuracy_usec(&self) -> Result<u64, dbus::Error>;
    fn default_timeout_start_usec(&self) -> Result<u64, dbus::Error>;
    fn default_timeout_stop_usec(&self) -> Result<u64, dbus::Error>;
    fn default_restart_usec(&self) -> Result<u64, dbus::Error>;
    fn default_start_limit_interval(&self) -> Result<u64, dbus::Error>;
    fn default_start_limit_burst(&self) -> Result<u32, dbus::Error>;
    fn default_cpuaccounting(&self) -> Result<bool, dbus::Error>;
    fn default_block_ioaccounting(&self) -> Result<bool, dbus::Error>;
    fn default_memory_accounting(&self) -> Result<bool, dbus::Error>;
    fn default_tasks_accounting(&self) -> Result<bool, dbus::Error>;
    fn default_limit_cpu(&self) -> Result<u64, dbus::Error>;
    fn default_limit_cpusoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_fsize(&self) -> Result<u64, dbus::Error>;
    fn default_limit_fsizesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_data(&self) -> Result<u64, dbus::Error>;
    fn default_limit_datasoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_stack(&self) -> Result<u64, dbus::Error>;
    fn default_limit_stacksoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_core(&self) -> Result<u64, dbus::Error>;
    fn default_limit_coresoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rss(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rsssoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nofile(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nofilesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_as(&self) -> Result<u64, dbus::Error>;
    fn default_limit_assoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nproc(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nprocsoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_memlock(&self) -> Result<u64, dbus::Error>;
    fn default_limit_memlocksoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_locks(&self) -> Result<u64, dbus::Error>;
    fn default_limit_lockssoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_sigpending(&self) -> Result<u64, dbus::Error>;
    fn default_limit_sigpendingsoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_msgqueue(&self) -> Result<u64, dbus::Error>;
    fn default_limit_msgqueuesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nice(&self) -> Result<u64, dbus::Error>;
    fn default_limit_nicesoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rtprio(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rtpriosoft(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rttime(&self) -> Result<u64, dbus::Error>;
    fn default_limit_rttimesoft(&self) -> Result<u64, dbus::Error>;
    fn default_tasks_max(&self) -> Result<u64, dbus::Error>;
    fn timer_slack_nsec(&self) -> Result<u64, dbus::Error>;
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitNew {
    pub arg0: String,
    pub arg1: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitNew {
            arg0: i.read()?,
            arg1: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitNew {
    const NAME: &'static str = "UnitNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitRemoved {
    pub arg0: String,
    pub arg1: dbus::Path<'static>,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitRemoved {
            arg0: i.read()?,
            arg1: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitRemoved {
    const NAME: &'static str = "UnitRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobNew {
    pub arg0: u32,
    pub arg1: dbus::Path<'static>,
    pub arg2: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobNew {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobNew {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobNew {
    const NAME: &'static str = "JobNew";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerJobRemoved {
    pub arg0: u32,
    pub arg1: dbus::Path<'static>,
    pub arg2: String,
    pub arg3: String,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
        arg::RefArg::append(&self.arg3, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerJobRemoved {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerJobRemoved {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
            arg3: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerJobRemoved {
    const NAME: &'static str = "JobRemoved";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerStartupFinished {
    pub arg0: u64,
    pub arg1: u64,
    pub arg2: u64,
    pub arg3: u64,
    pub arg4: u64,
    pub arg5: u64,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
        arg::RefArg::append(&self.arg1, i);
        arg::RefArg::append(&self.arg2, i);
        arg::RefArg::append(&self.arg3, i);
        arg::RefArg::append(&self.arg4, i);
        arg::RefArg::append(&self.arg5, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerStartupFinished {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerStartupFinished {
            arg0: i.read()?,
            arg1: i.read()?,
            arg2: i.read()?,
            arg3: i.read()?,
            arg4: i.read()?,
            arg5: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerStartupFinished {
    const NAME: &'static str = "StartupFinished";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerUnitFilesChanged {
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn append(&self, _: &mut arg::IterAppend) {
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    fn read(_: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerUnitFilesChanged {
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerUnitFilesChanged {
    const NAME: &'static str = "UnitFilesChanged";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

#[derive(Debug)]
pub struct OrgFreedesktopSystemd1ManagerReloading {
    pub arg0: bool,
}

impl arg::AppendAll for OrgFreedesktopSystemd1ManagerReloading {
    fn append(&self, i: &mut arg::IterAppend) {
        arg::RefArg::append(&self.arg0, i);
    }
}

impl arg::ReadAll for OrgFreedesktopSystemd1ManagerReloading {
    fn read(i: &mut arg::Iter) -> Result<Self, arg::TypeMismatchError> {
        Ok(OrgFreedesktopSystemd1ManagerReloading {
            arg0: i.read()?,
        })
    }
}

impl dbus::message::SignalArgs for OrgFreedesktopSystemd1ManagerReloading {
    const NAME: &'static str = "Reloading";
    const INTERFACE: &'static str = "org.freedesktop.systemd1.Manager";
}

impl<'a, T: blocking::BlockingSender, C: ::std::ops::Deref<Target=T>> OrgFreedesktopSystemd1Manager for blocking::Proxy<'a, C> {

    fn get_unit(&self, arg0: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnit", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn get_unit_by_pid(&self, arg0: u32) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnitByPID", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn load_unit(&self, arg0: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "LoadUnit", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn start_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn start_unit_replace(&self, arg0: &str, arg1: &str, arg2: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartUnitReplace", (arg0, arg1, arg2, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn stop_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "StopUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "RestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn try_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "TryRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_or_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadOrRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn reload_or_try_restart_unit(&self, arg0: &str, arg1: &str) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReloadOrTryRestartUnit", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn kill_unit(&self, arg0: &str, arg1: &str, arg2: i32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "KillUnit", (arg0, arg1, arg2, ))
    }

    fn reset_failed_unit(&self, arg0: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ResetFailedUnit", (arg0, ))
    }

    fn set_unit_properties(&self, arg0: &str, arg1: bool, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetUnitProperties", (arg0, arg1, arg2, ))
    }

    fn start_transient_unit(&self, arg0: &str, arg1: &str, arg2: Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>, arg3: Vec<(&str, Vec<(&str, arg::Variant<Box<dyn arg::RefArg>>)>)>) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "StartTransientUnit", (arg0, arg1, arg2, arg3, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn get_job(&self, arg0: u32) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetJob", (arg0, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn cancel_job(&self, arg0: u32) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "CancelJob", (arg0, ))
    }

    fn clear_jobs(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ClearJobs", ())
    }

    fn reset_failed(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ResetFailed", ())
    }

    fn list_units(&self) -> Result<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnits", ())
            .and_then(|r: (Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn list_units_filtered(&self, arg0: Vec<&str>) -> Result<Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnitsFiltered", (arg0, ))
            .and_then(|r: (Vec<(String, String, String, String, String, String, dbus::Path<'static>, u32, String, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn list_jobs(&self) -> Result<Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListJobs", ())
            .and_then(|r: (Vec<(u32, String, String, String, dbus::Path<'static>, dbus::Path<'static>)>, )| Ok(r.0, ))
    }

    fn subscribe(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Subscribe", ())
    }

    fn unsubscribe(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Unsubscribe", ())
    }

    fn dump(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Dump", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn create_snapshot(&self, arg0: &str, arg1: bool) -> Result<dbus::Path<'static>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "CreateSnapshot", (arg0, arg1, ))
            .and_then(|r: (dbus::Path<'static>, )| Ok(r.0, ))
    }

    fn remove_snapshot(&self, arg0: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "RemoveSnapshot", (arg0, ))
    }

    fn reload(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reload", ())
    }

    fn reexecute(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reexecute", ())
    }

    fn exit(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Exit", ())
    }

    fn reboot(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Reboot", ())
    }

    fn power_off(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "PowerOff", ())
    }

    fn halt(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "Halt", ())
    }

    fn kexec(&self) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "KExec", ())
    }

    fn switch_root(&self, arg0: &str, arg1: &str) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SwitchRoot", (arg0, arg1, ))
    }

    fn set_environment_(&self, arg0: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetEnvironment", (arg0, ))
    }

    fn unset_environment(&self, arg0: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnsetEnvironment", (arg0, ))
    }

    fn unset_and_set_environment(&self, arg0: Vec<&str>, arg1: Vec<&str>) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnsetAndSetEnvironment", (arg0, arg1, ))
    }

    fn list_unit_files(&self) -> Result<Vec<(String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ListUnitFiles", ())
            .and_then(|r: (Vec<(String, String)>, )| Ok(r.0, ))
    }

    fn get_unit_file_state(&self, arg0: &str) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetUnitFileState", (arg0, ))
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn enable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "EnableUnitFiles", (arg0, arg1, arg2, ))
    }

    fn disable_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "DisableUnitFiles", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn reenable_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "ReenableUnitFiles", (arg0, arg1, arg2, ))
    }

    fn link_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "LinkUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn preset_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetUnitFiles", (arg0, arg1, arg2, ))
    }

    fn preset_unit_files_with_mode(&self, arg0: Vec<&str>, arg1: &str, arg2: bool, arg3: bool) -> Result<(bool, Vec<(String, String, String)>), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetUnitFilesWithMode", (arg0, arg1, arg2, arg3, ))
    }

    fn mask_unit_files(&self, arg0: Vec<&str>, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "MaskUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn unmask_unit_files(&self, arg0: Vec<&str>, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "UnmaskUnitFiles", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn set_default_target(&self, arg0: &str, arg1: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetDefaultTarget", (arg0, arg1, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn get_default_target(&self) -> Result<String, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "GetDefaultTarget", ())
            .and_then(|r: (String, )| Ok(r.0, ))
    }

    fn preset_all_unit_files(&self, arg0: &str, arg1: bool, arg2: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "PresetAllUnitFiles", (arg0, arg1, arg2, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn add_dependency_unit_files(&self, arg0: Vec<&str>, arg1: &str, arg2: &str, arg3: bool, arg4: bool) -> Result<Vec<(String, String, String)>, dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "AddDependencyUnitFiles", (arg0, arg1, arg2, arg3, arg4, ))
            .and_then(|r: (Vec<(String, String, String)>, )| Ok(r.0, ))
    }

    fn set_exit_code_(&self, arg0: u8) -> Result<(), dbus::Error> {
        self.method_call("org.freedesktop.systemd1.Manager", "SetExitCode", (arg0, ))
    }

    fn version(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Version")
    }

    fn features(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Features")
    }

    fn virtualization(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Virtualization")
    }

    fn architecture(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Architecture")
    }

    fn tainted(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Tainted")
    }

    fn firmware_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FirmwareTimestamp")
    }

    fn firmware_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FirmwareTimestampMonotonic")
    }

    fn loader_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LoaderTimestamp")
    }

    fn loader_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LoaderTimestampMonotonic")
    }

    fn kernel_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "KernelTimestamp")
    }

    fn kernel_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "KernelTimestampMonotonic")
    }

    fn init_rdtimestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "InitRDTimestamp")
    }

    fn init_rdtimestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "InitRDTimestampMonotonic")
    }

    fn userspace_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UserspaceTimestamp")
    }

    fn userspace_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UserspaceTimestampMonotonic")
    }

    fn finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FinishTimestamp")
    }

    fn finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "FinishTimestampMonotonic")
    }

    fn security_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityStartTimestamp")
    }

    fn security_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityStartTimestampMonotonic")
    }

    fn security_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityFinishTimestamp")
    }

    fn security_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SecurityFinishTimestampMonotonic")
    }

    fn generators_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsStartTimestamp")
    }

    fn generators_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsStartTimestampMonotonic")
    }

    fn generators_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsFinishTimestamp")
    }

    fn generators_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "GeneratorsFinishTimestampMonotonic")
    }

    fn units_load_start_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadStartTimestamp")
    }

    fn units_load_start_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadStartTimestampMonotonic")
    }

    fn units_load_finish_timestamp(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadFinishTimestamp")
    }

    fn units_load_finish_timestamp_monotonic(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitsLoadFinishTimestampMonotonic")
    }

    fn log_level(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LogLevel")
    }

    fn log_target(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "LogTarget")
    }

    fn nnames(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NNames")
    }

    fn nfailed_units(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NFailedUnits")
    }

    fn njobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NJobs")
    }

    fn ninstalled_jobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NInstalledJobs")
    }

    fn nfailed_jobs(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "NFailedJobs")
    }

    fn progress(&self) -> Result<f64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Progress")
    }

    fn environment(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "Environment")
    }

    fn confirm_spawn(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ConfirmSpawn")
    }

    fn show_status(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ShowStatus")
    }

    fn unit_path(&self) -> Result<Vec<String>, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "UnitPath")
    }

    fn default_standard_output(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStandardOutput")
    }

    fn default_standard_error(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStandardError")
    }

    fn runtime_watchdog_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "RuntimeWatchdogUSec")
    }

    fn shutdown_watchdog_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ShutdownWatchdogUSec")
    }

    fn control_group(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ControlGroup")
    }

    fn system_state(&self) -> Result<String, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "SystemState")
    }

    fn exit_code(&self) -> Result<u8, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "ExitCode")
    }

    fn default_timer_accuracy_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimerAccuracyUSec")
    }

    fn default_timeout_start_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimeoutStartUSec")
    }

    fn default_timeout_stop_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTimeoutStopUSec")
    }

    fn default_restart_usec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultRestartUSec")
    }

    fn default_start_limit_interval(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStartLimitInterval")
    }

    fn default_start_limit_burst(&self) -> Result<u32, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultStartLimitBurst")
    }

    fn default_cpuaccounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultCPUAccounting")
    }

    fn default_block_ioaccounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultBlockIOAccounting")
    }

    fn default_memory_accounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultMemoryAccounting")
    }

    fn default_tasks_accounting(&self) -> Result<bool, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTasksAccounting")
    }

    fn default_limit_cpu(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCPU")
    }

    fn default_limit_cpusoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCPUSoft")
    }

    fn default_limit_fsize(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitFSIZE")
    }

    fn default_limit_fsizesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitFSIZESoft")
    }

    fn default_limit_data(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitDATA")
    }

    fn default_limit_datasoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitDATASoft")
    }

    fn default_limit_stack(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSTACK")
    }

    fn default_limit_stacksoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSTACKSoft")
    }

    fn default_limit_core(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCORE")
    }

    fn default_limit_coresoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitCORESoft")
    }

    fn default_limit_rss(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRSS")
    }

    fn default_limit_rsssoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRSSSoft")
    }

    fn default_limit_nofile(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNOFILE")
    }

    fn default_limit_nofilesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNOFILESoft")
    }

    fn default_limit_as(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitAS")
    }

    fn default_limit_assoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitASSoft")
    }

    fn default_limit_nproc(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNPROC")
    }

    fn default_limit_nprocsoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNPROCSoft")
    }

    fn default_limit_memlock(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMEMLOCK")
    }

    fn default_limit_memlocksoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMEMLOCKSoft")
    }

    fn default_limit_locks(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitLOCKS")
    }

    fn default_limit_lockssoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitLOCKSSoft")
    }

    fn default_limit_sigpending(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSIGPENDING")
    }

    fn default_limit_sigpendingsoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitSIGPENDINGSoft")
    }

    fn default_limit_msgqueue(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMSGQUEUE")
    }

    fn default_limit_msgqueuesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitMSGQUEUESoft")
    }

    fn default_limit_nice(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNICE")
    }

    fn default_limit_nicesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitNICESoft")
    }

    fn default_limit_rtprio(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTPRIO")
    }

    fn default_limit_rtpriosoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTPRIOSoft")
    }

    fn default_limit_rttime(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTTIME")
    }

    fn default_limit_rttimesoft(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultLimitRTTIMESoft")
    }

    fn default_tasks_max(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "DefaultTasksMax")
    }

    fn timer_slack_nsec(&self) -> Result<u64, dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::get(&self, "org.freedesktop.systemd1.Manager", "TimerSlackNSec")
    }

    fn set_log_level(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "LogLevel", value)
    }

    fn set_log_target(&self, value: String) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "LogTarget", value)
    }

    fn set_runtime_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "RuntimeWatchdogUSec", value)
    }

    fn set_shutdown_watchdog_usec(&self, value: u64) -> Result<(), dbus::Error> {
        <Self as blocking::stdintf::org_freedesktop_dbus::Properties>::set(&self, "org.freedesktop.systemd1.Manager", "ShutdownWatchdogUSec", value)
    }
}
