[![Latest Version]][crates.io] ![License]

Command line utilities to work with UNIX syslog.

# syslog-unix

Read syslog messages from a UNIX domain datagram socket and format it to standard output.

Features:

* Produce human friendly log messages from syslog.
* Produce syslog messages suitable for forwarding to remote log server.
* Strip new line character from the end of the message.
* Replace new line character with `#012` (configurable) to preserve message boundaries when using `syslog` output format.
* Optionally use RFC3339 (with microseconds) timestamp format with `syslog` output format.
* Configurable maximum message length.
* Optionally to read message timestamps prefixed to syslog datagram (see [socktee](https://sr.ht/~jpastuszek/socktee/) `-T` flag).

## Example usage

Read messages from syslog socket and print them in human readable form:

```
umask 0000
syslog-unix /dev/log human
```

Prints messages like this:

```
user.notice: 2022-04-22 15:10:26.566281 someuser: hello world
```

Read messages from syslog socket and print them in syslog format suitable for forwarding to syslog server:

```
umask 0000
syslog-unix /dev/log syslog
```

Prints messages like this:

```
<13>Apr 22 15:58:03 somehost someuser: hello world
```

# syslog-logger

Read log message from standard input and format it as syslog message to a UNIX domain socket.

## Example usage

Log a single message:

```
syslog-logger $USER "hello world"
```

Log every line of standard input as a separate message:

```
ls | syslog-logger ls
```

Log standard input as a single message:

```
fortune | syslog-logger -1 fortune
```

# syslog-mlogger

Read log message from standard input and format it as syslog message to a UNIX domain socket, while reconstructing log messages spanning multiple lines as one message.

## Example usage

```bash
syslog-mlogger java-app '^\s+' --negate --strip-pattern <<EOF
Exception in thread "main" java.lang.NullPointerException
        at com.example.myproject.Book.getTitle(Book.java:16)
        at com.example.myproject.Author.getBookTitles(Author.java:25)
        at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
Exception in thread "main" java.lang.NullPointerException
        at com.example.myproject.Book.getTitle(Book.java:16)
        at com.example.myproject.Author.getBookTitles(Author.java:25)
        at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
Hello world!
Exception in thread "main" java.lang.NullPointerException
        at com.example.myproject.Book.getTitle(Book.java:16)
        at com.example.myproject.Author.getBookTitles(Author.java:25)
        at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
EOF
```

The example command will log 4 syslog messages:

```
<13>Apr 22 15:02:30 java-app: Exception in thread "main" java.lang.NullPointerException
at com.example.myproject.Book.getTitle(Book.java:16)
at com.example.myproject.Author.getBookTitles(Author.java:25)
at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
```

```
<13>Apr 22 15:02:30 java-app: Exception in thread "main" java.lang.NullPointerException
at com.example.myproject.Book.getTitle(Book.java:16)
at com.example.myproject.Author.getBookTitles(Author.java:25)
at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
```

```
<13>Apr 22 15:02:30 java-app: Hello world!
```

```
<13>Apr 22 15:02:30 java-app: Exception in thread "main" java.lang.NullPointerException
at com.example.myproject.Book.getTitle(Book.java:16)
at com.example.myproject.Author.getBookTitles(Author.java:25)
at com.example.myproject.Bootstrap.main(Bootstrap.java:14)
```

# Installation

Install `cargo` utility with your package manager.

After installation with `cargo` utility the binaries will be located in `~/.cargo/bin`.

## From crates.io

```bash
cargo install syslogio
```

## From source

Clone the source code repository with Git.

In the source directory run:

```bash
cargo install --path . --force
```

[crates.io]: https://crates.io/crates/syslogio
[Latest Version]: https://img.shields.io/crates/v/syslogio.svg
[License]: https://img.shields.io/crates/l/syslogio.svg
