/*-
 * syslog-rs - a syslog client translated from libc to rust
 * Copyright (C) 2020  Aleksandr Morozov, RELKOM s.r.o
 * Copyright (C) 2021-2022  Aleksandr Morozov
 * 
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 *  file, You can obtain one at https://mozilla.org/MPL/2.0/.
 */

/// This file contains an inplemetation of interface (trait)
/// which generalizes a `StreamableSyslog`.

use crate::Priority;

pub trait SyslogStream: core::fmt::Write
{
    /// Replaces PRI with new and returns old (replaced)
    fn update_pri(&mut self, new_pri: Priority) -> Priority;
}