
#[macro_use] extern crate lazy_static;

use std::thread;
use std::time::Duration;

#[cfg(feature = "use_sync")]
use syslog_rs::sy_sync_queue::{Syslog, SyslogStd, SyslogExt};

use syslog_rs::{LogStat, LogFacility, Priority};

lazy_static! {
    static ref SYSLOG: Syslog = 
            Syslog::openlog(
                Some("example"), 
                LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
                LogFacility::LOG_DAEMON
            ).unwrap();
}

macro_rules! logdebug 
{
    ($($arg:tt)*) => (
        SYSLOG.syslog(Priority::LOG_DEBUG, format!($($arg)*))
    )
}

pub fn main()
{
    logdebug!("test message!");

    thread::sleep(Duration::from_micros(10));

    let mut stream = SYSLOG.make_stream(Priority::LOG_DEBUG);

    let d = "890";

    let _ = write!(stream, "test {} 123 ", d);

    std::thread::sleep(Duration::from_secs(1));

    return;
}

