#[macro_use] extern crate lazy_static;

use std::thread;
use std::time::{Duration};

#[cfg(feature = "use_sync")]
use syslog_rs::sy_sync::{Syslog, SyslogCommon};
use syslog_rs::{LogStat, LogFacility, Priority, UnsafeReadOnlyCell};

lazy_static! {
    static ref SYNC_SYSLOG: UnsafeReadOnlyCell<Syslog> = 
        unsafe { UnsafeReadOnlyCell::new_uninitialized("syslog_sync") };
}

macro_rules! logdebug 
{
    ($($arg:tt)*) => (
        (*SYNC_SYSLOG).syslog(Priority::LOG_DEBUG, format!($($arg)*));
    )
}

pub fn main()
{
    if SYNC_SYSLOG.is_init() == true
    {
        return;
    }

    let syslog = 
        Syslog::openlog(
            Some("example"), 
            LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
            LogFacility::LOG_DAEMON
        ).unwrap();

    unsafe { SYNC_SYSLOG.init(syslog) };

    logdebug!("test message!");

    thread::sleep(Duration::from_micros(10));

    return;
}
