#[macro_use] extern crate lazy_static;

use tokio::time::{Duration, sleep};

use syslog_rs::sy_async::{Syslog};
use syslog_rs::{LogStat, LogFacility, Priority, UnsafeReadOnlyCell};

lazy_static! {
    static ref SYSLOG: UnsafeReadOnlyCell<Syslog> = 
        unsafe { UnsafeReadOnlyCell::new_uninitialized("syslog_sync") };
}



macro_rules! logdebug 
{
    ($($arg:tt)*) => (
        SYSLOG.syslog(Priority::LOG_DEBUG, format!($($arg)*)).await
    )
}

#[tokio::main]
async fn main()
{
    let syslog =
        Syslog::openlog(
            Some("example"), 
            LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
            LogFacility::LOG_DAEMON
        ).await.unwrap();


    unsafe { SYSLOG.init(syslog) };

    logdebug!("test message!");
    

    sleep(Duration::from_micros(10)).await;

    return;
}
