#[macro_use] extern crate lazy_static;
#[test]
fn test_cell()
{
    use std::thread;
    use std::time::{Instant, Duration};

    #[cfg(feature = "use_sync")]
    use syslog_rs::sy_sync::{Syslog};
    use syslog_rs::{LogStat, LogFacility, Priority, UnsafeReadOnlyCell};

    lazy_static! {
        static ref SYNC_SYSLOG: UnsafeReadOnlyCell<Syslog> = 
            unsafe { UnsafeReadOnlyCell::new_uninitialized("syslog_sync") };
    }

    macro_rules! logdebug 
    {
        ($($arg:tt)*) => (
            let now = Instant::now();
            (*SYNC_SYSLOG).syslog(Priority::LOG_DEBUG, format!($($arg)*));
            let elapsed = now.elapsed();
            println!("t1: {:?}", elapsed);
        )
    }

    if SYNC_SYSLOG.is_init() == true
    {
        return;
    }

    let syslog = 
        Syslog::openlog(
            Some("example"), 
            LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
            LogFacility::LOG_DAEMON
        ).unwrap();

    unsafe { SYNC_SYSLOG.init(syslog) };

    
    logdebug!("test message!");
    logdebug!("test message2!");
    (*SYNC_SYSLOG).change_identity("test111");
    logdebug!("test message!");
    
    thread::sleep(Duration::from_micros(10));

    return;

}