#[cfg(feature = "use_async")]
#[macro_use] extern crate lazy_static;

#[cfg(feature = "use_async")]
#[macro_use] extern crate syslog_rs;

#[cfg(feature = "use_async")]
pub mod example
{
    use std::sync::Arc;
    use std::thread;
    use std::time::{Duration};

    use tokio::runtime::Runtime;

    use syslog_rs::sy_async::{Syslog};
    use syslog_rs::{LogStat, LogFacility, Priority};


    lazy_static! {
        static ref SYSLOG: Arc<Syslog> = {
            Runtime::new().unwrap().block_on(async {
                Arc::new(
                    Syslog::openlog(
                        Some("example"), 
                        LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
                        LogFacility::LOG_DAEMON
                    ).await.unwrap()
                )
            })
        };
    }

    macro_rules! logdebug 
    {
        ($($arg:tt)*) => (
            SYSLOG.syslog(Priority::LOG_DEBUG, format!($($arg)*)).await
        )
    }



    pub async fn main1()
    {
        logdebug!("test message!");

        thread::sleep(Duration::from_micros(10));

        return;
    }
}


#[cfg(feature = "use_async")]
pub fn main()
{
    use tokio::runtime::Runtime;
    
    use self::example::*;

    Runtime::new().unwrap().block_on(async {
        main1().await;
    });

    return;
}

#[cfg(not(feature = "use_async"))]
fn main(){}
