#[cfg(not(feature = "use_async"))]
pub mod example
{
    use std::sync::Arc;
    use std::thread;
    use std::time::{Duration};

    use syslog_rs::{Syslog, LogStat, LogFacility, Priority};


    lazy_static! {
        static ref SYSLOG: Arc<Syslog> = 
            Arc::new(
                Syslog::openlog(
                    Some("example"), 
                    LogStat::LOG_CONS | LogStat::LOG_NDELAY | LogStat::LOG_PID, 
                    LogFacility::LOG_DAEMON
                ).unwrap()
            );
    }

    macro_rules! logdebug 
    {
        ($($arg:tt)*) => (
            SYSLOG.syslog(Priority::LOG_DEBUG, format!($($arg)*))
        )
    }



    pub fn main1()
    {
        logdebug!("test message!");

        thread::sleep(Duration::from_micros(10));

        return;
    }
}


#[cfg(not(feature = "use_async"))]
#[macro_use] extern crate lazy_static;

#[cfg(not(feature = "use_async"))]
#[macro_use] extern crate syslog_rs;
#[cfg(not(feature = "use_async"))]
pub fn main()
{
    use self::example::*;
    return;
}

#[cfg(feature = "use_async")]
fn main(){}

