#[cfg(test)]
mod cpu {
    // Note this useful idiom: importing names from outer (for mod tests) scope.
    use sys_metrics::cpu::*;

    #[test]
    fn test_cpucorecount() {
        let logical_count = get_cpu_logical_count().unwrap();

        assert!(logical_count > 0);
    }

    #[test]
    fn test_cpufreq() {
        let cpufreq = get_cpufreq().unwrap();

        assert!(cpufreq > 0.0);
    }

    #[test]
    #[allow(unused_comparisons)]
    fn test_cputimes() {
        let cputimes = get_cputimes().unwrap();

        assert!(cputimes.total_time() >= 0);
        assert!(cputimes.busy_time() >= 0);
        assert!(cputimes.idle_time() >= 0);
    }

    #[test]
    #[allow(unused_comparisons)]
    fn test_cpustats() {
        let cpustats = get_cpustats().unwrap();

        assert!(cpustats.interrupts >= 0);
        assert!(cpustats.ctx_switches >= 0);
        assert!(cpustats.soft_interrupts >= 0);
    }

    #[test]
    fn test_loadavg() {
        let loadavg = get_loadavg().unwrap();

        let o = loadavg.one;
        assert!(o >= 0.0);
        let t = loadavg.five;
        assert!(t >= 0.0);
        let f = loadavg.fifteen;
        assert!(f >= 0.0);
    }
}
