# sys-locale

[![crates.io version](https://img.shields.io/crates/v/sys-locale.svg)](https://crates.io/crates/sys-locale)
[![crate documentation](https://docs.rs/sys-locale/badge.svg)](https://docs.rs/sys-locale)
![MSRV](https://img.shields.io/badge/rustc-1.46+-blue.svg)
[![crates.io downloads](https://img.shields.io/crates/d/sys-locale.svg)](https://crates.io/crates/sys-locale)
![CI](https://github.com/1Password/sys-locale/workflows/CI/badge.svg)

A small and lightweight Rust library to obtain the locale the active locale on the system.

`sys-locale` is small library for obtaining the current locale set for the system or application with the relevant platform APIs.
The library is also `no_std` compatible except on Linux and BSD, only relying on `alloc`.

Platform support currently includes:
- Android
- iOS
- macOS
- Linux, BSD, and other UNIX variations
- WebAssembly
- Windows

```rust
use sys_locale::get_locale;

let locale = get_locale().unwrap_or_else(|| String::from("en-US"));

println!("The current locale is {}", locale);
```

## MSRV

The Minimum Supported Rust Version is currently 1.46.0. This will be bumped to the latest stable version of Rust when needed.

## Credits

Made with ❤️ by the [1Password](https://1password.com/) team.

#### License

<sup>
Licensed under either of <a href="LICENSE-APACHE">Apache License, Version
2.0</a> or <a href="LICENSE-MIT">MIT license</a> at your option.
</sup>

<br>

<sub>
Unless you explicitly state otherwise, any contribution intentionally submitted
for inclusion in this crate by you, as defined in the Apache-2.0 license, shall
be dual licensed as above, without any additional terms or conditions.
</sub>