#pragma once

#include "synthizer.h"

#include "compiler_specifics.hpp"

#include <string>
#include <utility>

namespace synthizer {

void logToStderr();
void disableLogging();
bool isLoggingEnabled();

/*
 * A thread has an id (generated by the logging system) and a purpose (i.e. audio, client).
 * Purpose can be anything for example object-25-streaming-thread.
 * This is formatted into log messages to know what a thread is for.
 * */
void setThreadPurpose(std::string purpose);

enum SYZ_LOG_LEVEL getLogLevel();
void setLogLevel(enum SYZ_LOG_LEVEL level);
PRINTF_LIKE(2, 3)
void log(enum SYZ_LOG_LEVEL level, const char *format, ...);

#define logLazy(level, ...)                                                                                            \
  do {                                                                                                                 \
    if ((level) <= getLogLevel())                                                                                      \
      log((level), __VA_ARGS__);                                                                                       \
  } while (0)

#define logError(...) logLazy(SYZ_LOG_LEVEL_ERROR, __VA_ARGS__)
#define logWarn(...) logLazy(SYZ_LOG_LEVEL_WARN, __VA_ARGS__)
#define logInfo(...) logLazy(SYZ_LOG_LEVEL_INFO, __VA_ARGS__)
#define logDebug(...) logLazy(SYZ_LOG_LEVEL_DEBUG, __VA_ARGS__)

} // namespace synthizer
