// Symphonia
// Copyright (c) 2020 The Project Symphonia Developers.
//
// This Source Code Form is subject to the terms of the Mozilla Public
// License, v. 2.0. If a copy of the MPL was not distributed with this
// file, You can obtain one at https://mozilla.org/MPL/2.0/.

//////////////////////////////////////////////////////////////////////
//                             WARNING                              //
//                                                                  //
//         Do not edit the contents of this file manually!          //
//                                                                  //
// The tables within this file were automatically derived from the  //
//         ISO/IEC 14496-3 (MPEG-4 Part 10) standard using          //
// aac_huffman_tablegen.py in <root>/src/symphonia-codec-aac/tools. //
//                                                                  //
//////////////////////////////////////////////////////////////////////

use symphonia_core::{val8, val16, jmp8, jmp16};
use symphonia_core::io::huffman::{H8, H16, HuffmanTable};

pub const SPEC_TABLE_1: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x28, 1),    // 0b0000
        val16!(0x28, 1),    // 0b0001
        val16!(0x28, 1),    // 0b0010
        val16!(0x28, 1),    // 0b0011
        val16!(0x28, 1),    // 0b0100
        val16!(0x28, 1),    // 0b0101
        val16!(0x28, 1),    // 0b0110
        val16!(0x28, 1),    // 0b0111
        jmp16!(16, 1),    // 0b1000
        jmp16!(18, 1),    // 0b1001
        jmp16!(20, 1),    // 0b1010
        jmp16!(22, 1),    // 0b1011
        jmp16!(24, 3),    // 0b1100
        jmp16!(32, 3),    // 0b1101
        jmp16!(40, 3),    // 0b1110
        jmp16!(48, 4),    // 0b1111

        // 0b1000 ... (16 +2)
        val16!(0x43, 1),    // 0b0
        val16!(0xd, 1),    // 0b1

        // 0b1001 ... (18 +2)
        val16!(0x27, 1),    // 0b0
        val16!(0x31, 1),    // 0b1

        // 0b1010 ... (20 +2)
        val16!(0x29, 1),    // 0b0
        val16!(0x25, 1),    // 0b1

        // 0b1011 ... (22 +2)
        val16!(0x2b, 1),    // 0b0
        val16!(0x1f, 1),    // 0b1

        // 0b1100 ... (24 +8)
        val16!(0x3a, 3),    // 0b000
        val16!(0x16, 3),    // 0b001
        val16!(0x26, 3),    // 0b010
        val16!(0x2e, 3),    // 0b011
        val16!(0x22, 3),    // 0b100
        val16!(0x2a, 3),    // 0b101
        val16!(0x4c, 3),    // 0b110
        val16!(0x24, 3),    // 0b111

        // 0b1101 ... (32 +8)
        val16!(0x4, 3),    // 0b000
        val16!(0x1c, 3),    // 0b001
        val16!(0x40, 3),    // 0b010
        val16!(0x30, 3),    // 0b011
        val16!(0x10, 3),    // 0b100
        val16!(0x2c, 3),    // 0b101
        val16!(0x46, 3),    // 0b110
        val16!(0x20, 3),    // 0b111

        // 0b1110 ... (40 +8)
        val16!(0x34, 3),    // 0b000
        val16!(0x32, 3),    // 0b001
        val16!(0xa, 3),    // 0b010
        val16!(0x44, 3),    // 0b011
        val16!(0xc, 3),    // 0b100
        val16!(0x42, 3),    // 0b101
        val16!(0xe, 3),    // 0b110
        val16!(0x1e, 3),    // 0b111

        // 0b1111 ... (48 +16)
        jmp16!(64, 1),    // 0b0000
        jmp16!(66, 1),    // 0b0001
        jmp16!(68, 1),    // 0b0010
        jmp16!(70, 1),    // 0b0011
        jmp16!(72, 1),    // 0b0100
        jmp16!(74, 1),    // 0b0101
        jmp16!(76, 1),    // 0b0110
        jmp16!(78, 1),    // 0b0111
        jmp16!(80, 1),    // 0b1000
        jmp16!(82, 1),    // 0b1001
        jmp16!(84, 1),    // 0b1010
        jmp16!(86, 1),    // 0b1011
        jmp16!(88, 2),    // 0b1100
        jmp16!(92, 2),    // 0b1101
        jmp16!(96, 3),    // 0b1110
        jmp16!(104, 3),    // 0b1111

        // 0b1111 0000 ... (64 +2)
        val16!(0x49, 1),    // 0b0
        val16!(0x13, 1),    // 0b1

        // 0b1111 0001 ... (66 +2)
        val16!(0x3d, 1),    // 0b0
        val16!(0x33, 1),    // 0b1

        // 0b1111 0010 ... (68 +2)
        val16!(0x2f, 1),    // 0b0
        val16!(0x23, 1),    // 0b1

        // 0b1111 0011 ... (70 +2)
        val16!(0x21, 1),    // 0b0
        val16!(0x37, 1),    // 0b1

        // 0b1111 0100 ... (72 +2)
        val16!(0x41, 1),    // 0b0
        val16!(0x2d, 1),    // 0b1

        // 0b1111 0101 ... (74 +2)
        val16!(0x19, 1),    // 0b0
        val16!(0xf, 1),    // 0b1

        // 0b1111 0110 ... (76 +2)
        val16!(0x7, 1),    // 0b0
        val16!(0x1d, 1),    // 0b1

        // 0b1111 0111 ... (78 +2)
        val16!(0x3b, 1),    // 0b0
        val16!(0x39, 1),    // 0b1

        // 0b1111 1000 ... (80 +2)
        val16!(0x15, 1),    // 0b0
        val16!(0x1, 1),    // 0b1

        // 0b1111 1001 ... (82 +2)
        val16!(0x1b, 1),    // 0b0
        val16!(0x35, 1),    // 0b1

        // 0b1111 1010 ... (84 +2)
        val16!(0x45, 1),    // 0b0
        val16!(0x4d, 1),    // 0b1

        // 0b1111 1011 ... (86 +2)
        val16!(0x17, 1),    // 0b0
        val16!(0x4f, 1),    // 0b1

        // 0b1111 1100 ... (88 +4)
        val16!(0x5, 2),    // 0b00
        val16!(0x9, 2),    // 0b01
        val16!(0x4b, 2),    // 0b10
        val16!(0x3f, 2),    // 0b11

        // 0b1111 1101 ... (92 +4)
        val16!(0xb, 2),    // 0b00
        val16!(0x3, 2),    // 0b01
        val16!(0x11, 2),    // 0b10
        val16!(0x47, 2),    // 0b11

        // 0b1111 1110 ... (96 +8)
        val16!(0x3c, 3),    // 0b000
        val16!(0x14, 3),    // 0b001
        val16!(0x18, 3),    // 0b010
        val16!(0x38, 3),    // 0b011
        val16!(0x50, 3),    // 0b100
        val16!(0x8, 3),    // 0b101
        val16!(0x48, 3),    // 0b110
        val16!(0x6, 3),    // 0b111

        // 0b1111 1111 ... (104 +8)
        val16!(0x0, 3),    // 0b000
        val16!(0x4a, 3),    // 0b001
        val16!(0x3e, 3),    // 0b010
        val16!(0x1a, 3),    // 0b011
        val16!(0x12, 3),    // 0b100
        val16!(0x2, 3),    // 0b101
        val16!(0x36, 3),    // 0b110
        val16!(0x4e, 3),    // 0b111
    ],
    n_init_bits: 4,
    n_table_bits: 11,
};

pub const SPEC_TABLE_2: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x28, 3),    // 0b0000
        val16!(0x28, 3),    // 0b0001
        val16!(0x43, 4),    // 0b0010
        jmp16!(16, 1),    // 0b0011
        jmp16!(18, 1),    // 0b0100
        jmp16!(20, 1),    // 0b0101
        jmp16!(22, 2),    // 0b0110
        jmp16!(26, 2),    // 0b0111
        jmp16!(30, 2),    // 0b1000
        jmp16!(34, 2),    // 0b1001
        jmp16!(38, 2),    // 0b1010
        jmp16!(42, 2),    // 0b1011
        jmp16!(46, 3),    // 0b1100
        jmp16!(54, 3),    // 0b1101
        jmp16!(62, 4),    // 0b1110
        jmp16!(78, 4),    // 0b1111

        // 0b0011 ... (16 +2)
        val16!(0xd, 1),    // 0b0
        val16!(0x29, 1),    // 0b1

        // 0b0100 ... (18 +2)
        val16!(0x25, 1),    // 0b0
        val16!(0x27, 1),    // 0b1

        // 0b0101 ... (20 +2)
        val16!(0x1f, 1),    // 0b0
        val16!(0x2b, 1),    // 0b1

        // 0b0110 ... (22 +4)
        val16!(0x31, 1),    // 0b00
        val16!(0x31, 1),    // 0b01
        val16!(0x22, 2),    // 0b10
        val16!(0x16, 2),    // 0b11

        // 0b0111 ... (26 +4)
        val16!(0x2e, 2),    // 0b00
        val16!(0x2a, 2),    // 0b01
        val16!(0x30, 2),    // 0b10
        val16!(0x26, 2),    // 0b11

        // 0b1000 ... (30 +4)
        val16!(0xc, 2),    // 0b00
        val16!(0x3a, 2),    // 0b01
        val16!(0x40, 2),    // 0b10
        val16!(0x4, 2),    // 0b11

        // 0b1001 ... (34 +4)
        val16!(0x24, 2),    // 0b00
        val16!(0x46, 2),    // 0b01
        val16!(0x44, 2),    // 0b10
        val16!(0x20, 2),    // 0b11

        // 0b1010 ... (38 +4)
        val16!(0x10, 2),    // 0b00
        val16!(0x32, 2),    // 0b01
        val16!(0x1c, 2),    // 0b10
        val16!(0xe, 2),    // 0b11

        // 0b1011 ... (42 +4)
        val16!(0x1e, 2),    // 0b00
        val16!(0xa, 2),    // 0b01
        val16!(0x4c, 2),    // 0b10
        val16!(0x34, 2),    // 0b11

        // 0b1100 ... (46 +8)
        val16!(0x2c, 2),    // 0b000
        val16!(0x2c, 2),    // 0b001
        val16!(0x42, 2),    // 0b010
        val16!(0x42, 2),    // 0b011
        val16!(0x2f, 3),    // 0b100
        val16!(0x41, 3),    // 0b101
        val16!(0x13, 3),    // 0b110
        val16!(0x21, 3),    // 0b111

        // 0b1101 ... (54 +8)
        val16!(0x3d, 3),    // 0b000
        val16!(0x4b, 3),    // 0b001
        val16!(0x47, 3),    // 0b010
        val16!(0x19, 3),    // 0b011
        val16!(0x1d, 3),    // 0b100
        val16!(0x4f, 3),    // 0b101
        val16!(0xf, 3),    // 0b110
        val16!(0x1, 3),    // 0b111

        // 0b1110 ... (62 +16)
        val16!(0xb, 3),    // 0b0000
        val16!(0xb, 3),    // 0b0001
        val16!(0x37, 3),    // 0b0010
        val16!(0x37, 3),    // 0b0011
        val16!(0x49, 3),    // 0b0100
        val16!(0x49, 3),    // 0b0101
        val16!(0x3b, 4),    // 0b0110
        val16!(0x15, 4),    // 0b0111
        val16!(0x7, 4),    // 0b1000
        val16!(0x11, 4),    // 0b1001
        val16!(0x5, 4),    // 0b1010
        val16!(0x3, 4),    // 0b1011
        val16!(0x1b, 4),    // 0b1100
        val16!(0x45, 4),    // 0b1101
        val16!(0x3f, 4),    // 0b1110
        val16!(0x2d, 4),    // 0b1111

        // 0b1111 ... (78 +16)
        val16!(0x35, 4),    // 0b0000
        val16!(0x17, 4),    // 0b0001
        val16!(0x9, 4),    // 0b0010
        val16!(0x33, 4),    // 0b0011
        val16!(0x39, 4),    // 0b0100
        val16!(0x23, 4),    // 0b0101
        val16!(0x4d, 4),    // 0b0110
        val16!(0x3c, 4),    // 0b0111
        val16!(0x14, 4),    // 0b1000
        jmp16!(94, 1),    // 0b1001
        jmp16!(96, 1),    // 0b1010
        jmp16!(98, 1),    // 0b1011
        jmp16!(100, 1),    // 0b1100
        jmp16!(102, 1),    // 0b1101
        jmp16!(104, 1),    // 0b1110
        jmp16!(106, 1),    // 0b1111

        // 0b1111 1001 ... (94 +2)
        val16!(0x38, 1),    // 0b0
        val16!(0x0, 1),    // 0b1

        // 0b1111 1010 ... (96 +2)
        val16!(0x18, 1),    // 0b0
        val16!(0x1a, 1),    // 0b1

        // 0b1111 1011 ... (98 +2)
        val16!(0x50, 1),    // 0b0
        val16!(0x6, 1),    // 0b1

        // 0b1111 1100 ... (100 +2)
        val16!(0x3e, 1),    // 0b0
        val16!(0x12, 1),    // 0b1

        // 0b1111 1101 ... (102 +2)
        val16!(0x8, 1),    // 0b0
        val16!(0x48, 1),    // 0b1

        // 0b1111 1110 ... (104 +2)
        val16!(0x36, 1),    // 0b0
        val16!(0x2, 1),    // 0b1

        // 0b1111 1111 ... (106 +2)
        val16!(0x4a, 1),    // 0b0
        val16!(0x4e, 1),    // 0b1
    ],
    n_init_bits: 4,
    n_table_bits: 9,
};

pub const SPEC_TABLE_3: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x0, 1),    // 0b0000
        val16!(0x0, 1),    // 0b0001
        val16!(0x0, 1),    // 0b0010
        val16!(0x0, 1),    // 0b0011
        val16!(0x0, 1),    // 0b0100
        val16!(0x0, 1),    // 0b0101
        val16!(0x0, 1),    // 0b0110
        val16!(0x0, 1),    // 0b0111
        val16!(0x1b, 4),    // 0b1000
        val16!(0x1, 4),    // 0b1001
        val16!(0x9, 4),    // 0b1010
        val16!(0x3, 4),    // 0b1011
        jmp16!(16, 1),    // 0b1100
        jmp16!(18, 2),    // 0b1101
        jmp16!(22, 4),    // 0b1110
        jmp16!(38, 4),    // 0b1111

        // 0b1100 ... (16 +2)
        val16!(0x24, 1),    // 0b0
        val16!(0x4, 1),    // 0b1

        // 0b1101 ... (18 +4)
        val16!(0xc, 2),    // 0b00
        val16!(0xa, 2),    // 0b01
        val16!(0x1e, 2),    // 0b10
        val16!(0xd, 2),    // 0b11

        // 0b1110 ... (22 +16)
        val16!(0x1c, 2),    // 0b0000
        val16!(0x1c, 2),    // 0b0001
        val16!(0x1c, 2),    // 0b0010
        val16!(0x1c, 2),    // 0b0011
        val16!(0x27, 2),    // 0b0100
        val16!(0x27, 2),    // 0b0101
        val16!(0x27, 2),    // 0b0110
        val16!(0x27, 2),    // 0b0111
        val16!(0x28, 3),    // 0b1000
        val16!(0x28, 3),    // 0b1001
        val16!(0x1f, 3),    // 0b1010
        val16!(0x1f, 3),    // 0b1011
        val16!(0x25, 3),    // 0b1100
        val16!(0x25, 3),    // 0b1101
        val16!(0x36, 4),    // 0b1110
        val16!(0x2, 4),    // 0b1111

        // 0b1111 ... (38 +16)
        val16!(0x5, 4),    // 0b0000
        val16!(0x3f, 4),    // 0b0001
        val16!(0x30, 4),    // 0b0010
        jmp16!(54, 1),    // 0b0011
        jmp16!(56, 1),    // 0b0100
        jmp16!(58, 1),    // 0b0101
        jmp16!(60, 1),    // 0b0110
        jmp16!(62, 1),    // 0b0111
        jmp16!(64, 1),    // 0b1000
        jmp16!(66, 1),    // 0b1001
        jmp16!(68, 2),    // 0b1010
        jmp16!(72, 2),    // 0b1011
        jmp16!(76, 2),    // 0b1100
        jmp16!(80, 2),    // 0b1101
        jmp16!(84, 3),    // 0b1110
        jmp16!(92, 4),    // 0b1111

        // 0b1111 0011 ... (54 +2)
        val16!(0x7, 1),    // 0b0
        val16!(0x10, 1),    // 0b1

        // 0b1111 0100 ... (56 +2)
        val16!(0x2d, 1),    // 0b0
        val16!(0xe, 1),    // 0b1

        // 0b1111 0101 ... (58 +2)
        val16!(0x42, 1),    // 0b0
        val16!(0x6, 1),    // 0b1

        // 0b1111 0110 ... (60 +2)
        val16!(0x15, 1),    // 0b0
        val16!(0xf, 1),    // 0b1

        // 0b1111 0111 ... (62 +2)
        val16!(0x12, 1),    // 0b0
        val16!(0xb, 1),    // 0b1

        // 0b1111 1000 ... (64 +2)
        val16!(0x39, 1),    // 0b0
        val16!(0x31, 1),    // 0b1

        // 0b1111 1001 ... (66 +2)
        val16!(0x16, 1),    // 0b0
        val16!(0x2a, 1),    // 0b1

        // 0b1111 1010 ... (68 +4)
        val16!(0x2b, 1),    // 0b00
        val16!(0x2b, 1),    // 0b01
        val16!(0x2e, 2),    // 0b10
        val16!(0x21, 2),    // 0b11

        // 0b1111 1011 ... (72 +4)
        val16!(0x22, 2),    // 0b00
        val16!(0x13, 2),    // 0b01
        val16!(0x43, 2),    // 0b10
        val16!(0x29, 2),    // 0b11

        // 0b1111 1100 ... (76 +4)
        val16!(0x40, 2),    // 0b00
        val16!(0x20, 2),    // 0b01
        val16!(0x8, 2),    // 0b10
        val16!(0x11, 2),    // 0b11

        // 0b1111 1101 ... (80 +4)
        val16!(0x4b, 2),    // 0b00
        val16!(0x33, 2),    // 0b01
        val16!(0x1d, 2),    // 0b10
        val16!(0x37, 2),    // 0b11

        // 0b1111 1110 ... (84 +8)
        val16!(0x19, 2),    // 0b000
        val16!(0x19, 2),    // 0b001
        val16!(0x48, 3),    // 0b010
        val16!(0x34, 3),    // 0b011
        val16!(0x26, 3),    // 0b100
        val16!(0x3a, 3),    // 0b101
        val16!(0x2c, 3),    // 0b110
        val16!(0x4c, 3),    // 0b111

        // 0b1111 1111 ... (92 +16)
        val16!(0x18, 3),    // 0b0000
        val16!(0x18, 3),    // 0b0001
        val16!(0x17, 3),    // 0b0010
        val16!(0x17, 3),    // 0b0011
        val16!(0x23, 4),    // 0b0100
        val16!(0x49, 4),    // 0b0101
        val16!(0x45, 4),    // 0b0110
        val16!(0x4e, 4),    // 0b0111
        val16!(0x1a, 4),    // 0b1000
        val16!(0x4f, 4),    // 0b1001
        val16!(0x46, 4),    // 0b1010
        val16!(0x32, 4),    // 0b1011
        val16!(0x35, 4),    // 0b1100
        jmp16!(108, 1),    // 0b1101
        jmp16!(110, 2),    // 0b1110
        jmp16!(114, 4),    // 0b1111

        // 0b1111 1111 1101 ... (108 +2)
        val16!(0x14, 1),    // 0b0
        val16!(0x3c, 1),    // 0b1

        // 0b1111 1111 1110 ... (110 +4)
        val16!(0x2f, 1),    // 0b00
        val16!(0x2f, 1),    // 0b01
        val16!(0x3d, 2),    // 0b10
        val16!(0x44, 2),    // 0b11

        // 0b1111 1111 1111 ... (114 +16)
        val16!(0x41, 2),    // 0b0000
        val16!(0x41, 2),    // 0b0001
        val16!(0x41, 2),    // 0b0010
        val16!(0x41, 2),    // 0b0011
        val16!(0x50, 3),    // 0b0100
        val16!(0x50, 3),    // 0b0101
        val16!(0x4d, 3),    // 0b0110
        val16!(0x4d, 3),    // 0b0111
        val16!(0x47, 3),    // 0b1000
        val16!(0x47, 3),    // 0b1001
        val16!(0x3b, 3),    // 0b1010
        val16!(0x3b, 3),    // 0b1011
        val16!(0x38, 3),    // 0b1100
        val16!(0x38, 3),    // 0b1101
        val16!(0x4a, 4),    // 0b1110
        val16!(0x3e, 4),    // 0b1111
    ],
    n_init_bits: 4,
    n_table_bits: 16,
};

pub const SPEC_TABLE_4: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x28, 4),    // 0b0000
        val16!(0xd, 4),    // 0b0001
        val16!(0x25, 4),    // 0b0010
        val16!(0x27, 4),    // 0b0011
        val16!(0x1f, 4),    // 0b0100
        val16!(0x1b, 4),    // 0b0101
        val16!(0x24, 4),    // 0b0110
        val16!(0x0, 4),    // 0b0111
        val16!(0x4, 4),    // 0b1000
        val16!(0x1e, 4),    // 0b1001
        jmp16!(16, 1),    // 0b1010
        jmp16!(18, 1),    // 0b1011
        jmp16!(20, 1),    // 0b1100
        jmp16!(22, 3),    // 0b1101
        jmp16!(30, 4),    // 0b1110
        jmp16!(46, 4),    // 0b1111

        // 0b1010 ... (16 +2)
        val16!(0x1c, 1),    // 0b0
        val16!(0xc, 1),    // 0b1

        // 0b1011 ... (18 +2)
        val16!(0x1, 1),    // 0b0
        val16!(0xa, 1),    // 0b1

        // 0b1100 ... (20 +2)
        val16!(0x3, 1),    // 0b0
        val16!(0x9, 1),    // 0b1

        // 0b1101 ... (22 +8)
        val16!(0x43, 3),    // 0b000
        val16!(0x2b, 3),    // 0b001
        val16!(0x31, 3),    // 0b010
        val16!(0x29, 3),    // 0b011
        val16!(0x42, 3),    // 0b100
        val16!(0x40, 3),    // 0b101
        val16!(0x30, 3),    // 0b110
        val16!(0x3a, 3),    // 0b111

        // 0b1110 ... (30 +16)
        val16!(0x10, 3),    // 0b0000
        val16!(0x10, 3),    // 0b0001
        val16!(0xe, 4),    // 0b0010
        val16!(0x2a, 4),    // 0b0011
        val16!(0x16, 4),    // 0b0100
        val16!(0x20, 4),    // 0b0101
        val16!(0x2e, 4),    // 0b0110
        val16!(0x26, 4),    // 0b0111
        val16!(0x22, 4),    // 0b1000
        val16!(0x3f, 4),    // 0b1001
        val16!(0x39, 4),    // 0b1010
        val16!(0x2d, 4),    // 0b1011
        val16!(0x37, 4),    // 0b1100
        val16!(0xb, 4),    // 0b1101
        val16!(0x15, 4),    // 0b1110
        val16!(0x5, 4),    // 0b1111

        // 0b1111 ... (46 +16)
        val16!(0xf, 4),    // 0b0000
        val16!(0x13, 4),    // 0b0001
        val16!(0x1d, 4),    // 0b0010
        val16!(0x7, 4),    // 0b0011
        val16!(0x21, 4),    // 0b0100
        val16!(0x36, 4),    // 0b0101
        val16!(0x2, 4),    // 0b0110
        jmp16!(62, 1),    // 0b0111
        jmp16!(64, 1),    // 0b1000
        jmp16!(66, 1),    // 0b1001
        jmp16!(68, 1),    // 0b1010
        jmp16!(70, 2),    // 0b1011
        jmp16!(74, 2),    // 0b1100
        jmp16!(78, 2),    // 0b1101
        jmp16!(82, 3),    // 0b1110
        jmp16!(90, 4),    // 0b1111

        // 0b1111 0111 ... (62 +2)
        val16!(0x12, 1),    // 0b0
        val16!(0x6, 1),    // 0b1

        // 0b1111 1000 ... (64 +2)
        val16!(0x34, 1),    // 0b0
        val16!(0x4c, 1),    // 0b1

        // 0b1111 1001 ... (66 +2)
        val16!(0x46, 1),    // 0b0
        val16!(0x2c, 1),    // 0b1

        // 0b1111 1010 ... (68 +2)
        val16!(0x32, 1),    // 0b0
        val16!(0x44, 1),    // 0b1

        // 0b1111 1011 ... (70 +4)
        val16!(0x33, 2),    // 0b00
        val16!(0x4b, 2),    // 0b01
        val16!(0x45, 2),    // 0b10
        val16!(0x19, 2),    // 0b11

        // 0b1111 1100 ... (74 +4)
        val16!(0x11, 2),    // 0b00
        val16!(0x49, 2),    // 0b01
        val16!(0x17, 2),    // 0b10
        val16!(0x3d, 2),    // 0b11

        // 0b1111 1101 ... (78 +4)
        val16!(0x23, 2),    // 0b00
        val16!(0x4f, 2),    // 0b01
        val16!(0x2f, 2),    // 0b10
        val16!(0x3b, 2),    // 0b11

        // 0b1111 1110 ... (82 +8)
        val16!(0x41, 2),    // 0b000
        val16!(0x41, 2),    // 0b001
        val16!(0x35, 2),    // 0b010
        val16!(0x35, 2),    // 0b011
        val16!(0x47, 3),    // 0b100
        val16!(0x4d, 3),    // 0b101
        val16!(0x18, 3),    // 0b110
        val16!(0x48, 3),    // 0b111

        // 0b1111 1111 ... (90 +16)
        val16!(0x8, 3),    // 0b0000
        val16!(0x8, 3),    // 0b0001
        val16!(0x3c, 3),    // 0b0010
        val16!(0x3c, 3),    // 0b0011
        val16!(0x14, 3),    // 0b0100
        val16!(0x14, 3),    // 0b0101
        val16!(0x38, 3),    // 0b0110
        val16!(0x38, 3),    // 0b0111
        val16!(0x50, 3),    // 0b1000
        val16!(0x50, 3),    // 0b1001
        val16!(0x1a, 3),    // 0b1010
        val16!(0x1a, 3),    // 0b1011
        val16!(0x4e, 3),    // 0b1100
        val16!(0x4e, 3),    // 0b1101
        val16!(0x4a, 4),    // 0b1110
        val16!(0x3e, 4),    // 0b1111
    ],
    n_init_bits: 4,
    n_table_bits: 12,
};

pub const SPEC_TABLE_5: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x28, 1),    // 0b0000
        val16!(0x28, 1),    // 0b0001
        val16!(0x28, 1),    // 0b0010
        val16!(0x28, 1),    // 0b0011
        val16!(0x28, 1),    // 0b0100
        val16!(0x28, 1),    // 0b0101
        val16!(0x28, 1),    // 0b0110
        val16!(0x28, 1),    // 0b0111
        val16!(0x1f, 4),    // 0b1000
        val16!(0x31, 4),    // 0b1001
        val16!(0x29, 4),    // 0b1010
        val16!(0x27, 4),    // 0b1011
        jmp16!(16, 1),    // 0b1100
        jmp16!(18, 1),    // 0b1101
        jmp16!(20, 4),    // 0b1110
        jmp16!(36, 4),    // 0b1111

        // 0b1100 ... (16 +2)
        val16!(0x30, 1),    // 0b0
        val16!(0x20, 1),    // 0b1

        // 0b1101 ... (18 +2)
        val16!(0x1e, 1),    // 0b0
        val16!(0x32, 1),    // 0b1

        // 0b1110 ... (20 +16)
        val16!(0x16, 3),    // 0b0000
        val16!(0x16, 3),    // 0b0001
        val16!(0x2a, 3),    // 0b0010
        val16!(0x2a, 3),    // 0b0011
        val16!(0x3a, 3),    // 0b0100
        val16!(0x3a, 3),    // 0b0101
        val16!(0x26, 3),    // 0b0110
        val16!(0x26, 3),    // 0b0111
        val16!(0x15, 4),    // 0b1000
        val16!(0x3b, 4),    // 0b1001
        val16!(0x1d, 4),    // 0b1010
        val16!(0x33, 4),    // 0b1011
        val16!(0x17, 4),    // 0b1100
        val16!(0x39, 4),    // 0b1101
        val16!(0x21, 4),    // 0b1110
        val16!(0x2f, 4),    // 0b1111

        // 0b1111 ... (36 +16)
        val16!(0xd, 4),    // 0b0000
        val16!(0x43, 4),    // 0b0001
        val16!(0x25, 4),    // 0b0010
        val16!(0x2b, 4),    // 0b0011
        jmp16!(52, 1),    // 0b0100
        jmp16!(54, 1),    // 0b0101
        jmp16!(56, 1),    // 0b0110
        jmp16!(58, 1),    // 0b0111
        jmp16!(60, 1),    // 0b1000
        jmp16!(62, 1),    // 0b1001
        jmp16!(64, 2),    // 0b1010
        jmp16!(68, 2),    // 0b1011
        jmp16!(72, 2),    // 0b1100
        jmp16!(76, 3),    // 0b1101
        jmp16!(84, 3),    // 0b1110
        jmp16!(92, 4),    // 0b1111

        // 0b1111 0100 ... (52 +2)
        val16!(0xc, 1),    // 0b0
        val16!(0x34, 1),    // 0b1

        // 0b1111 0101 ... (54 +2)
        val16!(0x44, 1),    // 0b0
        val16!(0x1c, 1),    // 0b1

        // 0b1111 0110 ... (56 +2)
        val16!(0xe, 1),    // 0b0
        val16!(0x42, 1),    // 0b1

        // 0b1111 0111 ... (58 +2)
        val16!(0x2e, 1),    // 0b0
        val16!(0x22, 1),    // 0b1

        // 0b1111 1000 ... (60 +2)
        val16!(0x18, 1),    // 0b0
        val16!(0x3c, 1),    // 0b1

        // 0b1111 1001 ... (62 +2)
        val16!(0x14, 1),    // 0b0
        val16!(0x38, 1),    // 0b1

        // 0b1111 1010 ... (64 +4)
        val16!(0xb, 2),    // 0b00
        val16!(0x41, 2),    // 0b01
        val16!(0x19, 2),    // 0b10
        val16!(0x37, 2),    // 0b11

        // 0b1111 1011 ... (68 +4)
        val16!(0x45, 2),    // 0b00
        val16!(0x3d, 2),    // 0b01
        val16!(0xf, 2),    // 0b10
        val16!(0x13, 2),    // 0b11

        // 0b1111 1100 ... (72 +4)
        val16!(0x24, 2),    // 0b00
        val16!(0x4, 2),    // 0b01
        val16!(0x4d, 2),    // 0b10
        val16!(0x4c, 2),    // 0b11

        // 0b1111 1101 ... (76 +8)
        val16!(0x3, 3),    // 0b000
        val16!(0x2c, 3),    // 0b001
        val16!(0x4b, 3),    // 0b010
        val16!(0x1b, 3),    // 0b011
        val16!(0x35, 3),    // 0b100
        val16!(0x23, 3),    // 0b101
        val16!(0x5, 3),    // 0b110
        val16!(0x2d, 3),    // 0b111

        // 0b1111 1110 ... (84 +8)
        val16!(0x40, 3),    // 0b000
        val16!(0xa, 3),    // 0b001
        val16!(0x10, 3),    // 0b010
        val16!(0x1a, 3),    // 0b011
        val16!(0x2, 3),    // 0b100
        val16!(0x4e, 3),    // 0b101
        val16!(0x36, 3),    // 0b110
        val16!(0x3e, 3),    // 0b111

        // 0b1111 1111 ... (92 +16)
        val16!(0x46, 3),    // 0b0000
        val16!(0x46, 3),    // 0b0001
        val16!(0x6, 3),    // 0b0010
        val16!(0x6, 3),    // 0b0011
        val16!(0x12, 4),    // 0b0100
        val16!(0x4a, 4),    // 0b0101
        val16!(0x3f, 4),    // 0b0110
        val16!(0x1, 4),    // 0b0111
        val16!(0x7, 4),    // 0b1000
        val16!(0x47, 4),    // 0b1001
        val16!(0x11, 4),    // 0b1010
        val16!(0x4f, 4),    // 0b1011
        val16!(0x49, 4),    // 0b1100
        val16!(0x9, 4),    // 0b1101
        jmp16!(108, 1),    // 0b1110
        jmp16!(110, 1),    // 0b1111

        // 0b1111 1111 1110 ... (108 +2)
        val16!(0x48, 1),    // 0b0
        val16!(0x8, 1),    // 0b1

        // 0b1111 1111 1111 ... (110 +2)
        val16!(0x50, 1),    // 0b0
        val16!(0x0, 1),    // 0b1
    ],
    n_init_bits: 4,
    n_table_bits: 13,
};

pub const SPEC_TABLE_6: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x28, 4),    // 0b0000
        val16!(0x31, 4),    // 0b0001
        val16!(0x27, 4),    // 0b0010
        val16!(0x29, 4),    // 0b0011
        val16!(0x1f, 4),    // 0b0100
        val16!(0x32, 4),    // 0b0101
        val16!(0x20, 4),    // 0b0110
        val16!(0x30, 4),    // 0b0111
        val16!(0x1e, 4),    // 0b1000
        jmp16!(16, 2),    // 0b1001
        jmp16!(20, 2),    // 0b1010
        jmp16!(24, 2),    // 0b1011
        jmp16!(28, 2),    // 0b1100
        jmp16!(32, 3),    // 0b1101
        jmp16!(40, 4),    // 0b1110
        jmp16!(56, 4),    // 0b1111

        // 0b1001 ... (16 +4)
        val16!(0x39, 2),    // 0b00
        val16!(0x3b, 2),    // 0b01
        val16!(0x17, 2),    // 0b10
        val16!(0x15, 2),    // 0b11

        // 0b1010 ... (20 +4)
        val16!(0x16, 2),    // 0b00
        val16!(0x21, 2),    // 0b01
        val16!(0x3a, 2),    // 0b10
        val16!(0x2f, 2),    // 0b11

        // 0b1011 ... (24 +4)
        val16!(0x33, 2),    // 0b00
        val16!(0x26, 2),    // 0b01
        val16!(0x1d, 2),    // 0b10
        val16!(0x2a, 2),    // 0b11

        // 0b1100 ... (28 +4)
        val16!(0x38, 2),    // 0b00
        val16!(0x18, 2),    // 0b01
        val16!(0x14, 2),    // 0b10
        val16!(0x3c, 2),    // 0b11

        // 0b1101 ... (32 +8)
        val16!(0xe, 3),    // 0b000
        val16!(0x44, 3),    // 0b001
        val16!(0x42, 3),    // 0b010
        val16!(0x22, 3),    // 0b011
        val16!(0xc, 3),    // 0b100
        val16!(0x34, 3),    // 0b101
        val16!(0x2e, 3),    // 0b110
        val16!(0x1c, 3),    // 0b111

        // 0b1110 ... (40 +16)
        val16!(0x43, 3),    // 0b0000
        val16!(0x43, 3),    // 0b0001
        val16!(0xd, 3),    // 0b0010
        val16!(0xd, 3),    // 0b0011
        val16!(0x25, 3),    // 0b0100
        val16!(0x25, 3),    // 0b0101
        val16!(0x2b, 3),    // 0b0110
        val16!(0x2b, 3),    // 0b0111
        val16!(0x45, 3),    // 0b1000
        val16!(0x45, 3),    // 0b1001
        val16!(0xb, 4),    // 0b1010
        val16!(0x19, 4),    // 0b1011
        val16!(0x3d, 4),    // 0b1100
        val16!(0x41, 4),    // 0b1101
        val16!(0x37, 4),    // 0b1110
        val16!(0x13, 4),    // 0b1111

        // 0b1111 ... (56 +16)
        val16!(0xf, 4),    // 0b0000
        val16!(0x46, 4),    // 0b0001
        jmp16!(72, 1),    // 0b0010
        jmp16!(74, 1),    // 0b0011
        jmp16!(76, 1),    // 0b0100
        jmp16!(78, 1),    // 0b0101
        jmp16!(80, 1),    // 0b0110
        jmp16!(82, 1),    // 0b0111
        jmp16!(84, 1),    // 0b1000
        jmp16!(86, 1),    // 0b1001
        jmp16!(88, 1),    // 0b1010
        jmp16!(90, 1),    // 0b1011
        jmp16!(92, 1),    // 0b1100
        jmp16!(94, 2),    // 0b1101
        jmp16!(98, 2),    // 0b1110
        jmp16!(102, 3),    // 0b1111

        // 0b1111 0010 ... (72 +2)
        val16!(0x40, 1),    // 0b0
        val16!(0xa, 1),    // 0b1

        // 0b1111 0011 ... (74 +2)
        val16!(0x10, 1),    // 0b0
        val16!(0x2d, 1),    // 0b1

        // 0b1111 0100 ... (76 +2)
        val16!(0x1b, 1),    // 0b0
        val16!(0x4d, 1),    // 0b1

        // 0b1111 0101 ... (78 +2)
        val16!(0x5, 1),    // 0b0
        val16!(0x3, 1),    // 0b1

        // 0b1111 0110 ... (80 +2)
        val16!(0x35, 1),    // 0b0
        val16!(0x4b, 1),    // 0b1

        // 0b1111 0111 ... (82 +2)
        val16!(0x23, 1),    // 0b0
        val16!(0x24, 1),    // 0b1

        // 0b1111 1000 ... (84 +2)
        val16!(0x6, 1),    // 0b0
        val16!(0x2, 1),    // 0b1

        // 0b1111 1001 ... (86 +2)
        val16!(0x3e, 1),    // 0b0
        val16!(0x12, 1),    // 0b1

        // 0b1111 1010 ... (88 +2)
        val16!(0x4, 1),    // 0b0
        val16!(0x4e, 1),    // 0b1

        // 0b1111 1011 ... (90 +2)
        val16!(0x4a, 1),    // 0b0
        val16!(0x1a, 1),    // 0b1

        // 0b1111 1100 ... (92 +2)
        val16!(0x4c, 1),    // 0b0
        val16!(0x36, 1),    // 0b1

        // 0b1111 1101 ... (94 +4)
        val16!(0x2c, 1),    // 0b00
        val16!(0x2c, 1),    // 0b01
        val16!(0x9, 2),    // 0b10
        val16!(0x11, 2),    // 0b11

        // 0b1111 1110 ... (98 +4)
        val16!(0x3f, 2),    // 0b00
        val16!(0x49, 2),    // 0b01
        val16!(0x47, 2),    // 0b10
        val16!(0x4f, 2),    // 0b11

        // 0b1111 1111 ... (102 +8)
        val16!(0x7, 2),    // 0b000
        val16!(0x7, 2),    // 0b001
        val16!(0x1, 2),    // 0b010
        val16!(0x1, 2),    // 0b011
        val16!(0x50, 3),    // 0b100
        val16!(0x8, 3),    // 0b101
        val16!(0x0, 3),    // 0b110
        val16!(0x48, 3),    // 0b111
    ],
    n_init_bits: 4,
    n_table_bits: 11,
};

pub const SPEC_TABLE_7: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x0, 1),    // 0b0000
        val16!(0x0, 1),    // 0b0001
        val16!(0x0, 1),    // 0b0010
        val16!(0x0, 1),    // 0b0011
        val16!(0x0, 1),    // 0b0100
        val16!(0x0, 1),    // 0b0101
        val16!(0x0, 1),    // 0b0110
        val16!(0x0, 1),    // 0b0111
        val16!(0x8, 3),    // 0b1000
        val16!(0x8, 3),    // 0b1001
        val16!(0x1, 3),    // 0b1010
        val16!(0x1, 3),    // 0b1011
        val16!(0x9, 4),    // 0b1100
        jmp16!(16, 2),    // 0b1101
        jmp16!(20, 4),    // 0b1110
        jmp16!(36, 4),    // 0b1111

        // 0b1101 ... (16 +4)
        val16!(0x11, 2),    // 0b00
        val16!(0xa, 2),    // 0b01
        val16!(0x10, 2),    // 0b10
        val16!(0x2, 2),    // 0b11

        // 0b1110 ... (20 +16)
        val16!(0x19, 3),    // 0b0000
        val16!(0x19, 3),    // 0b0001
        val16!(0xb, 3),    // 0b0010
        val16!(0xb, 3),    // 0b0011
        val16!(0x12, 3),    // 0b0100
        val16!(0x12, 3),    // 0b0101
        val16!(0x18, 3),    // 0b0110
        val16!(0x18, 3),    // 0b0111
        val16!(0x3, 3),    // 0b1000
        val16!(0x3, 3),    // 0b1001
        val16!(0x13, 4),    // 0b1010
        val16!(0x1a, 4),    // 0b1011
        val16!(0xc, 4),    // 0b1100
        val16!(0x21, 4),    // 0b1101
        val16!(0xd, 4),    // 0b1110
        val16!(0x29, 4),    // 0b1111

        // 0b1111 ... (36 +16)
        val16!(0x1b, 4),    // 0b0000
        val16!(0x14, 4),    // 0b0001
        val16!(0x4, 4),    // 0b0010
        val16!(0x20, 4),    // 0b0011
        jmp16!(52, 1),    // 0b0100
        jmp16!(54, 1),    // 0b0101
        jmp16!(56, 1),    // 0b0110
        jmp16!(58, 1),    // 0b0111
        jmp16!(60, 1),    // 0b1000
        jmp16!(62, 1),    // 0b1001
        jmp16!(64, 1),    // 0b1010
        jmp16!(66, 2),    // 0b1011
        jmp16!(70, 2),    // 0b1100
        jmp16!(74, 2),    // 0b1101
        jmp16!(78, 3),    // 0b1110
        jmp16!(86, 4),    // 0b1111

        // 0b1111 0100 ... (52 +2)
        val16!(0x22, 1),    // 0b0
        val16!(0x15, 1),    // 0b1

        // 0b1111 0101 ... (54 +2)
        val16!(0x2a, 1),    // 0b0
        val16!(0x5, 1),    // 0b1

        // 0b1111 0110 ... (56 +2)
        val16!(0x31, 1),    // 0b0
        val16!(0x28, 1),    // 0b1

        // 0b1111 0111 ... (58 +2)
        val16!(0xe, 1),    // 0b0
        val16!(0x23, 1),    // 0b1

        // 0b1111 1000 ... (60 +2)
        val16!(0x1d, 1),    // 0b0
        val16!(0x1c, 1),    // 0b1

        // 0b1111 1001 ... (62 +2)
        val16!(0x2b, 1),    // 0b0
        val16!(0x16, 1),    // 0b1

        // 0b1111 1010 ... (64 +2)
        val16!(0x32, 1),    // 0b0
        val16!(0xf, 1),    // 0b1

        // 0b1111 1011 ... (66 +4)
        val16!(0x1e, 2),    // 0b00
        val16!(0x6, 2),    // 0b01
        val16!(0x30, 2),    // 0b10
        val16!(0x24, 2),    // 0b11

        // 0b1111 1100 ... (70 +4)
        val16!(0x39, 2),    // 0b00
        val16!(0x25, 2),    // 0b01
        val16!(0x3a, 2),    // 0b10
        val16!(0x2c, 2),    // 0b11

        // 0b1111 1101 ... (74 +4)
        val16!(0x33, 2),    // 0b00
        val16!(0x17, 2),    // 0b01
        val16!(0x3b, 2),    // 0b10
        val16!(0x34, 2),    // 0b11

        // 0b1111 1110 ... (78 +8)
        val16!(0x2d, 2),    // 0b000
        val16!(0x2d, 2),    // 0b001
        val16!(0x26, 2),    // 0b010
        val16!(0x26, 2),    // 0b011
        val16!(0x1f, 2),    // 0b100
        val16!(0x1f, 2),    // 0b101
        val16!(0x38, 3),    // 0b110
        val16!(0x7, 3),    // 0b111

        // 0b1111 1111 ... (86 +16)
        val16!(0x35, 3),    // 0b0000
        val16!(0x35, 3),    // 0b0001
        val16!(0x2e, 3),    // 0b0010
        val16!(0x2e, 3),    // 0b0011
        val16!(0x3c, 3),    // 0b0100
        val16!(0x3c, 3),    // 0b0101
        val16!(0x27, 3),    // 0b0110
        val16!(0x27, 3),    // 0b0111
        val16!(0x2f, 3),    // 0b1000
        val16!(0x2f, 3),    // 0b1001
        val16!(0x3d, 3),    // 0b1010
        val16!(0x3d, 3),    // 0b1011
        val16!(0x3e, 4),    // 0b1100
        val16!(0x36, 4),    // 0b1101
        val16!(0x37, 4),    // 0b1110
        val16!(0x3f, 4),    // 0b1111
    ],
    n_init_bits: 4,
    n_table_bits: 12,
};

pub const SPEC_TABLE_8: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x9, 3),    // 0b0000
        val16!(0x9, 3),    // 0b0001
        val16!(0x11, 4),    // 0b0010
        val16!(0x8, 4),    // 0b0011
        val16!(0xa, 4),    // 0b0100
        val16!(0x1, 4),    // 0b0101
        val16!(0x12, 4),    // 0b0110
        jmp16!(16, 1),    // 0b0111
        jmp16!(18, 1),    // 0b1000
        jmp16!(20, 1),    // 0b1001
        jmp16!(22, 2),    // 0b1010
        jmp16!(26, 2),    // 0b1011
        jmp16!(30, 2),    // 0b1100
        jmp16!(34, 3),    // 0b1101
        jmp16!(42, 4),    // 0b1110
        jmp16!(58, 4),    // 0b1111

        // 0b0111 ... (16 +2)
        val16!(0x0, 1),    // 0b0
        val16!(0x10, 1),    // 0b1

        // 0b1000 ... (18 +2)
        val16!(0x2, 1),    // 0b0
        val16!(0x19, 1),    // 0b1

        // 0b1001 ... (20 +2)
        val16!(0xb, 1),    // 0b0
        val16!(0x1a, 1),    // 0b1

        // 0b1010 ... (22 +4)
        val16!(0x13, 1),    // 0b00
        val16!(0x13, 1),    // 0b01
        val16!(0x1b, 2),    // 0b10
        val16!(0x21, 2),    // 0b11

        // 0b1011 ... (26 +4)
        val16!(0xc, 2),    // 0b00
        val16!(0x22, 2),    // 0b01
        val16!(0x14, 2),    // 0b10
        val16!(0x18, 2),    // 0b11

        // 0b1100 ... (30 +4)
        val16!(0x3, 2),    // 0b00
        val16!(0x23, 2),    // 0b01
        val16!(0x1c, 2),    // 0b10
        val16!(0x2a, 2),    // 0b11

        // 0b1101 ... (34 +8)
        val16!(0x29, 3),    // 0b000
        val16!(0x15, 3),    // 0b001
        val16!(0xd, 3),    // 0b010
        val16!(0x2b, 3),    // 0b011
        val16!(0x1d, 3),    // 0b100
        val16!(0x24, 3),    // 0b101
        val16!(0x2c, 3),    // 0b110
        val16!(0x4, 3),    // 0b111

        // 0b1110 ... (42 +16)
        val16!(0x25, 3),    // 0b0000
        val16!(0x25, 3),    // 0b0001
        val16!(0x20, 3),    // 0b0010
        val16!(0x20, 3),    // 0b0011
        val16!(0x16, 3),    // 0b0100
        val16!(0x16, 3),    // 0b0101
        val16!(0x32, 3),    // 0b0110
        val16!(0x32, 3),    // 0b0111
        val16!(0x31, 3),    // 0b1000
        val16!(0x31, 3),    // 0b1001
        val16!(0xe, 3),    // 0b1010
        val16!(0xe, 3),    // 0b1011
        val16!(0x1e, 4),    // 0b1100
        val16!(0x33, 4),    // 0b1101
        val16!(0x2d, 4),    // 0b1110
        val16!(0x28, 4),    // 0b1111

        // 0b1111 ... (58 +16)
        val16!(0x34, 4),    // 0b0000
        val16!(0x5, 4),    // 0b0001
        val16!(0x26, 4),    // 0b0010
        val16!(0x39, 4),    // 0b0011
        val16!(0x3a, 4),    // 0b0100
        val16!(0x17, 4),    // 0b0101
        val16!(0x35, 4),    // 0b0110
        val16!(0x3b, 4),    // 0b0111
        val16!(0xf, 4),    // 0b1000
        val16!(0x2e, 4),    // 0b1001
        val16!(0x1f, 4),    // 0b1010
        jmp16!(74, 1),    // 0b1011
        jmp16!(76, 1),    // 0b1100
        jmp16!(78, 1),    // 0b1101
        jmp16!(80, 1),    // 0b1110
        jmp16!(82, 2),    // 0b1111

        // 0b1111 1011 ... (74 +2)
        val16!(0x36, 1),    // 0b0
        val16!(0x3c, 1),    // 0b1

        // 0b1111 1100 ... (76 +2)
        val16!(0x30, 1),    // 0b0
        val16!(0x27, 1),    // 0b1

        // 0b1111 1101 ... (78 +2)
        val16!(0x6, 1),    // 0b0
        val16!(0x3d, 1),    // 0b1

        // 0b1111 1110 ... (80 +2)
        val16!(0x3e, 1),    // 0b0
        val16!(0x37, 1),    // 0b1

        // 0b1111 1111 ... (82 +4)
        val16!(0x2f, 2),    // 0b00
        val16!(0x38, 2),    // 0b01
        val16!(0x7, 2),    // 0b10
        val16!(0x3f, 2),    // 0b11
    ],
    n_init_bits: 4,
    n_table_bits: 10,
};

pub const SPEC_TABLE_9: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x0, 1),    // 0b0000
        val16!(0x0, 1),    // 0b0001
        val16!(0x0, 1),    // 0b0010
        val16!(0x0, 1),    // 0b0011
        val16!(0x0, 1),    // 0b0100
        val16!(0x0, 1),    // 0b0101
        val16!(0x0, 1),    // 0b0110
        val16!(0x0, 1),    // 0b0111
        val16!(0xd, 3),    // 0b1000
        val16!(0xd, 3),    // 0b1001
        val16!(0x1, 3),    // 0b1010
        val16!(0x1, 3),    // 0b1011
        val16!(0xe, 4),    // 0b1100
        jmp16!(16, 2),    // 0b1101
        jmp16!(20, 4),    // 0b1110
        jmp16!(36, 4),    // 0b1111

        // 0b1101 ... (16 +4)
        val16!(0x1b, 2),    // 0b00
        val16!(0xf, 2),    // 0b01
        val16!(0x1a, 2),    // 0b10
        val16!(0x2, 2),    // 0b11

        // 0b1110 ... (20 +16)
        val16!(0x28, 3),    // 0b0000
        val16!(0x28, 3),    // 0b0001
        val16!(0x1c, 3),    // 0b0010
        val16!(0x1c, 3),    // 0b0011
        val16!(0x10, 3),    // 0b0100
        val16!(0x10, 3),    // 0b0101
        val16!(0x27, 4),    // 0b0110
        val16!(0x3, 4),    // 0b0111
        val16!(0x1d, 4),    // 0b1000
        val16!(0x29, 4),    // 0b1001
        val16!(0x11, 4),    // 0b1010
        val16!(0x35, 4),    // 0b1011
        val16!(0x1e, 4),    // 0b1100
        val16!(0x12, 4),    // 0b1101
        jmp16!(52, 1),    // 0b1110
        jmp16!(54, 1),    // 0b1111

        // 0b1111 ... (36 +16)
        jmp16!(56, 1),    // 0b0000
        jmp16!(58, 1),    // 0b0001
        jmp16!(60, 1),    // 0b0010
        jmp16!(62, 2),    // 0b0011
        jmp16!(66, 2),    // 0b0100
        jmp16!(70, 2),    // 0b0101
        jmp16!(74, 2),    // 0b0110
        jmp16!(78, 2),    // 0b0111
        jmp16!(82, 3),    // 0b1000
        jmp16!(90, 3),    // 0b1001
        jmp16!(98, 3),    // 0b1010
        jmp16!(106, 3),    // 0b1011
        jmp16!(114, 4),    // 0b1100
        jmp16!(130, 4),    // 0b1101
        jmp16!(146, 4),    // 0b1110
        jmp16!(162, 4),    // 0b1111

        // 0b1110 1110 ... (52 +2)
        val16!(0x36, 1),    // 0b0
        val16!(0x2a, 1),    // 0b1

        // 0b1110 1111 ... (54 +2)
        val16!(0x4, 1),    // 0b0
        val16!(0x34, 1),    // 0b1

        // 0b1111 0000 ... (56 +2)
        val16!(0x42, 1),    // 0b0
        val16!(0x1f, 1),    // 0b1

        // 0b1111 0001 ... (58 +2)
        val16!(0x13, 1),    // 0b0
        val16!(0x2b, 1),    // 0b1

        // 0b1111 0010 ... (60 +2)
        val16!(0x43, 1),    // 0b0
        val16!(0x4f, 1),    // 0b1

        // 0b1111 0011 ... (62 +4)
        val16!(0x37, 1),    // 0b00
        val16!(0x37, 1),    // 0b01
        val16!(0x5, 2),    // 0b10
        val16!(0x20, 2),    // 0b11

        // 0b1111 0100 ... (66 +4)
        val16!(0x41, 2),    // 0b00
        val16!(0x14, 2),    // 0b01
        val16!(0x2c, 2),    // 0b10
        val16!(0x15, 2),    // 0b11

        // 0b1111 0101 ... (70 +4)
        val16!(0x69, 2),    // 0b00
        val16!(0x38, 2),    // 0b01
        val16!(0x44, 2),    // 0b10
        val16!(0x50, 2),    // 0b11

        // 0b1111 0110 ... (74 +4)
        val16!(0x5c, 2),    // 0b00
        val16!(0x6, 2),    // 0b01
        val16!(0x6a, 2),    // 0b10
        val16!(0x22, 2),    // 0b11

        // 0b1111 0111 ... (78 +4)
        val16!(0x2d, 2),    // 0b00
        val16!(0x21, 2),    // 0b01
        val16!(0x39, 2),    // 0b10
        val16!(0x76, 2),    // 0b11

        // 0b1111 1000 ... (82 +8)
        val16!(0x16, 2),    // 0b000
        val16!(0x16, 2),    // 0b001
        val16!(0x5d, 2),    // 0b010
        val16!(0x5d, 2),    // 0b011
        val16!(0x4e, 3),    // 0b100
        val16!(0x45, 3),    // 0b101
        val16!(0x51, 3),    // 0b110
        val16!(0x6b, 3),    // 0b111

        // 0b1111 1001 ... (90 +8)
        val16!(0x7, 3),    // 0b000
        val16!(0x77, 3),    // 0b001
        val16!(0x2f, 3),    // 0b010
        val16!(0x3a, 3),    // 0b011
        val16!(0x2e, 3),    // 0b100
        val16!(0x8, 3),    // 0b101
        val16!(0x83, 3),    // 0b110
        val16!(0x52, 3),    // 0b111

        // 0b1111 1010 ... (98 +8)
        val16!(0x23, 3),    // 0b000
        val16!(0x46, 3),    // 0b001
        val16!(0x68, 3),    // 0b010
        val16!(0x5b, 3),    // 0b011
        val16!(0x5e, 3),    // 0b100
        val16!(0x84, 3),    // 0b101
        val16!(0x78, 3),    // 0b110
        val16!(0x6c, 3),    // 0b111

        // 0b1111 1011 ... (106 +8)
        val16!(0x17, 3),    // 0b000
        val16!(0x5f, 3),    // 0b001
        val16!(0x53, 3),    // 0b010
        val16!(0x47, 3),    // 0b011
        val16!(0x3c, 3),    // 0b100
        val16!(0x3b, 3),    // 0b101
        val16!(0x30, 3),    // 0b110
        val16!(0x90, 3),    // 0b111

        // 0b1111 1100 ... (114 +16)
        val16!(0x49, 3),    // 0b0000
        val16!(0x49, 3),    // 0b0001
        val16!(0x75, 3),    // 0b0010
        val16!(0x75, 3),    // 0b0011
        val16!(0x6d, 3),    // 0b0100
        val16!(0x6d, 3),    // 0b0101
        val16!(0x85, 4),    // 0b0110
        val16!(0x24, 4),    // 0b0111
        val16!(0x9, 4),    // 0b1000
        val16!(0x91, 4),    // 0b1001
        val16!(0x79, 4),    // 0b1010
        val16!(0x54, 4),    // 0b1011
        val16!(0x9d, 4),    // 0b1100
        val16!(0x3d, 4),    // 0b1101
        val16!(0x6e, 4),    // 0b1110
        val16!(0x18, 4),    // 0b1111

        // 0b1111 1101 ... (130 +16)
        val16!(0x7a, 4),    // 0b0000
        val16!(0x86, 4),    // 0b0001
        val16!(0x48, 4),    // 0b0010
        val16!(0x60, 4),    // 0b0011
        val16!(0x25, 4),    // 0b0100
        val16!(0x19, 4),    // 0b0101
        val16!(0x9e, 4),    // 0b0110
        val16!(0x92, 4),    // 0b0111
        val16!(0x31, 4),    // 0b1000
        val16!(0x4a, 4),    // 0b1001
        val16!(0x55, 4),    // 0b1010
        val16!(0x6f, 4),    // 0b1011
        val16!(0x93, 4),    // 0b1100
        val16!(0xa, 4),    // 0b1101
        val16!(0x61, 4),    // 0b1110
        val16!(0x9f, 4),    // 0b1111

        // 0b1111 1110 ... (146 +16)
        val16!(0x82, 4),    // 0b0000
        val16!(0x87, 4),    // 0b0001
        val16!(0x3e, 4),    // 0b0010
        val16!(0x56, 4),    // 0b0011
        val16!(0x26, 4),    // 0b0100
        val16!(0x7b, 4),    // 0b0101
        val16!(0x7c, 4),    // 0b0110
        val16!(0x3f, 4),    // 0b0111
        val16!(0x8f, 4),    // 0b1000
        val16!(0x57, 4),    // 0b1001
        val16!(0x32, 4),    // 0b1010
        val16!(0x4b, 4),    // 0b1011
        jmp16!(178, 1),    // 0b1100
        jmp16!(180, 1),    // 0b1101
        jmp16!(182, 1),    // 0b1110
        jmp16!(184, 1),    // 0b1111

        // 0b1111 1111 ... (162 +16)
        jmp16!(186, 1),    // 0b0000
        jmp16!(188, 1),    // 0b0001
        jmp16!(190, 1),    // 0b0010
        jmp16!(192, 1),    // 0b0011
        jmp16!(194, 1),    // 0b0100
        jmp16!(196, 1),    // 0b0101
        jmp16!(198, 1),    // 0b0110
        jmp16!(200, 1),    // 0b0111
        jmp16!(202, 1),    // 0b1000
        jmp16!(204, 1),    // 0b1001
        jmp16!(206, 1),    // 0b1010
        jmp16!(208, 1),    // 0b1011
        jmp16!(210, 2),    // 0b1100
        jmp16!(214, 2),    // 0b1101
        jmp16!(218, 2),    // 0b1110
        jmp16!(222, 3),    // 0b1111

        // 0b1111 1110 1100 ... (178 +2)
        val16!(0x70, 1),    // 0b0
        val16!(0x63, 1),    // 0b1

        // 0b1111 1110 1101 ... (180 +2)
        val16!(0xa1, 1),    // 0b0
        val16!(0x33, 1),    // 0b1

        // 0b1111 1110 1110 ... (182 +2)
        val16!(0x94, 1),    // 0b0
        val16!(0x62, 1),    // 0b1

        // 0b1111 1110 1111 ... (184 +2)
        val16!(0xa0, 1),    // 0b0
        val16!(0x95, 1),    // 0b1

        // 0b1111 1111 0000 ... (186 +2)
        val16!(0x88, 1),    // 0b0
        val16!(0x40, 1),    // 0b1

        // 0b1111 1111 0001 ... (188 +2)
        val16!(0x64, 1),    // 0b0
        val16!(0x4c, 1),    // 0b1

        // 0b1111 1111 0010 ... (190 +2)
        val16!(0xb, 1),    // 0b0
        val16!(0xa2, 1),    // 0b1

        // 0b1111 1111 0011 ... (192 +2)
        val16!(0x58, 1),    // 0b0
        val16!(0x9c, 1),    // 0b1

        // 0b1111 1111 0100 ... (194 +2)
        val16!(0x89, 1),    // 0b0
        val16!(0x4d, 1),    // 0b1

        // 0b1111 1111 0101 ... (196 +2)
        val16!(0x65, 1),    // 0b0
        val16!(0x7d, 1),    // 0b1

        // 0b1111 1111 0110 ... (198 +2)
        val16!(0xc, 1),    // 0b0
        val16!(0x96, 1),    // 0b1

        // 0b1111 1111 0111 ... (200 +2)
        val16!(0x71, 1),    // 0b0
        val16!(0x7e, 1),    // 0b1

        // 0b1111 1111 1000 ... (202 +2)
        val16!(0x8a, 1),    // 0b0
        val16!(0x66, 1),    // 0b1

        // 0b1111 1111 1001 ... (204 +2)
        val16!(0xa3, 1),    // 0b0
        val16!(0x59, 1),    // 0b1

        // 0b1111 1111 1010 ... (206 +2)
        val16!(0x73, 1),    // 0b0
        val16!(0x97, 1),    // 0b1

        // 0b1111 1111 1011 ... (208 +2)
        val16!(0x67, 1),    // 0b0
        val16!(0x5a, 1),    // 0b1

        // 0b1111 1111 1100 ... (210 +4)
        val16!(0x72, 2),    // 0b00
        val16!(0x8b, 2),    // 0b01
        val16!(0x74, 2),    // 0b10
        val16!(0x7f, 2),    // 0b11

        // 0b1111 1111 1101 ... (214 +4)
        val16!(0x80, 2),    // 0b00
        val16!(0x81, 2),    // 0b01
        val16!(0x8d, 2),    // 0b10
        val16!(0xa5, 2),    // 0b11

        // 0b1111 1111 1110 ... (218 +4)
        val16!(0x8c, 2),    // 0b00
        val16!(0x98, 2),    // 0b01
        val16!(0xa4, 2),    // 0b10
        val16!(0x99, 2),    // 0b11

        // 0b1111 1111 1111 ... (222 +8)
        val16!(0xa6, 2),    // 0b000
        val16!(0xa6, 2),    // 0b001
        val16!(0xa7, 2),    // 0b010
        val16!(0xa7, 2),    // 0b011
        val16!(0x8e, 3),    // 0b100
        val16!(0x9a, 3),    // 0b101
        val16!(0x9b, 3),    // 0b110
        val16!(0xa8, 3),    // 0b111
    ],
    n_init_bits: 4,
    n_table_bits: 15,
};

pub const SPEC_TABLE_10: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0xe, 4),    // 0b0000
        val16!(0xf, 4),    // 0b0001
        val16!(0x1b, 4),    // 0b0010
        jmp16!(16, 1),    // 0b0011
        jmp16!(18, 1),    // 0b0100
        jmp16!(20, 1),    // 0b0101
        jmp16!(22, 1),    // 0b0110
        jmp16!(24, 2),    // 0b0111
        jmp16!(28, 2),    // 0b1000
        jmp16!(32, 2),    // 0b1001
        jmp16!(36, 3),    // 0b1010
        jmp16!(44, 3),    // 0b1011
        jmp16!(52, 4),    // 0b1100
        jmp16!(68, 4),    // 0b1101
        jmp16!(84, 4),    // 0b1110
        jmp16!(100, 4),    // 0b1111

        // 0b0011 ... (16 +2)
        val16!(0x1c, 1),    // 0b0
        val16!(0xd, 1),    // 0b1

        // 0b0100 ... (18 +2)
        val16!(0x1, 1),    // 0b0
        val16!(0x10, 1),    // 0b1

        // 0b0101 ... (20 +2)
        val16!(0x29, 1),    // 0b0
        val16!(0x28, 1),    // 0b1

        // 0b0110 ... (22 +2)
        val16!(0x1d, 1),    // 0b0
        val16!(0x2a, 1),    // 0b1

        // 0b0111 ... (24 +4)
        val16!(0x1a, 2),    // 0b00
        val16!(0x2, 2),    // 0b01
        val16!(0x1e, 2),    // 0b10
        val16!(0x36, 2),    // 0b11

        // 0b1000 ... (28 +4)
        val16!(0x11, 2),    // 0b00
        val16!(0x35, 2),    // 0b01
        val16!(0x0, 2),    // 0b10
        val16!(0x37, 2),    // 0b11

        // 0b1001 ... (32 +4)
        val16!(0x2b, 2),    // 0b00
        val16!(0x27, 2),    // 0b01
        val16!(0x3, 2),    // 0b10
        val16!(0x38, 2),    // 0b11

        // 0b1010 ... (36 +8)
        val16!(0x1f, 2),    // 0b000
        val16!(0x1f, 2),    // 0b001
        val16!(0x43, 2),    // 0b010
        val16!(0x43, 2),    // 0b011
        val16!(0x12, 3),    // 0b100
        val16!(0x42, 3),    // 0b101
        val16!(0x44, 3),    // 0b110
        val16!(0x2c, 3),    // 0b111

        // 0b1011 ... (44 +8)
        val16!(0x45, 3),    // 0b000
        val16!(0x39, 3),    // 0b001
        val16!(0x50, 3),    // 0b010
        val16!(0x20, 3),    // 0b011
        val16!(0x51, 3),    // 0b100
        val16!(0x34, 3),    // 0b101
        val16!(0x4f, 3),    // 0b110
        val16!(0x4, 3),    // 0b111

        // 0b1100 ... (52 +16)
        val16!(0x13, 3),    // 0b0000
        val16!(0x13, 3),    // 0b0001
        val16!(0x2d, 3),    // 0b0010
        val16!(0x2d, 3),    // 0b0011
        val16!(0x46, 3),    // 0b0100
        val16!(0x46, 3),    // 0b0101
        val16!(0x52, 3),    // 0b0110
        val16!(0x52, 3),    // 0b0111
        val16!(0x3a, 3),    // 0b1000
        val16!(0x3a, 3),    // 0b1001
        val16!(0x53, 4),    // 0b1010
        val16!(0x5d, 4),    // 0b1011
        val16!(0x2e, 4),    // 0b1100
        val16!(0x21, 4),    // 0b1101
        val16!(0x47, 4),    // 0b1110
        val16!(0x6a, 4),    // 0b1111

        // 0b1101 ... (68 +16)
        val16!(0x5e, 4),    // 0b0000
        val16!(0x41, 4),    // 0b0001
        val16!(0x5c, 4),    // 0b0010
        val16!(0x5, 4),    // 0b0011
        val16!(0x69, 4),    // 0b0100
        val16!(0x14, 4),    // 0b0101
        val16!(0x6b, 4),    // 0b0110
        val16!(0x5f, 4),    // 0b0111
        val16!(0x3b, 4),    // 0b1000
        val16!(0x22, 4),    // 0b1001
        val16!(0x54, 4),    // 0b1010
        val16!(0x60, 4),    // 0b1011
        val16!(0x15, 4),    // 0b1100
        val16!(0x2f, 4),    // 0b1101
        val16!(0x6c, 4),    // 0b1110
        val16!(0x3c, 4),    // 0b1111

        // 0b1110 ... (84 +16)
        val16!(0x48, 4),    // 0b0000
        val16!(0x6d, 4),    // 0b0001
        val16!(0x49, 4),    // 0b0010
        jmp16!(116, 1),    // 0b0011
        jmp16!(118, 1),    // 0b0100
        jmp16!(120, 1),    // 0b0101
        jmp16!(122, 1),    // 0b0110
        jmp16!(124, 1),    // 0b0111
        jmp16!(126, 1),    // 0b1000
        jmp16!(128, 1),    // 0b1001
        jmp16!(130, 1),    // 0b1010
        jmp16!(132, 1),    // 0b1011
        jmp16!(134, 1),    // 0b1100
        jmp16!(136, 1),    // 0b1101
        jmp16!(138, 1),    // 0b1110
        jmp16!(140, 1),    // 0b1111

        // 0b1111 ... (100 +16)
        jmp16!(142, 1),    // 0b0000
        jmp16!(144, 1),    // 0b0001
        jmp16!(146, 2),    // 0b0010
        jmp16!(150, 2),    // 0b0011
        jmp16!(154, 2),    // 0b0100
        jmp16!(158, 2),    // 0b0101
        jmp16!(162, 2),    // 0b0110
        jmp16!(166, 2),    // 0b0111
        jmp16!(170, 2),    // 0b1000
        jmp16!(174, 2),    // 0b1001
        jmp16!(178, 2),    // 0b1010
        jmp16!(182, 2),    // 0b1011
        jmp16!(186, 3),    // 0b1100
        jmp16!(194, 3),    // 0b1101
        jmp16!(202, 3),    // 0b1110
        jmp16!(210, 4),    // 0b1111

        // 0b1110 0011 ... (116 +2)
        val16!(0x61, 1),    // 0b0
        val16!(0x55, 1),    // 0b1

        // 0b1110 0100 ... (118 +2)
        val16!(0x77, 1),    // 0b0
        val16!(0x4e, 1),    // 0b1

        // 0b1110 0101 ... (120 +2)
        val16!(0x56, 1),    // 0b0
        val16!(0x78, 1),    // 0b1

        // 0b1110 0110 ... (122 +2)
        val16!(0x30, 1),    // 0b0
        val16!(0x76, 1),    // 0b1

        // 0b1110 0111 ... (124 +2)
        val16!(0x23, 1),    // 0b0
        val16!(0x6, 1),    // 0b1

        // 0b1110 1000 ... (126 +2)
        val16!(0x6e, 1),    // 0b0
        val16!(0x79, 1),    // 0b1

        // 0b1110 1001 ... (128 +2)
        val16!(0x3d, 1),    // 0b0
        val16!(0x84, 1),    // 0b1

        // 0b1110 1010 ... (130 +2)
        val16!(0x16, 1),    // 0b0
        val16!(0x62, 1),    // 0b1

        // 0b1110 1011 ... (132 +2)
        val16!(0x6f, 1),    // 0b0
        val16!(0x7a, 1),    // 0b1

        // 0b1110 1100 ... (134 +2)
        val16!(0x63, 1),    // 0b0
        val16!(0x85, 1),    // 0b1

        // 0b1110 1101 ... (136 +2)
        val16!(0x4a, 1),    // 0b0
        val16!(0x86, 1),    // 0b1

        // 0b1110 1110 ... (138 +2)
        val16!(0x24, 1),    // 0b0
        val16!(0x83, 1),    // 0b1

        // 0b1110 1111 ... (140 +2)
        val16!(0x31, 1),    // 0b0
        val16!(0x7b, 1),    // 0b1

        // 0b1111 0000 ... (142 +2)
        val16!(0x57, 1),    // 0b0
        val16!(0x68, 1),    // 0b1

        // 0b1111 0001 ... (144 +2)
        val16!(0x3e, 1),    // 0b0
        val16!(0x5b, 1),    // 0b1

        // 0b1111 0010 ... (146 +4)
        val16!(0x91, 1),    // 0b00
        val16!(0x91, 1),    // 0b01
        val16!(0x64, 2),    // 0b10
        val16!(0x92, 2),    // 0b11

        // 0b1111 0011 ... (150 +4)
        val16!(0x88, 2),    // 0b00
        val16!(0x17, 2),    // 0b01
        val16!(0x90, 2),    // 0b10
        val16!(0x7c, 2),    // 0b11

        // 0b1111 0100 ... (154 +4)
        val16!(0x7, 2),    // 0b00
        val16!(0x70, 2),    // 0b01
        val16!(0x87, 2),    // 0b10
        val16!(0x32, 2),    // 0b11

        // 0b1111 0101 ... (158 +4)
        val16!(0x4b, 2),    // 0b00
        val16!(0x71, 2),    // 0b01
        val16!(0x94, 2),    // 0b10
        val16!(0x8, 2),    // 0b11

        // 0b1111 0110 ... (162 +4)
        val16!(0x93, 2),    // 0b00
        val16!(0x25, 2),    // 0b01
        val16!(0x65, 2),    // 0b10
        val16!(0x58, 2),    // 0b11

        // 0b1111 0111 ... (166 +4)
        val16!(0x89, 2),    // 0b00
        val16!(0x3f, 2),    // 0b01
        val16!(0x18, 2),    // 0b10
        val16!(0x9e, 2),    // 0b11

        // 0b1111 1000 ... (170 +4)
        val16!(0x7d, 2),    // 0b00
        val16!(0x9f, 2),    // 0b01
        val16!(0x95, 2),    // 0b10
        val16!(0x4c, 2),    // 0b11

        // 0b1111 1001 ... (174 +4)
        val16!(0xa0, 2),    // 0b00
        val16!(0x96, 2),    // 0b01
        val16!(0xa1, 2),    // 0b10
        val16!(0x33, 2),    // 0b11

        // 0b1111 1010 ... (178 +4)
        val16!(0x59, 2),    // 0b00
        val16!(0x75, 2),    // 0b01
        val16!(0x8a, 2),    // 0b10
        val16!(0x82, 2),    // 0b11

        // 0b1111 1011 ... (182 +4)
        val16!(0x9d, 2),    // 0b00
        val16!(0x9, 2),    // 0b01
        val16!(0x40, 2),    // 0b10
        val16!(0x7e, 2),    // 0b11

        // 0b1111 1100 ... (186 +8)
        val16!(0xa2, 2),    // 0b000
        val16!(0xa2, 2),    // 0b001
        val16!(0x26, 2),    // 0b010
        val16!(0x26, 2),    // 0b011
        val16!(0x72, 2),    // 0b100
        val16!(0x72, 2),    // 0b101
        val16!(0x7f, 3),    // 0b110
        val16!(0x19, 3),    // 0b111

        // 0b1111 1101 ... (194 +8)
        val16!(0x97, 3),    // 0b000
        val16!(0xa3, 3),    // 0b001
        val16!(0x66, 3),    // 0b010
        val16!(0x4d, 3),    // 0b011
        val16!(0x5a, 3),    // 0b100
        val16!(0x8b, 3),    // 0b101
        val16!(0x73, 3),    // 0b110
        val16!(0xa4, 3),    // 0b111

        // 0b1111 1110 ... (202 +8)
        val16!(0xa, 3),    // 0b000
        val16!(0x67, 3),    // 0b001
        val16!(0x8f, 3),    // 0b010
        val16!(0x8c, 3),    // 0b011
        val16!(0x98, 3),    // 0b100
        val16!(0x99, 3),    // 0b101
        val16!(0xb, 3),    // 0b110
        val16!(0x9a, 3),    // 0b111

        // 0b1111 1111 ... (210 +16)
        val16!(0x80, 3),    // 0b0000
        val16!(0x80, 3),    // 0b0001
        val16!(0x8d, 3),    // 0b0010
        val16!(0x8d, 3),    // 0b0011
        val16!(0x9c, 3),    // 0b0100
        val16!(0x9c, 3),    // 0b0101
        val16!(0x74, 3),    // 0b0110
        val16!(0x74, 3),    // 0b0111
        val16!(0xa5, 4),    // 0b1000
        val16!(0x8e, 4),    // 0b1001
        val16!(0x81, 4),    // 0b1010
        val16!(0x9b, 4),    // 0b1011
        val16!(0xa7, 4),    // 0b1100
        val16!(0xc, 4),    // 0b1101
        val16!(0xa6, 4),    // 0b1110
        val16!(0xa8, 4),    // 0b1111
    ],
    n_init_bits: 4,
    n_table_bits: 12,
};

pub const SPEC_TABLE_11: HuffmanTable<H16> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val16!(0x0, 4),    // 0b0000
        val16!(0x12, 4),    // 0b0001
        jmp16!(16, 1),    // 0b0010
        jmp16!(18, 1),    // 0b0011
        jmp16!(20, 1),    // 0b0100
        jmp16!(22, 2),    // 0b0101
        jmp16!(26, 3),    // 0b0110
        jmp16!(34, 3),    // 0b0111
        jmp16!(42, 4),    // 0b1000
        jmp16!(58, 4),    // 0b1001
        jmp16!(74, 4),    // 0b1010
        jmp16!(90, 4),    // 0b1011
        jmp16!(106, 4),    // 0b1100
        jmp16!(122, 4),    // 0b1101
        jmp16!(138, 4),    // 0b1110
        jmp16!(154, 4),    // 0b1111

        // 0b0010 ... (16 +2)
        val16!(0x120, 1),    // 0b0
        val16!(0x11, 1),    // 0b1

        // 0b0011 ... (18 +2)
        val16!(0x1, 1),    // 0b0
        val16!(0x23, 1),    // 0b1

        // 0b0100 ... (20 +2)
        val16!(0x13, 1),    // 0b0
        val16!(0x24, 1),    // 0b1

        // 0b0101 ... (22 +4)
        val16!(0x14, 2),    // 0b00
        val16!(0x34, 2),    // 0b01
        val16!(0x35, 2),    // 0b10
        val16!(0x22, 2),    // 0b11

        // 0b0110 ... (26 +8)
        val16!(0x25, 2),    // 0b000
        val16!(0x25, 2),    // 0b001
        val16!(0x2, 2),    // 0b010
        val16!(0x2, 2),    // 0b011
        val16!(0x36, 2),    // 0b100
        val16!(0x36, 2),    // 0b101
        val16!(0x45, 3),    // 0b110
        val16!(0x15, 3),    // 0b111

        // 0b0111 ... (34 +8)
        val16!(0x46, 3),    // 0b000
        val16!(0x26, 3),    // 0b001
        val16!(0x47, 3),    // 0b010
        val16!(0x37, 3),    // 0b011
        val16!(0x33, 3),    // 0b100
        val16!(0x3, 3),    // 0b101
        val16!(0x56, 3),    // 0b110
        val16!(0x57, 3),    // 0b111

        // 0b1000 ... (42 +16)
        val16!(0x27, 3),    // 0b0000
        val16!(0x27, 3),    // 0b0001
        val16!(0x48, 3),    // 0b0010
        val16!(0x48, 3),    // 0b0011
        val16!(0x16, 3),    // 0b0100
        val16!(0x16, 3),    // 0b0101
        val16!(0x58, 3),    // 0b0110
        val16!(0x58, 3),    // 0b0111
        val16!(0x38, 3),    // 0b1000
        val16!(0x38, 3),    // 0b1001
        val16!(0x59, 3),    // 0b1010
        val16!(0x59, 3),    // 0b1011
        val16!(0x49, 4),    // 0b1100
        val16!(0x68, 4),    // 0b1101
        val16!(0x28, 4),    // 0b1110
        val16!(0x67, 4),    // 0b1111

        // 0b1001 ... (58 +16)
        val16!(0x69, 4),    // 0b0000
        val16!(0x39, 4),    // 0b0001
        val16!(0x17, 4),    // 0b0010
        val16!(0x54, 4),    // 0b0011
        val16!(0x43, 4),    // 0b0100
        val16!(0x115, 4),    // 0b0101
        val16!(0x113, 4),    // 0b0110
        val16!(0x114, 4),    // 0b0111
        val16!(0x6a, 4),    // 0b1000
        val16!(0x116, 4),    // 0b1001
        val16!(0x44, 4),    // 0b1010
        val16!(0x4a, 4),    // 0b1011
        val16!(0x4, 4),    // 0b1100
        val16!(0x32, 4),    // 0b1101
        val16!(0x5a, 4),    // 0b1110
        val16!(0x65, 4),    // 0b1111

        // 0b1010 ... (74 +16)
        val16!(0x117, 4),    // 0b0000
        val16!(0x112, 4),    // 0b0001
        val16!(0x118, 4),    // 0b0010
        val16!(0x29, 4),    // 0b0011
        val16!(0x79, 4),    // 0b0100
        val16!(0x3a, 4),    // 0b0101
        val16!(0x6b, 4),    // 0b0110
        val16!(0x5b, 4),    // 0b0111
        val16!(0x76, 4),    // 0b1000
        val16!(0x11a, 4),    // 0b1001
        val16!(0x7a, 4),    // 0b1010
        val16!(0x78, 4),    // 0b1011
        val16!(0x119, 4),    // 0b1100
        val16!(0x87, 4),    // 0b1101
        val16!(0x21, 4),    // 0b1110
        val16!(0x18, 4),    // 0b1111

        // 0b1011 ... (90 +16)
        val16!(0x4b, 4),    // 0b0000
        val16!(0x11b, 4),    // 0b0001
        val16!(0x7b, 4),    // 0b0010
        val16!(0x11c, 4),    // 0b0011
        val16!(0x98, 4),    // 0b0100
        val16!(0x111, 4),    // 0b0101
        val16!(0x6c, 4),    // 0b0110
        val16!(0xa9, 4),    // 0b0111
        val16!(0x2a, 4),    // 0b1000
        val16!(0x5c, 4),    // 0b1001
        val16!(0xba, 4),    // 0b1010
        val16!(0x11d, 4),    // 0b1011
        val16!(0x8b, 4),    // 0b1100
        val16!(0x8a, 4),    // 0b1101
        val16!(0x3b, 4),    // 0b1110
        val16!(0x55, 4),    // 0b1111

        // 0b1100 ... (106 +16)
        val16!(0x11e, 4),    // 0b0000
        val16!(0xcb, 4),    // 0b0001
        val16!(0x7c, 4),    // 0b0010
        val16!(0x4c, 4),    // 0b0011
        val16!(0x6d, 4),    // 0b0100
        val16!(0x7d, 4),    // 0b0101
        val16!(0x5, 4),    // 0b0110
        jmp16!(170, 1),    // 0b0111
        jmp16!(172, 1),    // 0b1000
        jmp16!(174, 1),    // 0b1001
        jmp16!(176, 1),    // 0b1010
        jmp16!(178, 1),    // 0b1011
        jmp16!(180, 1),    // 0b1100
        jmp16!(182, 1),    // 0b1101
        jmp16!(184, 1),    // 0b1110
        jmp16!(186, 1),    // 0b1111

        // 0b1101 ... (122 +16)
        jmp16!(188, 1),    // 0b0000
        jmp16!(190, 1),    // 0b0001
        jmp16!(192, 1),    // 0b0010
        jmp16!(194, 1),    // 0b0011
        jmp16!(196, 1),    // 0b0100
        jmp16!(198, 1),    // 0b0101
        jmp16!(200, 1),    // 0b0110
        jmp16!(202, 1),    // 0b0111
        jmp16!(204, 1),    // 0b1000
        jmp16!(206, 1),    // 0b1001
        jmp16!(208, 1),    // 0b1010
        jmp16!(210, 1),    // 0b1011
        jmp16!(212, 1),    // 0b1100
        jmp16!(214, 1),    // 0b1101
        jmp16!(216, 1),    // 0b1110
        jmp16!(218, 1),    // 0b1111

        // 0b1110 ... (138 +16)
        jmp16!(220, 1),    // 0b0000
        jmp16!(222, 1),    // 0b0001
        jmp16!(224, 2),    // 0b0010
        jmp16!(228, 2),    // 0b0011
        jmp16!(232, 2),    // 0b0100
        jmp16!(236, 2),    // 0b0101
        jmp16!(240, 2),    // 0b0110
        jmp16!(244, 2),    // 0b0111
        jmp16!(248, 2),    // 0b1000
        jmp16!(252, 2),    // 0b1001
        jmp16!(256, 2),    // 0b1010
        jmp16!(260, 2),    // 0b1011
        jmp16!(264, 2),    // 0b1100
        jmp16!(268, 2),    // 0b1101
        jmp16!(272, 2),    // 0b1110
        jmp16!(276, 2),    // 0b1111

        // 0b1111 ... (154 +16)
        jmp16!(280, 2),    // 0b0000
        jmp16!(284, 2),    // 0b0001
        jmp16!(288, 2),    // 0b0010
        jmp16!(292, 2),    // 0b0011
        jmp16!(296, 2),    // 0b0100
        jmp16!(300, 2),    // 0b0101
        jmp16!(304, 2),    // 0b0110
        jmp16!(308, 2),    // 0b0111
        jmp16!(312, 2),    // 0b1000
        jmp16!(316, 2),    // 0b1001
        jmp16!(320, 3),    // 0b1010
        jmp16!(328, 3),    // 0b1011
        jmp16!(336, 3),    // 0b1100
        jmp16!(344, 3),    // 0b1101
        jmp16!(352, 3),    // 0b1110
        jmp16!(360, 4),    // 0b1111

        // 0b1100 0111 ... (170 +2)
        val16!(0x8c, 1),    // 0b0
        val16!(0x11f, 1),    // 0b1

        // 0b1100 1000 ... (172 +2)
        val16!(0xdc, 1),    // 0b0
        val16!(0x19, 1),    // 0b1

        // 0b1100 1001 ... (174 +2)
        val16!(0x89, 1),    // 0b0
        val16!(0xfe, 1),    // 0b1

        // 0b1100 1010 ... (176 +2)
        val16!(0x5d, 1),    // 0b0
        val16!(0xed, 1),    // 0b1

        // 0b1100 1011 ... (178 +2)
        val16!(0x3c, 1),    // 0b0
        val16!(0x8d, 1),    // 0b1

        // 0b1100 1100 ... (180 +2)
        val16!(0x7e, 1),    // 0b0
        val16!(0x2b, 1),    // 0b1

        // 0b1100 1101 ... (182 +2)
        val16!(0x8e, 1),    // 0b0
        val16!(0x9b, 1),    // 0b1

        // 0b1100 1110 ... (184 +2)
        val16!(0x9c, 1),    // 0b0
        val16!(0x10f, 1),    // 0b1

        // 0b1100 1111 ... (186 +2)
        val16!(0x4d, 1),    // 0b0
        val16!(0x6e, 1),    // 0b1

        // 0b1101 0000 ... (188 +2)
        val16!(0x66, 1),    // 0b0
        val16!(0x9d, 1),    // 0b1

        // 0b1101 0001 ... (190 +2)
        val16!(0x5e, 1),    // 0b0
        val16!(0x8f, 1),    // 0b1

        // 0b1101 0010 ... (192 +2)
        val16!(0x7f, 1),    // 0b0
        val16!(0x1a, 1),    // 0b1

        // 0b1101 0011 ... (194 +2)
        val16!(0xad, 1),    // 0b0
        val16!(0x6, 1),    // 0b1

        // 0b1101 0100 ... (196 +2)
        val16!(0xac, 1),    // 0b0
        val16!(0x9a, 1),    // 0b1

        // 0b1101 0101 ... (198 +2)
        val16!(0x9e, 1),    // 0b0
        val16!(0x4e, 1),    // 0b1

        // 0b1101 0110 ... (200 +2)
        val16!(0x2c, 1),    // 0b0
        val16!(0x9f, 1),    // 0b1

        // 0b1101 0111 ... (202 +2)
        val16!(0x3d, 1),    // 0b0
        val16!(0x6f, 1),    // 0b1

        // 0b1101 1000 ... (204 +2)
        val16!(0xae, 1),    // 0b0
        val16!(0x90, 1),    // 0b1

        // 0b1101 1001 ... (206 +2)
        val16!(0xaf, 1),    // 0b0
        val16!(0xa0, 1),    // 0b1

        // 0b1101 1010 ... (208 +2)
        val16!(0xbe, 1),    // 0b0
        val16!(0x1b, 1),    // 0b1

        // 0b1101 1011 ... (210 +2)
        val16!(0x77, 1),    // 0b0
        val16!(0xb0, 1),    // 0b1

        // 0b1101 1100 ... (212 +2)
        val16!(0x80, 1),    // 0b0
        val16!(0x3e, 1),    // 0b1

        // 0b1101 1101 ... (214 +2)
        val16!(0x5f, 1),    // 0b0
        val16!(0xab, 1),    // 0b1

        // 0b1101 1110 ... (216 +2)
        val16!(0x4f, 1),    // 0b0
        val16!(0xbd, 1),    // 0b1

        // 0b1101 1111 ... (218 +2)
        val16!(0xdf, 1),    // 0b0
        val16!(0x70, 1),    // 0b1

        // 0b1110 0000 ... (220 +2)
        val16!(0xe0, 1),    // 0b0
        val16!(0x2d, 1),    // 0b1

        // 0b1110 0001 ... (222 +2)
        val16!(0x110, 1),    // 0b0
        val16!(0x60, 1),    // 0b1

        // 0b1110 0010 ... (224 +4)
        val16!(0xc0, 1),    // 0b00
        val16!(0xc0, 1),    // 0b01
        val16!(0xbf, 2),    // 0b10
        val16!(0xa1, 2),    // 0b11

        // 0b1110 0011 ... (228 +4)
        val16!(0x81, 2),    // 0b00
        val16!(0x91, 2),    // 0b01
        val16!(0x10, 2),    // 0b10
        val16!(0x51, 2),    // 0b11

        // 0b1110 0100 ... (232 +4)
        val16!(0x7, 2),    // 0b00
        val16!(0x40, 2),    // 0b01
        val16!(0xc1, 2),    // 0b10
        val16!(0xde, 2),    // 0b11

        // 0b1110 0101 ... (236 +4)
        val16!(0xe1, 2),    // 0b00
        val16!(0xcf, 2),    // 0b01
        val16!(0x2f, 2),    // 0b10
        val16!(0xe2, 2),    // 0b11

        // 0b1110 0110 ... (240 +4)
        val16!(0x92, 2),    // 0b00
        val16!(0x71, 2),    // 0b01
        val16!(0xb2, 2),    // 0b10
        val16!(0xb1, 2),    // 0b11

        // 0b1110 0111 ... (244 +4)
        val16!(0xf0, 2),    // 0b00
        val16!(0xd0, 2),    // 0b01
        val16!(0x1c, 2),    // 0b10
        val16!(0x50, 2),    // 0b11

        // 0b1110 1000 ... (248 +4)
        val16!(0xbc, 2),    // 0b00
        val16!(0x3f, 2),    // 0b01
        val16!(0x1e, 2),    // 0b10
        val16!(0xce, 2),    // 0b11

        // 0b1110 1001 ... (252 +4)
        val16!(0x82, 2),    // 0b00
        val16!(0x41, 2),    // 0b01
        val16!(0x61, 2),    // 0b10
        val16!(0x62, 2),    // 0b11

        // 0b1110 1010 ... (256 +4)
        val16!(0xf2, 2),    // 0b00
        val16!(0x52, 2),    // 0b01
        val16!(0xc2, 2),    // 0b10
        val16!(0xf1, 2),    // 0b11

        // 0b1110 1011 ... (260 +4)
        val16!(0xd1, 2),    // 0b00
        val16!(0xe3, 2),    // 0b01
        val16!(0xd2, 2),    // 0b10
        val16!(0x88, 2),    // 0b11

        // 0b1110 1100 ... (264 +4)
        val16!(0xc3, 2),    // 0b00
        val16!(0x2e, 2),    // 0b01
        val16!(0xa2, 2),    // 0b10
        val16!(0xf3, 2),    // 0b11

        // 0b1110 1101 ... (268 +4)
        val16!(0x73, 2),    // 0b00
        val16!(0xb4, 2),    // 0b01
        val16!(0x101, 2),    // 0b10
        val16!(0x93, 2),    // 0b11

        // 0b1110 1110 ... (272 +4)
        val16!(0xa3, 2),    // 0b00
        val16!(0xf4, 2),    // 0b01
        val16!(0xb3, 2),    // 0b10
        val16!(0x63, 2),    // 0b11

        // 0b1110 1111 ... (276 +4)
        val16!(0xc4, 2),    // 0b00
        val16!(0xef, 2),    // 0b01
        val16!(0x30, 2),    // 0b10
        val16!(0x72, 2),    // 0b11

        // 0b1111 0000 ... (280 +4)
        val16!(0x1d, 2),    // 0b00
        val16!(0xe5, 2),    // 0b01
        val16!(0x8, 2),    // 0b10
        val16!(0xe4, 2),    // 0b11

        // 0b1111 0001 ... (284 +4)
        val16!(0x83, 2),    // 0b00
        val16!(0xd3, 2),    // 0b01
        val16!(0x84, 2),    // 0b10
        val16!(0x102, 2),    // 0b11

        // 0b1111 0010 ... (288 +4)
        val16!(0xcd, 2),    // 0b00
        val16!(0x74, 2),    // 0b01
        val16!(0x31, 2),    // 0b10
        val16!(0x104, 2),    // 0b11

        // 0b1111 0011 ... (292 +4)
        val16!(0x103, 2),    // 0b00
        val16!(0x1f, 2),    // 0b01
        val16!(0xa4, 2),    // 0b10
        val16!(0x53, 2),    // 0b11

        // 0b1111 0100 ... (296 +4)
        val16!(0xf5, 2),    // 0b00
        val16!(0x95, 2),    // 0b01
        val16!(0xe6, 2),    // 0b10
        val16!(0x94, 2),    // 0b11

        // 0b1111 0101 ... (300 +4)
        val16!(0x64, 2),    // 0b00
        val16!(0x42, 2),    // 0b01
        val16!(0xb5, 2),    // 0b10
        val16!(0xc5, 2),    // 0b11

        // 0b1111 0110 ... (304 +4)
        val16!(0xd4, 2),    // 0b00
        val16!(0x105, 2),    // 0b01
        val16!(0x106, 2),    // 0b10
        val16!(0x96, 2),    // 0b11

        // 0b1111 0111 ... (308 +4)
        val16!(0x100, 2),    // 0b00
        val16!(0x85, 2),    // 0b01
        val16!(0x99, 2),    // 0b10
        val16!(0x9, 2),    // 0b11

        // 0b1111 1000 ... (312 +4)
        val16!(0xa6, 2),    // 0b00
        val16!(0xa5, 2),    // 0b01
        val16!(0xd5, 2),    // 0b10
        val16!(0xf6, 2),    // 0b11

        // 0b1111 1001 ... (316 +4)
        val16!(0xb7, 2),    // 0b00
        val16!(0xf7, 2),    // 0b01
        val16!(0xd6, 2),    // 0b10
        val16!(0x75, 2),    // 0b11

        // 0b1111 1010 ... (320 +8)
        val16!(0x86, 2),    // 0b000
        val16!(0x86, 2),    // 0b001
        val16!(0xa7, 3),    // 0b010
        val16!(0x107, 3),    // 0b011
        val16!(0xc6, 3),    // 0b100
        val16!(0xc9, 3),    // 0b101
        val16!(0x20, 3),    // 0b110
        val16!(0xb6, 3),    // 0b111

        // 0b1111 1011 ... (328 +8)
        val16!(0xb8, 3),    // 0b000
        val16!(0xe8, 3),    // 0b001
        val16!(0xe7, 3),    // 0b010
        val16!(0xc8, 3),    // 0b011
        val16!(0xc7, 3),    // 0b100
        val16!(0x97, 3),    // 0b101
        val16!(0xf9, 3),    // 0b110
        val16!(0xe9, 3),    // 0b111

        // 0b1111 1100 ... (336 +8)
        val16!(0xd9, 3),    // 0b000
        val16!(0x108, 3),    // 0b001
        val16!(0xf8, 3),    // 0b010
        val16!(0xaa, 3),    // 0b011
        val16!(0xd7, 3),    // 0b100
        val16!(0xa8, 3),    // 0b101
        val16!(0xa, 3),    // 0b110
        val16!(0xd8, 3),    // 0b111

        // 0b1111 1101 ... (344 +8)
        val16!(0xbb, 3),    // 0b000
        val16!(0xda, 3),    // 0b001
        val16!(0xb9, 3),    // 0b010
        val16!(0xea, 3),    // 0b011
        val16!(0xd, 3),    // 0b100
        val16!(0xfa, 3),    // 0b101
        val16!(0x109, 3),    // 0b110
        val16!(0x10a, 3),    // 0b111

        // 0b1111 1110 ... (352 +8)
        val16!(0xca, 3),    // 0b000
        val16!(0xfb, 3),    // 0b001
        val16!(0xdd, 3),    // 0b010
        val16!(0xb, 3),    // 0b011
        val16!(0xeb, 3),    // 0b100
        val16!(0x10b, 3),    // 0b101
        val16!(0x10c, 3),    // 0b110
        val16!(0xdb, 3),    // 0b111

        // 0b1111 1111 ... (360 +16)
        val16!(0xee, 3),    // 0b0000
        val16!(0xee, 3),    // 0b0001
        val16!(0xfc, 3),    // 0b0010
        val16!(0xfc, 3),    // 0b0011
        val16!(0xec, 3),    // 0b0100
        val16!(0xec, 3),    // 0b0101
        val16!(0xcc, 3),    // 0b0110
        val16!(0xcc, 3),    // 0b0111
        val16!(0xfd, 3),    // 0b1000
        val16!(0xfd, 3),    // 0b1001
        val16!(0xe, 4),    // 0b1010
        val16!(0xc, 4),    // 0b1011
        val16!(0x10d, 4),    // 0b1100
        val16!(0xff, 4),    // 0b1101
        val16!(0xf, 4),    // 0b1110
        val16!(0x10e, 4),    // 0b1111
    ],
    n_init_bits: 4,
    n_table_bits: 12,
};

pub const SCF_TABLE: HuffmanTable<H8> = HuffmanTable {
    data: &[
        // 0b ... (0 +16)
        val8!(0x3c, 1),    // 0b0000
        val8!(0x3c, 1),    // 0b0001
        val8!(0x3c, 1),    // 0b0010
        val8!(0x3c, 1),    // 0b0011
        val8!(0x3c, 1),    // 0b0100
        val8!(0x3c, 1),    // 0b0101
        val8!(0x3c, 1),    // 0b0110
        val8!(0x3c, 1),    // 0b0111
        val8!(0x3b, 3),    // 0b1000
        val8!(0x3b, 3),    // 0b1001
        val8!(0x3d, 4),    // 0b1010
        val8!(0x3a, 4),    // 0b1011
        val8!(0x3e, 4),    // 0b1100
        jmp8!(16, 1),    // 0b1101
        jmp8!(18, 2),    // 0b1110
        jmp8!(22, 4),    // 0b1111

        // 0b1101 ... (16 +2)
        val8!(0x39, 1),    // 0b0
        val8!(0x3f, 1),    // 0b1

        // 0b1110 ... (18 +4)
        val8!(0x38, 2),    // 0b00
        val8!(0x40, 2),    // 0b01
        val8!(0x37, 2),    // 0b10
        val8!(0x41, 2),    // 0b11

        // 0b1111 ... (22 +16)
        val8!(0x42, 3),    // 0b0000
        val8!(0x42, 3),    // 0b0001
        val8!(0x36, 3),    // 0b0010
        val8!(0x36, 3),    // 0b0011
        val8!(0x43, 3),    // 0b0100
        val8!(0x43, 3),    // 0b0101
        val8!(0x35, 4),    // 0b0110
        val8!(0x44, 4),    // 0b0111
        val8!(0x34, 4),    // 0b1000
        val8!(0x45, 4),    // 0b1001
        val8!(0x33, 4),    // 0b1010
        jmp8!(38, 1),    // 0b1011
        jmp8!(40, 1),    // 0b1100
        jmp8!(42, 2),    // 0b1101
        jmp8!(46, 3),    // 0b1110
        jmp8!(54, 4),    // 0b1111

        // 0b1111 1011 ... (38 +2)
        val8!(0x46, 1),    // 0b0
        val8!(0x32, 1),    // 0b1

        // 0b1111 1100 ... (40 +2)
        val8!(0x31, 1),    // 0b0
        val8!(0x47, 1),    // 0b1

        // 0b1111 1101 ... (42 +4)
        val8!(0x48, 2),    // 0b00
        val8!(0x30, 2),    // 0b01
        val8!(0x49, 2),    // 0b10
        val8!(0x2f, 2),    // 0b11

        // 0b1111 1110 ... (46 +8)
        val8!(0x4a, 2),    // 0b000
        val8!(0x4a, 2),    // 0b001
        val8!(0x2e, 2),    // 0b010
        val8!(0x2e, 2),    // 0b011
        val8!(0x4c, 3),    // 0b100
        val8!(0x4b, 3),    // 0b101
        val8!(0x4d, 3),    // 0b110
        val8!(0x4e, 3),    // 0b111

        // 0b1111 1111 ... (54 +16)
        val8!(0x2d, 3),    // 0b0000
        val8!(0x2d, 3),    // 0b0001
        val8!(0x2b, 3),    // 0b0010
        val8!(0x2b, 3),    // 0b0011
        val8!(0x2c, 4),    // 0b0100
        val8!(0x4f, 4),    // 0b0101
        val8!(0x2a, 4),    // 0b0110
        val8!(0x29, 4),    // 0b0111
        val8!(0x50, 4),    // 0b1000
        val8!(0x28, 4),    // 0b1001
        jmp8!(70, 1),    // 0b1010
        jmp8!(72, 1),    // 0b1011
        jmp8!(74, 2),    // 0b1100
        jmp8!(78, 2),    // 0b1101
        jmp8!(82, 3),    // 0b1110
        jmp8!(90, 4),    // 0b1111

        // 0b1111 1111 1010 ... (70 +2)
        val8!(0x51, 1),    // 0b0
        val8!(0x27, 1),    // 0b1

        // 0b1111 1111 1011 ... (72 +2)
        val8!(0x52, 1),    // 0b0
        val8!(0x26, 1),    // 0b1

        // 0b1111 1111 1100 ... (74 +4)
        val8!(0x53, 1),    // 0b00
        val8!(0x53, 1),    // 0b01
        val8!(0x25, 2),    // 0b10
        val8!(0x23, 2),    // 0b11

        // 0b1111 1111 1101 ... (78 +4)
        val8!(0x55, 2),    // 0b00
        val8!(0x21, 2),    // 0b01
        val8!(0x24, 2),    // 0b10
        val8!(0x22, 2),    // 0b11

        // 0b1111 1111 1110 ... (82 +8)
        val8!(0x54, 2),    // 0b000
        val8!(0x54, 2),    // 0b001
        val8!(0x20, 2),    // 0b010
        val8!(0x20, 2),    // 0b011
        val8!(0x57, 3),    // 0b100
        val8!(0x59, 3),    // 0b101
        val8!(0x1e, 3),    // 0b110
        val8!(0x1f, 3),    // 0b111

        // 0b1111 1111 1111 ... (90 +16)
        val8!(0x56, 4),    // 0b0000
        val8!(0x1d, 4),    // 0b0001
        val8!(0x1a, 4),    // 0b0010
        val8!(0x1b, 4),    // 0b0011
        val8!(0x1c, 4),    // 0b0100
        val8!(0x18, 4),    // 0b0101
        val8!(0x58, 4),    // 0b0110
        jmp8!(106, 1),    // 0b0111
        jmp8!(108, 2),    // 0b1000
        jmp8!(112, 2),    // 0b1001
        jmp8!(116, 3),    // 0b1010
        jmp8!(124, 3),    // 0b1011
        jmp8!(132, 3),    // 0b1100
        jmp8!(140, 3),    // 0b1101
        jmp8!(148, 3),    // 0b1110
        jmp8!(156, 3),    // 0b1111

        // 0b1111 1111 1111 0111 ... (106 +2)
        val8!(0x19, 1),    // 0b0
        val8!(0x16, 1),    // 0b1

        // 0b1111 1111 1111 1000 ... (108 +4)
        val8!(0x17, 1),    // 0b00
        val8!(0x17, 1),    // 0b01
        val8!(0x5a, 2),    // 0b10
        val8!(0x15, 2),    // 0b11

        // 0b1111 1111 1111 1001 ... (112 +4)
        val8!(0x13, 2),    // 0b00
        val8!(0x3, 2),    // 0b01
        val8!(0x1, 2),    // 0b10
        val8!(0x2, 2),    // 0b11

        // 0b1111 1111 1111 1010 ... (116 +8)
        val8!(0x0, 2),    // 0b000
        val8!(0x0, 2),    // 0b001
        val8!(0x62, 3),    // 0b010
        val8!(0x63, 3),    // 0b011
        val8!(0x64, 3),    // 0b100
        val8!(0x65, 3),    // 0b101
        val8!(0x66, 3),    // 0b110
        val8!(0x75, 3),    // 0b111

        // 0b1111 1111 1111 1011 ... (124 +8)
        val8!(0x61, 3),    // 0b000
        val8!(0x5b, 3),    // 0b001
        val8!(0x5c, 3),    // 0b010
        val8!(0x5d, 3),    // 0b011
        val8!(0x5e, 3),    // 0b100
        val8!(0x5f, 3),    // 0b101
        val8!(0x60, 3),    // 0b110
        val8!(0x68, 3),    // 0b111

        // 0b1111 1111 1111 1100 ... (132 +8)
        val8!(0x6f, 3),    // 0b000
        val8!(0x70, 3),    // 0b001
        val8!(0x71, 3),    // 0b010
        val8!(0x72, 3),    // 0b011
        val8!(0x73, 3),    // 0b100
        val8!(0x74, 3),    // 0b101
        val8!(0x6e, 3),    // 0b110
        val8!(0x69, 3),    // 0b111

        // 0b1111 1111 1111 1101 ... (140 +8)
        val8!(0x6a, 3),    // 0b000
        val8!(0x6b, 3),    // 0b001
        val8!(0x6c, 3),    // 0b010
        val8!(0x6d, 3),    // 0b011
        val8!(0x76, 3),    // 0b100
        val8!(0x6, 3),    // 0b101
        val8!(0x8, 3),    // 0b110
        val8!(0x9, 3),    // 0b111

        // 0b1111 1111 1111 1110 ... (148 +8)
        val8!(0xa, 3),    // 0b000
        val8!(0x5, 3),    // 0b001
        val8!(0x67, 3),    // 0b010
        val8!(0x78, 3),    // 0b011
        val8!(0x77, 3),    // 0b100
        val8!(0x4, 3),    // 0b101
        val8!(0x7, 3),    // 0b110
        val8!(0xf, 3),    // 0b111

        // 0b1111 1111 1111 1111 ... (156 +8)
        val8!(0x10, 3),    // 0b000
        val8!(0x12, 3),    // 0b001
        val8!(0x14, 3),    // 0b010
        val8!(0x11, 3),    // 0b011
        val8!(0xb, 3),    // 0b100
        val8!(0xc, 3),    // 0b101
        val8!(0xe, 3),    // 0b110
        val8!(0xd, 3),    // 0b111
    ],
    n_init_bits: 4,
    n_table_bits: 19,
};
