# Syllogism

Utilities to allow for some specialization using stable Rust.

Specialization is a 
[feature for the rust programming language that is being developed](https://github.com/rust-lang/rust/issues/31844)
and it's mentioned in the [2019 roadmap](https://blog.rust-lang.org/2019/04/23/roadmap.html).
This crate is meant to be used in a transition period when specialization is not yet available
in stable Rust.

This crate provides two techniques for specialization:
* Using the `IsNot` trait. This can be used when the data-type that you want to specialize for
  is a concrete type.
* Using the `Specialize` trait. This can be used when the data-type that you want to specialize
  for is a type parameter.

Both techniques require a huge amount of boilerplate. We are developing another crate that has
some procedural macros that can generate this boilerplate for you.

Note that this crate can only be used for certain types of specialization, see the examples below.

Examples
--------
Using the `IsNot` trait:

```rust
// One special implementation:
impl GenericTrait<SpecialDataType1> for MyStruct {
    // ...
}
// Another special implementation:
impl GenericTrait<SpecialDataType2> for MyStruct {
    // ...
}
// The generic implementation.
impl<T> GenericTrait<T> for MyStruct
where T: IsNot<SpecialDataType1> + IsNot<SpecialDataType2>{
    // ...
}
```

Using the `Specialize` trait:

```rust
impl<T> GenericTrait<T> for MyStruct<T>
where T: Specialize<SpecialDataType> {
    fn some_method(&self, param: T) {
        match param.specialize() {
            Distinction::Special(special) => {
                // The special implementation.
            },
            Distinction::Generic(generic) => {
                // The generic implementation.
            }
        }
    }
}
```

Contributing
------------

We welcome contributions, both in the form of issues and in the form of merge requests.
Before opening a merge request, please open an issue first so that you know whether a subsequent
merge request would likely be approved.


License
-------

This crate is distributed under the terms of the MIT license or the Apache License (Version 2.0),
at your choice.
For the application of the MIT license, the examples included in the doc comments are not
considered "substatial portions of this Software".
