// Automatically generated rust module for 'job_schemas.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use core::convert::TryFrom;
use core::ops::Deref;
use core::ops::DerefMut;
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct OracleJob {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for OracleJob {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for OracleJob {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_OracleJob {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct HttpTask {
    pub url: String,
    pub method: mod_OracleJob::mod_HttpTask::Method,
    pub headers: Vec<mod_OracleJob::mod_HttpTask::Header>,
    pub stringified_body: String,
}

impl<'a> MessageRead<'a> for HttpTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.url = r.read_string(bytes)?.to_owned(),
                Ok(16) => msg.method = r.read_enum(bytes)?,
                Ok(26) => msg.headers.push(r.read_message::<mod_OracleJob::mod_HttpTask::Header>(bytes)?),
                Ok(34) => msg.stringified_body = r.read_string(bytes)?.to_owned(),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for HttpTask {
    fn get_size(&self) -> usize {
        0
        + if self.url == String::default() { 0 } else { 1 + sizeof_len((&self.url).len()) }
        + if self.method == job_schemas::mod_OracleJob::mod_HttpTask::Method::METHOD_UNKOWN { 0 } else { 1 + sizeof_varint(*(&self.method) as u64) }
        + self.headers.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
        + if self.stringified_body == String::default() { 0 } else { 1 + sizeof_len((&self.stringified_body).len()) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.url != String::default() { w.write_with_tag(10, |w| w.write_string(&**&self.url))?; }
        if self.method != job_schemas::mod_OracleJob::mod_HttpTask::Method::METHOD_UNKOWN { w.write_with_tag(16, |w| w.write_enum(*&self.method as i32))?; }
        for s in &self.headers { w.write_with_tag(26, |w| w.write_message(s))?; }
        if self.stringified_body != String::default() { w.write_with_tag(34, |w| w.write_string(&**&self.stringified_body))?; }
        Ok(())
    }
}

pub mod mod_HttpTask {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Header {
    pub key: String,
    pub value: String,
}

impl<'a> MessageRead<'a> for Header {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.key = r.read_string(bytes)?.to_owned(),
                Ok(18) => msg.value = r.read_string(bytes)?.to_owned(),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Header {
    fn get_size(&self) -> usize {
        0
        + if self.key == String::default() { 0 } else { 1 + sizeof_len((&self.key).len()) }
        + if self.value == String::default() { 0 } else { 1 + sizeof_len((&self.value).len()) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.key != String::default() { w.write_with_tag(10, |w| w.write_string(&**&self.key))?; }
        if self.value != String::default() { w.write_with_tag(18, |w| w.write_string(&**&self.value))?; }
        Ok(())
    }
}

#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub enum Method {
    METHOD_UNKOWN = 0,
    METHOD_GET = 1,
    METHOD_POST = 2,
}

impl Default for Method {
    fn default() -> Self {
        Method::METHOD_UNKOWN
    }
}

impl From<i32> for Method {
    fn from(i: i32) -> Self {
        match i {
            0 => Method::METHOD_UNKOWN,
            1 => Method::METHOD_GET,
            2 => Method::METHOD_POST,
            _ => Self::default(),
        }
    }
}

impl<'a> From<&'a str> for Method {
    fn from(s: &'a str) -> Self {
        match s {
            "METHOD_UNKOWN" => Method::METHOD_UNKOWN,
            "METHOD_GET" => Method::METHOD_GET,
            "METHOD_POST" => Method::METHOD_POST,
            _ => Self::default(),
        }
    }
}

}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JsonParseTask {
    pub path: Vec<String>,
}

impl<'a> MessageRead<'a> for JsonParseTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.path.push(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JsonParseTask {
    fn get_size(&self) -> usize {
        0
        + self.path.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.path { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct ArrayIndexTask {
    pub index: i32,
}

impl<'a> MessageRead<'a> for ArrayIndexTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.index = r.read_int32(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for ArrayIndexTask {
    fn get_size(&self) -> usize {
        0
        + if self.index == 0i32 { 0 } else { 1 + sizeof_varint(*(&self.index) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if self.index != 0i32 { w.write_with_tag(8, |w| w.write_int32(*&self.index))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct MedianTask {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for MedianTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for MedianTask {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct MeanTask {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for MeanTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for MeanTask {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Task {
    pub Task: mod_OracleJob::mod_Task::OneOfTask,
}

impl<'a> MessageRead<'a> for Task {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::http_task(r.read_message::<mod_OracleJob::HttpTask>(bytes)?),
                Ok(18) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::json_parse_task(r.read_message::<mod_OracleJob::JsonParseTask>(bytes)?),
                Ok(26) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::array_index_task(r.read_message::<mod_OracleJob::ArrayIndexTask>(bytes)?),
                Ok(34) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::median_task(r.read_message::<mod_OracleJob::MedianTask>(bytes)?),
                Ok(42) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::mean_task(r.read_message::<mod_OracleJob::MeanTask>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Task {
    fn get_size(&self) -> usize {
        0
        + match self.Task {
            mod_OracleJob::mod_Task::OneOfTask::http_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::json_parse_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::array_index_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::median_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::mean_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::None => 0,
    }    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        match self.Task {            mod_OracleJob::mod_Task::OneOfTask::http_task(ref m) => { w.write_with_tag(10, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::json_parse_task(ref m) => { w.write_with_tag(18, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::array_index_task(ref m) => { w.write_with_tag(26, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::median_task(ref m) => { w.write_with_tag(34, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::mean_task(ref m) => { w.write_with_tag(42, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::None => {},
    }        Ok(())
    }
}

pub mod mod_Task {

use super::*;

#[derive(Debug, PartialEq, Clone)]
pub enum OneOfTask {
    http_task(mod_OracleJob::HttpTask),
    json_parse_task(mod_OracleJob::JsonParseTask),
    array_index_task(mod_OracleJob::ArrayIndexTask),
    median_task(mod_OracleJob::MedianTask),
    mean_task(mod_OracleJob::MeanTask),
    None,
}

impl Default for OneOfTask {
    fn default() -> Self {
        OneOfTask::None
    }
}

}

}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JobPosting {
    pub aggregator_state_pubkey: Vec<u8>,
    pub node_pubkeys: Vec<Vec<u8>>,
}

impl<'a> MessageRead<'a> for JobPosting {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.aggregator_state_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(18) => msg.node_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JobPosting {
    fn get_size(&self) -> usize {
        0
        + if self.aggregator_state_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.aggregator_state_pubkey).len()) }
        + self.node_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if !self.aggregator_state_pubkey.is_empty() { w.write_with_tag(10, |w| w.write_bytes(&**&self.aggregator_state_pubkey))?; }
        for s in &self.node_pubkeys { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JobResult {
    pub job_pubkey: Vec<u8>,
    pub node_pubkey: Vec<u8>,
    pub result: f64,
    pub error: bool,
    pub slot: u64,
    pub timestamp: i64,
}

impl<'a> MessageRead<'a> for JobResult {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.job_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(18) => msg.node_pubkey = r.read_bytes(bytes)?.to_owned(),
                Ok(25) => msg.result = r.read_double(bytes)?,
                Ok(32) => msg.error = r.read_bool(bytes)?,
                Ok(40) => msg.slot = r.read_uint64(bytes)?,
                Ok(48) => msg.timestamp = r.read_int64(bytes)?,
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JobResult {
    fn get_size(&self) -> usize {
        0
        + if self.job_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.job_pubkey).len()) }
        + if self.node_pubkey.is_empty() { 0 } else { 1 + sizeof_len((&self.node_pubkey).len()) }
        + if self.result == 0f64 { 0 } else { 1 + 8 }
        + if self.error == false { 0 } else { 1 + sizeof_varint(*(&self.error) as u64) }
        + if self.slot == 0u64 { 0 } else { 1 + sizeof_varint(*(&self.slot) as u64) }
        + if self.timestamp == 0i64 { 0 } else { 1 + sizeof_varint(*(&self.timestamp) as u64) }
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if !self.job_pubkey.is_empty() { w.write_with_tag(10, |w| w.write_bytes(&**&self.job_pubkey))?; }
        if !self.node_pubkey.is_empty() { w.write_with_tag(18, |w| w.write_bytes(&**&self.node_pubkey))?; }
        if self.result != 0f64 { w.write_with_tag(25, |w| w.write_double(*&self.result))?; }
        if self.error != false { w.write_with_tag(32, |w| w.write_bool(*&self.error))?; }
        if self.slot != 0u64 { w.write_with_tag(40, |w| w.write_uint64(*&self.slot))?; }
        if self.timestamp != 0i64 { w.write_with_tag(48, |w| w.write_int64(*&self.timestamp))?; }
        Ok(())
    }
}

