// Automatically generated rust module for 'bundle.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct BundleAuth {
    pub version: Option<u32>,
    pub aggregator_address: Option<Vec<u8>>,
    pub bundle_address: Option<Vec<u8>>,
    pub idx: Option<i32>,
}

impl<'a> MessageRead<'a> for BundleAuth {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.version = Some(r.read_uint32(bytes)?),
                Ok(18) => msg.aggregator_address = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(26) => msg.bundle_address = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(32) => msg.idx = Some(r.read_int32(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for BundleAuth {
    fn get_size(&self) -> usize {
        0
        + self.version.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.aggregator_address.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.bundle_address.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.idx.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.version { w.write_with_tag(8, |w| w.write_uint32(*s))?; }
        if let Some(ref s) = self.aggregator_address { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.bundle_address { w.write_with_tag(26, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.idx { w.write_with_tag(32, |w| w.write_int32(*s))?; }
        Ok(())
    }
}

