// Automatically generated rust module for 'aggregator_state.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct FulfillmentAgreement {
    pub node_pubkeys: Vec<Vec<u8>>,
    pub requested: Option<bool>,
}

impl<'a> MessageRead<'a> for FulfillmentAgreement {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.node_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(24) => msg.requested = Some(r.read_bool(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for FulfillmentAgreement {
    fn get_size(&self) -> usize {
        0
        + self.node_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
        + self.requested.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.node_pubkeys { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.requested { w.write_with_tag(24, |w| w.write_bool(*s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct RoundResult {
    pub num_success: Option<i32>,
    pub num_error: Option<i32>,
    pub result: Option<f64>,
    pub round_open_slot: Option<u64>,
    pub round_open_timestamp: Option<i64>,
    pub min_response: Option<f64>,
    pub max_response: Option<f64>,
    pub medians: Vec<f64>,
}

impl<'a> MessageRead<'a> for RoundResult {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.num_success = Some(r.read_int32(bytes)?),
                Ok(16) => msg.num_error = Some(r.read_int32(bytes)?),
                Ok(25) => msg.result = Some(r.read_double(bytes)?),
                Ok(32) => msg.round_open_slot = Some(r.read_uint64(bytes)?),
                Ok(40) => msg.round_open_timestamp = Some(r.read_int64(bytes)?),
                Ok(49) => msg.min_response = Some(r.read_double(bytes)?),
                Ok(57) => msg.max_response = Some(r.read_double(bytes)?),
                Ok(65) => msg.medians.push(r.read_double(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for RoundResult {
    fn get_size(&self) -> usize {
        0
        + self.num_success.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.num_error.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.result.as_ref().map_or(0, |_| 1 + 8)
        + self.round_open_slot.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.round_open_timestamp.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.min_response.as_ref().map_or(0, |_| 1 + 8)
        + self.max_response.as_ref().map_or(0, |_| 1 + 8)
        + (1 + 8) * self.medians.len()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.num_success { w.write_with_tag(8, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.num_error { w.write_with_tag(16, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.result { w.write_with_tag(25, |w| w.write_double(*s))?; }
        if let Some(ref s) = self.round_open_slot { w.write_with_tag(32, |w| w.write_uint64(*s))?; }
        if let Some(ref s) = self.round_open_timestamp { w.write_with_tag(40, |w| w.write_int64(*s))?; }
        if let Some(ref s) = self.min_response { w.write_with_tag(49, |w| w.write_double(*s))?; }
        if let Some(ref s) = self.max_response { w.write_with_tag(57, |w| w.write_double(*s))?; }
        for s in &self.medians { w.write_with_tag(65, |w| w.write_double(*s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct AggregatorState {
    pub version: Option<u32>,
    pub configs: Option<mod_AggregatorState::Configs>,
    pub fulfillment_manager_pubkey: Option<Vec<u8>>,
    pub job_definition_pubkeys: Vec<Vec<u8>>,
    pub agreement: Option<FulfillmentAgreement>,
    pub current_round_result: Option<RoundResult>,
    pub last_round_result: Option<RoundResult>,
}

impl<'a> MessageRead<'a> for AggregatorState {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.version = Some(r.read_uint32(bytes)?),
                Ok(18) => msg.configs = Some(r.read_message::<mod_AggregatorState::Configs>(bytes)?),
                Ok(26) => msg.fulfillment_manager_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(34) => msg.job_definition_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(42) => msg.agreement = Some(r.read_message::<FulfillmentAgreement>(bytes)?),
                Ok(50) => msg.current_round_result = Some(r.read_message::<RoundResult>(bytes)?),
                Ok(58) => msg.last_round_result = Some(r.read_message::<RoundResult>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for AggregatorState {
    fn get_size(&self) -> usize {
        0
        + self.version.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.configs.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.fulfillment_manager_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.job_definition_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
        + self.agreement.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.current_round_result.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
        + self.last_round_result.as_ref().map_or(0, |m| 1 + sizeof_len((m).get_size()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.version { w.write_with_tag(8, |w| w.write_uint32(*s))?; }
        if let Some(ref s) = self.configs { w.write_with_tag(18, |w| w.write_message(s))?; }
        if let Some(ref s) = self.fulfillment_manager_pubkey { w.write_with_tag(26, |w| w.write_bytes(&**s))?; }
        for s in &self.job_definition_pubkeys { w.write_with_tag(34, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.agreement { w.write_with_tag(42, |w| w.write_message(s))?; }
        if let Some(ref s) = self.current_round_result { w.write_with_tag(50, |w| w.write_message(s))?; }
        if let Some(ref s) = self.last_round_result { w.write_with_tag(58, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_AggregatorState {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Configs {
    pub locked: Option<bool>,
    pub min_confirmations: Option<i32>,
    pub min_update_delay_seconds: Option<i64>,
}

impl<'a> MessageRead<'a> for Configs {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(8) => msg.locked = Some(r.read_bool(bytes)?),
                Ok(16) => msg.min_confirmations = Some(r.read_int32(bytes)?),
                Ok(24) => msg.min_update_delay_seconds = Some(r.read_int64(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Configs {
    fn get_size(&self) -> usize {
        0
        + self.locked.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.min_confirmations.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.min_update_delay_seconds.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.locked { w.write_with_tag(8, |w| w.write_bool(*s))?; }
        if let Some(ref s) = self.min_confirmations { w.write_with_tag(16, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.min_update_delay_seconds { w.write_with_tag(24, |w| w.write_int64(*s))?; }
        Ok(())
    }
}

}

