// Automatically generated rust module for 'job_schemas.proto' file

#![allow(non_snake_case)]
#![allow(non_upper_case_globals)]
#![allow(non_camel_case_types)]
#![allow(unused_imports)]
#![allow(unknown_lints)]
#![allow(clippy::all)]
#![cfg_attr(rustfmt, rustfmt_skip)]


use quick_protobuf::{MessageRead, MessageWrite, BytesReader, Writer, WriterBackend, Result};
use quick_protobuf::sizeofs::*;
use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct OracleJob {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for OracleJob {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for OracleJob {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

pub mod mod_OracleJob {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct HttpTask {
    pub url: Option<String>,
    pub method: Option<mod_OracleJob::mod_HttpTask::Method>,
    pub headers: Vec<mod_OracleJob::mod_HttpTask::Header>,
    pub body: Option<String>,
}

impl<'a> MessageRead<'a> for HttpTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.url = Some(r.read_string(bytes)?.to_owned()),
                Ok(16) => msg.method = Some(r.read_enum(bytes)?),
                Ok(26) => msg.headers.push(r.read_message::<mod_OracleJob::mod_HttpTask::Header>(bytes)?),
                Ok(34) => msg.body = Some(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for HttpTask {
    fn get_size(&self) -> usize {
        0
        + self.url.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.method.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.headers.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
        + self.body.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.url { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        if let Some(ref s) = self.method { w.write_with_tag(16, |w| w.write_enum(*s as i32))?; }
        for s in &self.headers { w.write_with_tag(26, |w| w.write_message(s))?; }
        if let Some(ref s) = self.body { w.write_with_tag(34, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

pub mod mod_HttpTask {

use super::*;

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Header {
    pub key: Option<String>,
    pub value: Option<String>,
}

impl<'a> MessageRead<'a> for Header {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.key = Some(r.read_string(bytes)?.to_owned()),
                Ok(18) => msg.value = Some(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Header {
    fn get_size(&self) -> usize {
        0
        + self.key.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.value.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.key { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        if let Some(ref s) = self.value { w.write_with_tag(18, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, PartialEq, Eq, Clone, Copy)]
pub enum Method {
    METHOD_UNKOWN = 0,
    METHOD_GET = 1,
    METHOD_POST = 2,
}

impl Default for Method {
    fn default() -> Self {
        Method::METHOD_UNKOWN
    }
}

impl From<i32> for Method {
    fn from(i: i32) -> Self {
        match i {
            0 => Method::METHOD_UNKOWN,
            1 => Method::METHOD_GET,
            2 => Method::METHOD_POST,
            _ => Self::default(),
        }
    }
}

impl<'a> From<&'a str> for Method {
    fn from(s: &'a str) -> Self {
        match s {
            "METHOD_UNKOWN" => Method::METHOD_UNKOWN,
            "METHOD_GET" => Method::METHOD_GET,
            "METHOD_POST" => Method::METHOD_POST,
            _ => Self::default(),
        }
    }
}

}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JsonParseTask {
    pub path: Option<String>,
}

impl<'a> MessageRead<'a> for JsonParseTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.path = Some(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JsonParseTask {
    fn get_size(&self) -> usize {
        0
        + self.path.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.path { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct MedianTask {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for MedianTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for MedianTask {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct MeanTask {
    pub tasks: Vec<mod_OracleJob::Task>,
}

impl<'a> MessageRead<'a> for MeanTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.tasks.push(r.read_message::<mod_OracleJob::Task>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for MeanTask {
    fn get_size(&self) -> usize {
        0
        + self.tasks.iter().map(|s| 1 + sizeof_len((s).get_size())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        for s in &self.tasks { w.write_with_tag(10, |w| w.write_message(s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct WebsocketTask {
    pub url: Option<String>,
    pub subscription: Option<String>,
    pub max_data_age_seconds: Option<i32>,
    pub filter: Option<String>,
}

impl<'a> MessageRead<'a> for WebsocketTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.url = Some(r.read_string(bytes)?.to_owned()),
                Ok(18) => msg.subscription = Some(r.read_string(bytes)?.to_owned()),
                Ok(24) => msg.max_data_age_seconds = Some(r.read_int32(bytes)?),
                Ok(34) => msg.filter = Some(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for WebsocketTask {
    fn get_size(&self) -> usize {
        0
        + self.url.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.subscription.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.max_data_age_seconds.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.filter.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.url { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        if let Some(ref s) = self.subscription { w.write_with_tag(18, |w| w.write_string(&**s))?; }
        if let Some(ref s) = self.max_data_age_seconds { w.write_with_tag(24, |w| w.write_int32(*s))?; }
        if let Some(ref s) = self.filter { w.write_with_tag(34, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct CcxtWsTask {
    pub exchange: Option<String>,
    pub pair: Option<String>,
}

impl<'a> MessageRead<'a> for CcxtWsTask {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.exchange = Some(r.read_string(bytes)?.to_owned()),
                Ok(18) => msg.pair = Some(r.read_string(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for CcxtWsTask {
    fn get_size(&self) -> usize {
        0
        + self.exchange.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.pair.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.exchange { w.write_with_tag(10, |w| w.write_string(&**s))?; }
        if let Some(ref s) = self.pair { w.write_with_tag(18, |w| w.write_string(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct Task {
    pub Task: mod_OracleJob::mod_Task::OneOfTask,
}

impl<'a> MessageRead<'a> for Task {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::http_task(r.read_message::<mod_OracleJob::HttpTask>(bytes)?),
                Ok(18) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::json_parse_task(r.read_message::<mod_OracleJob::JsonParseTask>(bytes)?),
                Ok(34) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::median_task(r.read_message::<mod_OracleJob::MedianTask>(bytes)?),
                Ok(42) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::mean_task(r.read_message::<mod_OracleJob::MeanTask>(bytes)?),
                Ok(50) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::websocket_task(r.read_message::<mod_OracleJob::WebsocketTask>(bytes)?),
                Ok(58) => msg.Task = mod_OracleJob::mod_Task::OneOfTask::ccxt_ws_task(r.read_message::<mod_OracleJob::CcxtWsTask>(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for Task {
    fn get_size(&self) -> usize {
        0
        + match self.Task {
            mod_OracleJob::mod_Task::OneOfTask::http_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::json_parse_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::median_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::mean_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::websocket_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::ccxt_ws_task(ref m) => 1 + sizeof_len((m).get_size()),
            mod_OracleJob::mod_Task::OneOfTask::None => 0,
    }    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        match self.Task {            mod_OracleJob::mod_Task::OneOfTask::http_task(ref m) => { w.write_with_tag(10, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::json_parse_task(ref m) => { w.write_with_tag(18, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::median_task(ref m) => { w.write_with_tag(34, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::mean_task(ref m) => { w.write_with_tag(42, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::websocket_task(ref m) => { w.write_with_tag(50, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::ccxt_ws_task(ref m) => { w.write_with_tag(58, |w| w.write_message(m))? },
            mod_OracleJob::mod_Task::OneOfTask::None => {},
    }        Ok(())
    }
}

pub mod mod_Task {

use super::*;

#[derive(Debug, PartialEq, Clone)]
pub enum OneOfTask {
    http_task(mod_OracleJob::HttpTask),
    json_parse_task(mod_OracleJob::JsonParseTask),
    median_task(mod_OracleJob::MedianTask),
    mean_task(mod_OracleJob::MeanTask),
    websocket_task(mod_OracleJob::WebsocketTask),
    ccxt_ws_task(mod_OracleJob::CcxtWsTask),
    None,
}

impl Default for OneOfTask {
    fn default() -> Self {
        OneOfTask::None
    }
}

}

}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JobPosting {
    pub aggregator_state_pubkey: Option<Vec<u8>>,
    pub node_pubkeys: Vec<Vec<u8>>,
}

impl<'a> MessageRead<'a> for JobPosting {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(10) => msg.aggregator_state_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(18) => msg.node_pubkeys.push(r.read_bytes(bytes)?.to_owned()),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JobPosting {
    fn get_size(&self) -> usize {
        0
        + self.aggregator_state_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.node_pubkeys.iter().map(|s| 1 + sizeof_len((s).len())).sum::<usize>()
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.aggregator_state_pubkey { w.write_with_tag(10, |w| w.write_bytes(&**s))?; }
        for s in &self.node_pubkeys { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        Ok(())
    }
}

#[derive(Debug, Default, PartialEq, Clone)]
pub struct JobResult {
    pub node_pubkey: Option<Vec<u8>>,
    pub result: Option<f64>,
    pub error: Option<bool>,
    pub slot: Option<u64>,
    pub timestamp: Option<i64>,
}

impl<'a> MessageRead<'a> for JobResult {
    fn from_reader(r: &mut BytesReader, bytes: &'a [u8]) -> Result<Self> {
        let mut msg = Self::default();
        while !r.is_eof() {
            match r.next_tag(bytes) {
                Ok(18) => msg.node_pubkey = Some(r.read_bytes(bytes)?.to_owned()),
                Ok(25) => msg.result = Some(r.read_double(bytes)?),
                Ok(32) => msg.error = Some(r.read_bool(bytes)?),
                Ok(40) => msg.slot = Some(r.read_uint64(bytes)?),
                Ok(48) => msg.timestamp = Some(r.read_int64(bytes)?),
                Ok(t) => { r.read_unknown(bytes, t)?; }
                Err(e) => return Err(e),
            }
        }
        Ok(msg)
    }
}

impl MessageWrite for JobResult {
    fn get_size(&self) -> usize {
        0
        + self.node_pubkey.as_ref().map_or(0, |m| 1 + sizeof_len((m).len()))
        + self.result.as_ref().map_or(0, |_| 1 + 8)
        + self.error.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.slot.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
        + self.timestamp.as_ref().map_or(0, |m| 1 + sizeof_varint(*(m) as u64))
    }

    fn write_message<W: WriterBackend>(&self, w: &mut Writer<W>) -> Result<()> {
        if let Some(ref s) = self.node_pubkey { w.write_with_tag(18, |w| w.write_bytes(&**s))?; }
        if let Some(ref s) = self.result { w.write_with_tag(25, |w| w.write_double(*s))?; }
        if let Some(ref s) = self.error { w.write_with_tag(32, |w| w.write_bool(*s))?; }
        if let Some(ref s) = self.slot { w.write_with_tag(40, |w| w.write_uint64(*s))?; }
        if let Some(ref s) = self.timestamp { w.write_with_tag(48, |w| w.write_int64(*s))?; }
        Ok(())
    }
}

